/*  Last edited: Mar 23 13:06 1992 (rd) */

#ifndef DEF_DNA_H
#define DEF_DNA_H

#define A_ 1
#define T_ 2
#define U_ 2
#define G_ 4
#define C_ 8

#define R_ (A_ | G_)
#define Y_ (T_ | C_)
#define M_ (A_ | C_)
#define K_ (G_ | T_)
#define S_ (C_ | G_)
#define W_ (A_ | T_)

#define H_ (A_ | C_ | T_)
#define B_ (G_ | C_ | T_)
#define V_ (G_ | A_ | C_)
#define D_ (G_ | A_ | T_)

#define N_ (A_ | T_ | G_ | C_)

extern char dnaDecodeChar[] ;  /* this is the mapping used to decode a single base */
extern char rnaDecodeChar[] ; 
char * dnaDecodeString(char *cp) ; /* Decodes up to 255 char in a static buffer */
void dnaEncodeString(char *cp) ; /* reversed encoding, works en place */
void dnaDecodeArray (Array a) ;	/* works in place */
void dnaEncodeArray (Array a) ;	/* works in place */

Array dnaGet(KEY key) ;
void dnaStoreDestroy(KEY key, Array dna) ;

   /* Handles for dnacpt package */
BOOL fMapActive(Array *dnaArrayp, Array *protein, 
		Array *dnaColp, KEY *seqKeyp, int *frame, void** lookp) ;
void fMapDisplayDNA (void * look) ;
void dnacptTranslate2(Array dna, Array protein, Array colors, int frame) ;
int fMapSetFrame(int f) ;
void fMapFindOrigin(void *vv, int *origin, int *length) ;

Array  fMapGetMessage(void *vv, BOOL *positiveFrame) ;
void fMapIntronsExons (void *vv, Array prot) ;

int fMapSetStatus(int s) ;  /* if s==-1, just returns present value */
void fMapRaiseStatus(int s) ;

/* the text values are filled in dnasubs.c

G	Guanine
A	Adenine 
T	Thymine
C	Cytosine
R	Purine			A,G
Y	Pyramidine		T,C
M	Amino			A,C
K	Ketone			G,T
S	Strong interaction	C,G
W	Weak interaction	A,T
H	not-G			A,C,T
B	not-A			G,C,T
V	not-T			A,C,G
D	not-C			A,G,T
N	any                     G,A,T,C

*/
#endif
/*****************************************************/
