/*  File: bs_.h
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: fused from 3 headers used in all the same files
 		private BS stuff, plus interaction between BS and cache
 * Exported functions:
 * HISTORY:
 * Last edited: Mar 19 11:56 1992 (mieg)
 * Created: Tue Mar 10 03:40:07 1992 (mieg)
 *-------------------------------------------------------------------
 */

#ifndef DEFINE_BS__h
#define DEFINE_BS__h

#include "array.h"  /* Needs Stack */

       /* CAVEAT : If sizeof(BSdata) changes data on disk
                   can no longer be read , see b_.h */

       /* model data keys are all tags, so use table bits for flags */
#define UNIQUE_BIT KEYMAKE(1,0)
#define DELETE_BIT KEYMAKE(2,0)

typedef KEY TEXTKEY ;
typedef union  { int i;
                 unsigned int u;
                 long L;
                 unsigned long U;
                 float f;
                 TEXTKEY text; /* to dereference a text entry */
                 KEY key ;    /* used in models */
               } BSdata;
 
typedef struct bshow *BS;
typedef struct btext *BT;
 
        struct bshow {BS  up, down, right;
                      KEY key;
                      BSdata n;
                      BT bt ;
                      int size;  /* used in BSstore */
                     } ;
 
        struct btext { char *cp; /* holds a copy of text, do free */
		       BS   bsm; /* only used during treedisp update */
                     } ;
/********* cache stuff ********/
 
typedef BS CACHE_HANDLE ;
#define DEF_CACHE_HANDLE

#ifndef DEF_CACHE
#define DEF_CACHE
  typedef void* CACHE ;
#endif

typedef struct sobj *OBJ ;
struct sobj { KEY key ;
	      int magic ;
	      CACHE x ;
	      OBJ parent ;
	      int numberOfChildren ;
	      BS root, curr, modCurr ;
	      Stack xref ;
	    } ;
#define DEFINE_OBJ

/*******************************/
 
#define bsText(bs) ((bs) && (bs)->bt && (bs)->bt->cp ? (bs)->bt->cp : 0)

BS BSalloc (void) ;
void BSfree (BS p) ;
 
BT BTalloc (void) ;
void BTfree (BT p) ;

#include "bstree.h"

#define bsIsTag(bs)	(!class((bs)->key) && (bs)->key > _LastN)
#define bsIsType(bs)	(class((bs)->key) && (bs)->key == KEYMAKE(class((bs)->key), 1))
#define bsIsComment(bs)	((class((bs)->key) & 0x7f) == _VComment)

void bsFuseModel (OBJ obj) ;	/* fuses in model for tree display updater */
void bsMakePaths (int table) ;
BOOL bsModelMatch (BS bs, BS *bsmp) ;
BS bsModelRight (BS bsm) ;
BS bsModelRoot (OBJ obj) ;

void cacheMark (CACHE cache) ; /* Call after updating to ensure it will go to disk */
BOOL isCacheModified (CACHE cache) ;
BOOL isCacheLocked (CACHE cache) ;

#endif
/******************************************************************/
