/*  Last edited: Mar 31 19:03 1992 (mieg) */

/***************************************************************/
/*  File array.h  : header file for array.c                    */
/*                                                             */
/*         R.Durbin & J.Thierry-Mieg.                          */
/*                    last modified   8/2/91 by RMD.           */
/*                                                             */
/***************************************************************/
 
#ifndef DEF_ARRAY_H
#define DEF_ARRAY_H
 
unsigned int stackused (void) ;
 
/************* Array package ********/

/* #define ARRAY_CHECK either here or in a single file to
   check the bounds on arr() and arrp() calls
   if defined here can remove from specific C files by defining
   ARRAY_NO_CHECK (because some of our finest code relies on abuse of arr!)
*/

/* #define ARRAY_CHECK */

typedef struct ArrayStruct
  { char* base ;    /* char* since need to do pointer arithmetic in bytes */
    int   dim ;     /* length of alloc'ed space */
    int   size ;
    int   max ;     /* largest element accessed via array() */
    int   id ;      /* unique identifier */
    int   magic ;
  } *Array ;
 
    /* NB we need the full definition for arr() for macros to work
       do not use it in user programs - it is private.
    */

#define ARRAY_MAGIC 8918274
#define STACK_MAGIC 8918275
#define   ASS_MAGIC 8918276
 
Array   uArrayCreate (int n, int size) ;
Array   uArrayReCreate (Array a,int n, int size) ;
void    uArrayDestroy (Array a) ;
char    *uArray (Array a, int index) ;
char    *uArrCheck (Array a, int index) ;
#define arrayCreate(n,type)	uArrayCreate(n,sizeof(type))
#define arrayReCreate(a,n,type)	uArrayReCreate(a,n,sizeof(type))
#define arrayDestroy(x)		((x) ? uArrayDestroy(x), x=0, TRUE : FALSE)
#define arrayp(ar,i,type)	((type*)uArray(ar,i))
#define array(ar,i,type)	(*(type*)uArray(ar,i))
#if (defined(ARRAY_CHECK) && !defined(ARRAY_NO_CHECK))
  #define arrp(ar,i,type)	((type*)uArrCheck(ar,i))
  #define arr(ar,i,type)	(*(type*)uArrCheck(ar,i))
#else
  #define arr(ar,i,type)	((*(type*)((ar)->base + (i)*(ar)->size)))
  #define arrp(ar,i,type)	(((type*)((ar)->base + (i)*(ar)->size)))
#endif
            /* only use arr() when there is no danger of needing expansion */
Array   arrayCopy (Array a) ;
int     arrayNumber(void) ;  /* returns the number of active Arrays */
void    arrayExtend (Array a, int n) ;
#define arrayMax(ar)            ((ar)->max)
#define arrayForceFeed(ar,j) (uArray(ar,j), (ar)->max = (j))
#define arrayExists(ar)		((ar) && (ar)->magic == ARRAY_MAGIC ? (ar)->id : 0 ) 
 
            /* JTM's package to hold sorted arrays of ANY TYPE */
BOOL    arrayInsert(Array a, void * s, int (*order)());
BOOL    arrayRemove(Array a, void * s, int (*order)());
void    arraySort(Array a, int (*order)()) ;
void    arrayCompress(Array a) ;
BOOL    arrayFind(Array a, void *s, int *ip, int (*order)());
BOOL    arrayIsEntry(Array a, int i, void *s);
 
/************** Stack package **************/
 
typedef struct StackStruct      /* assumes objects <= 16 bytes long */
  { Array a ;
    char* ptr ;         /* current end pointer */
    char* pos ;         /* potential internal pointer */

    char* safe ;        /* need to extend beyond here */
    int magic ;
  } *Stack ;
 
        /* as with ArrayStruct, the user should NEVER access StackStruct
           members directly - only through the subroutines/macros
        */
 
Stack   stackCreate (int n) ;
Stack   stackReCreate (Stack s, int n) ;
void    uStackDestroy (Stack s) ;
#define stackDestroy(x)	 ((x) ? uStackDestroy(x), (x)=0, TRUE : FALSE)
void    stackExtend (Stack s, int n) ;
void    stackClear (Stack s) ;
#define stackEmpty(stk)  ((stk)->ptr <= (stk)->a->base)
#define stackExists(stk) ((stk) && (stk)->magic == STACK_MAGIC ? arrayExists((stk)->a) : 0)
#define stackMax(stk)    (stackExists(stk) ? ((stk)->a->max) : 0 )
 
#if defined(IBM) || defined(THINK_C) /* The IBM refuses left casting as in: (type *)p++ */
  #define push(stk,x,type) ((stk)->ptr < (stk)->safe ? \
                           ( *(type *)((stk)->ptr) = (x) , (stk)->ptr += sizeof(type)) : \
			    (stackExtend (stk,16), \
			     *(type *)((stk)->ptr) = (x) , (stk)->ptr += sizeof(type)) )
  #define pop(stk,type)    (  ((stk)->ptr -= sizeof(type)) >= (stk)->a->base ? \
			    *((type*)((stk)->ptr)) : \
                          (messcrash ("User stack underflow"), *((type*)0)) )
  #define stackNext(stk,type) (*((type*)(  (stk)->pos += sizeof(type) )  - 1 )  )
#else
  #define push(stk,x,type) ((stk)->ptr < (stk)->safe ? \
                          *((type*)((stk)->ptr))++ = (x) : \
                   (stackExtend (stk,16), *((type*)((stk)->ptr))++ = (x)) )
  #define pop(stk,type)    (--((type*)((stk)->ptr)) >= (type*)(stk)->a->base ? \
                          *((type*)((stk)->ptr)) : \
                          (messcrash ("User stack underflow"), *((type*)0)) )
  #define stackNext(stk,type) (*((type*)((stk)->pos))++)
#endif

void    pushText (Stack s, char *text) ;
char*   popText (Stack s) ;	/* returns last text and moves pointer before it */
void    catText (Stack s, char *text) ;  /* like strcat */
void	stackTokeniseTextOn(Stack s, char *text, char *delimiters) ; /* tokeniser */

int     stackMark (Stack s) ;              /* returns a mark of current ptr */
void    stackCursor (Stack s, int mark) ;  /* sets ->pos to mark */
#define stackAtEnd(stk)     ((stk)->pos >= (stk)->ptr)
char*   stackNextText (Stack s) ;
 
#define stackText(stk,mark) ((char*)((stk)->a->base + (mark)))
#define stackTextMax(stk)   ((stk)->ptr - (stk)->a->base)
#define stackTextForceFeed(stk,j) (arrayForceFeed((stk)->a,j) ,\
                 (stk)->ptr = (stk)->pos = (stk)->a->base + (j) ,\
                 (stk)->safe = (stk)->a->base + (stk)->a->dim - 16 )
 
/********** Line breaking package **********/
 
int     uLinesText (char *text, int width) ;
char    *uNextLine (char *text) ;
char    *uPopLine (char *text) ;
char    **uBrokenLines (char *text, int width) ; /* array of lines */
char    *uBrokenText (char *text, int width) ; /* \n's intercalated */
 
/********** Associator package *************/

typedef struct AssStruct
  { int magic ;                 /* Ass_MAGIC */
    int id ;                    /* unique identifier */
    int n ;			/* number of items stored */
    int m ;			/* power of 2 = size of arrays - 1 */
    void **in,**out ;
    unsigned int mask ;		/* m-1 */
  } *Associator ; 
 
#define assExists(a) ((a) && (a)->magic == ASS_MAGIC ? (a)->id : 0 )
Associator assCreate (void) ;
Associator assReCreate (Associator a) ;
void    uAssDestroy (Associator a) ;
#define assDestroy(x)  ((x) ? uAssDestroy(x), x = 0, TRUE : FALSE)
BOOL    uAssFind (Associator a, void* xin, void* *pout) ;
#define assFind(ax,xin,pout)    uAssFind(ax,xin,(void**)(pout))
            /* if found, updates *pout and returns TRUE, else returns FALSE */
BOOL    assInsert (Associator a, void* xin, void* xout) ;
            /* if already there returns FALSE, else inserts and returns TRUE */
BOOL    assRemove (Associator a, void* xin) ;
            /* if found, removes entry and returns TRUE, else returns FALSE */
void    assDump (Associator a) ;
           /* for debug - uses printf */
void    assClear (Associator a) ;
BOOL    uAssNext (Associator a, void* *pin, void* *pout) ;
#define assNext(ax,pin,pout)	uAssNext((ax),(void**)(pin),(void**)pout)
 
#endif
