/*  File: acedb.h
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Mar  4 01:58 1992 (rd)
 * * Oct 21 14:01 1991 (mieg): added overflow  protection in KEYMAKE 
 * Created: Mon Oct 21 14:01:19 1991 (mieg)
 *-------------------------------------------------------------------
 */
 
             /*********************************************/
             /* ACeDB.h                                   */
             /* type definitions and size limits          */
             /*********************************************/
 
#ifndef DEF_ACeDB_h
#define DEF_ACeDB_h
 
#include "regular.h"           /*contains KEY*/
 
void help(void) ;
void helpOn(char *text) ; 
void mainActivity(char * text) ;

#define KEYMAKE(t,i)  ((KEY)( (((KEY) (t))<<24) | ( ((KEY) (i)) & 0xffffffL) ))
#define KEYKEY(kk)  ((KEY)( ((KEY) (kk)) & ((KEY) 0xffffffL) ))
#define class(kk)  ((int)( ((KEY) (kk))>>24 ))
 
char* name(KEY k);     /*returns the name or the word "NULL" in case of a wrong key */
char* className(KEY k) ; /* returns the name of the class of key */
#endif
 

