/*  Last edited: Mar 25 18:33 1992 (mieg) */
/*************************************************************************/
   /* accumulates in usage the codon used in dna messenger */      
static void dnacptAddCds2 (Array usage,  Array dna)
{
  int i = arrayMax(dna), codon = 0 , frame = 0 ;
  char *cp = arrp(dna, 0, char) ;
  
  while(i--)
    { 
      if (codon != 64)
	switch(*cp++)
	  {
	  case T_: break ;
	  case C_: codon += 1 ; break ;
	  case A_: codon += 2 ; break ;
	  case G_: codon += 3 ; break ;
	  default: codon = 64 ; break ;
	  }

      frame++ ;
      frame %= 3 ;
      if (frame)
	{ if (codon != 64) codon <<= 2 ; }
      else 
	{ array(usage, codon, int)++ ;
/*   Stops should not occur 
	  if(codon ==10 || codon == 11 || codon == 14 )
	     invokeDebugger() ;
*/
	  codon = 0 ;
	}
    }    
  if (frame)
    array(usage, 65, int)++ ;
}

/****************************************************************************/
   /* construct the plus and back messengers  dna1 and dna2 */
static int dnacptAddCds (Array dna, Array cds, Array usage)
{ int ncds = 0 , from, to, i , j ;
  Array dna1, dna2 ; int n1 = 0, n2 = 0 ;
  char *cp ;

  dna1 = arrayCreate(1000, char) ;
  dna2 = arrayCreate(1000, char) ;

  for (i=0 ; i<arrayMax(cds) ; i+= 2)
    {
      from = arr(cds,i,int) ; to = arr(cds, i+1, int) ;
      if (from == -1)
	{ ncds++ ; 
	  if (arrayMax(dna1))
	    { dnacptAddCds2(usage, dna1) ;
#ifdef CODE_FILE
	      dnaDecodeArray (dna1) ;
	      array(dna1, arrayMax(dna1), char) = 0 ;
	      fprintf (codeFile, "%s %s\n", name(to), arrp(dna1,0,char)) ;
#endif	     
	    }
	  if (arrayMax(dna2))
	    { dnacptComplement(dna2) ;
	      dnacptAddCds2(usage, dna2) ;
#ifdef CODE_FILE
	      dnaDecodeArray (dna2) ;
	      array(dna2, arrayMax(dna2), char) = 0 ;
	      fprintf (codeFile, "%s %s\n", name(to), arrp(dna2,0,char)) ;
#endif	     
	    }
	  arrayMax(dna1) = arrayMax(dna2) = 0 ;
	  n1 = n2 = 0 ;  
	  continue ;
	}
      
      if (from <= to)
	for (j = from , cp = arrp(dna, j, char) ; j <= to ; j++, cp++)
	  array(dna1,n1++,char) = *cp ;
      else
	for (j = from , cp = arrp(dna, j, char) ; j >= to ; j--, cp--)
	  array(dna2,n2++,char) = *cp ;
    }
  arrayDestroy(dna1) ; arrayDestroy(dna2) ;
  return
    ncds ;
}

/*************************************************************************/
    /* Gets the coding sequences recursivelly 
     *  taking orientation into account
     */  
static BOOL  dnacptGetCds(Array cds, KEY  seq, int from, int to)
{ int i, min, max, n ;
  BOOL result = FALSE ;
  OBJ Seq = bsCreate(seq) ;
  Array exons = arrayCreate(8, BSunit) ;
  Array subSeq = arrayCreate(9, BSunit) ;
  if (!Seq)
    return FALSE ;
  if (bsFindTag(Seq, _CDS))  /* seq is by itself coding sequences */
    { 
      min = 1 ; max = 0 ;	/* max 0 means go to the end of the spliced sequence */
      if (bsGetData(Seq, _bsRight, _Int, &min))
	bsGetData(Seq, _bsRight, _Int, &max) ;
      n = arrayMax(cds) ;
      if (!bsFindTag(Seq, _Source_Exons) || !bsFlatten(Seq, 2, exons))
	{ array(exons, 0, BSunit).i = 1 ;  /* Failure: Make a fake entry */
	  array(exons, 1, BSunit).i = (from < to) ? to - from + 1 : from - to + 1 ;
	}
      for (i = 0; i < arrayMax(exons) ; i += 2, n += 2 ) /*  exons themselves */
	{ result = TRUE ; 
	  if (from < to)        /* -1 because no zero in biology */
	    {
	      array(cds, n, int) = from + arr(exons,i,BSunit).i - 1 ;
	      array(cds, n + 1, int) = from + arr(exons,i + 1 ,BSunit).i - 1 ;
	    }
	  else
	    {
	      array(cds, n, int) = from - arr(exons,i,BSunit).i + 1 ;
	      array(cds, n + 1, int) = from - arr(exons,i + 1 ,BSunit).i + 1 ;
	    }
	}
      array(cds, n  , int) = -1 ;
      array(cds, n + 1 , int) = seq ; /* end of seq */
    }
  else  /* recurse though the sub sequences */
    {
      if (bsFindTag(Seq, _Contains)  &&    /* At present the model is messy, 
					      _Contains   Has_xxx ?Seq int int
					      We should move to _Contains ?Seq int int 
					      This poses a compatibility problem in release 1.n
					      */
	  bsFlatten(Seq, 4, subSeq) )
	for (i=0; i < arrayMax(subSeq) ; i += 4)
	  if (from < to)        /* -1 because no zero in biology */
	    dnacptGetCds(cds, arr(subSeq,i+1,BSunit).k , 
			 from + arr(subSeq,i+2,BSunit).i - 1,
			 from + arr(subSeq,i+3,BSunit).i - 1 ) ;
	  else
	    dnacptGetCds(cds, arr(subSeq,i+1,BSunit).k ,
			 from -  arr(subSeq,i+2,BSunit).i + 1 ,
			 from -  arr(subSeq,i+3,BSunit).i + 1 ) ;
    }
  arrayDestroy(subSeq) ;
  arrayDestroy(exons) ;
  bsDestroy(Seq) ;
  return result ;
}

/*************************************************************************/
  /* Given tha active key set
   * look for dnasequnces whose descriptor is in keyset
   * in each, look recursively for the coding sequences,
   *  accumulate the codon usage and display.
   * by starting from _VDNA, we are garanteed not to double count.
   */

static void dnacptCodonUsage(void)
{
  Array dna ; KEY seq = 0 , dnaKey = 0 ;
  KEYSET keySet , ks2 ; void *look ;
  Array usage , cds ;
  int   dummy , n, nn = 0 , ncds = 0 ;
  DNACPTGET("dnacptCodonUsage") ;
      
  if(!dnacpt->useKeySet)
    { messout("I just know how to do that from a keySet") ;
      return ;
    }
  if (!keySetActive(&keySet, &look)) 
    { messout("First select a keySet containing sequences") ;
      return ;
    }

#ifdef CODE_FILE
  codeFile = fopen ("coding.seq","w") ;
#endif

  ks2 = keySetCreate() ;
  cds = arrayCreate(50,int) ;
  usage = arrayCreate(64, int) ;
  while(lexNext(_VDNA,&dnaKey))
    { if (lexReClass(dnaKey, &seq, _VSequence) &&
	  keySetFind(keySet, seq, &dummy) &&
	  (dna = dnaGet(dnaKey) ) )
	{ nn++ ;
	  arrayMax(cds) = 0 ;
	  dnacptGetCds (cds, seq,  0, arrayMax(dna) - 1 ) ;
	  n = dnacptAddCds(dna, cds, usage) ;
	  if (n)
	    { ncds += n ;
	      keySetInsert(ks2,seq) ;
	    }
	  arrayDestroy(dna) ;
	/*  break;  one is enough to debug */
	}
    }

#ifdef CODE_FILE
  fclose (codeFile) ;
#endif
      
  if (!nn)
    { messout("First select a keySet containing sequences") ;
      return ;
    }

  dnacptShowCodonUsage(nn, ncds, usage) ;

  /*   arrayDestroy(usage) ; destroyed in show.. */
  arrayDestroy(cds) ;
  keySetDestroy(keySet) ;
  keySetShow(ks2, look) ;
}

/*****************************************/
/***************/
#define INTRON_COLOR YELLOW
#define EXON_COLOR LIGHTGREEN

   /* Splicing subroutine */
Array  fMapGetMessage (void *vv, BOOL *positiveStrand)
{ LOOK look = (LOOK) vv ;
  int   i, j, jCode = 0, cds1=0, cds2=0 ;
  SEG   *seg ;
  KEY parent ;
  Array dna = look->dnaArray , cDna ;
 
  if (look && look->magic != MAGIC)
    messcrash ("fMapGetMessage called with corrupted handle") ;
  
  seg = arrp(look->segs, arr(look->boxIndex,look->activeBox,int), SEG) ;
  if (!seg)
    messcrash ("Richard owes Jean a pint") ;

  parent = seg->parent ;
  
  if (!iskey(parent) || class(seg->parent) != _VSequence)
    { messout ("Please pick a sequence first") ;
      return 0 ;
    }
  for (i = 0 ; i < arrayMax(look->segs) ; ++i)
    { seg = arrp(look->segs,i,SEG) ;
      if (seg->parent == parent)
	switch (seg->type)
	  {
	  case CDS:
	    cds1 = seg->x1 - 1 ; /* Plato strikes again */
	    cds2 = seg->x2 ;
	    break ;
	  case SEQUENCE_DOWN:
	    *positiveStrand = TRUE ;
	    break ;
	  case SEQUENCE_UP:
	    *positiveStrand = FALSE ;
	    break ;
	  }
    }
  if (cds1 == cds2)
    { messout ("Sorry, no coding sequence in %s", name(parent)) ;
      return 0 ;
    }

  cDna = arrayCreate(10000, char) ; /* wild guess */
  for (i = 0 ; i < arrayMax(look->segs) ; ++i)
    { seg = arrp(look->segs,i,SEG) ;
      if (seg->parent == parent)
      switch (seg->type)
	{			/* pick cDna */
	case EXON_DOWN: case EXON_UP:
	  for (j = seg->x1 - 1 ; j < seg->x2 ; ++j)
	    if (j >= cds1 && j < cds2)
	      array(cDna,jCode++,char) = arr(dna,j,char) ;
   	  break ;
	}
      if (j - 1 > arrayMax(look->colors))
	messcrash ("Length over flow %d > %d in fMapcDna",
		   j, arrayMax(look->colors)) ;
    }

  return cDna ;
}

/********************/

/********************/

void fMapIntronsExons (void *vv, Array prot)
		/* prot should be the protein sequence of the seq corresponding
		   to the activebox, reversed if UP.  This routine recalculates
		   Arrays look->colors and look->protein, then redraws */
{ 
  LOOK	look = (LOOK) vv ;
  int   i, j, jProt = 0, jCode = 0, colour, *ip ;
  int	length, cds1, cds2 ;
  char	*cp, aa ; 
  Array protein ;
  Array colors = look->colors ;
  SEG   *seg ;
  KEY 	parent ;
  BOOL  isUp = FALSE ;

  if (!look || look->magic != MAGIC ||
      !look->dnaArray || !look->colors)
    return ;
  
  if (look && look->magic != MAGIC)
    messcrash("fMapIntronsExons called with corrupted handle") ;
  if (look && !graphActivate (look->graph))
    { messout ("fMapIntronsExons lost its graph") ;
      return ;
    }

  graphPop() ;

  seg = arrp(look->segs, arr(look->boxIndex,look->activeBox,int), SEG) ;
  parent = seg->parent ;

  for (i = arrayMax(colors), ip = arrp(colors,0,int) ; i-- ;)
    *ip++ = BLACK ;

  protein = look->protein = arrayReCreate(look->protein, 
					  arrayMax(look->dnaArray)/3 + 3, char) ;
  arrayMax(protein) = arrayMax(look->dnaArray)/3 + 1 ;
  for (i = arrayMax(protein), cp = arrp(protein,0,char) ; i-- ;)
    *cp++ = ' ' ;

  length = 0 ;
  for (i = 0 ; i < arrayMax(look->segs) ; ++i)
    { seg = arrp(look->segs,i,SEG) ;
      if (seg->parent == parent) switch (seg->type)
	{
	case EXON_UP:
	  isUp = TRUE ;
	case EXON_DOWN:
	  length += seg->x2 - seg->x1 + 1 ;
	case INTRON_UP: case INTRON_DOWN:
          if (seg->x2 > arrayMax(colors))
	    messcrash ("Length overflow  %d > %d in fMapIntronsExons",
		       seg->x2,  arrayMax(colors)) ;
	  break ;
	case CDS:
	  cds1 = seg->x1 - 1 ;
	  cds2 = seg->x2 ;
	  break ;
	}
    }
  if (length % 3)
    { messout ("Coding length is %d mod 3", length % 3) ;
      if (isUp)
	jCode = -(length % 3) ;
    }
  
  for (i = 0 ; i < arrayMax(look->segs) ; ++i)
    { seg = arrp(look->segs,i,SEG) ;
      if (seg->parent == parent) switch (seg->type)
	{        /* chose translation frame */
	case EXON_DOWN: case EXON_UP:
	  colour = MAGENTA ;
	  for (j = seg->x1 - 1 ; j < seg->x2 ; ++j)
	    if (j >= cds1 && j < cds2)
	      { switch (jCode % 3)
		  {
		  case 0:
		    if (jProt < arrayMax(prot)) 
		      aa = arr(prot,jProt++,char) ;
		    if (aa == '*')
		      colour = RED ;
		    else
		      colour = LIGHTGREEN ;
		    break ;
		  case 1: 
		    arr(protein,j/3,char) = aa ; /* preserved over introns */
		    break ;
		  }
		arr(colors,j,int) = colour ;
		++jCode ;
	      }
	  for (j = jCode % 3 ; j ; --j)
	    arr(colors,seg->x2-j,int) = MAGENTA ;
	  break ;
	case INTRON_DOWN: case INTRON_UP:
	  for (j = seg->x1 - 1 ; j < seg->x2 ; ++j)
	    if (j >= cds1 && j < cds2)
	      { arr(colors,j,int) = YELLOW ;
		if (arr(protein,(j+1)/3,char) == ' ' )
		  arr(protein,(j+1)/3,char) = '-' ;
	      }
	  break ;
	}
    }
  fMapDraw (look,0) ;
}

/*************************************************************************/
/*************************************************************************/
