/*  Last edited: Nov 18 13:36 1991 (mieg) */
 
 
      /***************************************************************/
      /***************************************************************/
      /**  File topology.c  :                                       **/
      /**  Analysis of connected graphs                             **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  Public routines                                            */
      /*                                                             */
      /*  1 routines are public :  topoConnectedComponents()         */   
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  21/2/91  by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "keyset.h"
#include "topology.h"

/********************************/

static int topoFirstKeyOrder(void*a, void*b)
{
 return ((LINK*) a) -> a -  ((LINK*) b)-> a ;
}

/**************************************/

static void topoDoubleUnorientedLinks(Array links)
{
  register int i = arrayMax(links) ; 
  register LINK *x , *y ;

  arrayExtend(links, 2*i) ;
  arrayMax(links) = 2*i ;
  x = arrp(links, 0, LINK) ;
  y = arrp(links, i, LINK) ;
  while(i--)
    { x -> group = y -> group = 0 ;
      *y = *x ;  /* anything else, i.e. type */
      y -> a = x -> b ; 
      y -> b = x -> a ;
      x++ , y++ ;
    }
  arraySort(links, topoFirstKeyOrder) ;
}

/**************************************/

static void topoEnumerateVertex(Array links, Array vx)
{
  register int i , n = arrayMax(links) , j = 0;
  register KEY k = 0 ;

  arrayMax(vx) = 0 ;
  for(i = 0 ; i < n ; i++)
    if ( k != arrp(links,i,LINK) -> a)
      {  k = arrp(links,i,LINK) -> a ;
	 array(vx, j, VERTEX).a = k ;
	 array(vx, j, VERTEX).group = 0 ;
	 array(vx, j, VERTEX).pos = i ;
	 j++ ;
       }
}

/**************************************/

static Array VX, LK;
static int GP ;      /* number of the connected component */

/******************/

static int topoFindVertex(KEY k)
{
  register int i = arrayMax(VX) ;
  while(i--)
    if(arrp(VX,i,VERTEX)->a == k)
      return i ;
  messcrash("Topofindvertex cannot find %d", k) ;

  return 0 ; /* for compiler happiness */
}

/******************/

static void topoNCC2(int n)
{ KEY a = array(VX,n,VERTEX).a ;
  int pos = array(VX,n,VERTEX).pos ;

  array(VX,n,VERTEX).group = GP ;
  for(;pos < arrayMax(LK)  && array(LK, pos,LINK).a == a;pos++)
    { n = topoFindVertex(array(LK, pos,LINK).b) ;
      if(!arr(VX,n,VERTEX).group)
	  topoNCC2(n) ;
      else if(arr(VX,n,VERTEX).group != GP )
	messcrash
	  ("topoNCC2 : Double numbering, sorry") ;
    }
}

/******************/

static void topoNumberLinks(void)
{ KEY a ;
  register int i = arrayMax(LK), n ;
  while(i--)
    {  a = arr(LK,i,LINK).a ;
       n = topoFindVertex(a) ;
       arr(LK,i,LINK).group = arr(VX,n,VERTEX).group ;
     }
}

/*****************/

static int topoNumberConnectedComponents(Array links, Array vx)
{
  register int n = arrayMax(vx) ;

  VX = vx ; LK = links; GP = 0 ;
  while(n--)
    if(! arr(vx,n,VERTEX).group)
      { GP++ ;
	topoNCC2(n) ;
      }
  topoNumberLinks() ;
  return GP ;
}

/**************************************************************/
/************* Public Routines ********************************/

int topoConnectedComponents(Array links, Array vx)
{

  if(!arrayExists(links) || !arrayExists(vx))
    messcrash("topoConnectedComponents called with bad array") ;

  topoDoubleUnorientedLinks(links) ;
  topoEnumerateVertex(links, vx) ;  
  return topoNumberConnectedComponents(links, vx) ;
}

/**************************************************************/
/**************************************************************/
