/*  Last edited: Mar 27 20:13 1992 (mieg) */

 
      /***************************************************************/
      /***************************************************************/
      /**  File pmapcpt.c  :                                        **/
      /**  Aligns the clones into contigs                           **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  Public routines                                            */
      /*                                                             */
      /*  1 routines are public :  pMapCompute()                     */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  17/3/91  by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "keyset.h"
#include "key.h"
#include "lex.h"
#include "pick.h"
#include "sysclass.wrm"
#include "classes.wrm"
#include "tags.wrm"
#include "systags.wrm"
#include "bs.h"
#include "plot.h"
#include "a.h"
#include "session.h"
 
typedef struct LOOKSTUFF
  { int   magic;        /* == MAGIC*/
    Graph graph ;
    int projectBox ;
    char project[50] ;
    char oldProject[50] ;
    int curr, line ;
  } *LOOK ;


#define MAGIC  34152
 
static void  pCptRead(void);
static void pCptHisto(void);
static void pCptCompareAll(void) ;
static void pCptDisplay(void) ;
 
static int pairmin = 4, friendmin=4;
static BOOL pCptCompare(OBJ A, KEY k1, KEY k2, int option) ;
static int pCptCmp(int g1, int n1, int g2, int n2, int option) ;

void pMapCompute(void) ;

#define PCPTGET(name)     LOOK look ;\
                                       \
                          if (!graphAssFind (pMapCompute,&look)) \
		            messcrash ("(name) can't find graph") ; \
			  if (!look) \
                            messcrash ("(name) received a null pointer") ; \
                          if (look->magic != MAGIC) \
                            messcrash ("(name) received a wrong pointer")  ;\
                          displayPreserve()  

static Array bands , pairs , bands2clones ;
static KEYSET friends ;
 
/******************************************/

static void  pCptHisto(void)
{
  Array histo ;
  register int i,j=0,n=1,k;
  PCPTGET(pCptHisto) ;
 

  pCptRead() ;
  if(!bands)
    return ;

  histo  = arrayCreate(5000,int);
  i = arrayMax(bands);
  while(i--)
   array(histo,arr(bands,i,short),int)++;
  i = arrayMax(bands);
  while(i--)
    {
      if((j=arr(bands,i,short))>k) n++;
      k=j;
    }
  plotHisto
    (messprintf
     ("Bands histogram of project %s, %d clones",look->project,n),
            histo);
}
 
/******************************************/
 
static void   pCptRead(void)
{
 register int
  i = 0;
 int
  n;
 void
   *vp = &n;
 unsigned int
   nb = 20000, nr,
   size = sizeof(short);

 char
    filename[80];
 FILE
   *pCptfile, *corfile;
 PCPTGET(pCptRead) ;
 
 arrayDestroy(bands) ;

 pCptDisplay() ;
 graphText
   (messprintf("Reading project %s",look->project),
    2,look->line++);
 graphRedraw() ;
 strcpy(filename,"rawdata/sulston/");
 strcat(filename,look->project);
 
 bands = arrayCreate(nb,short);
 if (!(pCptfile= filopen(filename,"bnd","rb")))
   {
     messout("I reformat the ascii file %s.cor into a file of int  %s.bnd",
             filename, filename);
     if(!isWriteAccess())
       { messout(
  "Sorry, you need write access to perform this operation") ;
	 arrayDestroy(bands) ;
	 return ;
       }
     if (   !(corfile= filopen(filename,"cor","r"))
         || !(pCptfile= filopen(filename,"bnd","wb")))
       return ;
 
     array(bands,(++i)*nb,short) = 0; /* to create space */
     while (freeread(corfile))
       if(freeint(&n))
         array(bands,i++,short) = n ;
       else
         {
           messout("Error parsing line %d of cor file : %s",
                   i, freeword());
           break;
         }
 
     fclose(corfile) ;
     fwrite(arrp(bands,0,short),size,arrayMax(bands),pCptfile);
   }
 
 else
   {
     do
       {
         array(bands,(++i)*nb,short) = 0; /* to create space */
         vp = &arr(bands,nb*(i-1),short); /* possible relocation */
         fprintf(stderr,"I red %d bands\n",i*nb);
       }
     while ((nr=fread(vp,size,nb,pCptfile))==nb);
 
     arrayMax(bands) -= nb - nr; /* artificial space removed */
   }
 
 messout("I read %d gel bands from project %s",
         arrayMax(bands),look->project);

 fclose(pCptfile);
 return ;
}

/*********************************************************************/

static void pCptCompareAll(void)
{
  KEY key=0, k1;
  OBJ A ;
  register int i;
  Array histo ;
  int n = _VClone,  t = 0 ;
  PCPTGET(compareAll);

  if(!lexNext(n,&key)) 
    {
      messout("No initial clone");
      return;
    }
  if(bands) 
    {  messout("First pick a project") ;
       return ;
     }

  while(t++ < 1000 && lexNext(n,&key))
    if(A = bsUpdate(key))
      { k1 = 0 ;
	while(lexNext(n, &k1) && k1 != key
	      && pCptCompare(A,key,k1,0) ) ;
	bsSave(A) ;
  /* necessary because of double call to lexanext */
	if(k1 != key)
	  while(lexNext(n, &k1) && k1 != key) ;
      }
  
  histo = arrayCreate(50,int) ;
  if(pairs)
    for (i=0;i<arrayMax(pairs) ; i++) 
      if(arr(pairs,i,KEYSET))
	{ array(histo,i,int) ++ ;
	  lexaddkey(messprintf("pM%d",i),&key,_VCalcul) ;
	  arrayStore(key,arr(pairs,i,KEYSET)) ;
	  keySetDestroy(arr(pairs,i,KEYSET)) ;
	}
  if(arrayMax(histo))
    plotHisto("max(pairs(x)", histo) ;
  else
    messout("No pairs found") ;
}

/****************************************************************/

static BOOL pCptCompare(OBJ A,KEY k1, KEY k2, int option)
{
  OBJ B ;
  int  n, j, n1, n2 ;
  int  gel1, gel2;
  
  if (  !bsGetData(A,_Bands,_Int, &gel1)
      || gel1 < 0
      ||!bsGetData(A,_bsRight,_Int,&n1)
      || n1 < 0
      || n1 + gel1 > arrayMax(bands)
      )
    { fprintf( stderr,"pCptCompare cannot read the _Bands of %s",
	      name(k1)) ;
      return FALSE; /* to change k1 */
    }
  if (B = bsUpdate(k2) )
    if ( !bsGetData(B,_Bands,_Int, &gel2)
	|| gel2 < 0
	|| !bsGetData(B,_bsRight,_Int, &n2)
	|| n2 < 0
	|| n2 + gel2 > arrayMax(bands)
	)
      { bsDestroy(B) ;
	return TRUE;
      }

  n = pCptCmp(gel1, n1, gel2, n2, option);

  if(n >= friendmin)
    {
      if(!friends)
	friends = keySetCreate() ;
      if(!keySet(friends,n))
	lexaddkey(messprintf("CB%d",n),&(keySet(friends,n)), _VCalcul);
      bsAddKey(A,_Common_bands,keySet(friends,n)) ;
      bsAddKey(A,_bsRight,k2);
      bsAddKey(B,_Common_bands,keySet(friends,n)) ;
      bsAddKey(B,_bsRight,k1);
      fprintf(stderr,"fr %s-%s ",name(k1),name(k2)) ;
    }

  if(n >= pairmin)
    {
      if(!pairs)
	pairs = arrayCreate(50,KEYSET) ;
      if(!array(pairs,n,KEYSET))
	array(pairs,n,KEYSET) = keySetCreate() ;	
      j = keySetMax(array(pairs,n,KEYSET)) ;
      keySet(array(pairs,n,KEYSET), j++) = k1;
      keySet(array(pairs,n,KEYSET), j++) = k2 ;
    }
  bsSave(B) ;
  return TRUE;
}

/*******************************************************************/
/* counts the number of pCpt common to gel a and b */
/* the option is to implement later fuzzy counting */

static int pCptCmp(int g1, int n1, int g2, int n2, int option)
{
  register int n  = 0;
  register short
    *a = arrp(bands,g1,short),
    *b = arrp(bands,g2,short);

  while (n1 && n2)
    if (*a == *b)
      {
	n++; n1--; n2--; a++; b++;
      }
    else if(*a > *b)
      {
	n2--; b++  ;
      }
    else
      { 
	n1--; a++;
      }
  return n;
}

/*******************************************************************/
/* returns the distance between  gel a and b */
/* the option is to implement later fuzzy counting */

static float pCptDistance2(int g1, int n1, int g2, int n2, int option)
{
  register int c = 0, d = 0 ;
  register short
    *a = arrp(bands,g1,short),
    *b = arrp(bands,g2,short);

  while (n1 && n2)
    if (*a == *b)
      {
	c++; n1--; n2--; a++; b++;
      }
    else if(*a > *b)
      {
	d++ ;n2--; b++  ;
      }
    else
      { 
	d++ ;n1--; a++;
      }
  return d / ((float)(c + d)) ;
}

/*******************************************************************/
/* returns the distance between  gel a and b */
/* the option is to implement later fuzzy counting */

static float pCptDistance(int gel1, int n1, KEY k2)
{
  OBJ B ;
  int  n2, gel2 ;

  B = bsCreate(k2) ;
  if(!B)
    return 1. ;
  if ( !bsGetData(B,_Bands,_Int, &gel2)
      || gel2 < 0
      || !bsGetData(B,_bsRight,_Int, &n2)
      || n2 < 0
      || n2 + gel2 > arrayMax(bands)
      )
    { bsDestroy(B) ;
      return 1. ;
    }
  bsDestroy(B) ;

  return pCptDistance2(gel1, n1, gel2, n2, 0) ;
}

/*******************************************************************/

static void pCptFindNeighbours(KEY k1, double mini, Array histo) 
{
  OBJ A ;
  int n1, gel1 , i , ii ;
  KEY k2 ;
  float x ;
  KEYSET ks ;
  register short *a ;

  PCPTGET(FindNeighbours) ;

  if(bands) 
    {  messout("First pick a project") ;
       return ;
     }
  A = bsUpdate(k1) ;
  if(!A)
    return ;
  if (!bsGetData(A,_Bands,_Int, &gel1)
      || gel1 < 0
      || !bsGetData(A,_bsRight,_Int, &n1)
      || n1 < 0
      || n1 + gel1 > arrayMax(bands)
      )
    { bsDestroy(A) ;
      return ;
    }

  a = arrp(bands,gel1,short) ;
  ii = n1 ;
  while (ii --)
    { i = *a++ ;
      ks = array(bands2clones,i ,KEYSET) ;
      if(ks) 
	i = keySetMax(ks) ;
      else
	i = 0 ;
      while(i--)
	{ k2 = keySet(ks,i) ;
	  x = pCptDistance(gel1, n1, k2) ;
	  if(x < mini)
	    { bsAddKey(A,_Neighbours,k2) ;
	      bsAddData(A,_bsRight,_Float, &x) ;
/*
	      bsAddKey(B,_Neighbour,k1) ;
	      bsAddData(B,_bsRight,_Float, x) ;
*/
	    }
	  array(histo,(int)(100*x),int)++ ;
	}
    }

  bsSave(A) ;
}

/*******************************************************************/

static void  pCptGetBand2Clones(void)
{
  Array bb ;
  int i = 0 , n = 0 ;
  KEY key ;
  char *cp ;
  KEYSET ks ;
  PCPTGET(GetBands2Clones) ;

  if(bands2clones)
    return ;
  bb = arrayCreate(1000,KEYSET) ;
  key = 0 ;
  while(lexNext(_VCalcul,&key))
    { cp = name(key) ;
      if(*cp++ == 'c' &&
	 *cp++ == 'o' &&
	 *cp++ == 'r' &&
	 sscanf(cp,"%d",&i)
	 )
	ks = arrayGet(key,KEY) ; /* i.e. keySetGet */
      if(ks)
	{ n++ ;array(bb,i,KEYSET) = ks ; }
    }

  bands2clones = bb ;
  graphText(messprintf("Found %d groups up to %d", 
		       n, arrayMax(bb)),2, look->line++) ;
  graphRedraw() ;
}

/*******************************************************************/

static void pCptFindAllNeighbours(void)
{
  KEY clone = 0 ;
  float mini = .5 ;
  int t = 0 ;
  Array histo ;
  PCPTGET(FindAllNeighbours) ;

  if(bands) 
    {  messout("First pick a project") ;
       return ;
     }
  pCptGetBand2Clones() ;
  histo = arrayCreate(100,int) ;
  while(t++ < 100000 && lexNext(_VClone, &clone)) 
    pCptFindNeighbours(clone, mini, histo) ;
  plotHisto("Clone distances", histo) ;
}

/*******************************************************************/

static void pCptGetBands(void)
{
  KEY key = 0 ;
  OBJ A ;
  int  t = 0, gel, n , x ;
  PCPTGET(GetBands) ;

  if(!bands)
    { messout ("First select a project") ;
      return ;
    }
  while(t++ < 100 && lexNext(_VClone,&key))   
  if (A = bsUpdate(key))
    { if (bsGetData(A,_Bands,_Int, &gel)
	&& bsGetData(A,_bsRight,_Int, &n)
	  && gel + n < arrayMax(bands))
	while (n--)
	  { x = (int) arr(bands,gel++,short) ;
	    bsAddData(A,_Cor,_Int,&x) ;
	  }
      bsSave(A) ;
    }
}

/*******************************************************************/
      /* Construct one keySet for each band value */
static void pCptBands2Clones(void)
{
  KEY clone = 0 , key ;
  KEYSET ks ;
  Array bb ;
  OBJ A ;
  int  gel, n , x , i ;
  PCPTGET(Bands2Clones) ;

  if(!bands)
    { messout ("First select a project") ;
      return ;
    }
  bb = arrayCreate(1000, KEYSET) ;
  while(lexNext(_VClone,&clone))   
  if (A = bsCreate(clone))
    { if (bsGetData(A,_Bands,_Int, &gel)
	&& bsGetData(A,_bsRight,_Int, &n)
	  && gel + n < arrayMax(bands))
	while (n--)
	  { x = (int) arr(bands,gel++,short) ;
	    ks = array(bb,x,KEYSET) ;
	    if(!ks)
	      ks = array(bb,x,KEYSET) = keySetCreate() ;
	    i = keySetMax(ks) ;
	    keySet(ks,i) = clone;
	  }
      bsDestroy(A) ;
    }
  for(i=0; i<arrayMax(bb); i++)
    { ks = array(bb,i,KEYSET) ;
      if(ks && keySetMax(ks))
	{ lexaddkey(messprintf("cor%d",i),&key,_VCalcul) ;
	  arrayStore(key,ks = array(bb,i,KEYSET)) ;
	  keySetDestroy(ks) ;
	}
    }
  arrayDestroy(bb) ;
}

/***********************************************************************/
static Graph pCptGraph = 0 ; 
static void pCptDestroy (void)
{ register int i ;
  PCPTGET(pCptDestroy);

  look->magic = 0 ;
  arrayDestroy(bands);
  keySetDestroy(friends) ;
  if(pairs)
    for(i=0;i<arrayMax(pairs);i++)
      keySetDestroy(arr(pairs,i,KEYSET)) ;
  arrayDestroy(pairs) ;
  messfree(look) ;
  pCptGraph = 0 ;
}

/**********************************************************/

static void pCptPick (int k)
{    
  PCPTGET(pCptPick) ;
  
  if (!k)
    return ;

  else  if (k == look->projectBox)
    if ( k== look->curr )
      pCptRead() ;
    else
      {
	if (look->curr)
	  graphBoxDraw (look->curr, BLACK, WHITE) ;
	look->curr = k ;
	graphTextEntry (look->project,0,0,0,0) ;
      }
  graphActivate(look->graph) ;
}

/*********************************************************************/
 
static MENUOPT
   pCptMenu[] = {
     graphDestroy,"Quit",
     help,"Help",
     pCptHisto,"Histogram",
     pCptGetBands,"Get bands",
     pCptBands2Clones, "Bands 2 clones",
     pCptFindAllNeighbours, "Find All neighbours",
     pCptCompareAll,"Compare bands",
     0,0
     } ;

/*************************************************************/

static void pCptDisplay(void)
{ int dx, dy ;
  PCPTGET(pcptDisplay) ;
 
  graphActivate(look->graph) ;
  graphClear() ;
  graphFitBounds(&dx,&dy) ;
  graphButtons(pCptMenu,3.,1.,.8*dx) ;
  
  if(!bands)
    {  graphText ("Project: ", 0.5, 5.0) ;
       look->projectBox =
	 graphTextEntry (look->project, 50, 10.5, 6.50, 
			 pCptRead) ;
       look->line = 8 ;
     }
  else
       look->line = 5 ;
  graphRedraw() ;
}

/*********************************************************************/
/********************  public routines   *****************************/

void pMapCompute(void)
{ LOOK look ;
  if(graphActivate(pCptGraph))
    { 
      graphPop() ;
      return ;
    }

  pCptGraph = graphCreate (TEXT_FIT,"PCpt ", 0.0,0.0,0.55,0.35) ;
  if (!pCptGraph)
      return ;
 /* provision for multi windows */

  look=(LOOK)messalloc(sizeof(struct LOOKSTUFF));
  look->magic = MAGIC;
  look->graph = pCptGraph ;
  strcpy(look->project,"900417");

  graphAssociate(pMapCompute,look) ;
  graphMenu(pCptMenu) ;
  graphHelp("Physical_map_calculation") ;
  graphRegister (DESTROY,pCptDestroy) ;
  graphRegister (PICK,(GraphFunc)pCptPick) ;
  graphRegister(RESIZE,(GraphFunc)pCptDisplay);

  pCptDisplay() ;
}

/*************************************************************/

Array pMapFingerPrint(KEY clone)
{
  int from, n ;
  Array fp = 0 ;
  OBJ Clone ;


  if(class(clone) != _VClone
     || !(Clone = bsCreate(clone)) )
    return 0 ;
  if(bsGetData(Clone,_Bands,_Int,&from)
     && bsGetData(Clone,_bsRight,_Int,&n))
    {
      if(!bands)
	{ pMapCompute() ;
	  messout("First pick a project name and read the data") ;
	}
      else
	if(from+n <= arrayMax(bands))
	  { fp = arrayCreate(n,short) ;
	    while(n--)
	      array(fp,n,short) = array(bands,from+n,short) ;
	  }
      else
	messout
	  ("Clone %s\n Band %d > Max %d of data file",
	   name(clone), from+n, arrayMax(bands)) ;
    }
  else
    messout("Sorry, no finger print data known about clone %s",
	    name(clone)) ;


  bsDestroy(Clone) ;
  return fp ;
}

/*************************************************************/
/*************************************************************/






