/*  Last edited: Apr  2 18:44 1992 (mieg) */

 
      /***************************************************************/
      /***************************************************************/
      /**  File defcpt.c  :                                         **/
      /**  Localises genes versus deficiencies.                     **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  Public routines                                            */
      /*                                                             */
      /*  1 routines are public :  gMapCompute()                     */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  17/3/91  by JTM.          */
      /*                                                             */
      /***************************************************************/


  /* defcpt.c
   * The idea is to compute the best order
   * for a set of NM markers
   * covered by ND deficiencies
   *
   * This question was asked to JTM by Charles Theillet dec 10-90
   * adapted to ACEDB feb 20-91
   *
   * Several strategies may coexist in this file
   */


#include "acedb.h"
#include  "lex.h"
#include "bs.h"
#include "a.h"
#include "sysclass.wrm"
#include "classes.wrm"
#include "systags.wrm"
#include "tags.wrm"
#include "plot.h"
#include "pick.h"
#include "keyset.h"
#include "graph.h"
#include "wormtype.h"
#include "topology.h"

extern long random(void) ;   /* Unix */
static int dupCost(Array b) ;
static int dupCost2(int i, Array b) ;

static int 
  bestCost ,
  NM = 0 ,   /* number of markers */
  ND = 0 ,   /* number of deficiencies */
  Line = 3;   /* for displays */

static Graph
  defMapGraph = 0 ,
  defTreeGraph = 0 ,
  defMapCtlGraph = 0;

static Array
  a = 0 ,   /* The matrix markers . deficiencies */
  b = 0 ,   /* The present order of the markers */
  bestOrder = 0 ,
  gmap ,     /* standard genetic positions */
  m = 0 ,   /* for the calculations */
  tree = 0 ,
  distances = 0 ,
  knownOrder = 0 ,
  knownPairs = 0 ;

#define data(def,gene)  array(a,(def)*NM + (gene), char)
#define dist(g1,g2)     arr(distances,(g1)*NM + (g2), float)
typedef struct { int g1, g2 ;} GENE_PAIR ;

static KEYSET
  genes = 0 , def = 0 ;   /* The genes and def */

/*************************************************************************/

static void
  localDestroy(void) ,
  defCptParseDB(void) ,
  defCptRead(void) ,
  defCptGetData(void) ,
  defCptCost(void) ,
  defCptShuffle(void) ,
  defCptMonteCarlo(void) ,
  defCptTree(void) ,
  defCptRefine(void) ,
  defMapDisplay(void) ,
  defCptHisto(void) ;


static MENUOPT defcptMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        graphPrint,"Print",
	defCptParseDB,"Parse database",
        defCptRead, "Read file",
        defCptGetData, "Get contig",
        defCptCost,"Cost",
        defCptShuffle,"Shuffle",
        defCptMonteCarlo,"Monte-Carlo",
        defCptTree,"intrinsic tree",
        defCptRefine,"Refine tree",
        defMapDisplay,"Map",
        defCptHisto,"Histo",
        NULL, NULL };


#define TEST  \
   if (!a) \
     { graphClear() ;\
       graphButtons (defcptMenu,0.25,0.25,60) ;\
       graphText("First read soma data",1,1) ;\
       graphRedraw() ;\
       return ;\
     }

typedef struct { KEY gene , ch ; float p ; } GMAPST ;
extern int intFlag ;
static   Array flag = 0 ;

/***********************************************/
  /* parse 0,2   7,11  all on one line
     meaning: 1-1-2   then 7-8-9-10-11
     are continuous blocks
     */

static void defCptGetBlocks()
{ int i, j, k,  n = 0 ;

  arrayMax(knownPairs) = 0 ;
  freenext() ;
  while(freeint(&i) && freeint(&j))
    for(k=i+1;k<=j;k++)
      { array(knownPairs,n,GENE_PAIR).g1 = k-1 ;
	array(knownPairs,n,GENE_PAIR).g2 = k ;
	n++ ;
      }
  graphText(messprintf("Found %d Blocks", n), 2,6) ;
}

/***********************************************/
  /* parse   1,3,4,7  4,7,8,11  etc
     all on one line
     meaning:  12 and 3 are to the left of 4,5,6,7   etc 
     */
static void  defCptGetOrder()
{ int i, j, k, l, u, v,  n = 0 ;

  arrayMax(knownOrder) = 0 ;
  freenext() ;
  while(freeint(&i) &&  freeint(&j) &&
	freeint(&k) &&  freeint(&l))
    for(u=i;u<=j;u++)
      for(v=k;v<=l;v++)
	{ array(knownOrder,n,GENE_PAIR).g1 = u ;
	  array(knownOrder,n,GENE_PAIR).g2 = v ;
	  n++ ;
	}
  graphText(messprintf("Found %d Orders", n), 30,6) ;
}
	
/***********************************************/

static void defCptRead(void)
{
  /* read the data from an external file
   */
  int i, ii,  x, n, nm, line = 0;
  char * cp ;
  int   goodLines = 0 ;  
  FILE * f;
  
  if(! graphPrompt("absolute file name :","./defmapdata","w"))
    return ;
  arrayDestroy(a) ;
  arrayDestroy(b) ;
  arrayDestroy(bestOrder) ;
  arrayDestroy(flag) ;
  arrayDestroy(m) ;
  arrayDestroy(knownPairs) ;
  arrayDestroy(knownOrder) ;
  keySetDestroy(genes) ;
  keySetDestroy(def) ;
  
  f = fopen(cp =freeword(),"r") ;
  if (!f)
    {
      messout("Cannot open %s",cp) ;
      return ;
    }

  a = arrayCreate(100,char) ;
  flag = arrayCreate(50,int) ;
  knownPairs = arrayCreate(10,GENE_PAIR) ;
  knownOrder = arrayCreate(10,GENE_PAIR) ;
  n = 0; nm = 0 ;
  while(line++, freeread(f))
    if(!goodLines)
      {
	/* skip the comment lines */
	if(!freeint(&x))
	  continue ;
	/* Read the flag line */
	i = 0;
	while(TRUE)
	  { array(flag,i++,int) = x ;
	    if(!freeint(&x)) break ;
	  }
	nm = i;
	goodLines = TRUE ;
	continue ;
      }
    else
      {
	i = 0;
	while(freeint(&x))
	  {
	    if( x!=0 && x!=1 ) 
	      {
		messout(
 "Line %d of file %s, the %dth entry is %d, should be 0 or 1",
			line, cp, i, x) ;
		goto abort ;
	      }
	    array(a,n++,char) = (char) (x + 1) ;
	    i++ ;
	  }

	if(!i)
	  break ;
	if(i && (nm != i))
	  { messout("Line %d has %d entry, line 1 %d, I quit",
		    line, i, nm);
	    goto abort ;
	  }
      }
  NM = i = nm;
  ii = 0;
  while(i--)
    ii += array(flag,i,int) ;
  if(NM) ND = n/NM ;

  graphActivate(defMapCtlGraph) ;
  graphPop() ;
  graphClear() ;
  graphButtons (defcptMenu,0.25,0.25,60) ;
  graphText("File :",1,5);
  graphText(cp,8,5) ;
  graphText
    (messprintf
     ("%d markers, %d used,  %d deficiencies", NM,ii,  ND) , 12,5) ;

  while(line++, freeread(f))
    if (cp = freeword())
      { if(!strcmp("BLOCKS",cp))
	  { freeread(f) ;
	    defCptGetBlocks() ;
	  }
	else if(!strcmp("ORDER",cp))
	  { freeread(f) ;	 
	    defCptGetOrder() ;
	  }
	else 
	  { messout("I dont understand the input %s",cp) ;
	    goto abort ;
	  }
      }

  graphRedraw() ;
    
  if(NM)
    return ;

 abort:
  arrayDestroy(a) ;
  arrayDestroy(knownPairs) ;
  arrayDestroy(knownOrder) ;
}
 
/**********************************************/

static BOOL defDatum(KEY key,LINK* ca)
{
  OBJ obj = bsCreate(key) ;
  int x ;
  BOOL done = FALSE ;
  KEY def, gene ;
  char *cp ;
  if(!obj) return FALSE ;
  
  if( bsGetKey(obj,_Rearrangement, &def)
     && bsGetKey(obj,_Gene, &gene)
     && isDeficiency(def)
     && bsGetData(obj,_Results,_Text,&cp)
     )
    { if (pickMatch(cp,"*does not delete*"))
	x = 1 ;
      else if (pickMatch(cp, "* deletes *"))
	x = 2 ;
      else
	x = 0 ;
      if (x)
	{ done = TRUE ;
	  ca->a = def ;
	  ca->b = gene ;
	  ca->type = x ;
	  ca->group = 0 ;
	}
    }
  bsDestroy(obj) ;
  return done ;
}

/*********************************************************/

static void defCptParseDB(void)
{
  Array cc ; LINK c ;
  KEY defData ; 
  int n , tTotal = 0 , box ;
  KEY  key = 0 ;
  Array histo , vertex ;
  KEYSET
    defs = keySetCreate() ,
    genes = keySetCreate() ;
        

  graphActivate(defMapCtlGraph) ;
  graphPop() ;
  graphClear() ;
  graphButtons (defcptMenu,0.25,0.25,60) ;
  lexaddkey("defData", &defData,_VCalcul) ;

  graphText
    (messprintf
     ("I will scan the %d 2_point_data looking for deficiencies",
      lexMax(_V2_point_data))
     ,3,5) ;
  graphText
    ("Do not repeat this operation untill you modify the 2_point_data",
     3,6) ;
  graphRedraw() ;

  cc = arrayCreate(50, LINK) ;
  n = 0 ;
  while(lexNext(_VDf_Dup_data, &key))
    if( defDatum(key,&c))
      array(cc, n++,LINK) = c ;
  while(n--)
    { c = array(cc, n, LINK) ;
      keySetInsert(defs, c.a) ;
      keySetInsert(genes, c.b) ;
    }
  
  box = graphBoxStart() ;
  graphText(
	    messprintf("Found %d usable 2 point data out of %d",
		       arrayMax(cc), lexMax(_VDf_Dup_data)),
	    3, 7) ;
  graphText(
	    messprintf("   %d deficiencies tested against %d genes",
		       keySetMax(defs), keySetMax(genes)),
	    3, 8) ;
  graphText("I will now assemble these into contigs, please wait",
	    3,9) ;
  graphBoxDraw(box, BLACK,WHITE) ;

  n = arrayMax(cc) ;
  vertex = arrayCreate(n/2, VERTEX) ;
  tTotal = topoConnectedComponents(cc, vertex) ;
  
  box = graphBoxStart() ;
  graphText(messprintf("found %d contigs",tTotal), 2,10) ;
  graphBoxDraw(box, BLACK,WHITE) ;
  histo = arrayCreate(20,int) ;
  n = arrayMax(vertex) ;
  while(n--)
    array(histo, arr(vertex,n,VERTEX).group, int)++ ;
  plotHisto("Genes or Def per  contig",histo) ;

  arrayStore(defData,cc, linkFormat) ;
  arrayDestroy(cc) ;
  arrayDestroy(vertex) ;
  keySetDestroy(genes) ;
  keySetDestroy(defs) ;
}

/***********************************************/

static int gmapOrder(void *a, void *b)
{
  float x =
    ((GMAPST *) a)->p - ((GMAPST *) b)->p ;
  return
    x < 0 ? -1 
      : ( x== 0 ? 0 : 1 ) ;
}

/***********************************************/

static void defCptGetPos(void)
{
  register int i = arrayMax(genes);
  float p ; KEY ch ; OBJ G ;
  KEY gene ; int j ; Array gmapOrdered ;
  arrayDestroy(gmap) ;
  gmap = arrayCreate(i,GMAPST) ;

  while(i--)
    { array(gmap,i,GMAPST).gene = keySet(genes,i) ;
      arr(gmap,i,GMAPST).p = 0 ;
      G = bsCreate(keySet(genes,i)) ;
      if(G)
	{ if(bsGetKey(G,_gMap,&ch))
	    { arr(gmap,i,GMAPST).ch = ch ;
	      if(bsGetData(G,_bsRight,_Float,&p))
		arr(gmap,i,GMAPST).p = p ;
	    }
	  bsDestroy(G) ;
	}
    }
  gmapOrdered = arrayCopy(gmap) ;
  arraySort(gmapOrdered,gmapOrder) ;

  i = keySetMax(gmap) ;
  bestOrder = arrayCreate(i,int) ;
  while(i--)
    { gene = array(gmapOrdered,i,GMAPST).gene ;
      keySetFind(genes,gene,&j) ;
      array(bestOrder,i,int) = j ;
    }
  bestCost = dupCost(bestOrder) ;
  arrayDestroy(gmapOrdered) ;
}

/***********************************************/
  /* Genes are inequivallent if tested data differ */

typedef struct { int gg, np, nm, nn, cl ; } EQCL ;
/*********/
static int eqclOrder(void *a, void *b)
 { EQCL aa, bb ;

  aa = *(EQCL *)a ;
  bb = *(EQCL *)b ;

 
  if(aa.nn > bb.nn) return 1 ;
  if(aa.nn < bb.nn) return -1 ;
  
  if(aa.np > bb.np) return 1 ;
  if(aa.np < bb.np) return -1 ;
  
  return 0;
}

/**********/

/* g1 and g2 are equivalent if g2 data is 
   a subset of g1 data
   */
static int   defCptEquivalences(void)
{ int i, j, k, g , h ;
  Array e = arrayCreate(NM,EQCL) ;

  for(i=0; i<ND; i++)
    for(j=0;j<NM;j++)
      switch (data(i,j))
	{
	case 1:
	  array(e,j,EQCL).nm++ ;
	  array(e,j,EQCL).nn++ ;

	case 2:
	  array(e,j,EQCL).np++ ;
	  array(e,j,EQCL).nn++ ;
	}

  for(j=0;j<NM;j++)
    array(e,j,EQCL).gg = j ;

  arraySort(e,eqclOrder) ;
  for(j=0;j<NM;j++)
    { for(k=0;k<j;k++)
	if(arr(e,j,EQCL).nm < arr(e,k,EQCL).nm
	   && arr(e,j,EQCL).np < arr(e,k,EQCL).np)
	  { g = array(e,j,EQCL).gg ;
	    h = array(e,k,EQCL).gg ;
            for(i=0; i<ND; i++)
	    if (data(i,g)
		&& data(i,g) != data(i,h))
	      goto nextk ;
	    arr(e,j,EQCL).cl = arr(e,k,EQCL).cl ;
	    goto nextj ;
	  nextk: ;
	  }
    nextj:;
    }




  return 0 ;


}

/***********************************************/
   /* Get data prepared by parseDefData */
static void defCptGetData(void)
{
  int i, j, n, nm, t , NMusable , NQ , line ;
  Array cc ; LINK c ;
  KEY defData ; 


  arrayDestroy(a) ;
  arrayDestroy(b) ;
  arrayDestroy(bestOrder) ;
  arrayDestroy(flag) ;
  arrayDestroy(m) ;
  keySetDestroy(genes) ;
  keySetDestroy(def) ;
  
  graphClear() ;
  graphButtons (defcptMenu,0.25,0.25,60) ;
  if(! graphPrompt("Def contig number ?","1","i")
     || !freeint(&t))
    return ;
  lexaddkey("defData", &defData,_VCalcul) ;
  cc  = arrayGet(defData,LINK, linkFormat) ;
  if(!cc)
    { graphText("First read the data", 2,5) ;
      graphRedraw() ;
      return ;
    }

  a = arrayCreate(100,char) ;
  flag = arrayCreate(50,int) ;
  def = keySetCreate() ;
  genes = keySetCreate() ;
  

  n = 0; nm = 0 ;
  n = arrayMax(cc) ;
  while(n--)
    { c = array(cc, n, LINK) ;
      if(t == c.group 
	 && class(c.a) == _VRearrangement)
	{ keySetInsert(def, c.a) ;
	  keySetInsert(genes, c.b) ;
	}
    }

  NM = keySetMax(genes) ;
  ND = keySetMax(def) ;

  n = arrayMax(cc) ;
  while(n--)
    { c = array(cc, n, LINK) ;
      if(t == c.group && c.type 
	 && class(c.a) == _VRearrangement)
	{ if(keySetFind(def,c.a,&i) &&
	     keySetFind(genes,c.b,&j) )
	    { data(i,j) = (char) c.type ;
/*	      printf("\n %d %d %d %c %s %s",
		     i,j,c.type,data(i,j),
		     name(c.a), name(c.b)) ;
*/	    }
	  else
	    messcrash("Cant find %d -> %s\n%d->%s",
		      i, name(c.a),
		      j, name(c.b)) ;
	}
    }

/* The genes never uncovered cannot be mapped, so their flag stays 0 */
  NMusable = 0 ;
  for(i=0; i<ND; i++)
    for(j=0;j<NM;j++)
      if (data(i,j) == 2)
	if(!array(flag,j,int))
	  { NMusable++ ; array(flag,j,int) = 1 ; }
  if(NM)
    NQ = defCptEquivalences() ;
  defCptGetPos() ; 
  graphClear() ;
  graphButtons (defcptMenu,0.25,0.25,60) ;
  line = 6 ;
  graphText("Contig :",1,line);
  graphText(messprintf("%d",t),8,line) ;
 line += 2 ;
  graphText
    (messprintf
     ("%d markers, %d used,  %d deficiencies", NM, NM,  ND) , 12,line++) ;
  graphText
    (messprintf
     ("%d markers are uncovered at least once", NMusable) , 12,line++) ;
  graphText
    (messprintf
     ("The NM genes belong to %d equivalency classes", NQ) , 12,line++) ;

  graphRedraw() ;
  Line = 8;
  if(!NM)
    { arrayDestroy(a) ;
      a = 0 ;
    }
}
 
/***************************************************************/

static MENUOPT defMapGraphMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        graphPrint,"Print",
        NULL, NULL };

static void defMapGraphCreate(void)
{ 
  defMapGraph = graphCreate(TEXT_SCROLL,"Deficiency map", 0.0,0.25,0.4,0.65) ;
  graphRegister(DESTROY, localDestroy) ;
  graphMenu(defMapGraphMenu) ;
  graphHelp("Deficiency_map") ;
}

/***************************************************************/

static void  defMapDisplay(void)
{ 
  int  i, j , g , line = 1;

  if(graphActivate(defMapGraph))
    graphPop() ;
  else
    defMapGraphCreate() ;
  if(!genes || !keySetMax(genes))
    { messout("This works only from the database") ;
      return ;
    }
  graphClear() ;

  graphTextBounds(2*ND + 48, NM + NM/2 + 12) ;
  for(i=0; i< keySetMax(def) ; i++)
    { graphText(messprintf("%3d : ",i), 15 *(i%2),i/2 + 2) ;
      graphText(name(keySet(def,i)), 7 + 15 *(i%2), i/2 + 2) ;
    }
  line = i/2 + 3 ;
  graphBoxStart() ;
  bestCost = dupCost(bestOrder) ;
  graphText(messprintf("Cost %d", bestCost),1,line) ;
  line += 2 ;
  for (i=0;i<arrayMax(bestOrder);i++)
    { g = array(bestOrder,i,int) ;
      for (j = 0; j < ND; j++)
	switch((int)data(j,g))
	  {
	  case 0:
	    graphText(".", 2*j + 4 , i+line) ;
	    break ;
	  case 1:
	    graphText("|", 2*j + 4 , i+line) ;
	    break ;
	  case 2:
	    graphText("*", 2*j + 4 , i+line) ;
	    break ;
	  }
      graphText(name(keySet(genes,g)), 2*j + 8, i+line) ;
      graphText(name(array(gmap,g,GMAPST).ch), 2*j + 18, i+line) ;
      graphText(messprintf("%6.2f",array(gmap,g,GMAPST).p), 2*j + 21, i+line) ;
    }
  
  graphBoxEnd() ;
  graphRedraw() ;
}

/***************************************************************/

static void defCptHisto(void)
{
  Array  h1, h2 ;
  register   int i;
  register  char *cp ;  

  TEST ;

  /* h1 : Histo des nombres de marqueurs par dup */
  /* h2 : Histo des nombres de dup par marqueur */
  h1 = arrayCreate(ND, int) ;
  h2 = arrayCreate(NM, int) ;

  i = arrayMax(a) ;
  cp = arrp(a,0,char) ; cp--;
  while(cp++, i--) 
    if(*cp == 2)  /* dup i/NM  covers marker i%NM */
      { array(h1,i/NM,int)++ ;
	array(h2,i%NM,int)++ ;
      }
  plotHisto("Number of marker per deficiency", h1);
  plotHisto("Number of deficiency per marker", h2);
  /* note that h1, h2 will be destroyed later by plotHisto */
}

/***************************************************************/

static void defCptShuffle(void)
{
  register   int i, j, n;

  TEST ;

  if(!b)
    b = arrayCreate(NM,int) ;
  else
    arrayMax(b) = 0 ;

  i = NM ;
  while(i--)
    array(b,i,int) = 0 ;  /* forget */

  n = NM ;
  j = 0 ;    /* initial position */
  while (n)
    { 
      i = 1 + ((int) random()) % n ;
      while (i--)          /* skip i empty positions */
	  { j++; j %= NM ; 
	    while(arr(b,j,int))    { j++; j %= NM ;}
	  }
      array(b,j,int) = --n ;
    }
}

/***************************************************************/

static int foundMarker(int j,Array b)
{
  register int i = arrayMax(b) ;
  while(i--)
    if(arr(b,i,int) == j)
      return (i+1) ;
  return 0 ;
}


/***************************************************************/

static BOOL brokenGivenPair(Array b, int x, int y)
{
  int i,j ;
  
  if ((i = foundMarker(x,b)) && (j = foundMarker(y,b))
      && i != j-1 )
    return TRUE ;
  return FALSE ;
}

/***************************************************************/

static BOOL brokenGivenOrder(Array b, int x, int y)
{
  register int i,j ;
  
  if ((i = foundMarker(x,b)) && (j = foundMarker(y,b))
      && i > j)
    return TRUE ;
  return FALSE ;
}

/***************************************************************/

  /* Hackers way to impose some partial order */
static BOOL brokenLink(Array b)
{ int n ;

  if(knownPairs)
    { n = arrayMax(knownPairs) ;
      while(n--)
	if(brokenGivenPair(b,arr(knownPairs,n,GENE_PAIR).g1,
			    arr(knownPairs,n,GENE_PAIR).g2 ))
	  return TRUE ;
    }

  if(knownOrder)
    { n = arrayMax(knownOrder) ;
      while(n--)
	if(brokenGivenOrder(b,arr(knownOrder,n,GENE_PAIR).g1,
			    arr(knownOrder,n,GENE_PAIR).g2 ))
	  return TRUE ;
    }
  return FALSE ;
}

/***************************************************************/
   /* the cost is the number of flip from 0 to 1 minus 1 */

static int dupCost2(int i, Array b)
{
 register int c=-1, m ;
 register char previous = 1 , new ;

 for (m=0;m<arrayMax(b);m++)
   { new =  data(i,arr(b,m,int)) ;
     if(new)
      { if(previous == 1 && new == 2) c++ ;
	previous = new ;
      }
   }
 if (c == -1)
   c=0 ; /* case of an empty dup */
 return c ;
}


/***************************************************************/
   /* the cost is the number of flip from 0 to 1 minus 1 */
   /* plus a huge penalty if known bounds are broken */
static int dupCost(Array b)
{ register int i = ND, cc = 0 ;
  
  if(brokenLink(b))
    return (2*NM*ND) ;
  while(i--)
    cc += dupCost2(i,b) ;
 return cc ;
}

/***************************************************************/

static void mapFlip(void)
{
  register int i , j , n1, n2 ;
  n1 = n2 = 0 ;
  j = arrayMax(b) ;
  i = j/2 ;
  while(i--)
    {
      n1 += arr(b,i,int) ;
      n2 += arr(b,j-i-1,int) ;
    }
  if(n1>n2)
    { i = j/2 ;
      while(i--) 
	{ n1 = arr(b,i,int) ;
	  arr(b,i,int) = arr(b,-i + j -1 ,int) ;
	  arr(b, j -1 -i,int) = n1 ;
	}
    }
}

/***************************************************************/

static void defCptCost(void)
{
  register   int i, cc, box ;

  TEST ;

  if (!b)
    { b = arrayCreate(NM,int) ;
      i = NM ;
      while(i--)
	array(b,i,int) = i ;
    }
  mapFlip() ;
  cc = dupCost(b) ;
  box = graphBoxStart() ;
  graphText("order ",1,++Line) ;
  for (i=0;i<arrayMax(b);i++)
    graphText(messprintf("%d",array(b,i,int)), 9+3*i,Line) ;
  graphText(messprintf("cost %d",cc),1,++Line) ;
  Line++ ;
  graphBoxEnd() ;
  graphTextBounds(100,Line + 3) ;
  graphBoxDraw(box,BLACK,WHITE) ;
}

/***************************************************************/
typedef struct  { int cost; Array b;} MAP ;
static int MAX=5 ;
static int  costOrder(void *a, void *b)
{
  return (((MAP*)a)->cost - ((MAP*)b)->cost) ;
}

/***************************************************************/

static void defCptMonteCarlo(void)
{
  Array   bb, bb2, junka;       /* aliases do not create nor destroy */
  static Array m2 = 0;
  register   int i,j,k,l ;
  int   box, maxCost , nmap , jj ;
  int n, new ,  nm2 , localBestCost = 4*NM*ND ;
  
  TEST ;

  /* we initialize a table of cost functions */

  if (!m) 
    m = arrayCreate(MAX,MAP) ;

  i = arrayMax(m) ;
  while (i--)
    arrayDestroy(array(m,i,MAP).b);
      
  /* We start the previous  total cost */
  if(!b) 
    defCptShuffle() ;

  maxCost = dupCost(b) ;
  if (!bestOrder) 
    { bestCost = maxCost ;
      bestOrder = arrayCopy(b) ;
    }

   /* This will control the lenght of the calculation */
  if(  graphPrompt("How many tries","5","i"))
    freeint(&MAX) ;
  else
    return ;

  i = MAX ;
  while(i--)
    {
      array(m,i,MAP).b = arrayCreate(NM,int) ;
      array(m,i,MAP).cost = 2*NM*ND;
    }
  arrayMax(m) = MAX ;  /* at most */
  nmap = 0 ;

  /* now we establish some random order of inclusion */
  defCptShuffle() ;
  
  /* we initialize with a map with 2 entries */
  arrayMax(m) = 1;
  bb = array(m,0,MAP).b;
  arrayMax(bb) = 0;
  i = jj = 0 ;
  while(i<2) 
    {
      if (array(flag,arr(b,jj,int),int))
	array(bb,i++,int) = array(b,jj,int) ;
      jj++ ;
    }

  /* now we include new marker 
   * in all posible ways in previous maps *      
   */
  if(!m2)
    m2 = arrayCreate(100,MAP) ;      
  for(j=jj;j<NM;j++)
    {
      if(!array(flag,arr(b,j,int),int))
	continue ;
      nm2 = arrayMax(m2) = 0 ;
      new = arr(b,j,int) ;
      n = arrayMax(m) ;
      if(n>MAX) n = MAX ;
      for (i=0;i<n;i++)
	{
	  bb = arr(m,i,MAP).b ;
	  for (k=0;k<=arrayMax(bb);k++, nm2++)
	    {
              if(intFlag)
		{ intFlag = 0 ;
		  bb = bestOrder ;
		  l = arrayMax(b) = arrayMax(bb) ;
		  while(l--)
		    arr(b,l,int) = arr(bb,l,int) ;
		  defCptCost() ;
		}
	      bb2 = array(m2,nm2,MAP).b ;
	      if(!bb2)
		bb2 = array(m2,nm2,MAP).b = arrayCreate(NM,int) ;
	      arrayMax(bb2) = 0;
	      for (l=0;l<k;l++)
		array(bb2,l,int) = array(bb,l,int) ;
	      array(bb2,k,int) = new ;
	      for (l=k;l<arrayMax(bb);l++)
		array(bb2,l+1,int) = array(bb,l,int) ;
	      array(m2,nm2,MAP).cost = dupCost(bb2) ;
	    }

	}
      junka = m ; m = m2 ; m2 = junka ;
      arraySort(m, costOrder) ;
    }

  if(arrayMax(m))
    { if(localBestCost > array(m,0,MAP).cost )
	localBestCost = array(m,0,MAP).cost ;
      if(bestCost > array(m,0,MAP).cost )
	{ bb = array(m,0,MAP).b ;
	  l = arrayMax(bestOrder) = arrayMax(bb) ;
	  while(l--)
	    array(bestOrder,l,int) = arr(bb,l,int) ;
	  bestCost = array(m,0,MAP).cost ;
	}
    }
  
  box = graphBoxStart() ;
  graphText(messprintf("lowest cost %d",localBestCost),1,++Line) ; 
  graphBoxEnd() ;
  graphTextBounds(100,Line + 3) ;
  graphBoxDraw(box,BLACK,WHITE) ;

  i = -1;
  while(((++i)<arrayMax(m)) && ( bestCost == array(m,i,MAP).cost ))
    {
      bb = array(m,i,MAP).b ;
      l = arrayMax(b) = arrayMax(bb) ;
      while(l--)
	arr(b,l,int) = arr(bb,l,int) ;
      defCptCost() ;
    }

    /* Attention, the inner arrays are probably not destroyed */
}

/***************************************************************/
  /* this is another method based on the intrinsic tree */
  

  /* distance between genes g1 and g2 */
static void makeDistances(void)
{ register int i , j, k,  u, v ;

  TEST ;
  arrayDestroy(distances) ;
  distances = arrayCreate(NM*NM,float) ;
  array(distances,NM*NM - 1, float) = 0 ;
  i = NM;
  while(i--)
    { dist(i,i) = 0 ;
      j = i;
      while(j--)
	{ k = ND ;
	  u = v = 0 ;
	  while(k--)
	   { register char x = data(k,i), y = data(k,j);

	     switch (x)
	       { case 0:
		   switch(y)
		     { case 0:
			 break;
		       case 1:
			 u++ ;
			 break;
		       case 2:
			 u++ ;
			 break ;
		       }
		   break ;
		 case 1:
		   switch(y)
		     { case 0:
			 u++ ;
			 break;
		       case 1:
			 v+=2 ;
			 break;
		       case 2:
			 u+=2 ;
			 break ;
		       }
		   break ;
		 case 2:
		   switch(y)
		     { case 0:
			 u++ ;
			 break;
		       case 1:
			 u+=2 ;
			 break;
		       case 2:
			 v+=2 ;
			 break ;
		       }
		   break ;
		 }
	   }     
	  if (!u && !v) u = 1 ;
	  dist(i,j) = dist(j,i) = u / ((float) ( u + v )) ;
	}
    }
}

/********************************/
typedef struct { int n; KEYSET next ;} TR;
#define myabs(x) ( (x) < 0 ? (-(x)) : (x) )

/********************************/

static void defTreeGraphCreate(void)
{ 
  defTreeGraph = graphCreate(TEXT_SCROLL,"Deficiency tree",
			    0.180,0.25,0.4,0.65) ;
  graphRegister(DESTROY, localDestroy) ;
  graphMenu(defMapGraphMenu) ;
  graphHelp("Deficiency_map") ;

  graphTextBounds(80,NM + 5) ;
}

/********************************/

static void  defTreePlotGene(int i, int x, int y)
{ 
  graphText
    ( messprintf
     ("%s %6.2f",
      name(keySet(genes,i)),
      array(gmap,i,GMAPST).p
      ), 2 + 8*x, 2 + NM - y) ;
  array(bestOrder,NM - 1 - y,int) = i ;
}

/********************************/
static int yTree ;
static void  defTreePlotNext(int i, int x)
{
  int j , k , n ;
  KEYSET s = arr(tree,i,TR).next ;

  arr(tree,i,TR).n = 1 ; /* to prevent looping */
  if (s)
    { /*
j = keySetMax(s) ;
      if(j>1)
	n = j - 2 ; // exactly one, the father, is already drawn 
      else 
*/
	n = 0 ;
     for(j=0; j< keySetMax(s); j++)
	{ k = keySet(s,j) ;
	  if(!arr(tree,k,TR).n)
	    defTreePlotNext(k, x + n++) ;
	}
    }
  defTreePlotGene(i,x,yTree++) ;
}

/********************************/

static void defTreeClearN(void)
{ register int i = NM ;

  while(i--)
    arr(tree,i,TR).n = 0 ;
}

/********************************/

static int defTreeEnd(int k)
{ KEYSET s = arrp(tree,k,TR)->next ;
  int i = keySetMax(s) ;
  int j = -1 , l = -1 , myself = arr(tree,k,TR).n ;

  if(myself == 1)
    return k ;
  while(i--)
    { register int n = arr(tree,keySet(s,i),TR).n ;
      if(n<myself && n>l)
	{ l = n ; j = keySet(s,i) ;}
    }
  if(j == -1)
    messcrash("bad tree in defTreeEnd, sory") ;
  return defTreeEnd(j) ;
}

/********************************/

static int defTreeLength(int k)
{ KEYSET s = arrp(tree,k,TR)->next ;
  int i = keySetMax(s) , l = 0 ;

  arr(tree,k,TR).n = 1 ; /* To prevent looping */
  while(i--)
    { register int n ;
      if(!arr(tree,keySet(s,i),TR).n) /* not the father */
	if((n = defTreeLength(keySet(s,i))) > l)
	  l = n ;
    }
  arr(tree,k,TR).n = ++l ; /* ++ for self */
  return l ;
}

/********************************/
  /* Sort the sons by decreasing length 
     so eldest branch  percolates best 
     NB. Remember that lengths have been negated before sort call.
     */
static int defTreeOrder(void *a, void *b)
{ return 
    arr(tree,*(KEY*)a,TR).n 
    - arr(tree,*(KEY*)b,TR).n  ;
}

/*******/

static void defTreeSort(int k)
{ KEYSET s = arrp(tree,k,TR)->next ;
  int i = keySetMax(s) ;

  arr(tree,k,TR).n *= -1 ; /* To prevent looping */
  while(i--)
    if(arr(tree,keySet(s,i),TR).n > 0) /* not the father */
      defTreeSort(keySet(s,i)) ;
	
  arraySort(s,defTreeOrder) ;
}

/********************************/

static int defTreeFindHead(void)
{ int i ;

  defTreeClearN() ;
  defTreeLength(0) ; /* arbitrary strarting point */
  i = defTreeEnd(0) ;
  defTreeClearN() ;
  defTreeLength(i) ; /* Move backwards */
  defTreeSort(i) ;
  return i ;
}

/********************************/

static void defTreePlot(void)
{ int first = 0 ;
  
  if(graphActivate(defTreeGraph))
    { graphPop() ;
      graphClear() ;
    }
  else
    defTreeGraphCreate() ;
  if(!tree) 
    return ;

  if(!bestOrder)
    bestOrder = arrayCreate(NM,int) ;
  yTree = 0 ;
  first = defTreeFindHead() ;
  defTreeClearN() ;
  defTreePlotNext(first, 0) ;

  graphText
    (messprintf("Cost : %d",bestCost =  dupCost(bestOrder)),1,1) ;
  graphRedraw() ;
}

/********************************/

static void defCptTree(void)
{
  register   int i,j , n=2 , newn, nn ;
  int newi, newj ;
  float gdx, gd , max , x ;

  TEST ;

  /* we initialize a table of distances */
  makeDistances() ;
  defCptGetPos() ;

  if(tree)
    if(i=arrayMax(tree))
      while(i--)
	keySetDestroy(arr(tree,i,TR).next) ;
     
  arrayDestroy(tree) ;
  tree = arrayCreate(NM,TR) ;
  array(tree,NM - 1,TR).n = 1 ;
  arr(tree,NM-1,TR).next = keySetCreate() ;

  while(TRUE)
    {
      newi = newj = -1 ; max = 10000 ; nn = -1 ;
      gdx = 100000; /* distances can exceed 1 */
      i = NM ;
      while(i--)
	if(newn = arr(tree,i,TR).n)  /* for those already in tree */
	  { j = NM ;
	    while(j--)
	      if(!arr(tree,j,TR).n) /* among those not in tree */
		{ x = dist(i,j) ;
		  if(x < max )
		    { max = x ; newi = i ; newj = j ; nn = newn ;
		      if(   arr(gmap,i,GMAPST).p 
			 && arr(gmap,j,GMAPST).p
			 )
			gdx = myabs(arr(gmap,j,GMAPST).p 
				    - arr(gmap,i,GMAPST).p ) ;
		    }
		  else if ( x == max )
		    { if( arr(gmap,i,GMAPST).p 
			 && arr(gmap,j,GMAPST).p )
			gd =
			  myabs(arr(gmap,j,GMAPST).p 
				- arr(gmap,i,GMAPST).p ) ;
		      else
			gd = 10001 ;
		          /* favor long branches */
		      if (((newn > nn) && (gd == gdx))
			  || (gd < gdx)) {
			  newi = i ; newj = j ; 
			  gdx = gd ; nn = newn ;
			}
		    }
		}
	  }
      if(newi == -1)
	break ;
      arr(tree,newj,TR).n = n++ ;
      arr(tree,newj,TR).next = keySetCreate() ;
      i = keySetMax(arr(tree,newi,TR).next) ;
      keySet(arr(tree,newi,TR).next,i) = newj ;
      keySet(arr(tree,newj,TR).next,0) = newi ;
    }
  defTreePlot() ;
}

/********************************/

static void defCptRefine(void)
{

  TEST ;

  arrayDestroy(b) ;
  b = arrayCopy(bestOrder) ;
  mapFlip() ;
}

/*************************************************************************/

static void localDestroy(void)
{ register int i ;

  if(graphActivate(defMapGraph))
    { graphDestroy() ;
    }
  if(graphActivate(defTreeGraph))
    { graphDestroy() ;
    }
  if(graphActivate(defMapCtlGraph))
    {
      arrayDestroy(a) ;
      arrayDestroy(b) ;
      arrayDestroy(bestOrder) ;
      if(m)
	{ i = arrayMax(m) ;
	  while (i--)
	    arrayDestroy(array(m,i,MAP).b);
	}
      arrayDestroy(m) ;
      arrayDestroy(flag) ;
      arrayDestroy(gmap) ;
      if(tree)
	if(i=arrayMax(tree))
	  while(i--)
	    keySetDestroy(arr(tree,i,TR).next) ;
      arrayDestroy(tree) ;
      arrayDestroy(distances) ;
      keySetDestroy(genes) ;
      keySetDestroy(def) ;
      arrayDestroy(knownPairs) ;
      arrayDestroy(knownOrder) ;
      defMapCtlGraph = 0 ;
      graphDestroy() ;
    }
}

/*************************************************************************/
/********************  public routine  ***********************************/

void defCompute(void)
{
  Line = 8 ;
  if(graphActivate(defMapCtlGraph))
    { graphPop() ;
      return ;
    }

  defMapCtlGraph = graphCreate (TEXT_SCROLL,
    messprintf("Genetic Map by Def/Dup analysis"),
		    0.60,0.0,0.65,0.25) ;
  graphTextBounds (100,30) ;
  graphButtons (defcptMenu,0.25,0.25,60) ;

  graphRegister(DESTROY, localDestroy) ;
  graphMenu(defcptMenu) ;
  graphHelp("Deficiency_map") ;

  graphColor (BLACK) ;
  graphRedraw() ;
}

/*************************************************************/
/*************************************************************/
