/*  Last edited: Nov 28 15:42 1991 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File plot.c :                                            **/
      /**  Plot various sorts of data.                              **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  1 routines is  public :  plotHisto()                       */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified 20/6/90  by JTM.           */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "array.h"
#include "graph_.h"  /* Needed for makeReticule */

#define MAGIC 11111

typedef struct LOOKstruct
  { int   magic ;
    Array a;
    char * title ;
    int  xyBox ;
    char xBuf[16], yBuf[16] ;
    float x,y , miny, maxy, maxx ;
    int retBox ;
    Graph graph ;
  } *LOOK ;

#define LOOKGET(name)     LOOK look ; \
       			  if (!graphAssFind (plotHisto,&look)) \
		            messcrash ("graph not found in %s", name) ; \
			  if (!look) \
                            messcrash ("%s received a null pointer",name) ; \
                          if (look->magic != MAGIC) \
                            messcrash ("%s received a wrong pointer",name)

void plotHisto(char *title, Array a) ;
/*
static void histoPickX(void) ;
static void histoPickY(void) ;
*/

/*************************************************************************/
    /* returns 1 , 2 , 5 ,10 , 20, 50 ,100 etc */
static int regular(int p)
{
 register int i=1,j=1;
 if(p<0) {j=-1; p=-p;}
 while(i<p) i=10*i;
 if(8*i<10*p) return i*j;
 i /= 2;
 if(4*i<5*p) return i*j;
 i = (2*i)/5;
 if(16*i<20*p) return i*j;
 i = i/2;
 return i*j;
}


/******************************************************************/

static void plotDestroy(void)
{
  LOOKGET("plotDestroy") ;

  look->magic = 0 ;
  arrayDestroy (look->a) ;
  messfree (look) ;

  graphAssRemove (plotHisto) ;
}

/******************************************************************/

static void makeReticule(LOOK look)
{
  int nx, ny ;
  float x0, y0, h , cw, ch ;

  h = look->maxy - look->miny ;
  if (!h)
    h = 1;
  x0 = -.12*look->maxx ;
  y0 = -look->maxy - .07* h;
  graphTextInfo(&nx, &ny,&cw,&ch) ;
  if(look->xyBox)
      graphBoxDraw(look->xyBox,WHITE,WHITE) ;
  strncpy(look->xBuf,messprintf("%f",look->x),8);
  strncpy(look->yBuf,messprintf("%f",look->y),8);
  look->xyBox =  graphBoxStart() ;
  graphText (look->xBuf,  x0 + 7*cw, y0 + 2*ch) ;
  graphText (look->yBuf,  x0 + 7*cw, y0 + 3.5*ch) ;
  graphBoxEnd() ;
  graphBoxDraw(look->xyBox,BLUE,WHITE) ;

  if(look->retBox)
    {
      graphBoxDraw(look->retBox,WHITE,TRANSPARENT) ;
    }

  look->retBox = graphBoxStart() ;
  
  graphLine (0.,-look->y,look->maxx,-look->y) ;
  graphLine (look->x,-look->miny,look->x,-look->maxy) ;
  graphBoxEnd() ;
  graphBoxDraw(look->retBox,BLACK,TRANSPARENT) ;

/*
  graphTextEntry (look->yBuf, 0,0,0,0) ;
  graphTextEntry (look->xBuf, 0,0,0,0) ;
*/
}

/******************************************************************/

static void moveReticule (int box, double x, double y)
{
  LOOKGET("makeReticule") ;

  if(box != look->retBox )
    return ;
  y = -y + look->maxy ; /* coord is relative to the axis box */
  if(x == look->x && y == look->y)
    return ;
  look->x = x ; look->y = y ;
  makeReticule(look) ;
}

/******************************************************************/
/*
static void histoPickX(void)
{
  float x ;
  LOOKGET("pickX") ;
  if(sprintf(look->xBuf,"%f",&x)
     && x>=0 && x <= look->maxx)
    look->x = x ;
  
  makeReticule(look) ;
}
*/
/******************************************************************/
/*
static void histoPickY(void)
{
  float y ;
  LOOKGET("pickY") ;

  if(sprintf(look->yBuf,"%f",&y)
     && y>=look->miny && y <= look->maxy)
    look->y = y ;
  
  makeReticule(look) ;
}
*/
/*************************************************************************/

static void histoStatistics(void)
{ double ym,  y2m,  sig ;
  register int i ,*y ;
  register int yt, yt2 ;
  Array a ;
  LOOKGET("statistics") ;

  a = look->a ;
  if(!a || !arrayMax(a))
    return ;
  y = arrp(a,0,int) ;
  i = arrayMax(a) ;
  yt =  yt2 = 0 ;
  while(i--)
    { yt2 += (*y)*(*y) ;
      yt += *y++ ;
    }
  /* sig = sqrt( < ( y - <y>^2 )^2 > ) */
  ym = yt ; ym /= arrayMax(a) ;
  y2m =  yt * yt ; y2m /= arrayMax(a) ;
  sig = yt2 - ym*ym ;
  sig = sqrt(sig) ;
  messout(messprintf("Average y = %f, sigma = %f",
		     (float)yt / arrayMax(a), sig)) ;
}

/*************************************************************************/

static void plotDisplay(void)
{
  register int i, j ;
  int
  dx, dy,
  max, xofmax, tot = 0,
  miny , maxy, nx, ny ;
  float x0, y0, h , cw, ch ;
  Array a ;
  LOOKGET("plotDisplay") ;
  
  graphClear() ;
  a = look->a ; 
  miny = maxy = 0;
  max = arrayMax(a) ;
  for (i=0;i<max;i++)
    {
      if ((j=arr(a,i,int)) > maxy)
	{ maxy = j; xofmax = i ;}
      if (j<miny) miny = j;
      tot += j ;
    }

  h = maxy - miny ;
  if (!h)
    h = 1;
  x0 = -.12*max;
  y0 = -maxy - .07* h;
        /* All calls to y coordinate will be made to -y */
        /* because graph y axis is downwards */
  graphPlainBounds(x0,y0,1.24*max,1.19*h,0) ;
  graphTextInfo(&nx, &ny,&cw,&ch) ;

  graphBoxStart () ;
    
  dx = regular(max * 1.5 / 10);
  if(dx<=0) dx = 1; 
  for(i=1;i*dx < max;i++)
    graphText(messprintf("%d",i*dx),i*dx,1.3*ch);
  dy = regular(2.6*(maxy - miny)*1.1/10.);
  if(dy<=0) dy = 1; 
  for(i=1;(i<21) && (miny + i*dy < maxy);i++)
    graphText(messprintf("%5d",miny + i*dy),-6*cw,
                              -(miny + i* dy) );
  graphBoxEnd () ;
  graphBoxStart () ;
  graphColor(BLUE) ;

  for(i=0;i<max-1;i++)
    graphLine((float) i,-1.* arr(a,i,int),
	      (float) i+1.,-1.* arr(a,i+1,int));

/*

  for(i=0;i<max;i++)
    graphPoint((float) i, -1.* arr(a,i,int)) ;
*/

  graphBoxEnd () ;

  graphRedraw () ;

  graphBoxStart() ;
  graphText("x = ", x0+cw, y0 + 2*ch) ;
  graphText("y = ", x0+cw, y0 + 3.5*ch) ;
  graphBoxEnd () ;

  graphRedraw () ;
  graphColor(RED) ;
  { float tx = x0 + cw * (nx - 20) ;
    i = graphBoxStart () ;
    graphText(messprintf("total # %d",tot),tx ,y0 + 2*ch) ;
    graphText(messprintf("max y(%d) = %d",xofmax,maxy),tx, y0 + 3.2*ch) ;
    graphText(messprintf("max x = %d",max-1),tx ,y0 + 4.4*ch) ;
    graphBoxEnd () ;
    graphBoxDraw(i,RED,TRANSPARENT) ;
  } 

  graphRedraw () ;
  graphColor(BLACK) ;
  i =  graphBoxStart() ;
  graphLine(0.,0., 1.05*max, 0.);  /* x axis */
  graphLine(0.,-miny,0.,-maxy - .05*h); /* y axis */
  graphBoxEnd() ;
  graphBoxDraw(i,BLACK,TRANSPARENT) ;
  graphRedraw () ;
  look->retBox = 0 ;
  look->xyBox = 0 ;
  look->miny = miny;
  look->maxy = maxy ;
  look->maxx = (float) max ;
  look->x = max/2. ;
  look->y = (maxy+miny)/2. ;

  graphRedraw () ;

  makeReticule(look) ;
}

/******************************************************************/

static MENUOPT histoMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        graphPrint,"Print",
        histoStatistics,"Statistics",
        0,0 };

/******************************************************************/
/****************** public routine ********************************/

void plotHisto(char *title, Array a)
{
  int  i, max ;
  static float px = .01, py = .33 ;
  LOOK look ; 

  if(!a || !(max = arrayMax(a)))
    {
      messerror("plothisto(%s,array) received a null array", title);
      return;
    }
  if(a->size != sizeof(int))
    messcrash("plotHisto received a wrong type of Array, should be int ") ;
  i = max - 1;
  while( !arr(a,i,int) && i-- );  
  max = ++i;
  if(!max)
    {
     messout("plotHisto(%s) received a null histogram", title);
     return;
   }
  
  if(! graphCreate (PLAIN,title, px,py,0.5,0.33) )
    return ;

  px += .07; py += .07 ;  /* prevents superposition */
  look = (LOOK)messalloc(sizeof(struct LOOKstruct)) ;
  graphAssociate(plotHisto,look) ;
  graphRegister (DESTROY, plotDestroy) ;
  graphRegister (RESIZE,(GraphFunc) plotDisplay) ;
  graphRegister (PICK,  (GraphFunc)moveReticule) ;
  graphHelp("Histogram") ;
  graphMenu(histoMenu);
  look->magic = MAGIC ;
  look->a = a ;
  look->title = title ;
  
  plotDisplay() ;
}

/*************************************************************************/
/*************************************************************************/


