/*  Last edited: Mar 10 04:59 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File bstree.c :                                          **/
      /**  Transforms back and forth the B blocks into BS trees     **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  7     routines are public :                                */
      /*     bsTreeget, store, free and copy.                        */
      /*     BSalloc/free, status manage malloc(BS)                  */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  5/1/91 by JTM.            */
      /*                                                             */
      /***************************************************************/

#include <ctype.h>

#include "acedb.h"
#include "array.h"
#include "bs_.h"
#include "b_.h"
#include "block.h"
#include "lex.h"
#include "key.h"
#include "systags.wrm"
#include "array.h"
#include "chrono.h"

static BS     bsTreeRead     (BP bp,NODE nn,BS b0,BOOL doUnbreakComment);
static void   bsTreeReadCont  (BS *bsp);
static BP     bsTreeFindBlock  (BS  bs,KEY *kp) ;
static void   bsTreeStore2   (BP bp, KEY kk, BS  bs); 
static NODE   bsTreeSt2      (BS  bs,BP bp);
static void   bsTreeStoreContinuation  (KEY k,BP *bpp, BS  bs) ;
static int    bsTreeSize     (BS  bs);
static int    bsTreeBreakComment(BS bs);
static void   bsTreeUnbreakComment(BS bs, BS bs1);

/* extern int BSTEST; */       
int bsTreeTEST = FALSE ;
static  char BSbuffer[BLOC_SIZE];  /*to allow for the \t*/

/**************************************************************/
/**************************************************************/
                 /* cannot fail */
BS bsTreeGet(KEY key) 
{
 NODE nn;
 BP bp;
 BS bs;
 
 chrono("bsTreeGet") ;
 
 if(!iskeyold(key))
   { bs=BSalloc() ;
     bs->key=key;
   }
 else
   {
     Bget(&bp,&nn,key) ;  /* *bp,*nn becomes the origin of the branch*/
     bs = bsTreeRead(bp,nn,(BS)0,TRUE);
     
     blockunpinn(key);
   }
 
 chronoReturn(); 
 return bs ;
}

/********************************************************************/
                 /*store => free*/
        /* because the splitting of big objects destroys the tree */

 void bsTreeStore (BS  bs)
{
  KEY key=bs->key,kk ;
  int
    nc=0,         /*number of continuation blocks*/
    ncells, nl, nr,  nmax ;
  BS bs2, bsl,bsr, bsu, bsn, bsc;
  BP bp , bpc;

  chrono("bsTreeStore") ;
           /* set bs -> size, no more recursive sizing needed later */
  ncells=bsTreeSize(bs);
           /* set bp to a proper top block */
  bpc = bp = bsTreeFindBlock(bs,&kk) ;
  nmax=BNODEMAX-2 ;
  while((ncells=bs->size) >= BNODEMAX)
    {
      bs2=bs;

      while(ncells>nmax)
        {
          bsl=bs2->down; bsr=bs2->right;
          nl = bsl ? bsl->size : 0;
          nr = bsr ? bsr->size : 0;
	  ncells = (nl > nr)
            ? ( bs2=bsl, nl )
              : ( bs2=bsr, nr ) ;
        }

      if(!bs2)
        messcrash(" Error in bsTreeStore , check bsTreeSize() :\n%s",
                  name(bs->key));

                    /* bs2 is unhooked from bsu and hooked
                       to the new bsn
                       */

      nc++ ;
      bsn = BSalloc() ;
      bsn->key = key ;
      bsn->right = bs2;
      bsu=bs2->up; bs2->up=bsn;
      bsTreeStoreContinuation(key, &bpc, bsn) ;
                    /* bsc will now replace the bs2 tree under bsu */
      bsc= BSalloc () ;
      bsc->up=bsu;
      if (nl>nr)
        bsu->down = bsc;
      else
        bsu->right = bsc;
      bsc->key= _continuationKey  ;
      bsc->n.i = nc ;
      bsc->size = 2;
      ncells -= 2 ; /* The tree is pruned change the size above bsc*/
      while(bsu)
        {
          bsu->size -= ncells;
          bsu = bsu->up;
        }
    }
      /* save top of tree in original block */
  bsTreeStore2(bp,kk,bs);
     /* discard anything further down */
  blockSetEnd(bpc) ;
  blockrewrite(kk) ;
  
  chronoReturn();
}

/******************************************************************/
                 /* recursive pice,  calls bsTreeBreakComment */
static BS bsxxx ;
static int sizexxx ;
static void  bsTreeSize2   ()

{
  if(!bsxxx)
    return ;

  bsxxx->size = 0;

  if(bsxxx->down) 
    {
     bsxxx = bsxxx->down ;
     bsTreeSize2() ;
     bsxxx = bsxxx->up ;
     bsxxx->size += sizexxx ;
   }

  if(bsxxx->right) 
    {
     bsxxx = bsxxx->right ;
     bsTreeSize2() ;
     bsxxx = bsxxx->up ;
     bsxxx->size+= sizexxx ;
   }

  if  (bsxxx->key<=_LastC)
    {
      if(bsxxx->bt && bsxxx->bt->cp)
	{
	  register int i = strlen(bsxxx->bt->cp) ;
	  if(i > NODEX * BNODEMAX /2)
	    {
	      sizexxx = bsTreeBreakComment(bsxxx);
	      return ;
	    }
	  else 
	    bsxxx->size+=1+(i+NODEX-1)/NODEX;
	}
      else   /* a null comment occupies 2 keys, sorry */
	  bsxxx->size+=2;
    }

  else if(bsxxx->key<=_LastN)
    bsxxx->size += 2 ;

  else
    bsxxx->size += 1 ;  /* generic case of a KEY */

  sizexxx = bsxxx->size ;
  return ;
}

/******************************************************************/
                 /* calls bsTreeBreakComment */
static int    bsTreeSize    (BS bs)
{
  if(!bs)return(0);

  chrono("bsTreeSize") ;
  bsxxx = bs ;
  bsTreeSize2() ;  

  chronoReturn(); return(bs->size);
}
/**************************************************************/
static int  bsTreeBreakComment(BS bs)
{
 char * old = bs->bt->cp,
      * line,
      * cq ;
 BS bs1, bsu;
   
 int n ;

 chrono("bsTreeBreakComments") ;

 uLinesText(old, (BNODEMAX * NODEX)/ 2);
 line = uPopLine(old) ;

 while(TRUE)
   {
     cq = messalloc(strlen(line) + 1);

     strcpy(cq, line);
     if (!bs->bt)
       bs->bt = BTalloc() ;
     bs->bt->cp = cq;
     n = 1+(strlen(bs->bt->cp)+NODEX-1)/NODEX;
     if (bs->down)
       n += bs->down->size ;
     if (bs->right)
       n += bs->right->size ;
     bs->size = n ;
     
     line = uPopLine(old);
     if (!line)
       break;
     bs1 = BSalloc();

     bs1 -> key = bs->key ;
     bs -> key = _NextC;
     
     bs1->up = bs->up;
     bs->up = bs1;
     bs1->down = bs;       /* move the right hook to the top */
     bs1->right = bs->right ;
     if(bs1->right)
       {
	 bs1->right->up = bs1 ;
	 bs->size -=  bs->right->size ;
       }
     bs->right = 0 ;

     bsu = bs1->up;
     if (bsu)
       {
	 if (bsu->down == bs) bsu->down = bs1;
	 else
	   if (bsu->right == bs) bsu->right = bs1;
	   else
	     messcrash("link missing in bsTreeBreakComment");
       }
     bs = bs1;
   }
 messfree(old);
 bsxxx = bs ;
 chronoReturn(); return n;
}

/**************************************************************/
static void bsTreeUnbreakComment(BS bs, BS bs1)
{

 char * u = bs->bt ? bs->bt->cp : 0 ,
      * v = bs1->bt ? bs1->bt->cp : 0 ,
      * cq ;
 int n = ( u ? strlen(u) : 0 )  + ( v ? strlen(v) : 0 ) ;    

 chrono("bsTreeUnbreakComments") ;

 cq = messalloc(n + 1);
 *cq = 0;
 if(u)
   {
     strcat(cq,u);
     free(u);
   }
 if(v)
   {
     strcat(cq,v);
     free(v);
   }


 if (!bs->bt)
   bs->bt = BTalloc() ;
 bs->bt->cp = cq;
                 /* The right hook is already on bs */
 bs->down = bs1->down;
 bs1->down = bs1->right =  bs1->up = 0;
 BSfree(bs1);
 chronoReturn() ;

}

/**************************************************************/
      /*note that if b0=0 we do not read bs->down */

static BS  bsTreeRead (BP bp,NODE nn,BS b0, BOOL doUnbreakComment)
{
 NODEP r=bp->n+nn ;
 BS bs=BSalloc() ;
 BS bs1 ;

 chrono("bsTreeRead") ;

 bs->up=b0;
 bs->key=r->ck.key;

                                    /* down hook */
 bs->down = (b0 && r->d1) ? 
   bsTreeRead(bp,r->d1,bs,doUnbreakComment) : NULL;

 if (bs->key<=_LastC)
   {
     if(r->d2)
       {
	 Bnode2str(BSbuffer,bp,&r);
	 bs->bt = BTalloc();
	 bs->bt->cp = messalloc(strlen(BSbuffer)+1);
	 strcpy(bs->bt->cp,BSbuffer);
	 
         /* special right hook for compatibility with earlier version*/
	 bs->right = r->d1  ? 
	   bsTreeRead(bp,r->d1,bs,doUnbreakComment) : NULL;
       }
     if(    doUnbreakComment
        && (bs1 = bs->down)
        && (bs1->key == _NextC) )
        bsTreeUnbreakComment(bs, bs1) ;
     chronoReturn(); return(bs);
        /* this call may have changed r1 */
   }

 else  if(bs->key<=_LastN)
   {           /* In a number a BS cell corrresponds to 2 nodes */
     nn=r->d2;
     r = bp->n + nn ; /* Thus the right hook
			 will start from the second cell */
     bs->n = r->ck.x ;
     if(bs->key == _continuationKey)
       {
	 bsTreeReadCont(&bs) ;
	 chronoReturn(); return(bs);
       }
   }

                                                       /* right hook */
    bs->right = r->d2  ? bsTreeRead(bp,r->d2,bs,doUnbreakComment) : NULL;

    chronoReturn(); return(bs);
}

/**************************************************************/
                 /* replaces *bsp by the top
                    of the corresponding tree
                    freeing the relevant cells
                    */

static void  bsTreeReadCont(BS *bsp)
{
  NODE nn;
  BP bp;
  BS bs = *bsp,
     bs1 = 0,
     bs2 = 0;

  chrono("bsTreeReadCont") ;

  bp = blockGetContinuation(bs->n.i) ;
  nn= bp->hat.top ;
  bs1=bsTreeRead(bp,nn,(BS)0,TRUE);

  if(bs1)
    bs2 = bs1->right;
  if(!bs2)
       messcrash("Anomaly  bs2 =0 in bsTreeReadCont " );
  if(!(bs->up) || bs->down || bs->right )
       messcrash("Anomaly in bs in bsTreeReadCont ");
  bs2->up=bs->up;
  BSfree(bs);
  BSfree(bs1);
  *bsp = bs2;
  chronoReturn();
}

/**************************************************************/

static BP  bsTreeFindBlock  (BS  bs, KEY *kkp)
{
  KEY key=bs->key,kk,k2;
  int
    freecells, n1,
    ncells   = bs->size,     /*number of cells needed to store bs*/
    isold    = iskeyold(key) ,
    islong   =     ncells > BNODEMAX/2 ? TRUE : FALSE,
    ispruned = FALSE;
  BP bp;
  BS bs2;
  NODE nn ;
  NODEP r;
  
  chrono("bsTreeFindBlock") ;
  
/* islong = TRUE ;  should be removed, 20 12 90 added for debugging */

  if (isold || islong)
    kk=key;
  else                    /*find some location*/
    kk = blockfriend(key);
  
  if(isold || iskeyold(kk))
      Bget(&bp,&nn,kk);   /* *bp,*nn becomes the origin of the branch*/
  else
    {
      blockpinn(kk,&bp);
      nn=0;
      Binit(bp);
    }
  
  if(isold)
    if(nn)
      {
	Bprune(bp,nn,0);
	ispruned=TRUE;
      }
  
  
  freecells=Bfreelen(bp);
  if (ncells>freecells)
    {
      if(ncells<BNODEMAX/2)
	{
          r=bp->n+bp->hat.top;   /*Find the top object*/
          k2=kk;kk=r->ck.key;
          blockunpinn(k2);
          Bget(&bp,&nn,kk);
	  nn=bp->hat.top;
	  n1=Bbranchlen(bp,nn);
	  while(ncells+n1>BNODEMAX/2)
	    {
	      r=bp->n+nn; nn=r->d1;
	      if(!nn) break;
	      n1=Bbranchlen(bp,nn);
	    }
	  if(nn)
	    {
	      bs2=bs;
	      while(bs2->down)bs2=bs2->down;
	      bs2->down=bsTreeRead(bp,nn,bs2,FALSE);
	      Bprune(bp,nn,TRUE);
	      ispruned=TRUE;
	    }
        }
      
      if(ispruned)
	blockrewrite(kk) ;
      else 
	blockunpinn(kk);
      
      kk=key;
      isold=FALSE;
      ispruned=FALSE;
      blockreallocate(kk,&bp) ;
      Binit(bp) ;
    }
  
  *kkp = kk ;
  chronoReturn() ;
  return bp ;
}

/**************************************************************/

static void  bsTreeStore2    (BP bp, KEY kk, BS  bs)
{
  NODE nn,nn2;
  NODEP r;
  int fl ;

  chrono("bsTreeStore2") ;
  if(bs->size > (fl =Bfreelen(bp)))
    { bsTreeDump(bs) ; 
      messcrash("Block Overflow in bsTreeStore2");
    }
  nn=bsTreeSt2(bs,bp);
  nn2=nn;
  while(r=bp->n+nn2,r->d1) nn2=r->d1;
  r->d1=bp->hat.top;
  bp->hat.top=nn;
  
  bsTreePrune(bs);
  chronoReturn() ;
}

/**************************************************************/

static void  bsTreeStoreContinuation  (KEY key, BP *bpp, BS  bs)
{
  NODE nn ;
  
  chrono("bsTreeStoreContinuation") ;
  
  blockSetNext(bpp) ;
  Binit(*bpp) ;
  nn=bsTreeSt2(bs,*bpp);
  (*bpp)->hat.top=nn;
  
  bsTreePrune(bs);
  chronoReturn() ;
}

/************************************************************************/

static NODE bsTreeSt2 (BS bs,BP bp)
{
  NODEP r = Bnewnode(bp) ;

  r->ck.key=bs->key;

  if(bs->down) r->d1=bsTreeSt2(bs->down,bp);

  if((bs->key)<=_LastC)
    {  NODEP rnew = r ;  /* Bstr2node will grab additional nodes */
       Bstr2node(bs,bp,&rnew);
           /* comments  support right hooks in funny way */
       if(bs->right)
	 rnew->d1 = bsTreeSt2(bs->right,bp) ;
     }
  
  else if((bs->key)<=_LastN) 
	{	     /* grab a second node to write the Union */
	  NODEP rnew = Bnewnode(bp) ;

	  r->ck.key = bs->key ;
	  r->d2 = (NODE) (rnew  - bp->n) ;
	  rnew->ck.x = bs->n ;
	  if(bs->right) 
	    rnew->d2=bsTreeSt2(bs->right,bp);
	}
  
  else                 /* standard key */
    if(bs->right) r->d2=bsTreeSt2(bs->right,bp);
  
  return (NODE) ( r - bp->n) ;
}

/************************************************************************/
/************************************************************************/



