/*  Last edited: Mar 26 13:13 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File bstools.c :                                         **/
      /**  Manipulates the bs objects.                              **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*        routines are public :                                */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  20/9/91 by JTM.           */
      /*                                                             */
      /***************************************************************/

#include <ctype.h>

#include "acedb.h"
#include "array.h"
#include "bs_.h"
#include "chrono.h"

static void   bsTreePrune2    (BS  bs);
static void   bsTreeCopy2     (void) ;

/**************************************************************/

/* Manage BS allocation
   hope they speed things up/prevent fragmentation
   in any case, they will help monitoring memory usage
   NB they must be paired.
*/

static Stack freeBSstack = 0 ;
static int nBSused = 0, nBSalloc = 0 ;        /* useful for debug */

BS BSalloc (void)       /* self managed calloc */
{
  static int blocSize = 2048 ;
  BS p ;
  int i ;
 

  if (!freeBSstack)
    freeBSstack = stackCreate (4*blocSize) ;
  if (stackEmpty (freeBSstack))
    { p = (BS) messalloc (blocSize * sizeof (struct bshow)) ;
      for (i = blocSize ; i-- ; ++p)
        push (freeBSstack,p,BS) ;
      nBSalloc += blocSize ;
      blocSize *= 2 ;
    }
  p = pop (freeBSstack,BS) ;
  memset (p, 0, sizeof (struct bshow)) ;
  ++nBSused ;
  return p ;
}

void BSfree (BS bs)
{
  if (bs->bt)
    BTfree(bs->bt) ;
  push (freeBSstack,bs,BS) ;
  --nBSused ;
}

void BSstatus (int *used, int *alloc)
{ *used = nBSused ; *alloc = nBSalloc ;
}

/**************************************************************/
/**************************************************************/

         /* idem for BT */

static Stack freeBTstack = 0 ;
static int nBTused = 0 , nBTalloc = 0 ;    /* useful for debug */

BT BTalloc (void)       /* self managed calloc */
{
  static int blocSize = 2048 ;
  BT p ;
  int i ;

  if (!freeBTstack)
    freeBTstack = stackCreate (4*blocSize) ;
  if (stackEmpty (freeBTstack))
    { p = (BT) messalloc (blocSize * sizeof (struct btext)) ;
      for (i = blocSize ; i-- ; ++p)
        push (freeBTstack,p,BT) ;
      nBTalloc += blocSize ;
      blocSize *= 2 ;
    }
  p = pop (freeBTstack,BT) ;
  memset (p, 0, sizeof (struct btext)) ;
  ++nBTused ;
  return p ;
}

void BTfree (BT bt)
{
  if(bt->cp)
    free(bt->cp) ;
  push (freeBTstack,bt,BT) ;
  --nBTused ;
}


void BTstatus (int *used, int *alloc)
{ *used = nBTused ; *alloc = nBTalloc ;
}

/**************************************************************/
/**************************************************************/
/******************************************************************/
void   bsTreePrune(BS bs)
{
  if(!bs)return;
  
  chrono("bsTreefree") ;

  if(bs->up)          /* unhook */
    {
      if (bs->up->down == bs)
	bs->up->down = 0 ;
      else if (bs->up->right == bs)
	bs->up->right = 0 ;
      else 
	messcrash("double link error in bsTreePrune") ;
      bs->up = 0 ;
    }

  bsTreePrune2(bs);

  chronoReturn() ;

}
/******************************************************************/
static void   bsTreePrune2(BS bs)
{
  if(!bs)return;
  bsTreePrune2(bs->right);
  bsTreePrune2(bs->down);
  BSfree(bs);          
  bs=0;
}
/************************************************************************/
/************************************************************************/
       /* BS Copying system */

static BS bsCopy, bsOriginal, bsUpCopy;

/**************************/
static void bsTreeCopy2()
{
 bsCopy = BSalloc();
 *bsCopy = *bsOriginal;
 bsCopy->up = bsUpCopy;

 if(bsOriginal->bt)
   {
     bsCopy->bt = BTalloc() ;
     *bsCopy->bt = *bsOriginal->bt ;
    if(bsOriginal->bt->cp) 
     {
       bsCopy->bt->cp = messalloc(strlen(bsOriginal->bt->cp) + 1);
       strcpy(bsCopy->bt->cp,bsOriginal->bt->cp) ;
     }
   }

 if (bsOriginal->down)
   {
     bsOriginal = bsOriginal->down;
     bsUpCopy = bsCopy;
     bsTreeCopy2();
     bsUpCopy = bsCopy->up;
     bsUpCopy->down = bsCopy ;
     bsCopy = bsUpCopy;
     bsOriginal = bsOriginal->up;
   }

 if (bsOriginal->right)
   {
     bsOriginal = bsOriginal->right;
     bsUpCopy = bsCopy;
     bsTreeCopy2();
     bsUpCopy = bsCopy->up;
     bsUpCopy->right = bsCopy ;
     bsCopy = bsUpCopy;
     bsOriginal = bsOriginal->up;
   }

}

/**************************/
    /* copies a branch of a tree */
BS bsTreeCopy(BS bs)
{
 BS bstmp ;

 chrono("bsTreeCopy") ;

 if(!bs) return 0 ;
 bstmp = bs->up ;bs->up = 0;

 bsOriginal = bs;
 bsCopy = 0;
 bsUpCopy = 0;
 bsTreeCopy2();

 bs->up = bstmp;
 chronoReturn(); return bsCopy;
}

/*****************************************************/


void bsTreeDump (BS bs)
{
  static int depth = 0 ;
  int i ;

  for (i = 2*depth ; i-- ;)
    putchar (' ') ;

  fprintf (stderr, "%8x : k.%d(%s)   up.%x down.%x right.%x \n", 
	   (unsigned long) bs,
	   bs->key, name(bs->key),
	   (unsigned long) bs->up,
	   (unsigned long) bs->down,
	   (unsigned long) bs->right) ;

  if (bs->right)
    { ++depth ;
      bsTreeDump (bs->right) ;
      --depth ;
    }
  if (bs->down)
    bsTreeDump (bs->down) ;
}

/************************************************************************/
/************************************************************************/


