/*  File: wormmain.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: Main() of the complete program
        Provides Initialisation and Termination routines.
 * Exported functions:
 * HISTORY:
 * Last edited: Apr  1 14:35 1992 (mieg)
 * Created: Tue Oct 22 12:51:04 1991 (mieg)
 *-------------------------------------------------------------------
 */

/*******************************************************************/
/*   A C e D B                                                     */
/*   A Caenorhabditis elegans Data Base                            */
/*               by R.Durbin and J.Thierry Mieg                    */
/*******************************************************************/


/*  Version number is #defined  in session.h                       */

#include "acedb.h"
#include "graph.h"
#include "session.h"
#include "menu.h"
#include "systags.wrm"

extern void 
  blockInit(void),
  lexInit(void),
  pickInit(void),
  sessionInit(void),
  saveAll(void) ;  
extern BOOL  sessionCheckUserName(void) ;

void wormClose(void) ;                /* below */
void wormClose2(void) ;                /* below */
extern void *messcrashbuf ;           /* in messubs.c */
extern char *stackorigin ;            /* in arraysub */

MENUOPT *mainMenu ;	/* global so that session, wcs can change */

/******************* INITIALISATION ***************************/
/**************************************************************/

/******Stuff needed for the Application dependant code********/

#include "display.h"
#include "disptype.wrm"

extern DisplayFunc displayFunc[] ;
extern DumpFunc dumpFunc[] ;
extern ParseFunc parseFunc[] ;

/*********** Application dependant code  **********************/
/***** should be registerd in file wpec/quovadis.wrm **********/

#include "quovadis.wrm"   

/***************** fixed code ********************************/

static void wormInit (int argc, char **argv)
{
  char *homedir ;
                 /* This is the root of the database directory */
    /* by changing it, you may work on different sets of data */

  if (homedir = getenv ("ACEDB"))
    filsetdir (homedir) ;
  else
    messcrash ("%s %s",
	       "Environment variable ACEDB is not defined",
	       "Read the instructions in the README of this program"
	       ) ;
  
  /* Macro KEYKEY relies on KEY beeing 4 bytes long  */
  /* Furthermore, it may be assumed implicitly elsewhere */

  if (sizeof(KEY) != 4)
    messcrash ("KEY size is %d - it must be 4 - rethink and recompile!",
	        sizeof(KEY)) ;

  if (__Global_Bat != KEYMAKE(1,1))
    messcrash 
      ("Hand edit systags.wrm because KEYMAKE(1,1) = %d != __Global_Bat",
       KEYMAKE(1,1)) ; 

  /* messdump only if write access is granted, see in session.c */

  if (messcrashbuf = messalloc (12*1024), !messcrashbuf)
    messcrash ("Out of memory - can't even allocate messcrashbuf") ;

  /* The order of the initialisations is crucial */

  freeinit ();			/* must come before graphInit */
  freespecial ("\n;/%\\@") ;    /* No subshells ($ removed) */
  graphInit (&argc, argv) ;
  blockInit()  ;		/*Initialisation du cache*/  
  lexInit() ;                   /*Initialisation du lexique*/  
                                /* et lecture de sytags et tags */
  pickInit() ;                  /*Class definitions */
  displayInit() ;               /*Registers display functions */
  sessionInit() ;               /*Reads in the lexiques etc */
 
  /* must come after successful session initialisation */
  crashroutine (wormClose2);
}

/*************************************************************/
/****************** MAIN LOOP **********************/
BOOL ACEDB_SU  = FALSE ;
extern Graph pickCreate (BOOL chooseSession) ;

static void askOrders(void)
{
  Graph base ;

  if (getenv ("ACEDB_SU"))
    ACEDB_SU = TRUE ;
    
 /* base  = pickCreate (ACEDB_SU) ;  to have session control 
    but this option is also commented out in pickCreate */
  base  = pickCreate (FALSE) ; 
 
  menuInit (&mainMenu, quovadis, base) ;
  graphMenu (mainMenu);
#ifdef WCS
  menuSuppress ("WCS annotate", mainMenu) ;
#endif
  menuSuppress ("Save", mainMenu) ;
  if (!sessionCheckUserName())
    menuSuppress ("Write Access", mainMenu) ;
  if (!ACEDB_SU) 
    menuSuppress("Add new objects", mainMenu) ;

  graphStart (base) ;
}

/*************************************************/
/****************** TERMINATION ******************/

static void wormEnd(BOOL doSave)
{
  sessionClose (doSave) ;
  
  graphFinish () ;
  printf ("\n A bientot \n\n") ;
  exit(0) ;
}

/*************************************************/

void wormClose2(void)
{
 /* Kills all the open windows, forcing displayed objects to cache */
  graphCleanUp () ; 

  if (isWriteAccess() && 
      !graphQuery ("You did not save your work, should I ?"))
    wormEnd (FALSE) ;
  else
    wormEnd (TRUE) ;
}

/*************************************************/

void wormClose(void)
{
  if (thisSession.session != 1 &&
      !graphQuery("Do you really want to quit ACeDB"))
    return ;

  wormClose2 () ;
}

/******************  ACEDB  ***********************/
/**************************************************/

int
main (int argc, char **argv)

{char x ;

 stackorigin = &x ;
  printf("**** acedb database: Version %d.%d %s ****\n",
	 MAINCODERELEASE, SUBCODERELEASE,DATE_OF_CODE_RELEASE) ;
  printf("Authors: Richard Durbin (MRC, UK) rd@mrc-lmba.cam.ac.uk\n") ;
  printf("         Jean Thierry-Mieg (CNRS, France) mieg@frmop11.bitnet\n") ;
  printf("You may redistribute this program and database subject to the\n") ;
  printf("conditions in the accompanying copyright file.  Anyone interested in\n") ;
  printf("maintaining an up to date version should contact one of the authors\n") ;
  printf("at the above email addresses.\n") ;

 wormInit (argc, argv) ;
 askOrders () ;
 wormClose2 () ;
 return (0);
}

/**************************************************/
/**************************************************/
