/*  File: update.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: Parses the official acedb updates.
 * Exported functions: updateData
 * HISTORY:
 * Last edited: Apr  2 18:51 1992 (mieg)
 * * Jan 20 10:16 1992 (mieg): interactive access to alias, 
   should be done differently really.
 * Created: Fri Oct 25 13:35:14 1991 (mieg)
 *-------------------------------------------------------------------
 */

#include "acedb.h"
#include "display.h"
#include "session.h"

/*************************************************************************/
/******************************************************************/

static Graph updateGraph = 0;
static line = 3 ;
static void upMessage(char *cp)
{
  Graph old = graphActive() ;
  if(graphActivate(updateGraph))
    { graphText (cp, 1, line++) ;
      graphTextBounds (80,line+2) ;
      graphBoxDraw (0,-1,-1) ;
    }
  graphActivate(old) ;
}
    
/******************************************/
extern BOOL parseAutomatic(FILE *fil) ;


static void updateAlign(void)
{ extern void gMapMakeAll(void), pMapMakeAll(void) ;
  extern void alignMapsNonInteractive(void) ; 

  mainActivity ("Aligning during update") ;
  upMessage ("Aligning the genetic and physical maps - a few minutes") ;
  alignMapsNonInteractive() ; 
  upMessage ("Making genetic maps - a minute or two") ;
  gMapMakeAll () ;
  upMessage ("Making physical maps - a few minutes") ;
  pMapMakeAll () ;
  upMessage("All maps are updated") ;
  upMessage("I save to disk") ;
  sessionClose(TRUE) ;
  upMessage("Update complete") ;
  messout (messprintf ("We are now using data release %d-%d",
			 thisSession.mainDataRelease,
			 thisSession.subDataRelease)) ;
}

/******************************************/

static BOOL updateCheckFile(FILE *fil)
{ char *word ;
  int main = -1, sub = -1 ;

  freeread (fil) ;
  if (!(word = freeword()) || strcmp (word, "acedb") ||
      !(word = freeword()) || strcmp (word, "update"))
    { messout  ("You did not load an acedb update file") ;
      return FALSE ;
    }

  if (!freeint (&main) || main != thisSession.mainDataRelease ||
      !freeint (&sub)  || sub != thisSession.subDataRelease+1)
    { messout  ("Update %d.%d does not match the current state",
		main, sub) ;
      return FALSE ;
    }
  return TRUE ;
}


/******************************************/

static BOOL updateParseFile(FILE *fil)
{ extern BOOL getNewModels(void) ;

  mainActivity (messprintf ("Adding update %d", 
			    thisSession.subDataRelease + 1)) ;
  upMessage ("Reading in model file") ;
  if (!getNewModels ())
    { fclose(fil) ;
      return FALSE ;
    }

  upMessage ("Update started") ;
  
  return parseAutomatic (fil) ;  /* Does close fil */
}

/******************************************/

static void updateAction(void)
{ 
  FILE *fil = 0 ;
  char fileName[256] , * fn;
  BOOL doAlign = FALSE ;

  if (isWriteAccess())
    { messout("First, save your earlier work") ;
      return ;
    }

  sessionWriteAccess() ;
  if (!isWriteAccess())
    { messout
	("Sorry, without write access, you cannot update the data") ;
      return ;
    }

  if (getenv ("ACEDB_DATA"))
    strcpy (fileName, getenv("ACEDB_DATA")) ;
  else
    strcpy (fileName, messprintf ("%s/rawdata",filsetdir(0))) ;

  fn = fileName + strlen(fileName) ;
  while(TRUE)
    { if (!isWriteAccess())
	sessionWriteAccess() ;
      strcpy (fn, messprintf ("/update.%d-%d",
			      thisSession.mainDataRelease,
			      thisSession.subDataRelease + 1)) ;
      upMessage (messprintf("Looking for file %s",fileName)) ;
      
      if (!(fil = fopen(fileName, "r")))
	{ if (!doAlign)
	    messout ("Could not find file %s",fileName) ;
	  else
	    upMessage (messprintf ("Could not find file %s",
				   fileName)) ;
	  break ;
	}
      
      if (!updateCheckFile(fil))
	{ fclose(fil) ;
	  break ;
	}

      if (!updateParseFile (fil))  /* does close fil */
	{ messout ("%s%s","There were errors while parsing the ",
		   "official data: I exit.") ;
	  exit(1) ;
	}
      thisSession.subDataRelease++ ;
      doAlign = TRUE ;
      sessionClose(TRUE) ;
    }
  
  if (doAlign)
    { if (!isWriteAccess())
	sessionWriteAccess() ;
      updateAlign () ;
    }
  sessionClose(TRUE) ;
  mainActivity (0) ;
}

/******************************************/

static void updateDestroy (void)
{
  updateGraph = 0 ;
}

/*********************************************/
/************* public routine ****************/


static MENUOPT updateMenu[]={
        graphDestroy,"Quit",
        help,"Help",
	updateAction,"Next Update",
        0,0 };

/********************************************/

void updateData(void)
{
  if (!graphActivate(updateGraph))
    { updateGraph =  displayCreate(DtUpdate) ;
      graphMenu (updateMenu);
      graphTextBounds (80,100) ;
      graphRegister(DESTROY,updateDestroy) ;
      graphColor (BLACK) ;
      graphButtons (updateMenu, 1, 1, 50) ;
      line = 3 ;
      upMessage (messprintf ("We are now using data release %d-%d",
			     thisSession.mainDataRelease,
			     thisSession.subDataRelease)) ;
      graphRedraw () ;
    }
  else
    graphPop() ;
}
 
/*********************************************/
/*********************************************/

