/*  File: status.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 **  Status  of the ACeDB program.                            **
 * Exported functions:
 **  acedbstatus and dosomething                               
     dosomething is for a single user DOS system                
 * HISTORY:
 * Last edited: Apr 22 16:15 1992 (mieg)
 * Created: Fri Nov 29 12:20:30 1991 (mieg)
 *-------------------------------------------------------------------
 */
 
#include "acedb.h"
#include "disk.h"    /*for diskavail() and saveAll*/
#include "block.h"   /*for blockavail()*/
#include "lex.h"
#include "key.h"
#include "bs.h"
#include "cache.h"
#include "graph.h"
#include "display.h"
#include "pick.h"
#include "session.h"

void dosomething(void);
void acedbstatus(void);
extern char* getlogin(void) ;

/*************************************************************************/

             /*This program is called when the machine */
             /*is waiting for the user                 */
             /*in menus, message, yes/no etc           */
             /*It should not be used recursively.      */
             /* Static ; called by keywait             */


void dosomething(void)
{
 static int recursion=0;


 if(recursion) return;
 recursion=1;
                         /*try to do something*/
/*
 if(!i) i=blocksave();
 if(!i) i=lexdump(1);
*/
 recursion=0;
 return;
}

/******************************************************************/

extern unsigned int _stklen, stackused(void) ;
#ifndef __MSDOS__
 #define coreleft()     0
 #define _stklen        0
#endif

static Graph statusGraph = 0;
static void statusDestroy(void);
static void lexDetails(void);

static MENUOPT statusMenu[]={
        statusDestroy,"Quit",
        help,"Help",
	acedbstatus,"Update",
	lexDetails,"More on lexiques",
        blockshow,"Block Show",
        0,0 };

/**********************************************************/

static void lexDetails(void)
{ int i , line = 3 ;
  graphClear() ;
  graphPop() ;
  graphTextBounds (100,10) ;
  for(i=0; i<256;i++)
    if(pickType(KEYMAKE(i,0)))
      { line++ ;
	graphText("Class :",4, line) ;
	graphText(pickClass2Word(i),12, line) ;
	graphText(messprintf("%6d entries    %8d char",
			     lexMax(i), vocMax(i)), 25, line) ;
      }
  graphTextBounds (100,(line+5)) ;
  graphRedraw() ;
}

/**********************************************************/

void acedbstatus(void)
{
 unsigned long keynum,vocnum,vocspace;
 int
   dused, dfree, plus, minus,
   bsused, bsalloc, btused, btalloc, aused ,
   cacheused,cachel,cachek,cachemod, semid, semState ;
 int line ;
#ifdef __MSDOS__
 unsigned long corelft=coreleft() ;
 unsigned int stacklft = _stklen - stackused();
#endif

 diskavail(&dfree,&dused, &plus, &minus) ;
 lexavail(&vocnum,&keynum,&vocspace);
 BSstatus (&bsused, &bsalloc) ;
 BTstatus (&btused, &btalloc) ;
 aused = arrayNumber() ;
 semaphoreStatus(&semid, &semState) ;
 cacheStatus(&cacheused,&cachel,&cachek,&cachemod);
 if(graphActivate(statusGraph))
  { graphPop() ;
    graphClear();
    graphTextBounds (100,15) ;
  }
 else
    { statusGraph =  displayCreate(DtStatus) ;
      graphMenu (statusMenu);
      graphTextBounds (100,15) ;
      graphColor (BLACK) ;
    }
 line = 1 ;

 graphText
   ( messprintf("ACEDB, version %d.%d, data release %d-%d",
		thisSession.mainCodeRelease,
		thisSession.subCodeRelease,
		thisSession.mainDataRelease,
		thisSession.subDataRelease ) ,2,line++) ;
 line++ ;
 graphText(messprintf("Session : %d, User %s,  Write Access %s ",
		      thisSession.session, getlogin(), 
		      (isWriteAccess() ? "Yes" : "No" )  ) ,
                      12,line++);
 graphText(messprintf
	   ("Semaphore id : %d,    state %d, Global Address %d",
	    semid, semState, thisSession.gAddress), 12, line++) ;

 line++ ;
 graphText
   (messprintf
    ("On disk : %d blocks used,  %d blocks available.",
                     dused,dfree),2,line++) ;
 graphText
   (messprintf
    ("        : %d blocks allocated and %d freed in this session.",
                     plus, minus),2,line++);
 line++ ;
 graphText(messprintf(
   "The %lu lexiques contain a total of %lu keys and %lu char",
          vocnum,keynum,vocspace),2,line++);
 line ++ ;
 graphText(messprintf("Object Cache : %d obj used,  %d obj locked, %d obj known, %d mod.",
                     cacheused,cachel,cachek,cachemod),2,line++);
 line ++ ;
 graphText(messprintf("Number of Arrays   being used  %d",
		      aused),10,line++) ;
 graphText(messprintf(
"Nodes used/alloc  BS : %d/%d   BT : %d/%d",
		      bsused,bsalloc,btused,btalloc),10,line++) ;

#ifdef __MSDOS__
 line ++ ;
 graphText(messprintf("Available memory  %lu ",corelft/1024),
	   10,line++);
 graphText(messprintf("Available Stack   %u",stacklft),10,line++);
#endif

 graphTextBounds (100,++line) ;
 graphRedraw() ;
}
 
/******************************************/

static void statusDestroy(void)
{
  statusGraph = 0 ;
  graphDestroy() ;
}

/*********************************************/
/*********************************************/

