/*  Last edited: Apr 23 16:55 1992 (mieg) */


/*******************************************************************/
/*   A C e D B                                                     */
/*   A Caenorhabditis elegans Data Base                            */
/*               by R.Durbin and J.Thierry Mieg                    */
/*******************************************************************/
/*   Non interactive Query Server                                  */
/*******************************************************************/

/*  Version number is #defined  in session.h                       */

extern void 
  blockInit(void),
  lexInit(void),
  pickInit(void),
  sessionInit(void) ,
  sessionAutoSelect(void) ;

extern char *stackorigin ;            /* in arraysub */

#include "acedb.h"
#include "session.h"
#include "pick.h"
#include "bs.h"
#include "systags.wrm"
#include "tags.wrm"


/*******************************************************************/
/********** Missing routines ***************************************/
extern void pickInit(void) ;


  /* querymain.c  
     
     JTM september 1991.

     */

  /* This is a test environment for a query server
     
     The only public funtion in this package could be
     KEYSET query(oldset, text_of_query)

     We need to define a local lexique system
     to recognize tags and cache those objects 
     loaded in for analysis.

     The filtering on names of other classes could be
     left in the main database server, in this way
     query would not have to load all the vocabularies.

     graphtext is used by some dumper or other in 
     debugging mode.

     bsTreeGet needs be reprogrammed as a socket 
     communicating with the database server.

void * bsTreeGet(KEY key) 
{ return NULL ;
}

   */


void graphText (char *text, float x, float y)
{ printf(text) ;
}

void graphHelp(void)
{ return ;
}
void graphClear(void)
{ printf("\n\n") ;
  return ;
}

void graphRedraw(void)
{ printf("\n") ;
  return ;
}

void graphTextBounds(int w, int h)
{ return ;
}

void graphColor(int color)
{ return ;
}

void * graphCreate()
{ return NULL ;
}

BOOL graphPrompt (char *prompt, char *dfault, char *fmt)
{ return freeprompt(prompt,dfault,fmt) ;
}

BOOL graphQuery (char *text)
{ return freequery(text) ;
}



/* Needed to link diskSubs without beeing able to save */

int parseFile (FILE *fileHandle)
{ messcrash("parseFile shoud not be called by queryServer") ;
  return 0 ;
}

int cacheSaveAll(void)
{ messcrash("cacheSaveAll shoud not be called by queryServer") ;
 return 0 ;
}

    /* comparaisons in queryexe need a local lexique */
    
/*

char * name(KEY key)
{ return NULL ;
}

BOOL lexword2key(char *name,KEY *kp, int class)
{ *kp = 0 ;
  return FALSE ;
} 

int lexstrcmp( char *a, char *b)
{ return strcmp(a,b) ;
}


    // for pickInit 
BOOL lexaddkey(char *name,KEY *kp, int class)
{ *kp = 0 ;
  return FALSE ;
} 
    // called by objcache to release older object 


void* KEY2LEX(KEY kk)
{
 return NULL ;
}

void lexunlock(KEY key)
{ return ;
}

*/

/******************* INITIALISATION ***************************/
/**************************************************************/

static void wormInit (int argc, char **argv)
{
  char *homedir ;
                 /* This is the root of the database directory */
    /* by changing it, you may work on different sets of data */

  if (homedir = getenv ("ACEDB"))
    filsetdir (homedir) ;
  else
    messcrash ("%s %s",
	       "Environment variable ACEDB is not defined",
	       "Read the instructions in the README of this program"
	       ) ;
  
  /* Macro KEYKEY relies on KEY beeing 4 bytes long  */
  /* Furthermore, it may be assumed implicitly elsewhere */

  if (sizeof(KEY) != 4)
    messcrash ("KEY size is %d - it must be 4 - rethink and recompile!",
	        sizeof(KEY)) ;

  /* The order of the initialisations is crucial */

  freeinit ();			/* must come before graphInit */

  blockInit()  ;		/*Initialisation du cache*/  
  lexInit() ;                   /*Initialisation du lexique*/  
                                /* et lecture de sytags et tags */
  pickInit() ;                  /*Class definitions */
  sessionInit() ;               /*Reads in the lexiques etc */
  sessionAutoSelect() ;
}

/*************************************************************/

static void showModel(KEY key)
{
  FILE *f = filopen("wspec/models", "wrm","r") ;
  char *cp , buf[256] ;

  buf[255] = 0 ;
  if (!f)
    messcrash("showModel can t find the model file") ;
  while (freeread(f))  /* look for ?className */
    if ((cp = freeword()) && *cp == '?' && !strcmp(cp+1, className(key)))
      break ;

  if (strcmp(cp+1, className(key)))
    { printf ("model of class %s not found \n", className(key)) ;
      return ;
    }
  printf("%s %s\n", cp, freepos()) ;
  while (cp = fgets(buf, 255, f))
    if (*cp == '?')
	  { fclose(f) ;
	    return ;
	  }
    else  /* printout */
      printf("%s", cp) ;
}

/*************************************************************/

BOOL getClassKey (char *text, KEY *kp)
{
  return FALSE ;
}

/****************** MAIN LOOP **********************/
#include "keyset.h"
#include "query.h"
#include "a.h"
#include "dump.h"
#include "lex.h"

static FREEOPT qmenu[] = 
{ 
  18, "acedb",
  'q', "Quit :   Quits the program.       Any command can be abbreviated, $starts a subshell",
  'h', "Help : for further help",
  'c', "Classes : Give a list of all the visible class names and how many  objects they contain.",
  'n', "New class: Creates a new current list with all objects from class",
  'z', "Z class: Shows the model of the given class, useful before t or f commands",
  'g', "Get template: Gets all visible objects in the database whose name matches template",
  'm', "Match template : searches for *template* everywhere in the database",
  'u', "Undo : returns the current list to its previous state",
  'l', "List [template]: lists names of items in current list [matching template]",
  's', "Show [?Class or name] : shows objects of current list in class or matching name or all",
  'k', "Keep template : keeps in the active list only those objects whose name match the template",
  'r', "Remove template : removes from the active list only those objects whose name match the template",
  't', "Tag follow : i.e. Tag Author gives the list of authors of the papers of the current list", 
  'f', "Finds query_string : performs a complex query - 'help query_syntax' for further info",
  'w', "Write filename : acedump current list to file",
  'b', "Biblio : shows the associated bibliography",
  'd', "Dna : Fasta dump of related sequences",
  'a', "Array class:name format : formatted acedummp of A class object"
  } ;

static FREEOPT helpmenu[] =	/* no \n inside FREEOPT text (else rethink) */
{ 5, "helpmenu",
  1, "Tacedb : copyright etc", 
  2, "Query_syntax for the find command",
  3, "Useful_sequences : SL1 etc",
  4, "Clone_types used in the physical map (vector etc)",
  5, "DNA_and_amino_acids_nomenclature : codes for bases/amino acids and translation table",
} ;

static void askQueries(void)
{ 
  KEYSET ksNew = 0 , ksOld = 0 , kA = 0 , kClass;
  int nn = 0 , i, j, class ;
  KEY option, key ; FILE *f ;
  Array a ;
  char *fmt, *cp , c ;
  Stack grepText = 0 , localStack = 0 ;

  printf ("\n\nType ? for a list of options\n\n") ;

  while (TRUE)
    { 
      if (freeselect (&option, qmenu))
      switch (option)
	{
	case 'q':
	  return ;
	case 'h':
	  if (freekey (&option, helpmenu))
	    { freeforcecard (helpmenu[option].text) ;
	      helpPrintf (stdout, freeword()) ;
	    }
	  else
	    { printf (
"To see a list of possible commands type ?.  Commands are not case sensitive and can be\n"
"abbreviated.  Lines starting with @ will take the next word as a file name to read\n"
"commands from (include file), passing subsequent words on the line as parameters %1 etc.\n"
"Lines starting with $ execute the remainder of the line in an interactive subshell.\n"
"Everything following // on a line is ignored (comment).  To escape any of these special\n"
"characters use a backslash, eg \\\@.\n\n"
"This program maintains an internal list of current objects.  You can change the list with\n"
"the command 'find search string', where 'search string' follows the acedb query syntax.\n"
"For further help on any of the following features type 'help feature'\n"
		     ) ;
	      for (i = 1 ; i <= helpmenu[0].key ; i++)
		printf ("   %s\n",helpmenu[i].text) ;
	    }
	  break ;
	case 'l':   /* lists names matching template */
	  if (!ksNew)
	    { printf ("Active list is empty\n") ;
	      break ;
	    }
	  if (cp = freeword())
	    { kClass = keySetCreate() ;
	      for (i = 0, j = 0 ; i < keySetMax(ksNew) ; i++)
	      if (pickMatch(name(keySet(ksNew,i)), cp))
		keySet(kClass, j++) = keySet(ksNew, i) ;
	    }
	  else
	    kClass = keySetCopy(ksNew) ;
	  keySetDestroy(kA) ;
	  kA = keySetAlphaHeap(kClass, keySetMax(kClass)) ;
	  keySetDestroy(kClass) ;
	  fprintf(stdout, "\nKeySet : Answer_%d\n",++nn) ;
	  keySetDump(stdout,0, kA) ;
	  break ;
	case 'g':   /* gets all  names matching template */
	  if (cp = freeword())
	    { if (ksNew && ksOld != ksNew)
		{ keySetDestroy(ksOld) ;
		  ksOld =  ksNew ;
		}
	      ksNew = keySetCreate() ;
	      for (i = 0, j = 0 ; i < 256 ; i++) 
		if(pickVisible(i))
		  { while (lexNext(i, &key))
		      if (pickMatch(name(key), cp))
			keySet(ksNew, j++) = key ;
		  }
	      keySetSort(ksNew) ;
	      printf (" %d objects kept \n", keySetMax(ksNew)) ;
	    }
	  else
	    printf("Usage Keep template : keeps names from current list matching template") ;
	  break ;
	case 'k':   /* keeps names matching template */
	  if (!ksNew)
	    { printf ("Active list is empty\n") ;
	      break ;
	    }
	  if (cp = freeword())
	    { if (ksNew && ksOld != ksNew)
		{ keySetDestroy(ksOld) ;
		  ksOld =  ksNew ;
		}
	      ksNew = keySetCreate() ;
	      for (i = 0, j = 0 ; i < keySetMax(ksOld) ; i++)
	      if (pickMatch(name(keySet(ksOld,i)), cp))
		keySet(ksNew, j++) = keySet(ksOld, i) ;
	      printf (" %d objects kept \n", keySetMax(ksNew)) ;
	    }
	  else
	    printf("Usage Keep template : keeps names from current list matching template") ;
	  break ;
	case 'r':   /* remove names matching template */
	  if (!ksNew)
	    { printf ("Active list is empty\n") ;
	      break ;
	    }
	  if (cp = freeword())
	    { if (ksNew && ksOld != ksNew)
		{ keySetDestroy(ksOld) ;
		  ksOld =  ksNew ;
		}
	      ksNew = keySetCreate() ;
	      for (i = 0, j = 0 ; i < keySetMax(ksOld) ; i++)
	      if (!pickMatch(name(keySet(ksOld,i)), cp))
		keySet(ksNew, j++) = keySet(ksOld, i) ;
	      printf (" %d objects kept \n", keySetMax(ksNew)) ;
	    }
	  else
	    printf("Usage Remove template : remove names matching template") ;
	  break ;
	case 't':   /* Tag follow */
	  if (!ksNew || !keySetMax(ksNew))
	    { printf ("Active list is empty\n") ;
	      break ;
	    }
	  class = 0 ;
	  if (cp = freeword())
	    { /* Autocomplete to a tag */
	       KEY tag = 0 ;
	      
	      while (lexNext(0, &tag))
		if(pickMatch(name(tag), cp))
		  { if (strcmp(cp, name(tag)))
		      printf ("Autocompleting %s to %s",
			      cp, name(tag)) ;
		    if (ksNew && ksOld != ksNew)
		      { keySetDestroy(ksOld) ;
			ksOld =  ksNew ;
		      }
		    ksNew = query(ksOld, messprintf(">%s", name(tag))) ;
		    goto goodTag ;
		  }
	      printf ("Sorry, Tag %s unknown \n", cp) ;
	      break ;
	    }
	  else
	    { printf("Usage Tag tag-name, change to list of objetcs pointed by tag, "
		     "type Z class to see the model of the class") ;
	      break ;
	    }
	goodTag:
	  printf ("\nFound %d objects\n", keySetMax(ksNew)) ;
	  break ;
	case 's':   /* Show objects */
		  /* look for the class name */
	  if (!ksNew || !keySetMax(ksNew))
	    { printf ("Active list is empty\n") ;
	      break ;
	    }
	  class = 0 ;
	  if (cp = freeword())
	    { if (*cp == '?')
		{ /* Autocomplete to a Class */
		  char *name;
		  cp++ ;
		  for(class=0;class<256;class++)
		    if(  (name = pickClass2Word(class))
		       && pickMatch(name, cp) )
		      { if (strcmp(cp, name))
			  printf ("Autocompleting %s to %s",
				  cp, name) ;
			printf("Objects in current list belonging to class %s are:\n", name) ;
			kClass = query(ksNew, messprintf("?%s", pickClass2Word(class))) ;
		      }
		  if (class == 256)
		    { printf ("Class %s unknown \n", cp) ;
		      break ;
		    }
		}
	    else
	      { printf("Objects in current list whose name matches %s are:\n", cp) ;
		kClass = query(ksNew, cp) ;
	      }
	    }
	  else
	    kClass = keySetCopy(ksNew) ;
	  if (kClass && keySetMax(kClass))
	    { keySetDestroy(kA) ;
	      kA = keySetAlphaHeap(kClass, keySetMax(kClass)) ;
	      for (i = 0 ; i < keySetMax(kA) ; ++i)
		dumpKey (keySet(kA,i), stdout) ;
	    }
	  else
	    printf ("No match \n") ;
	      keySetDestroy(kClass) ;
	  break ;
	case 'u':   /* undo */
	  if (ksOld)
	    { keySetDestroy (ksNew) ;
	      ksNew = ksOld ;
	      ksOld = 0 ;
	      printf ("\nRecovered %d objects\n", keySetMax(ksNew)) ;
	    }
	  else
	    printf("No more previous list available\n") ;
	  break ;
	case 'c':  /* Class */
	  printf("These are the known classes and the number of objects in each class \n");
	  for(i=0; i<256;i++)
	    if(pickVisible(i))
	      printf("%35s %d \n", pickClass2Word(i),lexMax(i)) ;
	  break ;
	case 'n':   /* New class */
	  cp = freeword() ;
	  if (!cp) 
	    { printf ("Usage New Class : Construct a new current list"
		      " formed with all objects belonging to class \n") ;
	      break ;
	    }
	  class = 0 ;
	  { /* Autocomplete to a Class */
	      char *name;
	      for(class=0;class<256;class++)
		if(  (name = pickClass2Word(class))
		   && pickMatch(name, cp) )
		  { if (ksNew && ksOld != ksNew)
		      { keySetDestroy(ksOld) ;
			ksOld =  ksNew ;
		      }
		    ksNew = query(0, messprintf(">?%s", name)) ;
		    if (keySetMax(ksNew))
		      printf ("\nFound %d objects in class %s \n", keySetMax(ksNew), name) ;
		    else
		      { printf ("Class %s is empty\n", name) ;
			keySetDestroy(ksNew) ;
		      }
		    break ;
		  }
	      if (class == 256)
		{ printf ("Sorry, class %s is unknown,\n type C for a list of known classes. \n", cp) ;
		  break ;
		}
	    }
	  break ;
	case 'z':   /* Z class-model */
	  cp = freeword() ;
	  if (!cp) 
	    { printf ("Usage Z Class : Shows the model of given class, type C to list them\n") ;
	      break ;
	    }
	  class = 0 ;
	  { /* Autocomplete to a Class */
	      char *name;
	      for(class=0;class<256;class++)
		if(  (name = pickClass2Word(class))
		   && pickMatch(name, cp) )
		  { key = KEYMAKE(class, 0) ;
		    if (pickType(key) == 'B')
		      showModel(key) ;  /* dumpKey refuses to dump models */
		                          /* because they could not be parsed */
		    else
		      printf("Sorry, %c class %s has no model\n", 
			     pickType(key), name) ;
		    break ;
		  }
	      if (class == 256)
		{ printf ("Sorry, class %s is unknown,\n type C "
			  "for a list of known classes. \n", cp) ;
		  break ;
		}
	    }
	  break ;
	case 'f':   /* Performs a complex query */
	  if (!(cp = freewordcut("",&c)))
	    break ;
	  localStack = stackReCreate(localStack, 80) ;
	  pushText(localStack, cp) ;
	  if (ksNew && ksOld != ksNew)
	    { keySetDestroy(ksOld) ;
	      ksOld =  ksNew ;
	    }
	  ksNew = query(ksOld,stackText(localStack, 0)) ;
	  if (ksNew != ksOld)
	    printf ("\nFound %d objects\n", keySetMax(ksNew)) ;
	  break ;
	case 'm':   /* Match == Grep */
	  if (!(cp = freewordcut("",&c)))
	    break ;
	  if (ksNew)
	    { keySetDestroy(ksOld) ;
	      ksOld =  ksNew ;
	    }
	  printf ("I search for texts or object names matching *%s*\n", cp) ;
	  grepText = stackReCreate(grepText,20) ;
	  pushText(grepText,messprintf("*%s*",cp)) ;
	  ksNew = queryGrep(stackText(grepText,0)) ;
	  printf ("\nFound %d objects\n", keySetMax(ksNew)) ;
	  break ;
	case 'a':
	  if (lexClassKey (freeword(), &key)
	      && (fmt = freeword())
	      && (a = uArrayGet(key, sizeOfFormattedArray(fmt), fmt)))
	    { dumpFormattedArray (stdout, a, fmt) ;
	      arrayDestroy (a) ;
	    }
	  break ;
	case 'b':
	    printf("   Associated bibliography \n") ;
	  {
	    /* We need to declare all bib... to be able to destroy them */
	    
	    KEYSET bib1, bib2, bib3, bib4, bib , s = ksNew , aut = arrayCreate(12, BSunit) ;
	    KEY ref, text, kk; OBJ Ref ;
	    char  *cq ; int ix, j ;
	    Stack buf = stackCreate(50) ;

	    bib1 = query(s,"?Paper") ; /* Class Paper members of s */
	    bib2 = query(s,">Paper") ; /* Follow tag Paper */
	    bib3 = query(s,">Reference") ; /* Follow tag Reference */
	    
	    bib4 = keySetOR(bib2,bib3) ;
	    bib  = keySetOR(bib1,bib4) ;
	    
	    keySetDestroy(bib1) ;
	    keySetDestroy(bib2) ;
	    keySetDestroy(bib3) ;
	    keySetDestroy(bib4) ;
	    
	    for(i=0 ; i < keySetMax(bib) ; i++)
	      {
		printf("%s : \n", name(ref=keySet(bib,i))) ;
		if (Ref = bsCreate(ref))
		  {
		    if(bsGetKey (Ref,_Title,&text))
		      {
			uLinesText(cp=name(text),80);
			while(cq=uNextLine(cp))
			  printf("    %s \n", cq) ;
		      }
		    stackClear(buf) ; catText (buf,"") ;
		    if (bsFindTag (Ref, _Author) &&
			bsFlatten (Ref, 1, aut))
		      {
			for (j=0;j<arrayMax(aut);j++)
			  { if(j)
			      catText(buf,", ") ;
			    catText(buf,name(keySet(aut,j))) ;
			  }
			catText(buf,".");
			uLinesText(stackText(buf,0),80) ;
			while (cp = uNextLine(stackText(buf,0)))
			  printf ("   %s\n", cp);
		      }
		    stackClear(buf) ; catText(buf,"") ;
		    if (bsGetKey (Ref,_Journal,&kk))
		      catText (buf,name(kk));
		    if (bsGetData (Ref,_Volume,_Int,&ix))
		      { catText (buf, messprintf (" %d",ix)) ;
			if (bsGetData (Ref,_bsRight,_Text,&cp))
			  catText (buf, cp) ;
		      }
		    
		    if (bsGetData (Ref,_Page,_Int,&ix))
		      { catText (buf, messprintf (", %d",ix)) ;
			if (bsGetData (Ref,_bsRight,_Int,&ix))
			  catText (buf, messprintf ("-%d",ix)) ;
		      }
		    
		    if (bsGetData (Ref,_Year,_Int,&ix))
		      catText (buf, messprintf (" (%d)",ix)) ;
		    
		    uLinesText (stackText(buf,0),80) ;
		    while (cp = uNextLine(stackText(buf,0)))
		      printf ("    %s\n", cp);
		    bsDestroy(Ref);
		  }
	      }
	    keySetDestroy(bib) ;
	  }
	  break ;
	case 'w': /* write */
	  if (!ksNew || !keySetMax(ksNew))
	    { printf ("Active list is empty\n") ;
	      break ;
	    }
	  cp = freeword() ;
	  if (!cp || !*cp)
	    { printf("Usage Write filename: ace dump the current list in file\n") ;
	      break ;
	    }
	  f = fopen(cp, "w") ;
	  if (f)
	    { keySetDestroy(kA) ;
	      kA = keySetAlphaHeap(ksNew, keySetMax(ksNew)) ;
	      for (j = 0 , i = 0 ; i < keySetMax(kA) ; ++i)
		if (dumpKey (keySet(kA,i), f))
		  j++ ;
	      fclose (f) ;
	      printf("I wrote %d objects to file %s\n", j, cp) ;
	    }
	  else
	    printf("Sorry, I could not open file %s\n", cp) ;
	  break ;
	
	default:
	  printf ("Option not written yet\n") ;
	}
      continue ;
    }
}

/**************************************************/
/********* ACEDB non graphic Query Server  ********/
/**************************************************/

void main (int argc, char **argv)

{char x ;

 stackorigin = &x ;
  printf("**** acedb queryserver: Version %d.%d %s ****\n",
	 MAINCODERELEASE, SUBCODERELEASE,DATE_OF_CODE_RELEASE) ;
  printf("Authors: Richard Durbin (MRC, UK) rd@mrc-lmba.cam.ac.uk\n") ;
  printf("         Jean Thierry-Mieg (CNRS, France) mieg@frmop11.bitnet\n") ;
  printf("You may redistribute this program and database subject to the\n") ;
  printf("conditions in the accompanying copyright file.  Anyone interested in\n") ;
  printf("maintaining an up to date version should contact one of the authors\n") ;
  printf("at the above email addresses.\n") ;

 wormInit (argc, argv) ;
 askQueries () ;
  printf ("\n A bientot \n\n") ;
  exit(0) ;
}

/**************************************************/
/**************************************************/
