/*  File: mainpick.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Apr  2 18:51 1992 (mieg)
 * * Dec  6 13:28 1991 (mieg): autocompletion system
 * * Dec  2 20:59 1991 (mieg): if(isdisplayBlock) no autoPick
 because this create a textBound on wrong graphtype somehow ?
 * * Nov  5 18:28 1991 (mieg): call to keySetShow changed
 * Created: Tue Nov  5 18:26:56 1991 (mieg)
 *-------------------------------------------------------------------
 */

#include "acedb.h"
#include "array.h"
#include "graph.h"
#include <ctype.h>
#include "key.h"
#include "keyset.h"
#include "lex.h"
#include "pick.h"
#include "display.h"
#include "sysclass.wrm"
#include "query.h"


#define MAGIC 49662

typedef struct PickStruct
  { int    magic ;  /* == MAGIC */
    int    curr ;
    char*  template ;
    int    templateBox ;
    char*  grepText ;
    int    grepBox ;
    char   whatdoIdoText[64] ;
    int    whatdoIdoBox ;
    Graph  mainGraph ;
    Graph  dispGraph ;
    KEYSET oblist ;
    void*  dispHandle ;
  } *Pick ;
#define PICKSIZE sizeof(struct PickStruct)

#define PICKGET(name)     Pick pick ;\
                                       \
                          if (!graphAssFind (pickDestroy,&pick)) \
		            messcrash ("%s can't find pointer",name) ; \
			  if (!pick) \
                            messcrash ("%s received a null pointer",name) ; \
                          if (pick->magic != MAGIC) \
                            messcrash ("%s received a wrong pointer",name)

static void pickDestroy (void) ;
static Pick mainPick ;

/****************************************************************/

static void obDisplay (Pick pick)
{
	/* then switch to the display graph (make if necessary) */

  if (graphExists (pick->dispGraph))
    keySetShow (pick->oblist,pick->dispHandle) ;
  else
    { pick->dispGraph = displayCreate(DtKeySet) ;
      graphRetitle("Selection List") ;
      pick->dispHandle = keySetShow (pick->oblist,0) ;
    }

  if (keySetMax(pick->oblist) == 1 && !isDisplayBlocked())
    { KEY key = keySet(pick->oblist,0) ;

      keySetCurrent (pick->dispHandle,key) ;
      display (key,0,0) ;
    }
  graphActivate (pick->mainGraph) ;
}

/**************** text action **********************/

static BOOL classDisplay (void)  /* displays current option list */
{ 
  PICKGET("obDisplay") ;
  
  keySetDestroy (pick->oblist) ;
		  
  if (!pick->curr)
    { messout("Please pick a class") ;
      return FALSE ;
    }
  pick->oblist = query(0,   messprintf( ">?%s %s",
		     pickVocList[pick->curr].text,
		     pick->template)) ;

  obDisplay (pick) ;

  return (keySetMax(pick->oblist) != 0) ;
}

/*************************************************/

static void grepDisplay (void)
{
  int n ;
  static int confirm = 0 ;
  char *cp,*cq ;
  static char localText[128] , lastText[128] ;
  PICKGET("grepDisplay") ;
  
/* first check that the search text is non-trivial */

  for (n = 0, cp = pick->grepText ; *cp ; ++cp)

    if (isalnum(*cp))
      ++n ;
  if (n < 3)
    {      /* Possible non existence after Clean Up */
      if (graphActivate (pick->dispGraph))
	{ graphClear () ;
	  graphPop() ;
	}
      else
	{ pick->dispGraph = displayCreate(DtKeySet) ;
	  graphRetitle("Selection List") ;
	  pick->dispHandle = keySetShow (0,0) ;
	}
      graphText ("To search text please specify a search string ",1,1) ;
      graphText ("with at least 3 letters or digits.",1,2) ;
      graphText ("   Authorized wild chars are",1,4) ;
      graphText ("* (any string), ? (single char).",1,5) ;

      graphRedraw () ;
      graphActivate (pick->mainGraph) ;
      return ;
    }

/* make localText with a '*' in front of and behind the grep text */
  
  cp = pick->grepText ;
  if (*cp == '*')
    cq = localText ;
  else
    { *localText = '*' ;
      cq = localText+1 ;
    }
  while (*cq++ = *cp++) ;
  if (cq[-2] != '*')
    { cq[-1] = '*' ; *cq = 0 ; }

/* If the text has not changed, wait for confirmation */
  if(!strcmp(localText,lastText))
    if(!confirm++)
      return ;
  strncpy(lastText,localText,127) ;
  confirm = 0 ;

/* then do the search */

  keySetDestroy(pick->oblist)  ;

  pick->oblist = queryGrep(localText) ;
  obDisplay (pick) ;
}

/**************** pick Action ************/

int ksetClassComplete(char *text, int len, int class) ;
static void classComplete(char *cp, int len)
{ static int previousClass = -1 ;
  PICKGET("classComplete") ;

  if (!pick->curr)
    return ;
  if (previousClass != pick->curr)
    ksetClassComplete(0,0,0) ; /* reinitialise */
  ksetClassComplete(cp, len, pickVocList[pick->curr].key) ;
  previousClass = pick->curr ;
}


static void pickPick (int k)
{ 
  PICKGET("pickPick") ;
  
  if (k == pick->templateBox)
    {
/*      graphTextEntry (pick->template,0,0,0,0) ; */
      graphCompletionEntry(classComplete, pick->template,0,0,0,0) ; 
      k = pick->curr ;
      return ;
    }

  if (!k)
    return ;

  if (k <= pickVocList[0].key)
    { 
      if (k != pick->curr)
	{ if (pick->curr)
	    graphBoxDraw (pick->curr, BLACK, WHITE) ;
	  pick->curr = k ;
	  graphBoxDraw (pick->curr, WHITE, BLACK) ;
	  graphCompletionEntry (classComplete,pick->template,0,0,0,0) ;
	}
      else if (!classDisplay () && strcmp (pick->template,"*"))
	{ 		/* inappropriate template - display whole list */
	  strcpy (pick->template,"*") ;
	  graphCompletionEntry (classComplete,pick->template,0,0,0,0) ;
	  classDisplay () ;
	}
    }
  else if (k == pick->grepBox)
    {
      if (pick->curr)
	graphBoxDraw (pick->curr, BLACK, WHITE) ;
      pick->curr = 0 ;
      graphTextEntry (pick->grepText,0,0,0,0) ;
    }

}

/****************** destroy routine ************/

static void pickDestroy (void)
{ 
  Graph g = graphActive() ;
  PICKGET("obDestroy") ;

  if (graphActivate(pick->dispGraph))
      graphDestroy () ;

  if (graphActivate(pick->mainGraph))
     graphDestroy () ;

  graphActivate (g) ;

  free (pick->template) ;
  pick->magic = 0 ;
  free (pick) ;
  mainPick = 0 ;
}

/***************** public routine *****************************/

static Graph mainGraph = 0 ;
void mainCleanUp(void)
{
  if(graphActivate(mainGraph))
    graphCleanUp() ;
}
void pickPopMain(void)
{
  if(graphActivate(mainGraph))
    graphPop() ;
}

void mainActivity(char * text)
{ Pick pick = mainPick ;
  Graph hold = graphActive() ;

  if(!pick)
    return ;
  
  graphActivate(pick->mainGraph) ;
  if (!text)
    { strncpy(pick->whatdoIdoText, "Ready",20) ;
      graphBoxDraw(pick->whatdoIdoBox,BLACK,LIGHTGREEN) ;
    }
  else
    { strncpy(pick->whatdoIdoText, text, 20) ;
      graphBoxDraw(pick->whatdoIdoBox,BLACK,RED) ;
    }
  
  graphActivate(hold) ;
}

/***************** main create routine ************************/

Graph pickCreate (BOOL chooseSession)
{
  extern void sessionAutoSelect(void) ;
 
  int i,x,y , v ;
  int nx,ny,ncol ;
  int sep = 0 ;
  static  int firstpass = TRUE ;
  int nclasses = pickVocList[0].key ;
  Pick pick = (Pick) messalloc (sizeof(struct PickStruct)) ;
  
  pick->magic = MAGIC ;
  mainPick = pick ;

  pick->mainGraph = mainGraph =
    displayCreate (DtMain) ;
  graphAssociate (pickDestroy,pick) ;
  graphRegister (PICK, (GraphFunc)pickPick) ;
  graphRegister (DESTROY, pickDestroy) ;
  
/* dimensions */

  graphFitBounds (&nx,&ny) ;	/* want to find width */

  for (i = 1 ; i <= nclasses ; ++i)
    if (strlen(pickVocList[i].text) > sep)
      sep = strlen (pickVocList[i].text) ;
  sep += 2 ;

  ncol = 3 ; 	/*  could be (nx-2)/sep.  Would then need
		    if (ncol == 0) ncol = 1 ;
		*/
  ny = 4 + nclasses/ncol ;	/* use to make second window */

/* drawing */

  graphText ("Classes:", 0.5, 2.0) ;
  i = 1 ; x = 0 ; y = 3 ;
  while (TRUE)
    { graphBoxStart () ;
      graphText (pickVocList[i].text, 2 + x*sep, y) ;
      graphBoxEnd () ;
      if (++i > nclasses)
	break ;

      if (!(++x%ncol))
	{ x = 0 ; ++y ;
	}
    }

  graphBoxStart() ;
  graphText ("Text Search: ", 0.5, y+2) ;
  graphBoxEnd () ;
  pick->grepText = (char*) messalloc (17) ;
  *(pick->grepText) = 0 ;
  pick->grepBox = graphTextEntry (pick->grepText, 16, 14.5, y+2,
			  (GraphFunc)grepDisplay) ; /* cast to return void */

  graphText ("Template: ", 0.5, 0.5) ;
  pick->template = (char*)  messalloc (17) ;
  graphButton("Help",help,37.,.5) ;
  strcpy (pick->template,"*") ;
  pick->templateBox = graphCompletionEntry (classComplete, pick->template, 19, 12.0, 0.5, 
			 (GraphFunc)classDisplay) ;

  *pick->whatdoIdoText = 0 ;
 
  pick->whatdoIdoBox = graphBoxStart() ;
  graphTextPtr(pick->whatdoIdoText, 18, 2, 21) ;
  graphBoxEnd() ;
  
  graphRedraw () ;

  mainActivity(0) ;

  if(firstpass)
    sessionAutoSelect() ;
  firstpass = FALSE ;

  v = 1 ;    /* pick the first voc */

/* finally, pick voc v = Session  */
  if(chooseSession)
    { v = pickVocList[0].key + 1 ;
      while(v--)
	if(_VSession == pickVocList[v].key )
	  break ;
    }
         
  if(v<=0) v = 1 ;
  pick->curr = 0 ;
  pickPick (v) ;
  pickPick (v) ;	/* call twice to achieve selection */

  graphActivate(pick->mainGraph) ;
  return pick->mainGraph ;
}

/*************************************/
/**** Auto completion system *********/

void ksetShowSelection(KEYSET ks) 
{
  Graph oldGraph = graphActive() ;
  Pick pick = mainPick ;
 
  if(!pick)
    return ;
  
  graphActivate(pick->mainGraph) ;

  if(!keySetMax(ks))
    { messbeep() ;
      return ;
    }
  
  if (ks != pick->oblist)
    keySetDestroy (pick->oblist) ;
		    
  pick->oblist = ks ;

  obDisplay (pick) ;
  graphActivate(oldGraph) ;
}

/****************/

   /* return number of possible completions */
int ksetClassComplete(char *text, int len, int class)
{
  static KEYSET ks = 0, ks2, ksA ;
  static int previousClass = 0 ;
  static int myKeySetId = 0 ;
  static char buffer[80] ;
  char *cp, *cq, *text1 ;
  int i, j , n ;

  if(myKeySetId != keySetExists(ks))
    ks = 0 ;
  if(!text)
    { keySetDestroy(ks) ;
      return 0 ;
    }
 /*  keySetDestroy(ks) ; reusing is bugged somehow */
        /* check if i can keep working on same keyset */

  if (ks)
    {
      if (previousClass != class)
	keySetDestroy(ks) ;
      else
	{     /* check if search field just got longer */
	  cp = buffer ; cq = text ; n = 80; /* size of buffer */
	  while (--n && *cp && *cq++ == *cp++) ;
	  if(!n || *cp)
	    keySetDestroy(ks) ;
	}
    }
  
  if(!ks)
    ks = query
      ( 0, messprintf(">?%s \"%s*\"", pickClass2Word(class), text) ) ;
  else
    { ks2 = arrayCreate(keySetMax(ks), KEY) ;
      cp = text + strlen(text) ;
      *cp = '*' ;
      for (i=0, j=0; i<keySetMax(ks); i++ )
	if (pickMatch(name(keySet(ks,i)),text))
	  keySet(ks2,j++) = keySet(ks, i) ;
      *cp = 0 ;
      keySetDestroy(ks) ;
      ks = ks2 ;
    }
  
  if (!keySetMax(ks))
     messbeep() ;
  else
    {
      n = len = strlen(text) ;
      cq = text ; 
      while(n--)
	*cq++ = 0 ;

      ksA = keySetAlphaHeap(ks,keySetMax(ks)) ;
      cp = name(keySet(ksA,0)) ;
      cq = name(keySet(ksA,keySetMax(ksA) - 1)) ;
      text1 = text ;
      keySetDestroy(ksA) ;
      while(*cp && (*cp == *cq++))
	*text1++ = *cp++ ;
      if(! (len > strlen(text)) &&
	 keySetMax(ks))
	ksetShowSelection(ks) ;
    }
    
  myKeySetId = keySetExists(ks) ;
  previousClass = class ;
  strncpy(buffer, text, 79) ;
  return keySetMax(ks) ;
}


/****************************************/
/****************************************/



