/*  File: dump.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Apr  2 18:34 1992 (mieg)
 * Created: Sun Feb 16 01:31:41 1992 (mieg)
 *-------------------------------------------------------------------
 */

#include "../wnongraphic/dumpnogr.c"

static MENUOPT dumpMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        0,0 };

/******************************************/

static Graph dumpGraph = 0;

/******************************************/

static BOOL dumpClasses(void)
{ FILE *g ;
  register char c ;
  fprintf(f,"\n\n /*#* classes.wrm *#*/ \n\n") ;
  g = filopen("wspec/classes","wrm","r") ;
  if (!g)
    { fclose(f) ; return FALSE ;}
  while((c = fgetc(g)) != EOF)
    fputc(c,f) ;
  fclose(g) ;
  return TRUE ;
}

/******************************************/

static BOOL dumpTags(void)
{ FILE *g ;
  register char c ;
  fprintf(f,"\n\n /*#* tags.wrm *#*/ \n\n") ;
  g = filopen("wspec/tags","wrm","r") ;
  if (!g)
    { fclose(f) ; return FALSE ;}
  while((c = fgetc(g)) != EOF)
    fputc(c,f) ;
  fclose(g) ;
  return TRUE ;
}

/******************************************/

static void  dumpClass( int t, int * nk, int * no, int * ne) 
{

  KEY k = 0 ;
  *nk = *no = *ne = 0 ;
  while(lexNext(t,&k))
    { (*nk)++ ;
      if (iskey(k) == 2)
	{ (*no)++ ;
	  if(!dumpKey2(k,t))
	   (*ne)++ ;
	}
    }
}

/******************************************/

static void dumpDestroy(void)
{
  dumpGraph = 0 ;
}

/******************************************/

static FILE* dumpOpenOutput(void)
{ 
  char name[80] ;

  sprintf(name,"dump-%s-%s-session-%d", 
	   dateStamp(), timeStamp(), thisSession.session) ;
 
  if(!( f = filopen(name,"asc","w")))
    graphText("Dump could not open the OutPut file, Sorry",
	      5,5) ;
  else
    graphText(messprintf("Ready to dump into : %s",name),
	      2 , 3 ) ;
  graphRedraw() ;
  return f ;
}

/********************************************/

void dumpAll(void)
{
  int line , nk, ne, no , t , box ;

  if(!graphActivate(dumpGraph))
    { dumpGraph =  displayCreate(DtDump) ;
      graphMenu (dumpMenu);
      graphTextBounds (80,100) ;
      graphRegister(DESTROY,dumpDestroy) ;
      graphColor (BLACK) ;
    }
  else
    { graphPop() ;
      graphClear();
    }

  graphText(messprintf("Session %d", thisSession.session),
	    4, 2) ;
  f = dumpOpenOutput() ;

  line = 4 ;
  if(!f)
    graphText("Sorry, you do not have Write  Access \
I will not write anything but just \
check the consistency of the database ",
	      4, 4 ) ;

  graphRedraw() ;
  if(!graphQuery("Should I proceed ?"))
     return ;
  if(!f) 
    line = 7 ;
  
  if(f)
    {
      if(dumpClasses())
	graphText("Classes dumped", 4, line++)  ;
      else
	goto fin ;
      if(dumpTags())
	graphText("Tags dumped", 4, line++)  ;
      else
	goto fin ;
    }
  
  graphText("Dumping classes ", 4, line++)  ;
  graphRedraw() ;
  for(t = 1; t<256 ; t++)
    if(lexMax(t))
      {
	if(f && dumpPossible(t))
	  {
	    fprintf(f,"\n\n // Class %s \n\n",
		    pickClass2Word(t))  ;
	    dumpClass( t, &nk, &no, &ne) ;
	    box = graphBoxStart() ;
	    graphText(messprintf("Class %s : %d keys, %d obj, %d errors",
				 pickClass2Word(t),
				 nk,no, ne) , 4, line++)  ;
	    graphBoxEnd() ;
	    graphBoxDraw(box,BLACK,WHITE) ;
	  }
      }
  
 fin:
  if(f)
    { fprintf(f,"\n\n /*#########################*/ \n\n") ;
      fclose(f) ;
    }
  graphRedraw() ;
}
 
/*********************************************/
/******* Asn Models **************************/

extern char *asnCleanUp(char *cp) ;

static void  dumpAsnAllDefinitions(FILE *f)
{ int t ;
  BOOL previous = FALSE ;
  char *cp ;
  extern void  bsAsnDumpModel(FILE *f, int class) ;

  fprintf(f,"ACeDB-ASN  DEFINITIONS  ::= \nBEGIN\n\n") ;

  fprintf(f,"EXPORTS ACeDB-data ;\n\n") ;

/*   fprintf(f,"IMPORTS  xxxxx, yyyy, zzzz FROM elsewhere ;\n\n") ; */
  
  fprintf(f,"ACeDB-data ::= SET OF CHOICE \n{\n") ;
  for(t = 1; t<256 ; t++)
    if(asnDumpPossible(t))
      {
	if (previous)
	  fprintf(f,",\n") ;
	cp = pickClass2Word(t) ;
	fprintf(f, "   %s Acedb-%s", 
		asnCleanUp(cp), asnCleanUp(cp)) ;
	previous = TRUE ;
      }
  
  fprintf(f,"\n}\n\n") ;
  fprintf(f,"Acedb-Comment ::= SET OF VisibleString  \n\n") ;
  for(t = 1; t<256 ; t++)
    if(asnDumpPossible(t))
      bsAsnDumpModel(f,t) ;
	
  
  fprintf(f,"\n\n\nEND\n\n  -- End of ACEDB definitions -- \n") ;
  fclose(f) ;
}

/*********************************************/

void  dumpAsnDefinitions(void)
{ 
  char filName[80] , dirName[80] ;
  
  strcpy(filName,"acedb_definitions") ;
  strcpy(dirName,".") ;

  if(!( f = filqueryopen(dirName, filName,"asn","w")))
    messout("Dump could not open the OutPut file, Sorry") ;
  else
    dumpAsnAllDefinitions (f) ;
}

/******************************************/
/******************************************/ 
