/*  Last edited: Jan 21 14:18 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File session.c :                                         **/
      /**  Handles the sessions of the ACeDB program.               **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  ?   routines are public :                                  */
      /*     init, close, writeAccess.                               */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  8/10/90  by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "disk_.h"   /* defines BLOCKHEADER */
#include "array.h"
#include "menu.h"

extern char* getlogin(void) ;
extern void wormClose (void) ;    /* in wormmain.c */
extern void lexOverLoad(KEY key,DISK disk) ;
extern DISK lexDisk(KEY key) ;

#define BLKMX (BLOC_SIZE - sizeof(BLOCKHEADER) - sizeof(DISK)\
	       -sizeof(int) -sizeof(int) -sizeof(int))

typedef struct block /* sizeof(block) must be < BLOC_SIZE */
  {
    BLOCKHEADER  h ;
    DISK gAddress ;
    int mainRelease ,  subDataRelease, subCodeRelease ;
    char c[BLKMX] ;
  }
    BLOCK, *BLOCKP;   /*the transfer unit between disk and cache*/

#ifdef DEF_BP
  Fatal Error  Double definition of BP
#endif

typedef BLOCKP BP ;
#define DEF_BP

#include "session.h"
#include "a.h"
#include "bs.h"
#include "disk.h"
#include "lex.h"
#include "systags.wrm"
#include "sysclass.wrm"


static BLOCK b ;
void sessionUser(void) ;
extern void readModels(void) ;
SESSION  thisSession ;

#define DEBUG

/*************************************************************/
/****************************************************************/
static KEY   sessionChosen = 0 ;

/*************************************************************/

static void sessionStart(void)
{ OBJ Session ;
  int a, b, c ;

  a = b = c = 0 ;
  if(!sessionChosen)
   { messout("First pick a session in the Session List") ;
     return ;
   }
  Session = bsCreate(sessionChosen) ;
  if(!Session )
    { messout("Sorry, I cannot find %s",name(sessionChosen)) ;
      return ;
    }
  if(!bsGetData(Session,_VocLex,_Int,&a) ||
     !bsGetData(Session,_bsRight,_Int,&b) ||
     !bsGetData(Session,_bsRight,_Int,&c)  ||
     !bsGetData(Session,_CodeRelease,
	    _Int,&thisSession.mainCodeRelease) ||
     !bsGetData(Session,_bsRight,
		_Int,&thisSession.subCodeRelease) ||
     !bsGetData(Session,_DataRelease,
	    _Int,&thisSession.mainDataRelease) ||
     !bsGetData(Session,_bsRight,
	    _Int,&thisSession.subDataRelease) ) 
    { messout("No address in this session") ;
    }
  bsDestroy(Session) ;
  thisSession.from = sessionChosen ;

  lexOverLoad(__lexi3,(DISK)a) ;
  lexOverLoad(__lexa3,(DISK)b) ;
  lexOverLoad(__voc3,(DISK)c) ;
  lexRead() ;
}

/*************************************************************/

void sessionAutoSelect(void)
{ 
  sessionChosen = lexLastKey(_VSession) ;

  if(!sessionChosen)
    messcrash("The session class is empty, Reconstruct, sorry") ;
  sessionStart() ;
}

/*************************************************************/

void sessionInit(void)
{
 FILE * f;

 extern void lexReadGlobalTables(void) ;
 
 if (f = filopen("database/ACEDB","wrm","r"))
    {
      fclose(f) ;

      diskblockread(&b,1) ;
      if(b.mainRelease != MAINCODERELEASE)
	messcrash
	  ("%s%d.%d%s%d%s%s",
	   "You are running release ",MAINCODERELEASE,
	   SUBCODERELEASE,
	   " of ACEDB.\n The data base was created under release ",
	   b.mainRelease, ".xx To reconstruct the database",
   "remove the file ACEDB.wrm (save the old blocks.wrm first)."
	   ) ;
      thisSession.session = ++b.h.session ;
      thisSession.gAddress = b.gAddress ;
      lexOverLoad(__lexi1,b.gAddress) ;
      lexReadGlobalTables() ;
      return ;
    }
 
       /* else reinitialise the system */

 messcrash(
  "The database seems empty, it cannot be reinitialised by this ReadOnly Server.") ;
}

/*************************************************************/

void sessionRegister(void)
{ messcrash("sessionRegister shoud not be by Read Only programs") ;
}

BOOL isWriteAccess(void)
{ return FALSE ;
}

void sessionWriteAccess(void)
{ return ;
}


/*************************************************************/
/*************************************************************/


