/*  File: wcomm.c
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
	subroutines for worm communications {
 *  t. friedman		7/15/91 - first overhaul
 *  rev 6/8/91 : change for multiple clients

 * Exported functions:
 * HISTORY:
 * Last edited: Mar 14 19:28 1992 (mieg)
 * Created: Fri Nov  1 01:06:07 1991 (rd)
 *-------------------------------------------------------------------
 */



#ifdef WCS
#define WCS_LINK

#include "wcomm.h"		/* will also include <X11/Xlib.h> */

/* X include files */
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#define ACE

#ifdef ACE
#include "regular.h"
typedef void *MENUOPT ;
void menuRestore (char*, MENUOPT*) ;
void menuSuppress (char*, MENUOPT*) ;
extern MENUOPT* mainMenu ;
#else
#include <stdio.h>	/*??*/
#include <malloc.h>
#endif

#define NOBODY (Atom) -1	/* internal use */

/* save space for pointers to old error handlers:*/
static	XErrorHandler	DefaultXErrHandler;
static	XIOErrorHandler	DefaultXIOErrHandler;


/* Structure of communications block
 * Since X properties don't have substructure, this block is sent
 *	as a string
 * The end of the "handles" data is packed with strings 
 * The wb_handle.note fields are offsets into this string block;
 *	the first string in the block is the name of the application.
 */
#define	MAX_PARAM	60    /* arbitrarily large, to give room for strings */
struct WB_Message {
	Atom 	wb_atom;
	Window	wb_window;
	WMsgType	wb_type;
	int		wb_nparams;		/* actual parameter count */
	WHandle	wb_handle[MAX_PARAM];
}	mbuf, *inmsg;

#define	always_ok  False	/* for getting atom names */

static WCommBlock	*DaGuys = NULL;	/* who we talk to */
static WCommBlock	*LastGuy = NULL; /* tail of list */
static WCommBlock	my={0,0,0,0,0,0,0};	/* block for our program */
/* 
static WCommBlock	*his;		 pointer to current communicator 
static int		WCNumLinks = 0;
*/

static int
 WErrorHandler (zdisplay, zerr)
	Display		*zdisplay;
	XErrorEvent	*zerr;
{
    WCommBlock *WCBptr;	/* for tracking down lists */
    Window	his_window;

    /* a BadWindow error means the co-program has exited */
    if (zerr->error_code == BadWindow) {
	his_window = (Window) zerr->resourceid;

	/* check if it already exists. */
	for (WCBptr = DaGuys; WCBptr != NULL; WCBptr = WCBptr->WC_nextblock) 
	    if ( his_window == WCBptr->WC_window ) {
		WCBptr->WC_window =  None;
		return 1 ;  /* mieg return 1, wild guess, used to be return ; */
	    }
	/* probably should be some error message here */
    } else {
	/* otherwise, take the default error handling */
	(*DefaultXErrHandler) (zdisplay, zerr);
	/* for testing, we can use the following --
	XGetErrorText (zdisplay, zerr->error_code, msg, 80);
	fprintf (stderr, "Error code %d on request %d,%d: %s\n",
	    zerr->error_code, zerr->request_code, zerr->minor_code, msg);
	*/
    }
    return 0;
}


/* This error handler is just used to give a place to set a debugging
 * breakpoint to trap fatal errors before they cause program exit.
 */

static int
 WIOErrorHandler (zdisplay)
	Display		*zdisplay;
{
    /* let the default handler print the message */
    (*DefaultXIOErrHandler) (zdisplay);	/* pass it on */
    return 0;		/* X handler will be called immediately */
}

static int
 WReOpen (who_to)
	WCommLink who_to;
{
    who_to->WC_window = XGetSelectionOwner (my.WC_display, who_to->WC_atom);

    if (! my.WC_comm_type != writeonly
    && who_to->WC_comm_type != writeonly
    && who_to->WC_window != None)
    {
	/* inform other program of who we are */
	/* in the rare case where this was already opened, may be redundant */
	/* old way:
	XChangeProperty (my.WC_display, who_to->WC_window, who_to->WC_atom,
	XA_WINDOW, 32, PropModeReplace, (unsigned char *) &my.WC_window, 1);
	*/
	WSendMsg (who_to, ImHere, 0, NULL);
#ifdef ACE
	menuRestore ("WCS annotate", mainMenu) ;
#endif
    }
    return 0 ;
}

#define	dont_delete	False		/* parameter to get_window_property */

/* Open up a channel for communications.
 * establish a display & window to use for communications
 * if "my_name" is given, inform the system we can receive, else we're send-only
 * if "his_name" is given, try to establish communications with that
 * specific program.
 * if zdisplay or zwindow are zero, use previous value (if any)
 */

#ifdef old_way
WCommLink
 WInitComm ( my_name, his_name, zdisplay, zwindow, mycomm, hiscomm, handler)
#endif

Bool
 WInitComm ( my_name, zdisplay, zwindow, mycomm, handler)
    char    *my_name;		/* my program name */
    Display *zdisplay;	/* display & window to hook communications into */
    Window   zwindow;
    WCommType mycomm;	/* what communications we're willing to do */
    void    (* handler)();   /* routine to handle incoming data */
{
   /*
     long    nitems, bytes_left;
     int     ret_fmt;         ==0 means property doesn't exist
     Atom    ret_type;
     WCommLink newlink = WCNoLink;
*/


    if (zwindow != 0)
	my.WC_window = zwindow;	/* save these for future use */
    if (zdisplay != 0)
	my.WC_display = zdisplay;
    if (my.WC_window == 0 || my.WC_display == 0) {
	fprintf (stderr, "ERR: trying to open communications on NULL window");
	return False;
    }

	/* ask the window server for tags to use */
    if (my_name == NULL || *my_name == '\0') {
	my.WC_name = "ANON";
	my.WC_name_len = 5;
	my.WC_atom = NOBODY;
	my.WC_comm_type = writeonly;
	/* should look at mycomm & error if not set accordingly */
    } else {
	my.WC_name_len = strlen (my_name) + 1;
	my.WC_name = malloc (my.WC_name_len);
	strcpy (my.WC_name, my_name );
	my.WC_atom = XInternAtom (my.WC_display, my_name, always_ok);
	    /* hang our shingle out: open for business */
	XSetSelectionOwner (my.WC_display, my.WC_atom, my.WC_window, (Time) 0 );
	my.WC_comm_type = mycomm;;
    }

    /* install our own error traps; save pointers to default handlers */
    DefaultXIOErrHandler = XSetIOErrorHandler (WIOErrorHandler);  /* to debug */
    DefaultXErrHandler = XSetErrorHandler (WErrorHandler);

#ifdef old_way
    newlink = WOpenCommLink (his_name, hiscomm, handler);
	
    if (! my.WC_comm_type != writeonly)
	XFlush (my.WC_display);

    return newlink;		/* for now */
#endif
    my.WC_handler = handler;
    return True;
}


WCommLink
 WOpenCommLink (his_name, comm_type, handler)
    char *his_name;
    WCommType comm_type;
    void    (* handler)();   /* routine to handle incoming data */
{
    WCommBlock *WCBptr;	/* for tracking down lists */
    char *new_block;
    int alloc_len, name_len;

    if (his_name == NULL || *his_name == '\0') 
	return WCNoLink;

    /* check if it already exists. */
    for (WCBptr = DaGuys; WCBptr != NULL; WCBptr = WCBptr->WC_nextblock) 
	if ( 0 == strcmp (his_name, WCBptr->WC_name) )
	/* but is this really the right thing to do ? */
	    break;

    if (WCBptr == NULL) {
	name_len = strlen (his_name);
	alloc_len = sizeof(WCommBlock) + name_len + 1;
	new_block = malloc (alloc_len);
	WCBptr = (WCommBlock *) new_block;
	new_block += sizeof (WCommBlock);	/* storage for the name */
	strcpy (new_block, his_name);
	WCBptr->WC_name_len = name_len;
	WCBptr->WC_name = new_block;
	WCBptr->WC_atom = XInternAtom (my.WC_display, his_name, always_ok);
	WCBptr->WC_display = my.WC_display;
	WCBptr->WC_window = None;
	WCBptr->WC_comm_type = comm_type;
	WCBptr->WC_handler = handler;

	/* link them in with previous blocks */
	if (DaGuys == NULL) 
		DaGuys = WCBptr;
	else 
		LastGuy -> WC_nextblock = WCBptr;
	LastGuy = WCBptr;
    }
    if (WCBptr->WC_window == None)
	WReOpen (WCBptr);

    return WCBptr;
}

int	WSendMsg ( who_to, msg_type, num_handles, h_buff)
    WCommLink	who_to;		/* ignored for now */
    WMsgType	msg_type;
    int			num_handles;
    WHandle		*h_buff;
{
    char *st0, *st1, *st2;
    int	buflen, i;
    WHandle *mbufh = &mbuf.wb_handle[0];	/* for transfer loop */

    if (who_to == NULL || who_to == WCNoLink) {
	fprintf (stderr,
		 "request to send to a bad link: %d\n",
		 (long) who_to);
	invokeDebugger() ;
	return False;
    }	
    mbuf.wb_atom = my.WC_atom;
    mbuf.wb_window = my.WC_window;
    mbuf.wb_type = msg_type;
    mbuf.wb_nparams = num_handles;
    st0 = (char *) &mbuf.wb_handle[num_handles];  /* start of strings area */
    strcpy (st0, my.WC_name);	/* put app name as 1st string */
    st1 = st0 + my.WC_name_len;
    for (i=0; i< num_handles; i++, h_buff++, mbufh ++) {
#ifdef WComm_v1
	mbufh->obj = h_buff->obj;
#else
	st2 = h_buff->obj;
	if (st2 == NULL) {
	    mbufh->note = (char *) 0;
	    *st1++ = '\0';		/* redundant place holder in strings */
	} else {		/* copy in the string */
	    mbufh->obj = (char *) (st1 - st0);	/* string start is offset into buffer */
	    while ( (*st1++ = *st2++) != '\0')    /* copy & test */
			;
	}
#endif
	st2 = h_buff->note;
	if (st2 == NULL) {
	    mbufh->note = (char *) 0;
	    *st1++ = '\0';		/* redundant place holder in strings */
	} else {		/* copy in the string */
	    mbufh->note = (char *) (st1 - st0);	/* string start is offset into buffer */
	    while ( (*st1++ = *st2++) != '\0')    /* copy & test */
			;
	}
    }

    buflen = st1 - (char *) &mbuf;
    
    if (who_to->WC_window == None) 
	WReOpen (who_to);
    if (who_to->WC_window != None) {
	XChangeProperty (my.WC_display, who_to->WC_window, who_to->WC_atom,
	    XA_STRING, 8, PropModeReplace, (unsigned char *) &mbuf, buflen);
	return True;
    } else 
	return False;
}


/*------ search for a co-program atom in our blocks ----------*/
static WCommLink
 WFindLink (anAtom)
	Atom anAtom;
{
    WCommBlock *WCBptr;	/* for tracking down lists */

    if (anAtom == NOBODY)
	return WCNoLink;
    for (WCBptr = DaGuys; WCBptr != NULL; WCBptr = WCBptr->WC_nextblock) 
	if ( anAtom == WCBptr->WC_atom ) 
	    return WCBptr;
    return WCNoLink;
}


/*-------- Add a communicating co-brogram to out lists ----------*/
static void
 WRegisterComm (msg_ptr)
	struct WB_Message *msg_ptr;
{
    WCommBlock *WCBptr;	/* for tracking down lists */
    char * his_name;
    Atom his_atom;
    int  alloc_len, name_len;
    char *new_block;

#ifdef ACE
    menuRestore ("WCS annotate", mainMenu) ;
#endif

    his_name = (char *) &msg_ptr->wb_handle[0];
    his_atom = msg_ptr->wb_atom;

    /* check if it already exists. */
    WCBptr = WFindLink (his_atom);
    if (WCBptr != WCNoLink) {
	WCBptr->WC_window =  msg_ptr->wb_window;
	return;
    }

    /* ok, we don't have a block for this guy, so build one */
    name_len = strlen (his_name);
    alloc_len = sizeof(WCommBlock) + name_len + 1;
    new_block = malloc (alloc_len);
    WCBptr = (WCommBlock *) new_block;
    new_block += sizeof (WCommBlock);	/* storage for the name */
    strcpy (new_block, his_name);
    WCBptr->WC_atom = his_atom;
    WCBptr->WC_display = my.WC_display;
    WCBptr->WC_window = msg_ptr->wb_window;
    WCBptr->WC_name_len = name_len;
    WCBptr->WC_name = new_block;
    WCBptr->WC_comm_type = readwrite;

    /* link this in with previous blocks */
    if (DaGuys == NULL) 
	    DaGuys = WCBptr;
    else 
	    LastGuy -> WC_nextblock = WCBptr;
    LastGuy = WCBptr;
}

static void
 WUnRegisterComm (msg_ptr)
	struct WB_Message *msg_ptr;
{
    WCommBlock *WCBptr;	/* for tracking down lists */
    char * his_name;
    Atom his_atom;

#ifdef ACE
    menuSuppress ("WCS annotate", mainMenu) ;
#endif

    his_name = (char *) &msg_ptr->wb_handle[0];
    his_atom = msg_ptr->wb_atom;

    /* check if it already exists. */
    WCBptr = WFindLink (his_atom);
    if (WCBptr != WCNoLink) {
	WCBptr->WC_window =  None;
	return;
    }

    /* possibly should give an error message if it arrives here;
     * then again, it may be possible for a co-program to exit
     * before it is registered. So do nothing
     */
    /* NOTE: do NOT de-allocate the storage. We may have pointers
     * to it hanging around. And the co-program could start up again.
     */
}


static Bool
 WGetMsg ( myPevent, who_from, msg_type, num_handles, h_buffer)
    XPropertyEvent *myPevent;	/* redefine myevent structure */
    WCommLink	*who_from;
    WMsgType	*msg_type;
    int			*num_handles;
    WHandle		**h_buffer;
    /* return: true means msg was for wcs-comm; false is for others */
{
    Atom	ret_type;
    unsigned long	nitems, bytes_left;
    int		ret_fmt;		/* ==0 means property doesn't exist */
    struct WB_Message *msg_ptr;
    WHandle		*mhbuf;
    int		nparams, offset;

    if (myPevent-> atom != my.WC_atom) 	/* is this for wcs-comm? */
	    return False;
    if (myPevent-> state == PropertyDelete) { /* ignore deletion msgs */
	    *msg_type = MaintainLink;
	    return True;
    }
    XGetWindowProperty (my.WC_display,  my.WC_window, my.WC_atom, 0L, (long) 
	    sizeof(struct WB_Message), True, AnyPropertyType, & ret_type,
	    &ret_fmt, &nitems, &bytes_left, (unsigned char **) &msg_ptr);

    *who_from = WCNoLink;	/* for now */
    *msg_type = MaintainLink;	/* default for errors, says "ignore msg" */
    /* handle special cases first */
    if (ret_type != XA_STRING) {
#ifdef old_way
	if (ret_type == XA_WINDOW) {	/* co-process is making contact */
		comm_window = * (Window *)msg_ptr;
		/* ?? make this more robust later on */
	} else if (ret_type == 0)
#endif
	if (ret_type == 0)
		; /* may get an undocumented initial null buffer; ignore it */
	else	/* some kinda error */
		fprintf (stderr, "wrong atom type: %d\n", ret_type);
	XFree ((char *) msg_ptr);
	return True;
    }
    

    /* ok, we have a real message. Reformat & return it */
    *msg_type = msg_ptr->wb_type;
    if (*msg_type == ImHere) {		/*special case, initiate comm */
	    WRegisterComm (msg_ptr);
	    XFree((char *) msg_ptr);
	    return True;
    }
    if (*msg_type == ImLeaving) {	/*special case, end of communications */
	    WUnRegisterComm (msg_ptr); 
	    XFree((char *) msg_ptr);
	    return True;
    }
    *num_handles = nparams = msg_ptr-> wb_nparams;
    *h_buffer = mhbuf = & msg_ptr->wb_handle[0];
    offset = (int) &msg_ptr->wb_handle[nparams];	/* strings area ptr */
    /* restore the string pointers */
    for (; nparams-- > 0; mhbuf++) {
	    if (mhbuf-> note == 0)
		    mhbuf->note = NULL;		/* no string here */
	    else
		    mhbuf->note += offset;
#ifndef WCS_v1
	    if (mhbuf-> obj == 0)
		    mhbuf->obj = NULL;		/* no string here */
	    else
		    mhbuf->obj += offset;
#endif
	
    }
    *who_from = WFindLink (msg_ptr->wb_atom);
    return True;
}

void	WFree (h_buffer)
    WHandle		*h_buffer;
	/* The wcomm message was delivered by XGetProperty in dynamically
	 * appropriated space. We passed a pointer into the handles (tm)
	 * portion of this space; when the user is done with them,
	 * we can free the space.
	 * the parameter points to the first handle(tm) in the message;
	 * We need to adjust it backward to get to the actual beginning of
	 * the buffer area, which we then pass back to XFree.
	 *	-- breakable as coded. Needs to check that the buffer being
	 * freed was actually sent in by X!. 
	 * .... this is routine is probably not really necessary at the
	 * current level of message passing. 
	 */
{ 
    char * buff_ptr = (char *) h_buffer;	/* typecast formality */
    int	adjustment = (char *) &(mbuf.wb_handle[0]) - (char *) &mbuf;
    buff_ptr -= adjustment;
    XFree (buff_ptr);
}


int	WEndComm  (WCommLink who_with)		/* cleanup routine */
{
#ifdef ACE
    menuSuppress ("WCS annotate", mainMenu) ;
#endif
    /* send the co-routine a message ---- oops, next revision */
    /* let WSendMsg check for valid pointer */
    return WSendMsg (who_with, ImLeaving, 0, NULL);
};


void	WCleanup ()
{
	/* for now, nothing to clean up!! */
}

Bool
WPropMessage (xevt)
    XEvent *xevt;
{
    Bool	forwcs;		/* in case other packages use this method */
    WCommLink	whofrom;	/* for future expansion */
    WMsgType	request;		/* request type */
    int		count;			/* count of parameters */
    WHandle	*hbuf;			/* parameters */

    forwcs = WGetMsg ((XPropertyEvent *) xevt, &whofrom, &request, &count, &hbuf);
    if (forwcs) {
	/* ignore maintenance stuff, handle the rest*/
	if (request > MaintainLink)	{
	    if (whofrom != WCNoLink && whofrom->WC_handler != NULL)
		(* whofrom->WC_handler) (request, count, hbuf, whofrom);
	    else if ( my.WC_handler != NULL)
		(* my.WC_handler) (request, count, hbuf, whofrom);
	    else
		fprintf (stderr, "WComm: got an unhandleable X message\n");
	}
	WFree (hbuf);		/* clean up storage */
    } /* else --- leave property event for possible other users */
    return forwcs;
}


/*------ temp routine to send a handle back to an external co-program */

int  W_show_external_reference ( whoto, ext_obj, name)
    WCommLink  whoto;
#ifdef WComm_v1
    int ext_obj;
#else
    char *ext_obj;
#endif
    char *name;
{
    WHandle	t_handle;
    int got_comm;

    t_handle.obj = ext_obj;
    t_handle.note = name;
    
    /* should use the "whoto" to determine who to communicate with */
    got_comm = WSendMsg (whoto, ShowObject, 1, &t_handle);
    if (!got_comm) 
	    fprintf (stderr, "Can't communicate with external program. \n");
    return got_comm;
}


#endif  /* WCS */
