/*  Last edited: Nov 28 15:40 1991 (mieg) */
#include "regular.h"
#include "graph.h"

/***************************************************************/

void squeal (void)
{ printf ("Ahh! I die!!!!!!!!!\n") ; }

void point (double x, double y)
{ graphPoint (x,y) ; graphRedraw () ;}

void where (double x, double y)
{ printf ("spaced out at %f %f\n",x,y) ; }

static float oldx,oldy ;

void start (double x, double y)
{ graphXorLine (0.5,0.5,x,y) ; oldx = x ; oldy = y ; }

void stop (double x, double y)
{ graphXorLine (0.5,0.5,oldx,oldy) ; }

void drag (double x, double y)
{ stop (x,y) ; start (x,y) ;}

static FREEOPT options[] = { 4,"Options",
			     'd',"Quit",
			     'f',"Finish",
			     'p',"Pop",
			     't',"Retitle",
			   } ;
static char countchar = 0;
static Graph blockGraph ;
void keyboard (KEY k)
{
  static char prompt[128] = "Initial test prompt" ;

  switch (k)
    { 
    case 'a':
      printf("simulating a RIGHT_DOWN\n");
      graphEvent(RIGHT_DOWN, 0.0, 0.0);
      break;
    case 'b': graphColor (BLUE) ; break ;
    case 'd': graphDestroy() ; break ;
    case 't': graphRetitle("Brand new title") ; break ;
    case 's':
      printf ("I will simulate an 'e'\n") ; 
      graphEvent ('e',0.,0.) ; 
      break ;
    case 'f':
      graphFinish() ;
      break; 
    case 'r': graphColor (RED) ; break ;
    case 'p': graphPop () ; break ;
    case '0': case '1': case '2': case '3': case '4': 
      graphGoto (k-'0',0) ; 
      break ;
    case 'm': graphMessage ("Testing the message system") ;
    case 'u': graphUnMessage () ; break ;
    case 'o': graphOut (messprintf ("%s%s%s",
	       "Here is a fairly long test message to see how ",
	       "the mechanism works.  Can it do better than on ",
	       "the Sun?")) ; break ;
    case 'q': 
      if (graphQuery (prompt))
	printf ("got TRUE\n") ;
      else
	printf ("got FALSE\n") ;
      break ;
    case 'x':
      if (graphPrompt ("New prompt for query:",prompt,"t"))
	strcpy (prompt,freeword()) ;
      break ;
    case 'y':
      if (graphSelect (&k, options))
	printf ("selected option with key '%c'\n",k) ;
      break ;
    case 'z': /* test all ascii events */
      {
	printf("simulating an %c\n", (char)countchar);
	graphEvent(countchar++, 0.0, 0.0) ;
	break ;
      }
    case 'k':
      if (blockGraph)
	printf ("Answer from blocked graph was %d\n",graphBlock()) ;
      break ;
    case '8': case '9':
      graphUnBlock (k) ;
      break ;
	
    default:
      printf ("Got a key press %d = '%c'\n",k,k) ;
    }
}

void main (int argc, char **argv)
{
  Graph g1, g2, g3, g4 ;

  graphInit (&argc, argv) ;

  g1 = graphCreate (PLAIN,"plain",0,0,0.4,0.3) ;
  graphPointsize (0.05) ;
  graphRegister (LEFT_DOWN,(GraphFunc) where) ;
  graphRegister (KEYBOARD, (GraphFunc)keyboard) ;
  graphRegister (MIDDLE_DOWN, (GraphFunc)start) ;
  graphRegister (MIDDLE_DRAG, (GraphFunc)drag) ;
  graphRegister (MIDDLE_UP, (GraphFunc)stop) ;
  graphText ("Are the circles round?",0.3,0.7) ;
  graphColor (DARKBLUE) ;
  graphCircle (0.5,0.5,0.1) ;
  graphRedraw () ;

  g2 = graphCreate (TEXT_FIT,"text_fit",0,0,0,0) ;
  graphRegister (DESTROY,(GraphFunc) squeal) ;
  graphRegister (KEYBOARD,(GraphFunc) keyboard) ;
  graphRegister (LEFT_DOWN, (GraphFunc)where) ;

  g3 = graphCreate (TEXT_SCROLL,"text_scroll",0,0,0,0) ;
  graphTextBounds (80,25) ;
  graphRegister (KEYBOARD, (GraphFunc)keyboard) ;
  graphRegister (LEFT_DOWN,(GraphFunc) where) ;
  graphButton ("Squeal", squeal, 1, 1) ;

  g4 = graphCreate (MAP_SCROLL,"map_scroll",0,0,0,0) ;
  graphMapBounds (0.0,0.0,5.0,1.0,1.0) ;
  graphRegister (KEYBOARD,(GraphFunc) keyboard) ;
  graphPointsize (0.05) ;
  graphRegister (MIDDLE_DOWN,(GraphFunc) point) ;
  graphRegister (LEFT_DOWN,(GraphFunc) where) ;
  graphFreeMenu (keyboard, options) ;

  graphStart (g1) ;

  graphFinish () ;
}

