/*  File: timesubs.c
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: functions to time events, get date etc.
 		definitions in regular.h - uses opaque type Timer
 * Exported functions: timeStart, timeDestroy, timeSys, timeUser, 
            timeText, timestamp, dateStamp.
 * HISTORY:
 * Last edited: Mar  4 01:58 1992 (rd)
 * * Jan 20 10:46 1992 (mieg): Fixed  timeStamp, dateStamp
    and removed everything else with an ifdef
 * Created: a long time ago
 *-------------------------------------------------------------------
 */

#include "regular.h"
#include "mytime.h"
#include <time.h>
/* UNIX timer */
mytime_t        time  (mytime_t *timer);

#ifndef __convex__
mysize_t strftime(char *buf, mysize_t bufsize, const char *fmt,const  struct tm *tm) ;
#endif

/**********************************************/
  /* Returns  21:07:42, for 9 pm, 7min, 42sec */
char* timeStamp (void)
{ static char buf[32] ;
  mytime_t sec ;
  struct tm tm ;
  time(&sec) ;

  tm = *localtime(&sec) ;
    strftime(buf,32, "%H:%M:%S", localtime(&sec)) ;

  return buf ;
}

/**********************************************/
  /* Returns mon_20_may_1988 */
char* dateStamp (void)
{
  static char buf[32] ;
  mytime_t sec ;
  struct tm tm ;
  time(&sec) ;

 tm = *localtime(&sec) ;
 strftime(buf,32, "%a_%d_%b_%Y", localtime(&sec)) ;

/*  strftime(buf,32, "%a_%d_%b_%Y",*localtime(&sec)) ; */
  return buf ;
}

/**********************************/
/**********************************/

#ifdef Old_Stuff_from_Richard_not_used_in_acedb

#include <sys/time.h>
#include <sys/resource.h>
 
#ifndef NEXT
extern void getrusage (int, struct rusage *p) ;
#endif
 
/* subroutines to return info about system and real time */
 
#define MAXBUF 20
typedef struct rusage *Timer_ ;
static struct rusage current[1] ;
 
/**********************************************/
 
static double MICRO = 1.0e-6 ;
 
static double convert (struct timeval *tval) /* conversion to seconds */
{
  return (double) (tval->tv_sec + MICRO*tval->tv_usec) ;
}
 
/********************************************/
 
Timer timeStart (void)
{

  Timer_ p = (Timer_) calloc (1,sizeof (struct rusage)) ;
  if (!p)
    messcrash ("calloc failure in timeStart") ;
 
  getrusage (RUSAGE_SELF,p) ;
  return (Timer)p ;
 }
 
/**********************************************/
 
double timeSys (Timer tp)
{
  Timer_ p = (Timer_) tp ;
 
  getrusage (RUSAGE_SELF,current) ;
  if (p)
    return (convert (&current->ru_stime) - convert (&p->ru_stime)) ;
  else
    return convert (&current->ru_stime) ;
 }
 
/**********************************************/
 
double timeUser (Timer tp)
{
  Timer_ p = (Timer_) tp ;
 
  getrusage (RUSAGE_SELF,current) ;
  if (p)
    return (convert (&current->ru_utime) - convert (&p->ru_utime)) ;
  else
    return convert (&current->ru_utime) ;
 }
 
/**********************************************/
 
void timeDestroy (Timer tp)
{
  free ((Timer_)tp) ;
}
 
/**********************************************/
 
char* timeText (Timer tp)
{
static char buf[50] ;
  sprintf (buf,"%.2f s. user, %.2f s. system",timeUser(tp),timeSys(tp)) ;
  timeDestroy (tp) ;
  return buf ;
}
 
/**********************************************/
/**********************************************/

#endif
