

      /***************************************************************/
      /***************************************************************/
      /**  File randsubs.c :                                        **/
      /**  Random number generator                                  **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified   1/8/91   by RMD.         */
      /*                                                             */
      /***************************************************************/


static int xrand = 18721 ;
static int yrand = 37264 ;    /* original value 67571 */
static int zrand = 28737 ;

/*******************************/

double randfloat (void)

 {double x ;

  xrand = 171*xrand % 30269;
  yrand = 172*yrand % 30307;
  zrand = 170*zrand % 30323;
  x = xrand/30269.0 + yrand/30307.0 + zrand/30323.0;
  return (x-(int)x);
 }

/*******************************/

int randint (void)

 {xrand = 171*xrand % 30269;
  yrand = 172*yrand % 30307;
  zrand = 170*zrand % 30323;
  return (zrand) ;
 }

/*******************************/

double randgauss (void)

 {double sum ;
static double fac = 3.0/90899.0 ;

  xrand = 171*xrand % 30269;
  yrand = 172*yrand % 30307;
  zrand = 170*zrand % 30323;
  sum = xrand + yrand + zrand ;
  xrand = 171*xrand % 30269;
  yrand = 172*yrand % 30307;
  zrand = 170*zrand % 30323;
  sum += xrand + yrand + zrand ;
  xrand = 171*xrand % 30269;
  yrand = 172*yrand % 30307;
  zrand = 170*zrand % 30323;
  sum += xrand + yrand + zrand ;
  xrand = 171*xrand % 30269;
  yrand = 172*yrand % 30307;
  zrand = 170*zrand % 30323;
  sum += xrand + yrand + zrand ;
  return (sum*fac - 6.0) ;
 }

/*******************************/

void randsave (int *arr)

 {arr[0] = xrand ;
  arr[1] = yrand ;
  arr[2] = zrand ;
 }

/*********************************/

void randrestore (int *arr)

 {xrand = arr[0] ;
  yrand = arr[1] ;
  zrand = arr[2] ;
 }
