/*  Last edited: Jan 20 12:02 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File messubs.c :                                         **/
      /**  General messages display                                 **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified   6/2/91  by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "regular.h"
#include "mytime.h"
#ifdef MESSCLEAN
  void graphOut (char* text) { fprintf (stderr,"!! %s\n",text) ; }
#else
  #include "graph.h"	/* for graphOut() */
#endif

#include <stdarg.h> 
#ifndef THINK_C
  int vfprintf (FILE *stream, const char *format, va_list arglist);
  int vfscanf  (FILE *stream, const char *format, va_list arglist);
  int vprintf  (const char *format, va_list arglist);
  int vscanf   (const char *format, va_list arglist);
  int vsprintf (char *buffer, const char *format, va_list arglist);
  int vsscanf  (const char *buffer, const char *format,
                          va_list arglist);
#endif

#define MXDFN 128

char *messcrashbuf = 0 ;          /* program initialisation can malloc this */

static int isdump = FALSE ;
static FILE *dumpfil ;
#define BUFSIZE 4096
static char messbuf[BUFSIZE] ;
static VoidRoutine cleanup = 0 ;
static char dump_file_name[MXDFN] = "" ;

/*******************************/

void messbeep (void)
{
#ifdef THINK_C
  SysBeep (1) ;
#else
  printf ("%c",0x07) ;  /* bell character, I hope */
#endif
}

/*******************************/

void messout (char *format,...)
        /* does a printf, beeps bell, and writes to dumpfil if open */
{ va_list args ;

  va_start (args,format) ;
    vsprintf (messbuf,format,args) ;
  va_end (args) ;

#ifdef MESSCLEAN
  fprintf (stderr,"!! %s\n",messbuf) ;
#else
  graphOut (messbuf) ;
#endif

  messbeep () ;
  if (isdump)
    messdump (" messout : %s\n",messbuf) ;
}

/*****************************/

void messdumpset  (char *cp)
{
  if (strlen(cp) >= MXDFN)
    messcrash("messdumpset called with to long a name:  %s",cp) ;
  strcpy (dump_file_name,cp) ;
}

/*****************************/

void messdump (char *format,...)
        /* write to dumpfil (opens if need be) */
{ va_list args ;

  if (!isdump)
    { if (! *dump_file_name)
	strcpy (dump_file_name,"logbook") ;
      
#ifdef MESSCLEAN
      if (! (dumpfil = fopen (dump_file_name,"a")))
#else
      if (! (dumpfil = filopen (dump_file_name,"wrm","a")))
#endif
	messcrash ("Can't open dump file") ;
   
      fprintf (dumpfil,"\n%s %s\n",timeStamp(), dateStamp()) ;
      isdump = TRUE ;
    }
  
  va_start (args,format) ;
  vfprintf (dumpfil,format,args) ;
  va_end (args) ;
}

/*****************************/

/* put "break invokeDebugger" in your favourite debugger init file */

void invokeDebugger(void){}

/*****************************************/

void messerror (char *format,...)
                /* my version of perror() - accepts format + argument list */
{ va_list args ;
  char *messbuf2 = &messbuf[BUFSIZE/2];
  static int total = 50 ;
  extern int errno ;
#ifndef THINK_C
  extern char *sys_errlist[] ;
  extern int sys_nerr ;
#endif

  va_start (args,format) ;
    vsprintf (messbuf2,format,args) ;
  va_end (args) ;
  if (errno <= 0)
    messout ("internal system error : %s",messbuf2) ;
#ifndef THINK_C
  else if (errno < sys_nerr)
    messout ("%s : %s",messbuf2,sys_errlist[errno]) ;
#endif
  else
    messout ("%s : system error %d",messbuf2,errno) ;

  invokeDebugger() ;
  errno = 0 ;
    /* stops looping in parse bad tags */
  if (!total--)
    messcrash("Too many minor errors, sorry, see the log file") ;
}

/*******************************/

VoidRoutine crashroutine (VoidRoutine new)

 {VoidRoutine old = cleanup ;
  cleanup = new ;
  return old ;
 }

/*****************************/

void messcrash (char *format,...)
     /* does a printf, beeps bell, and exits */
{ va_list args ;

#ifdef THINK_C
  extern void crashOut (char* text) ;

  va_start (args,format) ;
    vsprintf (messbuf,format,args) ;
  va_end (args) ;
  crashOut (messbuf) ;
#else
  extern int errno ;
  extern char *sys_errlist[] ;
  extern int sys_nerr ;

  if (errno <= 0 || errno >= sys_nerr)
    fprintf (stderr,"!! FATAL ERROR %d: ", errno) ;
  else
    fprintf (stderr,"!! FATAL ERROR: system error %d %s \n",errno,sys_errlist[errno]) ;

  va_start (args,format) ;
    vfprintf (stderr,format,args) ;
  va_end (args) ;
  fprintf (stderr,"\n") ;
  messbeep () ;
#endif

  if (messcrashbuf)
    free (messcrashbuf) ;     /* frees up space that might be useful */
  messcrashbuf=0;
  
  if (isdump)
    fflush(dumpfil) ;
  
  invokeDebugger() ;

  if (cleanup)   /* Possibly  cleanup can crashregister something else */
    { VoidRoutine vr = cleanup ;
      cleanup = 0 ;              /* avoids recursion */
      (*vr)() ;        /* call user registered cleanup routine */
    }

  exit (1) ;
 }

/*****************************/

char *messprintf (char *format, ...)	/* beware finite buffer size */

 {va_list args ;

  va_start (args,format) ;
    vsprintf (messbuf,format,args) ;
  va_end (args) ;

  if (messbuf[BUFSIZE-1])
    messcrash ("messprintf buffer size exceeded - length is %d",
	       strlen (messbuf)) ;

  return messbuf ;
 }

/****************************/

char *messalloc (int size)
{
  char *cp = (char*) malloc ((mysize_t)size) ;
  if (!cp)
    messcrash ("malloc failure in messalloc (%d)",size) ;
  memset(cp,0,(mysize_t)size) ;
  return cp ;
}

/**** end of file ****/
