/*  Last edited: Feb 10 23:47 1992 (mieg) */



      /***************************************************************/
      /***************************************************************/
      /**  File w1/keyset.c                                         **/
      /**  Routines dealing with KEYSET's                           **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  3 routines is  public :  keySetAND keySetOR keySetOrder    */
      /*    In addition keyset.h defines as macros                   */
      /*    keySetInsert/Remove, Create/Destroy , Max, Sort, Find    */
      /*    consider also w7/ksetdisp.c                              */
      /*                                                             */
      /*  A KEYSET is an orderd Array of KEYs                        */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  22/10/90  by JTM.         */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "keyset.h"

#define KEYSIZE sizeof(KEY)

/**************************************************************/
      /* Pure chronologic order */

int keySetOrder(void *a,void *b)
{
  return
    (*(KEY*)a) - (*(KEY*)b) ;
}

/**************************************************************/
  /* This routine returns */
  /* the intersect (logical AND) of the first and second KEYSET */

KEYSET keySetAND(KEYSET x, KEYSET y)
{ 
  register int i = 0 , j = 0, k= 0 ;
  KEYSET z = keySetCreate();

  if(!x || !y )
    return z ;
  
  if ((x && x->size != KEYSIZE) || (y && y->size != KEYSIZE))
     messcrash ("keySetOR called on non KEY Array") ;

  while((i<keySetMax(x)) && (j<keySetMax(y)))
    { 
                      /*success, skip further in the 3 index */
      if(arr(x,i,KEY) == arr(y,j,KEY))
	{ array(z,k++,KEY) = arr(x,i++,KEY) ; 
	  j++ ;
	}
      else      /*recall that every index is in increasing order*/
	(keySetOrder(arrp(x,i,KEY),arrp(y,j,KEY)) < 0) ?  i++ : j++ ;
    }
 return z ;
}

/**************************************************************/
  /* This routine returns */
  /* the union (logical OR) of the first and second KEYSET */

KEYSET keySetOR(KEYSET x, KEYSET y)
{ 
  register int i = 0 , j = 0, k= 0 ;
  KEYSET z = keySetCreate();

  if(!x && !y )
    return z ;
  
  if ((x && x->size != KEYSIZE) || (y && y->size != KEYSIZE))
     messcrash ("keySetOR called on non KEY Array") ;

  if(!x)
    { keySetDestroy(z);
      z = arrayCopy(y) ;
      return z ;
    }

  if(!y)
    { keySetDestroy(z);
      z = arrayCopy(x) ;
      return z ;
    }


  while((i<keySetMax(x)) && (j<keySetMax(y)))
    { 
                      /*no doubles, skip further in the 3 index */
      if(arr(x,i,KEY) == arr(y,j,KEY))
	{ array(z,k++,KEY) = arr(x,i++,KEY) ; 
	  j++ ;
	}
      else      /*recall that every index is in increasing order*/
	if (keySetOrder(arrp(x,i,KEY),arrp(y,j,KEY)) < 0) 
	  array(z,k++,KEY) =  arr(x,i++,KEY) ;
	else
	  array(z,k++,KEY) =  arr(y,j++,KEY) ;
    }

 if(i == keySetMax(x))
   while(j<keySetMax(y))
     array(z,k++,KEY) =  arr(y,j++,KEY) ;
 else if(j == keySetMax(y))
   while(i<keySetMax(x))
     array(z,k++,KEY) =  arr(x,i++,KEY) ;
 
 return z ;
}

/**************************************************************/
  /* This routine returns */
  /* the exclusive union (logical XOR) of the first and second KEYSET */

KEYSET keySetXOR(KEYSET x, KEYSET y)
{ 
  register int i = 0 , j = 0, k= 0 ;
  KEYSET z = keySetCreate();


  if(!x && !y )
    return z ;
  
  if ((x && x->size != KEYSIZE) || (y && y->size != KEYSIZE))
     messcrash ("keySetXOR called on non KEY Array") ;

  if(!x)
    { keySetDestroy(z);
      z = arrayCopy(y) ;
      return z ;
    }

  if(!y)
    { keySetDestroy(z);
      z = arrayCopy(x) ;
      return z ;
    }

  while((i<keySetMax(x)) && (j<keySetMax(y)))
    { 
                /*discard the intersect */
      if(arr(x,i,KEY) == arr(y,j,KEY))
	{ i++; j++ ;
	}
	
      else      /*recall that every index is in increasing order*/
	{ 
	  if (keySetOrder(arrp(x,i,KEY),arrp(y,j,KEY)) < 0)
	    array(z,k++,KEY) =  arr(x,i++,KEY) ;
	  else
	    array(z,k++,KEY) =  arr(y,j++,KEY) ;
	}
    }

 if(i == keySetMax(x))
   while(j<keySetMax(y))
     array(z,k++,KEY) =  arr(y,j++,KEY) ;
 else if(j == keySetMax(y))
   while(i<keySetMax(x))
     array(z,k++,KEY) =  arr(x,i++,KEY) ;

 return z ;
}

/**************************************************************/
/**************************************************************/







