/*  File: filsubs.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
   file opening routines - Unix version
 * Exported functions:
 * HISTORY:
 * Last edited: Apr  2 18:35 1992 (mieg)
 * * Jan 11 01:59 1992 (mieg): If file has no ending i suppress the point
 * * Nov 29 19:15 1991 (mieg): If file had no endding, we were losing the
                               last character in dirDraw()
 * Created: Fri Nov 29 19:15:34 1991 (mieg)
 *-------------------------------------------------------------------
 */

#include "regular.h"
#include "array.h"
#include "graph.h"
#include <sys/types.h>
#include "mydirent.h"	/* drawDir directory operations */
 
static char fullname[128] = "./" ;
static char *partname = &fullname[2] ;
static char olddir[128] ;
 
/******************************/
 
char *filsetdir (char *s)       /* returns old name - sets if s != 0 */
 
{
  *partname = 0 ;
  strcpy (olddir,fullname) ;
 
  if (s)
   {strcpy (fullname,s) ;
    strcat (fullname,"/") ;
    partname = &fullname[strlen(fullname)] ;
   }
  olddir[strlen(olddir)-1] = 0 ;
  return olddir ;
 }
 
/*******************************/
 
FILE *filopen (char *name, char *ending, char *spec)
 
 {FILE *result ;
 
  if(!name || !ending || !spec)
    messcrash("filopen received a nul parameter") ;

  strcpy (partname,name) ;
  if(*ending)
    strcat (partname,".") ;
  strcat (partname,ending) ;
/*
  if (result = fopen (partname,spec))
    return result ;
  else
*/
   if (result = fopen (fullname,spec),result)
    return result ;
  else
   {messerror ("Failed to open %s",fullname) ;
    return (FILE *)0 ;
   }
 }
 
/*******************************/

FILE *filopent (char *name, int t, char *ending, char *spec)
{ 
  return filopen (messprintf ("%s%d",name,t),ending,spec) ;
}

/*********************************************************/
/****** package to handle file selection a la Mac *******/

static char  *dirName, *fileName, *endName ;
static Array dirMarks ;
static Stack dirStack ;
static int   oldPick = 0 ;
static int   dirBox, fileBox ;
static Graph filGraph, filFromGraph ;

static void dirCancel () { graphUnBlock (FALSE) ; }

static void dirSelect (char *name) { graphUnBlock (TRUE) ; }

static void dirDraw (void)
{
  DIR	*dirp ;
  MYDIRENT *dent ;
  int	endLen = strlen(endName) ;
  char*	d_name, *cp ;
  int	d_len, nentries, ibox, i ;

  if (!(dirp = opendir (dirName)))
    { messout ("Sorry - %s is not a valid directory",dirName) ;
      return ;
    }

  graphActivate (filGraph) ;
  graphClear () ;

  if (!*dirName)
   strcpy (dirName,".") ;
  graphText ("Directory:",1,1) ;	
  dirBox = graphTextEntry (dirName, 79, 11, 1, dirDraw) ;
  	/* note that self is the callback function!
	   OK since graphClear destroys the entry
	*/

  graphText ("File:",1,3) ; /* 2nd so it is active */
  fileBox = graphTextEntry (fileName, 23, 6, 3,(GraphFunc)dirSelect) ;

  graphButton ("CANCEL", dirCancel, 35, 3) ;

  graphText ("Select from: ",1,5) ;

  nentries = arrayMax(dirMarks) = 0 ;
  stackClear(dirStack) ;
  push (dirStack, 0, int) ;	/* so mark != 0 */
  oldPick = 0 ;
  while (dent = readdir (dirp))
    { d_name = dent->d_name ; 
      d_len = strlen (d_name) ;
      if (!endLen || (d_len > endLen  &&  
		      d_name[d_len-endLen-1] == '.'  &&
		      !strcmp (&d_name[d_len-endLen],endName)))
	{ ibox = graphBoxStart () ;
	  i = array(dirMarks,ibox,int) = stackMark(dirStack) ;
	  pushText(dirStack,d_name) ;
	  cp = stackText(dirStack,i) ;
	  if(*(cp + d_len - endLen - 1) == '.')
	    *(cp + d_len - endLen - 1) = 0 ;
	  graphText (cp,14,6+nentries) ;
	  graphBoxEnd () ;
	  if (!strncmp (fileName, d_name, d_len-endLen-1))
	    { oldPick = ibox ;
	      graphBoxDraw (ibox, WHITE, BLACK) ;
	    }
	  ++nentries ;
	}
    }
  
  closedir (dirp) ;

  if (!nentries)
    graphText (
      messprintf ("%s contains no %s files",dirName,endName), 
	       10,7) ;

/*  graphTextBounds (60,8+nentries) ; */
  graphRedraw () ;
}

static void dirPick (int k)
{
  if (!k)
    return ;
  if (k == oldPick)
    { strcpy (fileName,stackText(dirStack,arr(dirMarks,k,int))) ;
      graphUnBlock (TRUE) ;
    }
  else
    { if (oldPick)
	graphBoxDraw (oldPick, BLACK, WHITE) ;
      oldPick = 0 ;
      if (k == dirBox)
	graphTextEntry (dirName, 47, 11, 1, dirDraw) ;
      else if (k == fileBox)
	graphTextEntry (fileName, 23, 6, 3, (GraphFunc)dirSelect) ;
      else if (k < arrayMax(dirMarks) && arr(dirMarks,k,int))
	{ graphBoxDraw (k, WHITE, BLACK) ;
	  oldPick = k ;
	}
    }
}

/******************/

/* Remove unpleasant characters from file names */

static void cleanName(char *name)
{ 
  char *cp = name ;

  while (*cp)
    { if ((*cp < 'a' || *cp > 'z') && 
	  (*cp < 'A' || *cp > 'Z') &&
	  (*cp < '0' || *cp > '9') &&
	  *cp != '-' &&
	  *cp != '.' && *cp != '_')
	*cp = '_' ;
      cp++ ;
    }
}

#include "display.h"

FILE *filqueryopen (char *dname, char *fname, char *end, char *spec)
     /* uses the graph package to provide directory prompts */
     /* beware that dirName should be 80 long and filName 24 long */
{
  static BOOL isInside = FALSE ;
  FILE*	fil = 0 ;
  
  if (isInside)
    return 0 ;
  isInside = TRUE ;

  dirName = dname ;		/* set statics */
  fileName = fname ;
  endName = end ;

  if (!opendir (dirName) && 
      !(strcpy (dirName,"."), opendir (dirName)) &&
      !(strcpy (dirName,"/"), opendir (dirName)))
    { messout ("Sorry - I can not open a directory") ;
      return 0 ;
    }

  if (!dirStack)
    { dirStack = stackCreate(100) ;
      dirMarks = arrayCreate(10,int) ;
    }

  filFromGraph = graphActive() ;
  filGraph = displayCreate(DtFile_Chooser) ;
  graphRegister (PICK,(GraphFunc) dirPick) ;
  dirDraw () ;

  while (graphBlock())
    { stackClear (dirStack) ;
      catText (dirStack,dirName) ;
      catText (dirStack, "/") ;
      cleanName (fileName) ;
      catText (dirStack, fileName) ;
      catText (dirStack, ".") ;
      catText (dirStack, endName) ;
      if (spec[0] == 'w' && 
	  (fil = fopen (stackText(dirStack,0), "r")))
	{ fclose (fil) ; 
	  fil = 0 ;
	  if (graphQuery (messprintf ("Overwrite %s?",
				      stackText(dirStack,0))))
	    if (fil = fopen (stackText(dirStack,0), spec))
	      break ;
	    else
	      messout ("Sorry, can't open file %s for writing",
		       stackText (dirStack,0)) ;
	}
      else if (fil = fopen (stackText(dirStack,0), spec))
	break ;
      else
	messout ("Sorry, can't open file %s",
		 stackText(dirStack,0)) ;
      dirDraw () ;
    }
  
  graphDestroy () ;
  
  isInside = FALSE ;
  graphActivate (filFromGraph) ;
  return fil ;
}

/*************** end of file ****************/
