/*  Last edited: Nov 18 16:00 1991 (rd) */
/* filsubs.c

   file opening routines - Unix version

   Richard Durbin and Jean Thierry-Mieg, 1991.
*/

#include "regular.h"
#include "array.h"
#include "graph.h"
#include <sys/types.h>
#include <mydirent.h>	/* drawDir directory operations */
 
static char fullname[128] = "./" ;
static char *partname = &fullname[2] ;
static char olddir[128] ;
 
/******************************/
 
char *filsetdir (char *s)       /* returns old name - sets if s != 0 */
 
{
  *partname = 0 ;
  strcpy (olddir,fullname) ;
 
  if (s)
   {strcpy (fullname,s) ;
    strcat (fullname,"/") ;
    partname = &fullname[strlen(fullname)] ;
   }
  olddir[strlen(olddir)-1] = 0 ;
  return olddir ;
 }
 
/*******************************/
 
FILE *filopen (char *name, char *ending, char *spec)
 
 {FILE *result ;
 
  strcpy (partname,name) ;
  strcat (partname,".") ;
  strcat (partname,ending) ;
/*
  if (result = fopen (partname,spec))
    return result ;
  else
*/
   if (result = fopen (fullname,spec),result)
    return result ;
  else
   {messerror ("Failed to open %s",fullname) ;
    return (FILE *)0 ;
   }
 }
 
/*******************************/

FILE *filopent (char *name, int t, char *ending, char *spec)
{ 
  return filopen (messprintf ("%s%d",name,t),ending,spec) ;
}

/*************** end of file ****************/
