/****************************************************************************
*
* Name        : server1.c  of X Interprocess Communication(IPC) Benchmark
*
*
* Description : This is the synchronizing client program for local clients.
*               It is forked and execed by mlocal_clients.c.
*               It makes sure that all 
*               local clients are synchronized. It also synchronizes local clients
*               with remote clients using shared files and the synchronizing client.
*               It waits for a message from synchronizing client before it starts
*               of all local clients. Thus local clients have a phase lag with the
*               remote clients. To start of local clients it polls an integer within
*               a shared file. When the integer equals value of total number of clients
*               + one, and the local synchronizing client receives message from 
*               synchronizing client for remote clients then all local clients are
*               started off.
*
* Written by  : Dhruve Shah
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/time.h>
#include "defines.h"

#define SERV_TCP_PORT   3078
#define ITERLIMIT1 100 /* Iteration limit for server */



void sync_using_files(); /* Function to synchronize clients */


main(argc,argv)
int argc;
char **argv;
{
  int syn_sock,  newsynsock; /* sockets for communications */
  struct sockaddr_in   host_addr;
  char temp_buf[100];
 
/* Check if you have right number of arguments */

  if(argc != 2)
    {
      printf("Usage: server1 num_clients\n");
      exit(-1);
    }
#ifdef DEBUG
  printf("Number of clients is %d\n",atoi(argv[1]));
#endif DEBUG

/* Initialize sockets with remote server address. Make socket, bind and listen on it */

  syn_sock = initialize_syn_server(&host_addr);


/* Perform accept */

  newsynsock = accept_data(syn_sock);

/* Receive string to know that all remote clients have started */

  receive_data(newsynsock,temp_buf,100);

#ifdef DEBUG
  printf("temp buf = %s\n",temp_buf);
#endif DEBUG

/* Synchronize clients */

  sync_using_files(argv);
  printf("\nSynchronizing local client found value equal to number of clients\n\n");

/* Close sockets */

    close(newsynsock);
  close(syn_sock);

}

/***********************************************************************
 * Synchronize clients using files. Increment integer in shared file   *
 * Poll file till integer value equals total number of clients + 1     *
 ***********************************************************************/

void sync_using_files(argv)
char **argv;
{

 char lockname[MAXNAME], sema_lock[MAXNAME];
  int ret, sema_ret, value,syn_flag,iteration_count;
  FILE *rd_lock;


  sprintf(lockname,"file_lock");
  strcat(lockname, "_#w");
  sprintf(sema_lock,"file_lock");
  strcat(sema_lock, "_#s");
  strcat(lockname, "_#r");






  rd_lock = fopen(lockname,"r");
  if(rd_lock == NULL)
    {
      rd_lock = fopen(lockname, "w+");
      value = 1;
      fprintf(rd_lock, "%d",value);
      fclose(rd_lock);
    }
  else
    {
      fclose(rd_lock);
      sema_ret = -1;
      while(sema_ret == -1)
	{
	  sema_ret = open(sema_lock, O_CREAT | O_EXCL);
#ifdef DEBUG
	  if(ret < 0)
	    printf("Blocked by spinlocks..... read/write\n");
#endif DEBUG
	}
      close(sema_ret);

      rd_lock = fopen(lockname, "r+");
      if (rd_lock == NULL)
	printf("********* ERROR IN READ LOCK ********\n");
      fscanf(rd_lock,"%d",&value);
      value++;
      rewind(rd_lock);
      fprintf(rd_lock,"%d",value);
#ifdef DEBUG
      printf("value = %d\n",value);
#endif DEBUG
      rewind(rd_lock);
      fclose(rd_lock);
      unlink(sema_lock);
    }

  iteration_count = 0;
  syn_flag = FALSE;
  while(syn_flag == FALSE)
    {
      rd_lock = fopen(lockname, "r");
      if (rd_lock == NULL)
	printf("********* ERROR IN READ LOCK ********\n");
      fscanf(rd_lock,"%d",&value);
      rewind(rd_lock);
#ifdef DEBUG
      printf("value in syn loop = %d\n",value);
#endif DEBUG
      if(value == (atoi(argv[1]) + 1))
	syn_flag = TRUE;
      fclose(rd_lock);
      iteration_count++;
      if(iteration_count >= ITERLIMIT1)
	syn_flag = TRUE;

    }

}

initialize_syn_server(host_addr)
struct sockaddr_in *host_addr;
{

  char host[BUFSIZE];
  int sock, t;

  gethostname(host,MAXNAME);
  mk_syn_sock(host_addr, host);
  sock = create_socket();
  t = bind_sock(sock,host_addr);
  listen(sock,5);
  return(sock);

}


accept_data(sock)
int sock;
{

  struct sockaddr_in from;
  int g, len = sizeof(from);


  g = accept(sock, &from, &len);
  if(g < 0)
    {
      perror("accept");
      exit(1);
    }
  return(g);

} 

