/****************************************************************************
*
* Name        : Server.c  of X Interprocess Communication(IPC) Benchmark
*
*
* Description : This is the main Server program which forks children to provide
*               transaction service to various clients (local or remote). The 
*               X server is an implementation of a concurrent server. That is
*               the server forks of independant concurent child for each client.
*         
*               
*               
*
* Written by  : Dhruve Shah
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/time.h>
#include "defines.h"

#define SERV_TCP_PORT   3278


void server_do_transaction(); /* Function to perform transaction service for clients */
void child_quiet_exit(); /* Invoked on SIGCHLD by parent to make sure children 
                            exiting are updated in process table */

void cleanup(); /* On ^c unlink the shared file and exit */

/* Structure used to store timing information */

    struct my_timeval
    {
      long tv_sec;
      long tv_usec;
      long sys_tv_sec;
      long sys_tv_usec;
      long user_tv_sec;
      long user_tv_usec;
    };


main(argc,argv)
int argc;
char *argv;
{
  int sockfd,  newsockfd,  childpid ; 
  int first_flag; /* Flag used for noting the first entry */
  extern int errno; /* perror */
  struct sockaddr_in  host_addr; 
  FILE *fp;
  char temp_buf[100];

/* Other timing related data structures */

  struct my_timeval serv_start_time,serv_stop_time,tserv_start_time,tserv_stop_time;
  int server_time,tserver_time;
  unsigned  long start_time,stop_time;

 /* ignore death of children */

  signal(SIGCHLD,child_quiet_exit);  

  signal(SIGINT,cleanup); /* On ^c unlink shared file and exit */

/* Fill sockaddr_in with remote server address information. Make the socket, and 
   connect the socket */

  sockfd = initialize_server(&host_addr);

  first_flag = FALSE;


  for( ; ; )
    {
  again:
      newsockfd = accept_data(sockfd); /* Make a new socket descriptor using accept */

/* Keep track whether its the first time to start the timer */

      if((!first_flag))
	{
	  timer_start_stop(&tserv_start_time);
	  first_flag = TRUE;
	}

/* Check if its an interrupted system call. Since to service the signal handlers 
   accept might be interrupted so tranfer program control back to accept */
      
      if(newsockfd < 0)
	{
	  if(errno == EINTR)
	    {
	      errno = 0;
	      goto again;
	      
	    }
	  else
	    perror("accept");
	}

/* Fork of  a child to service each client */

    if((childpid = fork()) < 0)
      printf("Server: fork error\n");

    else if (childpid == 0) {
      close(sockfd);

      initialize_time_data(&serv_start_time); /* initialize time data structures */

      timer_start_stop(&serv_start_time); /* Start time */

      server_do_transaction(newsockfd); /* Perform transaction for client */

      initialize_time_data(&serv_stop_time); /* Initialize timing data structures */

      timer_start_stop(&serv_stop_time); /* Stop timer */

#ifdef DEBUG
      server_time = display_timing(&serv_start_time,&serv_stop_time,"Server time is  ");
#endif DEBUG
      _exit(0);
    }

   

    close(newsockfd); /* Close socket for child */



 } 


}

/*********************************************************************************
 * This function calls routine for servicing transactions                        *
 *********************************************************************************/

void server_do_transaction(s)
int s;
{

  transaction(s);

#ifdef DEBUG
  printf("Exited from server_do_transaction\n");
#endif DEBUG

}


/************************************************************************************
 * Main service transaction function. Accepts request and  sends reply data packets *
 * from client and to client.                                                       *
 ************************************************************************************/

int transaction(s)
int s;
{
  char buffer[MAXDATA];
  int rcv_size, snd_size;
  int tmp1;
  char temp1[10];
  long to_get, to_get_or_send, Which_Way1, Which_Way2;

  int more_data;

  more_data = TRUE;

  while(more_data == TRUE)
    {
      tmp1 = receive_data(s,buffer,MAXDATA);

#ifdef DEBUG
      printf("tmp1 = %d\n",tmp1);
#endif DEBUG

#ifdef DEBUG    
      printf("Received initial data packet\n");
#endif DEBUG

      strcpy(temp1, (char *)strtok(buffer,":"));

#ifdef DEBUG    
      printf("Number of bytes 1st packet = %d\n",atoi(temp1));
#endif DEBUG

      to_get = atoi(temp1);

      strcpy(temp1, (char *)strtok(NULL,":"));

#ifdef DEBUG    
      printf("Direction 1st packet  = %d\n",atoi(temp1));
#endif DEBUG

      Which_Way1 = atoi(temp1);


      strcpy(temp1, (char *)strtok(NULL,":"));
#ifdef DEBUG    
      printf("Number of bytes 2nd packet = %d\n",atoi(temp1));
#endif DEBUG
      to_get_or_send = atoi(temp1);

      strcpy(temp1, (char *)strtok(NULL,":"));
#ifdef DEBUG    
      printf("Direction 2nd packet  = %d\n",atoi(temp1));
#endif DEBUG

      Which_Way2 = atoi(temp1);

      strcpy(temp1, (char *)strtok(NULL," "));

#ifdef DEBUG    
      printf("More data  = %d\n",atoi(temp1));
#endif DEBUG

      more_data = atoi(temp1);
      if(more_data == FALSE)
	break;

  if(Which_Way2 >0 )
    {
      snd_size = send_data(s,buffer,to_get_or_send);
#ifdef DEBUG    
      printf("SERVER: data size sent is %d bytes\n",snd_size);
#endif DEBUG
    }
  else
    {
        rcv_size = receive_data(s,buffer,to_get_or_send);
#ifdef DEBUG    
	printf("SERVER: data size received is %d\n",rcv_size);
#endif DEBUG
      }
    }

#ifdef DEBUG
  printf("Exited from transaction procedure\n");
#endif DEBUG

  return(more_data);


}

/*************************************************************************************
 * Invoked on parent catching SIGCHLD signal. Wait for children process to terminate *
 * Wait3 ensures a non-blocking wait and WNOHANG ensures that wait3 does not block   *
 * when there are no children processes that wish to report status.                  *
 *************************************************************************************/

void child_quiet_exit()
{
  union wait status;

  while(wait3(&status,WNOHANG,0)>0)
    ;

}


/*********************************************************************************
 * This function unlinks the shared file invoked on encountering ^c (SIGINT)     *
 *********************************************************************************/

void cleanup()
{
  char lockname[30];

  sprintf(lockname,"file_lock_#w_#r");
  unlink(lockname);
  exit(0);
  

}

/***********************************************************************************
 * This function fills sockaddr_in with server address information. Creates a      *
 * socket, binds it and listens on the socket for clients.                         *
 ***********************************************************************************/

initialize_server(host_addr)
struct sockaddr_in *host_addr;
{

  char host[BUFSIZE];
  int sock, t;

  gethostname(host,MAXNAME);
  mk_sock_addrin(host_addr, host);
  sock = create_socket();
  t = bind_sock(sock,host_addr);
  listen(sock,5);
  return(sock);

}

/*************************************************************************************
 * This function performs the accept for the server                                  *
 *************************************************************************************/

accept_data(sock)
int sock;
{

  struct sockaddr_in from;
  int g, len = sizeof(from);


  g = accept(sock, &from, &len);
  return(g);

} 

/*******************************************************************************
 * This function initializes the timing related data structures                *
 *******************************************************************************/

initialize_time_data(time_data)
struct my_timeval *time_data;
{

  time_data->tv_sec = 0L;
  time_data->tv_usec = 0L;

}



