/****************************************************************************
*
* Name        : mstandalone_client.c  of X Interprocess Communication(IPC) Benchmark
*
*
* Description : This program forks and execs the local/remote clients in standalone
*                mode which would be communicating with the X IPC server.
*                The clients would be 
*               performing transactions which emulate X based activity like
*               xdvi or xwd or emacs etc. This emulation is done using data 
*               obtained from Mr. Ralph E. Droms collected for the performance 
*               of the X window System Communication Protocol. 
*               
*
* Written by  : Dhruve Shah
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



#include <stdio.h>
#include <sys/file.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <arpa/nameser.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <resolv.h>
#include <sys/wait.h>
#include <sys/time.h>
#include "defines.h"




void cleanup(); /* Function to remove shared file on ^c */
void wpi_logo();/* Function to print WPI logo for benchmark */

main(argc,argv)
int argc;
char **argv;
{

  int num_remote,i;  /* Number of clients */

  /* Character arrays for temporary string, input file name, and file lock */

  char buf[10], inpfile[MAXNAME], hostname[MAXNAME], lockname[MAXNAME];
  union wait status; /* Status used to store status information for exiting children 
		        in parent */

/* Structure used to store timing information */

    struct my_timeval
    {
      long tv_sec;
      long tv_usec;
      long sys_tv_sec;
      long sys_tv_usec;
      long user_tv_sec;
      long user_tv_usec;
    };

/* Other timing related data structures */

  struct my_timeval mclient_start_time,mclient_stop_time;
  int mclient_time;

/* Catch ^c and remove temporary shared file from file table entry */

  signal(SIGINT,cleanup);

/* Remote Master client program invoked with parameters
*  1. Remote hostname 2. Data file used for transactions 3. Number of Clients
*/

  if((argc != 4))
    {
      printf("Usage: mstandalone_client local_hostname/remote_hostname file no_of_clients\n");
      exit(-1);
    }

#ifdef DEBUG  
  printf("Server name is %s\n",argv[1]);
  printf("File name is %s\n",argv[2]);
  printf("Number of remote clients = %d\n",atoi(argv[3]));
#endif DEBUG

/* Save useful environment information in local data structures */

  strcpy(hostname,argv[1]);
  strcpy(inpfile,argv[2]);
  num_remote = atoi(argv[3]);

#ifdef DEBUG
  printf("\n Hostname = %s\n",hostname);
  printf("\n Input file = %s\n",inpfile);
  printf("\nNumber of local clients = %d\n",num_remote);
#endif DEBUG

/* Call synchronzing routine to ensure local and remote clients start together */

  start_clients(hostname,inpfile,num_remote);

/* Start  all remote clients */

  timer_start_stop(&mclient_start_time);  /* Start timer */

/* Wait for all children to complete */

  for(i=0; i<(num_remote);i++)
    wait(&status);

  timer_start_stop(&mclient_stop_time);/* stop timer */

  wpi_logo(); /* Print WPI logo for benchmark */

/* Display Elapsed local clients time */

  mclient_time = display_timing(&mclient_start_time,&mclient_stop_time,"Elapsed Standalone  Client  time is ");

/* Remove Shared file */

  sprintf(lockname,"file_lock_#w_#r");
  unlink(lockname);
}

/*********************************************************************************
 * This function forks and execs all the remote clients with appropriate input    *
 * arguments.                                                                    *
 *********************************************************************************/


start_clients(hostname,inpfile,num_clients)
char hostname[MAXNAME], inpfile[MAXNAME];
int num_clients;
{
  
  int i,value;
  char temp_buf[10],temp1_buf[10];

  sprintf(temp_buf,"%d",num_clients);
  for(i=0; i<num_clients;i++)
    {
      sprintf(temp1_buf,"%d",i);
      value = fork();
      if(value == 0)
	{
	  if(execl("client_standalone","./client_standalone",hostname,inpfile,temp_buf,temp1_buf,0)<0)
	    {
	      perror("execl");
	      exit(0);
	    }

	}
    }

}

/*********************************************************************************
 * This function unlinks the shared file invoked on encountering ^c (SIGINT)     *
 *********************************************************************************/

void cleanup()
{
  char lockname[30];

  sprintf(lockname,"file_lock_#w_#r");
  unlink(lockname);
  exit(0);
  

}

/*********************************************************************************
 * This function prints the logo for the WPI Benchmark Suite                     *
 *********************************************************************************/

void wpi_logo()
{

  printf("\n\n------------------------------ WPI BENCHMARK SUITE ------------------------\n");
  printf("Name: X Interprocess Communication Benchmark,v 1.0 91/05/08\n\n\n");

}

