/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-sdump.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : sdump.c
*
* Version     : $Revision 1.0 $
*
* Description : Synthetic benchmark of the dump program.           
*
* Written by  : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
* Rev History : 0.1: commented out the multiforking capability, July 1990
*               0.2: deleted the memory flushing sub-routine, July 1990
*               0.3: introduced standard embeded portable timing code, Aug 90
*               0.4: modified the embeded timing into function calls, Sep 90
   Under RCS control.
 $Log$
************************************************************************/




/*
Inputs :  (command line arguments to this program)
========
First argument: The pathname to the directory containing the test data.
                It is a set of 10 files of arbitrary size and format,
                named file_0...file_(N-1)

Second argument: The name [path] of the file to be used to simulate the tape
                 drive.

Third argument: Number of files to dump: Minimum:1, Maximum N

Example: sdump /usr1/aju/test  /usr1/aju/tmp/dump.out 5



Outputs:
========

Displays the following:

1. The number of files accessed.
2. The average size of each file in bytes.
3. Total number of bytes read ( equal to the product of 1 & 2 )
4. Elapsed time: Time (wall clock) taken to dump the directory.
5. Amount of data transfered in a second.


DUMP ANALYSIS: 10 files, Avg. Size: 1377305.13

Total bytes transfered : 13773051
Elapsed time for DUMP: 119130.00 milliseconds
Transfer rate: 115613.624 bytes/second.

*/





/*=-=-=-=-= program begins =-=-=-=-=-=-*/


/*
#define SCO
*/
/*
#define FORK
*/

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef SCO 
#include <unistd.h>  /* locking files in SCO */
#endif
#ifndef SCO 
#include <sys/file.h>
#endif
#include "timing.h"
#include "sdump.h"       /*=-=- include file for globals -=-=*/

/* global */
unsigned long   time_diff;

/*************************************************************************
*  main module.
*************************************************************************/
main (argc, argv)
     int     argc;
     char    *argv[];
{
        char            *path;
        int             oflag;
        int             pmode;
        int             fi_tape;
        int             ret, val;
	int             i,rtn;
	int		nforks;
	int             file_count;
	int             cycle;
	long            total_size, get_size();
        char            filename[30], diskname[30];
        char            remote_cmd[35];
	char            temp[30];
	char            c[5];
	char            ans[3];
#ifndef SCO
	register
#endif
        struct stat     *buff;
	char *ver;

	/* to automatically cahnge the version number with revisions */

	ver = (char *)calloc( 60, sizeof(char));
	/* release version */
	strcpy(ver,"$Id: sdump.c,v 1.0 91/02/22 11:07:11 aju Exp Locker: aju $");
	ver[28] = 0;
	ver += 13;



	if (argc != 4) {
	  printf ("\nProgram %s needs 3 arguments: \n", argv[0]);
	  printf ("   Directory containing the data-files\n");
	  printf ("   Name of the dump file (along with path)\n");
	  printf ("   Number of files to dump  (Min:1, Max:10)\n");
	  exit(-1);
	}
	else {
	  printf ("\nProgram %s executing with the following parameters: \n", 
		  argv[0]);
	  printf ("   Directory containing the data-files: %s\n", argv[1]);
	  printf ("   Name of the dump file : %s\n", argv[2]);
	  printf ("   Number of files to dump: %s\n", argv[3]);
	}

        strcpy(filename, argv[2]);
        strcpy(diskname, argv[1]);

        tape = filename;
        disk = diskname;

	/* number of files to be dumped */

	nforks = atoi(argv[3]);
	if ( nforks > MAXFILES ) nforks = MAXFILES;

	if ( nforks < 1  ) nforks =  1;

	total_size = 0;
	time_diff  = 0;


	strncat(disk,"/file_",6);
	strcpy( temp, argv[1]);
	strncat(temp,"/file_",6);



	total_size  = get_size(diskname, nforks) ;
	file_count  = get_filect(diskname, nforks ) ;



	  fi_tape = creat(tape, S_IREAD|S_IWRITE);
	  if (fi_tape < 0 ) {
	    msg("Cannot create %s\n", tape);
	    exit(X_ABORT);
	  }
	  
	  fi_tape = open(tape, O_TRUNC | O_RDWR | O_APPEND);
	  if (fi_tape < 0 ) {
	    msg("Cannot open %s\n", tape);
	    exit(X_ABORT);
	  }

/* timing starts */	
	begin_timing();



#ifdef TDEBUG
    printf("Starting pipe.....");
#endif
    rtn = pipe(control);
    if (rtn  == -1)
      {
	msg("pipe (control) returned error.\n");
	exit(-1);
      }

    rtn = pipe(fromDisk);
    if (rtn  == -1)
      {
	msg("pipe (fromDisk) returned error.\n");
	exit(-1);
      }

#ifdef TDEBUG
    printf("Done.\n");
#endif


	buff = (struct stat *)calloc(1, sizeof(struct stat));

#ifdef FORK
	  for (i = 0; i < nforks; i++) {
	    if (fork() == 0) {
	      sprintf( c, "%d", i);
	      strcpy(disk, temp); 
	      strcat(disk, c); 

	      fi = open(disk, O_RDONLY);
	      if (fi < 0) {
		msg("Cannot open %s\n", disk);
	      }
	      ret =  stat(disk, buff);
	      if (ret) 
		msg ("Error in stat: %d. Can't find %s\n", ret, disk);
	      else {
		dumpfile(buff, fi_tape);
	      }
	      _exit(0);
	    }
	    wait(&val);
	  }
#endif

#ifndef FORK	  
	for (i = 0; i < nforks; i++) {
	  strcpy(disk, temp); 
	  sprintf( c, "%d", i);
	  strcat(disk, c); 

	  
	  fi = open(disk, O_RDONLY);
	  if (fi < 0) {
	    printf("Cannot open %s\n", disk);
	  }

#ifdef TDEBUG
	  printf("Getting file statistics...\n");
#endif

	  ret =  stat(disk, buff);
	  if (ret) 
	    msg ("Error in stat: %d. Can't find %s\n", ret, disk);
	  else {
	    dumpfile(buff, fi_tape);  
	  }

	}
#endif
printf ("\n\n");


/* timing ends */
	end_timing();
	wpi_banner("Synthetic Dump Benchmark", ver);
	printf("DUMP ANALYSIS: %d files, Avg. Size:%.2f \n",
	       file_count, ((float)total_size/(float)file_count));
	printf("Total bytes transfered : %d \n", total_size);
        printf("%s %d", "Elapsed time for DUMP:", time_diff );
        printf(" milliseconds\n");

	printf("Transfer rate: %.3f bytes/second.\n",
			1000 * (float)total_size/(time_diff));
	printf("----------------------------------------------------\n\n\n\n");



}

/**************************************************************************
*  dumpfile: prints information about the file being dumped and calls dump.
*  called from: main()
***************************************************************************/

dumpfile(statinfo, tape_file)
     struct stat *statinfo;
     FILE *tape_file;

{
  printf("\nDumping file: %s\n", disk);
  printf(" %s %u\n %s %d\n %s %d\n %s %d %s\n" ,
         " File inode resides on device : " , statinfo->st_dev ,
         " File's inode number : " , statinfo->st_ino,
         " User-id of owner :",statinfo->st_uid ,
         " Actual size of the file  : ",  statinfo->st_size, " bytes");
  ino =statinfo->st_ino;

        msg("dumping  [regular files]\n");

#ifdef TDEBUG
   printf("Dump is called\n");
#endif
                        dump ( statinfo, tape_file);

}

/*************************************************************************
*  dump: dumps the files into a tape file by calling dump2tape()
*  called from: dumpfile()
*************************************************************************/


dump( statinfo, tape_fi)
     struct stat *statinfo;
     FILE tape_fi;
{
  register int i;
  long     size;
  int      n;
  char     *ba;
  long     val1, val2, product;

#ifdef TDEBUG
    printf("Getting product.\n");
#endif
  product =  statinfo->st_size;
#ifdef TDEBUG
    printf("Allocating memory.....");
#endif
  ba = (char *)calloc( product, sizeof(char));
  if (!(ba))
    {
      msg("Error: Can't calloc memory [dump()]\n");
      exit(-1);
    }
#ifdef TDEBUG
    printf("Done\nWill be reading data...");
#endif
#ifdef TDEBUG
    printf("\nReading data.(actual)..");
#endif
  n = read(fi, ba, product);
  if (n == -1)
    {
      msg("Error:  read  [dump()]\n");
      exit(-1);
    }
#ifdef TDEBUG
    printf(".:.");
#endif  
#ifdef TDEBUG
    printf("Done.\n");
#endif

  dump2tape(ba , product, tape_fi);
  free( ba);

}

/*************************************************************************
*  msg(): for printing messages. Called from most modules
*************************************************************************/


msg(fmt, a1, a2, a3, a4, a5)
	char	*fmt;
	int	a1, a2, a3, a4, a5;
{
	fprintf(stderr,"  DUMP: ");
#ifdef TDEBUG
	fprintf(stderr,"pid=%d ", getpid());
#endif
	fprintf(stderr, fmt, a1, a2, a3, a4, a5);
	fflush(stdout);
	fflush(stderr);
}

#define PIPE_BUFFER 4096


/*************************************************************************
* dump2tape: actuallt forks a tape process, creates pipes and transfers
*            the files to a tape-file.
* called from: dump2tape
*************************************************************************/
dump2tape(inp_buff, size, fi_tape)
  char *inp_buff;
  long size;
  FILE *fi_tape;
{
    char buffer[PIPE_BUFFER +1],  control_buff[10];
    int  count, i;
    int  rtn, pid;
    int  micros;
    int  transfer_size;
    int  res;
    int  kount;  
    double timePer;
    extern int errno;


#ifdef TDEBUG
    printf("Starting fork.....");
#endif
    pid = fork();
#ifdef TDEBUG
    printf("Done.\n");
#endif

    if ( size >= PIPE_BUFFER )
      transfer_size = PIPE_BUFFER;
    else 
      transfer_size = size;
    

#ifdef TDEBUG
    printf("Dumping file on simulated tape.\n");
#endif

#ifdef FORK

#ifndef SCO      /*  if MACH  */
    flock(fi_tape,  LOCK_SH ); /* for BSD and Mach */
#endif

#ifdef SCO
/*    lockf(fi_tape, F_LOCK, 0); */   /* for sysV and SCO */
#endif

#endif

#ifdef FORK


#endif 

    if (pid == 0) {
	   while (1) {
#ifdef TDEBUG
	     printf("Read Wait..."); 
#endif
	     rtn = read(fromDisk[0], buffer, transfer_size);	
	     if (rtn  == -1)
	       {
		 msg("read (fromDisk) returned error.\n");
		 exit(-1);
	       }

#ifdef TDEBUG
	     printf("Done \nWriting on Tape \n"); 
#endif
	     kount = write(fi_tape, buffer, transfer_size);
	     if (kount  == -1)
	       {
		 msg("write (fi_tape) returned error.\n");
		 exit(-1);
	       }

#ifdef TDEBUG
	     printf("%d bytes written  on tape\n", kount); 
#endif
	     rtn = read(control[0], buffer, 1);
	     if (rtn  == -1)
	       {
		 msg("read (control pipe) returned error.\n");
		 exit(-1);
	       }


#ifdef TDEBUG
	     printf("Read control\n"); 
#endif
	     if (buffer[0] == 'e') {
#ifdef TDEBUG
	       printf("Closing Tape\n");
#endif

#ifdef TDEBUG
	     printf("Child exiting\n"); 
#endif
	       break;
	     }
	
	   }
	   _exit(0);
	 }

	 if (pid == -1) {
	   fprintf(stderr, "Couldn't fork slave process: error %d.\n",
		   errno);
	   return;
	 }
    while(1)
      {
#ifdef TDEBUG
	  printf("Present size is %d bytes\n", size);
#endif
	  if ( size < PIPE_BUFFER )
	   transfer_size = size;
#ifdef TDEBUG
         printf("Writing on Tape pipe...\n");
#endif
	  rtn = write(fromDisk[1], inp_buff, transfer_size);
	  if (rtn  == -1)
	       {
		 msg("write (fromDisk) returned error.\n");
		 exit(-1);
	       }
	 inp_buff += transfer_size;
	 size -= transfer_size;
	 if (size <= 0)
	   {
	     rtn == write(control[1], "e", 1);
	     if (rtn  == -1)
	       {
		 msg("control EOD write returned error.\n");
		 exit(-1);
	       }

#ifdef TDEBUG
	     printf("End of write to pipe\n");
#endif



	     wait(res);

#ifdef FORK

#ifndef SCO
	     flock(fi_tape,   LOCK_UN ); /* for BSD 4.X and Mach */
#endif

#ifdef SCO
/*	     lockf(fi_tape, F_ULOCK, 0 );*/  /* for system V and SCO*/
#endif

#endif

#ifdef TDEBUG
	     printf("Completed writing on tape \n");
#endif
	     close( control);
	     close ( fromDisk);
	     return;
	   }	     
	 else
	   	 write(control[1], "c", 1);


       }



}

/*************************************************************************
*  get_size: gets the size of each file to be dumped
*  called from: main
*************************************************************************/

long get_size(directory, nforks)
char *directory;
int             nforks;
{
  char            disk[30];
  int             ret, val;
  int             i;
  long            total_size;
  char            c[5];
#ifndef SCO
  register 
#endif
  struct stat     *statinfo;
  char            temp[30];


  total_size = 0;
  strcpy( temp, directory);
  statinfo  = (struct stat *)calloc(1, sizeof(struct stat));

  for (i = 0; i < nforks; i++) {
    strcpy(disk, temp); 
    sprintf( c, "%d", i);
    strcat(disk, c); 

    ret =  stat(disk, statinfo);
    if (ret)
      msg ("get_size: Error in stat: %d. Can't find %s\n", ret, disk);
    else
      total_size += (long) statinfo->st_size;
    
  }
  return ( total_size);
}

/*************************************************************************
*  get_filect: gets the number of files that are to be dumped. It checks
*              for the presence of the files and increments count only if
*              they are physically present on disk.
*  called from: main
*************************************************************************/

get_filect(directory, nforks)
char *directory;
int             nforks;
{
  char            disk[30];
  int             ret, val;
  int             i;
  int            total_size;
  char            c[5];
#ifndef SCO
  register 
#endif
  struct stat     *statinfo;
  char            temp[30];



  total_size = 0;
  strcpy( temp, directory);

  statinfo  = (struct stat *)calloc(1, sizeof(struct stat));
  for (i = 0; i < nforks; i++) {
    strcpy(disk, temp); 
    sprintf( c, "%d", i);
    strcat(disk, c); 

    ret =  stat(disk, statinfo);
    if (!(ret))
      total_size ++;
    else
      msg ("get_filect: Error in stat: %d. Can't find %s\n", ret, disk);
    
  }
  return ( total_size);
}

/*************************************************************************
*                        The end of sdump
*               Also see: sdump.h, timing.h, timing.c
*************************************************************************/





