

/*********************************************************************
*
* Name        : thrd_timing.h
*
* Version     : 1.1
*
* Description : Common Standard Portable Timing Routine fpr threads.
*
* Written  by : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*                 
************************************************************************/
/*********************** SELECT TIMING METHOD ***********************/
/*                            systems
    timing          MACH 2.5    MACH 3.0   SCO V.3   SYS V.4
    ---------------------------------------------------------
    gettimeofday        X          X                    X
    getrusage           X          X                    
    ftime               X          X          X
    time                X          X          X         X
    times               X          X          X         X
    clock                                     X         X
*/

/* #define GETTIMEOFDAY  */
/* #define GETRUSAGE */
#define FTIME    
/* #define TIME */
/* #define TIMES */
/* #define CLOCK  */
/*****************************************************************/


/************* DEFINE TIMING PARAMETERS AND INCLUDES *************/
#ifdef GETTIMEOFDAY
#include <sys/time.h>     
  static struct timeval  gtimestart, gtimeend;
  static struct timezone gt_zp;
  double          gtimeelapsed;
  int             gtimediff;
#endif
#ifdef GETRUSAGE  
#include <sys/time.h>      
#include <sys/resource.h>  
  static struct rusage   rusage_start, rusage_end;
  double          rusage_utime, rusage_stime;
  int             rusage_udiff, rusage_sdiff;
#endif
#ifdef FTIME
#include <sys/timeb.h>     
  static struct timeb    ftimestart, ftimeend;
  unsigned long   ftimesec1, ftimesec2, ftimemillisec1, 
       ftimemillisec2;
  unsigned long   ftimediff;
#endif
#ifdef TIME
#include <sys/times.h>    
  static timet          timestart, timeend;
  int             timediff;
#endif
#ifdef TIMES
#include <sys/times.h>    
#include <sys/param.h>        
  static struct tms      times_start, times_end;
  long            times_utime, times_stime;
  int         times_udiff, times_sdiff;
#endif 
#ifdef CLOCK
  static long            clock_start, clock_end;
  int             clock_diff;
#endif







