/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-timing.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : timing.c
*
* Version     : 1.0
*
* Description : Common Standard Portable Timing Routine.
*
* Modified by : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*                 
************************************************************************/

/* $Log$  */

/******************************************************************
 * PRELIMINARY VERSION: Not for distribution.                     *
 * For final version, send mail to mach@cs.wpi.edu                *
 ******************************************************************/

#include <sys/types.h>
#include <sys/stat.h>


#define  START 0
#define  STOP  1

/* #define GETTIMEOFDAY  */
/* #define GETRUSAGE */
#define FTIME    
/* #define TIME */
/* #define TIMES */
/* #define CLOCK  */

timing( flag)
int flag;
{

/*****************************************************************/


/************* DEFINE TIMING PARAMETERS AND INCLUDES *************/
#ifdef GETTIMEOFDAY
#include <sys/time.h>     
  static struct timeval  gtimestart, gtimeend;
  static struct timezone gt_zp;
  double          gtimeelapsed;
  int             gtimediff;
#endif
#ifdef GETRUSAGE  
#include <sys/time.h>      
#include <sys/resource.h>  
  static struct rusage   rusage_start, rusage_end;
  double          rusage_utime, rusage_stime;
  int             rusage_udiff, rusage_sdiff;
#endif
#ifdef FTIME
#include <sys/timeb.h>     
  static struct timeb    ftimestart, ftimeend;
  unsigned long   ftimesec1, ftimesec2, ftimemillisec1, 
       ftimemillisec2;
  unsigned long   ftm_diff;
#endif
#ifdef TIME
#include <sys/times.h>    
  static timet          timestart, timeend;
  int             timediff;
#endif
#ifdef TIMES
#include <sys/times.h>    
#include <sys/param.h>        
  static struct tms      times_start, times_end;
  long            times_utime, times_stime;
  int         times_udiff, times_sdiff;
#endif 
#ifdef CLOCK
  static long            clock_start, clock_end;
  int             clock_diff;
#endif








unsigned long tm_diff;

if (flag == START)
  {
    /*********************  START TIMING ***********************/
#ifdef GETTIMEOFDAY
    gettimeofday (&gtimestart, &gt_zp);
#endif
#ifdef GETRUSAGE
    getrusage(RUSAGE_SELF, &rusage_start);
#endif
#ifdef FTIME
    ftime(&ftimestart);
#endif 
#ifdef TIME
    time(&timestart);
#endif
#ifdef TIMES
    times(&times_start);
#endif
#ifdef CLOCK
    clock_start = clock();
#endif
    /***************************************************************/

return ((unsigned long)0);

  }
else  /* flag = STOP or anything else */
  {

 /* end_timing() */


/******** STOP TIMING, COMPUTE AND PRINT RESULT(S) ****************/
#ifdef GETTIMEOFDAY
  gettimeofday (&gtime_end, &gtzp);
  gtime_elapsed = (1000*gtime_end.tv_sec + gtime_end.tv_usec/1000) -
                  (1000*gtime_start.tv_sec + gtime_start.tv_usec/1000);
  gtime_diff = gtime_elapsed;

  tm_diff= gtimediff;
#endif

#ifdef GETRUSAGE
  getrusage(RUSAGE_SELF, &rusage_end);
  rusage_utime = (1000*rusage_end.ru_utime.tv_sec +
                       rusage_end.ru_utime.tv_usec/1000) -
                 (1000*rusage_start.ru_utime.tv_sec +
                       rusage_start.ru_utime.tv_usec/1000);
  rusage_udiff = rusage_utime;
  rusage_stime = (1000*rusage_end.ru_stime.tv_sec +
                       rusage_end.ru_stime.tv_usec/1000)  -
                 (1000*rusage_start.ru_stime.tv_sec +
                       rusage_start.ru_stime.tv_usec/1000);
  rusage_sdiff = rusage_stime;
  printf("getrusage results:\n");
  printf("  User time   = %d msec\n",rusage_udiff);
  printf("  System time = %d msec\n",rusage_sdiff);
  tm_diff= rusage_udiff + rusage_sdiff;
#endif

#ifdef FTIME
  ftime(&ftimeend);
  ftimesec1 = ftimestart.time;
  ftimemillisec1 = ftimestart.millitm;
  ftimemillisec1 += ftimesec1*1000;
  ftimesec2 = ftimeend.time;
  ftimemillisec2 = ftimeend.millitm;
  ftimemillisec2 += ftimesec2*1000;
  ftm_diff = ftimemillisec2 - ftimemillisec1;
  tm_diff= ftm_diff;
#endif

#ifdef TIME
  time(&timeend);
  tm_diff= timeend - timestart;
  printf("time results:\n");
  printf("  Elaped time = %d sec\n",tm_diff);
#endif

#ifdef TIMES
  times(&times_end);
  times_utime = 1000*(times_end.tms_utime 
		 - times_start.tms_utime)/HZ;
  times_udiff = times_utime;
  times_stime = 1000*(times_end.tms_stime 
		 - times_start.tms_stime)/HZ;
  times_sdiff = times_stime;
  printf("times results:\n");
  printf("  User time   = %d msec\n",times_udiff);
  printf("  System time = %d msec\n",times_sdiff);
#endif

#ifdef CLOCK
  clock_end = clock();
  clock_diff = (clock_end - clock_start)/1000;
  printf("clock results:\n");
  printf("  CPU time    = %d msec\n",clock_diff);
#endif
/********************************************************/
  return(tm_diff);

 }

}
