/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-serv_anl.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : serv_anl.c   / * of sdbase * /
*
* Version     : $Revision 1.0 $
*
* Description : Analyzes the server's output files - Sdbase
*
* Written by  : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/




#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>


main(argc, argv)
int argc;
char *argv[];

{
  
  unsigned long rd_cnt, 		/* read request counter */
              wr_cnt,		/* write request counter */
	      ad_cnt,		/* add request counter */
	      gt_cnt,		/* get request counter */
	      rs_cnt;		/* result request counter */

  unsigned long errcnt;		/* Total error count */

  unsigned long ret_time;
  unsigned long total_tasks;	/* Total number of tasks logged in */
  unsigned long server_time, client_time;
  unsigned long init_time;
  unsigned long getlen_time;
  unsigned long read_time;
  unsigned long write_time;
  unsigned long append_time;
  unsigned long rd_blkd, wr_blkd, ap_blkd, gt_blkd;
  long      rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd, tot_ovhd;

  int             i, no_clients;
  char            c[5];
  char            disk[30];
  long      tot_server_time,
            tot_rd_cnt,tot_wr_cnt,tot_ad_cnt,tot_gt_cnt;
  long      tot_read_time, tot_write_time, tot_append_time,
            tot_getlen_time;
  long      tot_rd_bl, tot_wr_bl, tot_ap_bl, tot_gt_bl;
  FILE      *fp;
 
  printf("*** Server data Analyzer ***\n");
  if (argc == 1)
    {
      printf("usage: %s  N, where N is the # of files to be analyzed.\n",
	     argv[0]);
      exit(-1);
    }
  no_clients = atoi(argv[1]);
  tot_server_time=tot_rd_cnt=tot_wr_cnt=tot_ad_cnt=tot_gt_cnt=0L;
  tot_read_time= tot_write_time= tot_append_time= tot_getlen_time=0L; 
  tot_rd_bl =  tot_wr_bl = tot_ap_bl =  tot_gt_bl = 0L;


  printf("Analyzing Data for %d clients\n", no_clients);
  
  for(i=0; i<no_clients; i++)
    {
      strcpy(disk,"dbs_");
      sprintf( c, "%d", i);
      strcat(disk, c);
      fp = fopen ( disk, "r");
      if (fp == NULL)
	{
	  printf("Error: Can't open %s\n\n", disk);
	  printf("*** Only %d files analyzed\n", i);
	  break;
	}
      fscanf(fp, " %d", &server_time);
      fscanf( fp, " %d %d %d %d",
	      &rd_cnt, &wr_cnt, &ad_cnt, &gt_cnt);
      fscanf( fp," %d %d %d %d %d %d %d %d",
	      &read_time, &write_time, &append_time, &getlen_time,
	      &rd_blkd, &wr_blkd, &ap_blkd, &gt_blkd);
      fclose(fp);


        printf( "------------------server %d---------------------\n",i+1);
        printf( "\t read \t write \t append\t get_last_record \n");
        printf( "-----------------------------------------------\n");
        printf( "\t %d \t %d \t %d \t %d \t(Number of operations)\n",
                rd_cnt, wr_cnt, ad_cnt, gt_cnt);
        printf( "%14d%8d%8d%8d \t(Total time  in msecs)\n",
                read_time, write_time,append_time,getlen_time);
        printf( "\t%.2f %.2f  %.2f %.2f \t(Average time in msecs)\n",
               (float)read_time/(float)rd_cnt,
                (float)write_time/(float)wr_cnt,
                (float)append_time/(float)ad_cnt,
                (float)getlen_time/(float)gt_cnt);
        printf( "------------------------------------------------\n");
        printf( " server %d time = %d milliseconds\n",i+1,server_time);
        printf( "--- Time spent in locks --- (msec)\n");
        printf( "Read:  :  %8d\n", rd_blkd);
        printf( "Write  :  %8d\n", wr_blkd);
        printf( "Append :  %8d\n", ap_blkd);
        printf( "Getlast:  %8d\n", gt_blkd);
        printf( "-------------------\n");
        printf("Total  :  %8d\n",rd_blkd+wr_blkd+ap_blkd+gt_blkd);




      tot_server_time += server_time;
      tot_rd_cnt += rd_cnt;
      tot_wr_cnt += wr_cnt;
      tot_ad_cnt += ad_cnt;
      tot_gt_cnt += gt_cnt;
      tot_read_time += read_time;
      tot_write_time += write_time;
      tot_append_time += append_time;
      tot_getlen_time += getlen_time;
      tot_rd_bl += rd_blkd;
      tot_wr_bl += wr_blkd;
      tot_ap_bl += ap_blkd;
      tot_gt_bl += gt_blkd;

    }
        printf("\n\n\n\n");
        wpi_banner("Synthetic Database: database server", "v1.0" );
        printf( "------------------TOTAL-TIME--------------------\n");
        printf( "\t read \t write \t append\t get_last_record \n");
        printf( "------------------------------------------------\n");
        printf( "Number of operations\n");
        printf( "\t %d \t %d \t %d \t %d \n",
                tot_rd_cnt, tot_wr_cnt, tot_ad_cnt, tot_gt_cnt);
        printf( "Total time  (Time in msecs)\n");
        printf( "%14d%8d%8d%8d \n",
                tot_read_time, tot_write_time,tot_append_time,tot_getlen_time);
        printf( "Average time  (Time in msecs)\n");
        printf( "\t%.2f %.2f  %.2f %.2f \n",
               (float)tot_read_time/(float)tot_rd_cnt,
                (float)tot_write_time/(float)tot_wr_cnt,
                (float)tot_append_time/(float)tot_ad_cnt,
                (float)tot_getlen_time/(float)tot_gt_cnt);
        printf( "(Average time)/%d  (Time in msecs)\n",i);
        printf( " \t%.2f   %.2f   %.2f   %.2f \n",
               (float)tot_read_time/(float)tot_rd_cnt/(float)i,
                (float)tot_write_time/(float)tot_wr_cnt/(float)i,
                (float)tot_append_time/(float)tot_ad_cnt/(float)i,
                (float)tot_getlen_time/(float)tot_gt_cnt/(float)i);
        printf( "------------------------------------------------\n");
        printf( "Total server time = %d milliseconds\n",tot_server_time);
        printf( "(Total server time)/%d = %d ms\n",i,tot_server_time/i);

        printf( "\n*** Total time spent in locks *** (msec)\n", i);
        printf( "Read:  :  %8d\n", tot_rd_bl);
        printf( "Write  :  %8d\n", tot_wr_bl);
        printf( "Append :  %8d\n", tot_ap_bl);
        printf( "Getlast:  %8d\n", tot_gt_bl);
        printf( "-------------------\n");
        printf("Total  :  %8d\n",tot_rd_bl+tot_wr_bl+tot_ap_bl+tot_gt_bl);



  fp = fopen ( "tmp#ovhd", "r");
      if (fp == NULL)
        {
          printf("Error: Can't open temp files\n\n");
          return(1);
        }
  fscanf(fp, " %d %d %d %d %d", &rd_ovhd, &wr_ovhd, &ap_ovhd, &gt_ovhd, &tot_ovhd);
  fclose(fp);

  printf ("\nLock overheads(msec):\nread:\t%8d\nwrite:\t%8d\nappend:\t%8d\ngtlast:\t%8d\n",rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd);
  tot_ovhd = rd_ovhd + wr_ovhd + ap_ovhd + gt_ovhd;
  printf("------------------\nTotal:\t%8d msec \n", tot_ovhd);

  printf( "\n--- After lock overhead adjustments (server) ---\n");
  printf( "Total server time = %d milliseconds\n",tot_server_time - tot_ovhd);
  printf( "(Total server time)/%d = %d ms\n",i,(tot_server_time- tot_ovhd)/i);



}
