
/*********************************************************************
*
* Name        : rand_num.c  Returns random modulo num.
*
* Version     : 1.0
*
* Description : Common Standard Portable Timing Routine.
*
* Modified by : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
************************************************************************/

/*
  function randwc(num)
  Returns random modulo num.
  */
long randwc(num)
     long num;
{
long randnum();

  return(randnum(0L)%num);
}

/*
  randnum(val)
  Second order linear congruential generator.
  Constants suggested by J. G. Skellam.
  If val==0, returns next member of sequence.
  val!=0, "seeds" generator with val.
  */

long randnum(lngval)
     unsigned long lngval;
{
  register unsigned long interm;
  static unsigned long randw[2] = { 
    13 , 117 	};
  
  if (lngval!=0L) randw[1]=lngval;
  
  interm=(randw[0]*254754L+randw[1]*529562L)%999563L;
  randw[1]=randw[0];
  randw[0]=interm;
  return(interm);
}

