/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/*
*                                                       
*      Name        : sgcc.c
*                                                       
*      Version     : sgcc.c,v 0.8 90/10/14 
*                                                       
*      Description : synthetic program of the gcc.
*                    The program makes the same system calls as does gcc 
*		     when it compiles gcc. The number of calls made is 
*                    represents the average made by gcc each time it was 
*                    called by make. 
*                    Similar synthetic programs have been constructed of 
*                    cpp and cc1 and these are called within this program.
*                                                       
*      Written by  : Brad Nichols
*                    bbn@maxine.wpi.edu              
*                                                       
*      e-mail      : mach@cs.wpi.edu
*
*
*      Address     : Mach Research Group
*                    Worcester Polytechnic Institute    
*                    CS Dept                            
*                    100 Institute Road,                
*                    Worcester MA 01609.                
*                    U.S.A                              
*                    (508) 831-5357                                    
*                                                       
*      Rev History : 07/01/91
*                    Version 0.9
*                    Jonas A. Lehmann (jlehmann@cs.wpi.edu)
*                                                       
*/
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/




/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Includes                                                              */
/* Note: Some UNIX implementations do not have some of the include files.*/
/* Read the comments and try to find the correct include files.          */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/file.h>
#include <signal.h>
#include <sys/wait.h>
#include <string.h>          /* sys V */
#include <sys/time.h>        /* getrlimit() */
#include <sys/resource.h>    /* getrlimit() */

/* #include <strings.h> */   /* not on sys V */


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Constants                                                             */ 
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

#define GCC_CALLS           18  /* Number of times gcc is called */

#define CPP_CALLS           18  /* Number of times to call scpp  */
#define CC1_CALLS           18  /* Number of times to call scc1  */

#define ACCESS_CALLS        13  /* The constants below define how        */
#define UNLINK_CALLS        1   /* many times to perform an operation    */
#define VFORK_CALLS         2   /* each time sgcc is executed by scomp.  */
#define EXECVP_CALLS        2   /* The total is the value here times the */
#define GETPID_CALLS        1   /* total number of executions of sgcc.   */
#define WAIT_CALLS          2
#define SIGVEC_CALLS        10
#define SBRK_CALLS          2
#define GETPAGESIZE_CALLS   1
#define EXIT_CALLS          1

#define GIMMY_TOTAL   4000000


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* main()                                                                */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

main(argc, argv)
     int   argc;
     char *argv[];
{
  int fd, fdu, i, ans;
  int data_top, old_brk, cur_brk, new_mem_sofar;
  int gimmy, num_sbrks_sofar, psize, path_mode;
  char *myarr;
  char dummy_file_name[15];
  char base[10], unlink_id[20];
  int child, foo, pid;
  union wait *statusp;
  char *strncat();
  
  int sys, usr, file_op, rw_op, mem_op, misc_op;


  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* SYSTEM CALLS                                      */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* file operations                                   */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  sprintf(dummy_file_name,"%d",getpid());
  strcat(dummy_file_name,".temp");
  
  if ((fd = open(dummy_file_name,O_CREAT,0755)) < 0) 
    {
      fprintf(stderr, "couldn't create %s\n",dummy_file_name);
      exit(1);
    } 
  else 
    if (close(fd) < 0) 
      {
	fprintf(stderr, "couldn't close %s\n",dummy_file_name);
	exit(1);
      }
  
  path_mode = 0;
  
  for (i = 0; i < ACCESS_CALLS; i++) 
    {
      ans = access(dummy_file_name, path_mode);
      if (ans < 0) 
	{
	  fprintf(stderr, "Couldn't access %s\n",dummy_file_name);
	  exit(1);
	}
    }
  
  unlink(dummy_file_name);

  sprintf(unlink_id,"%d",getpid());
  strcat(unlink_id,".temp");
  
  for (i = 0; i < UNLINK_CALLS; i++) 
    {
      if ((fdu = open(unlink_id, O_CREAT,0755)) < 0) 
	{
	  fprintf(stderr, "couldn't create %s\n",unlink_id);
	  exit(1);
	} 
      else 
	{
	  if (unlink(unlink_id) < 0) 
	    {
	      fprintf(stderr, "couldn't unlink %s\n",unlink_id);
	      exit(1);
	    }
	}
    }
  
  
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* memory management                                 */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  
  num_sbrks_sofar = 0;
  gimmy = GIMMY_TOTAL/SBRK_CALLS;
  
  new_mem_sofar = 0;
  
  cur_brk = (int) sbrk(0);
  
  data_top = cur_brk;
  
  while ((new_mem_sofar<GIMMY_TOTAL) || (num_sbrks_sofar < SBRK_CALLS)) 
    {
      num_sbrks_sofar = num_sbrks_sofar + 1;
      old_brk = cur_brk;
      if ((GIMMY_TOTAL - new_mem_sofar) < gimmy)
	gimmy = GIMMY_TOTAL - new_mem_sofar;
      
      cur_brk = (int) sbrk(gimmy);

      cur_brk = (int) sbrk(0);  

      for (data_top = old_brk; data_top <= cur_brk; 
	   data_top = data_top + 1024) 
	{
	  myarr = (char *)data_top;
	  *myarr = 'a';
	}
      
      data_top = (int)myarr;
      cur_brk = (int) sbrk(0);
      new_mem_sofar = new_mem_sofar + (cur_brk - old_brk);
    }


  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* misc  system calls                                */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  for (i = 0; i < SIGVEC_CALLS; i++) 
    {
      signal(SIGFPE,SIG_DFL);
    }
  
  for (i = 0; i < GETPID_CALLS; i++) 
    {
      pid = getpid();
    }
  
  
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* process management                                */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  
  for (i = 0; i < (VFORK_CALLS/2); i++) 
    {
      if ((child = fork()) == 0 )
	{
	  execvp("./scpp",argv);
	} 
      else 
	{
	  wait(statusp);
	}
    } 
  
  for (i=0; i < (VFORK_CALLS/2) ;i++) 
    { 
      if ((child = fork()) == 0 ) 
	{
	  execvp("./scc1",argv);
	} 
      else 
	{
	  wait(statusp);
	}
    } 
  
  exit(0);
}
