/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/*
*                                                       
*      Name        : scc1.c
*                                                       
*      Version     : scc1.c,v 0.8 90/10/14 
*                                                       
*      Description : synthetic program of the cc1 compiler of gcc.
*                    The program makes the same system calls as cc1 does 
*                    when it   compiles gcc. The number of calls made is 
*                    set based on the gprof  output counts of cc1 for the 
*                    entire make of gcc divided by the number of times 
*                    cc1 is called durring the make. Or in other  words 
*                    the number of calls represents the average made by 
*                    cc1  each time it was called by gcc.
*                                                       
*      Written by  : Brad Nichols
*                    bbn@maxine.wpi.edu              
*                                                       
*      e-mail      : mach@cs.wpi.edu
*
*      Address     : Mach Research Group
*                    Worcester Polytechnic Institute    
*                    CS Dept                            
*                    100 Institute Road,                
*                    Worcester MA 01609.                
*                    U.S.A                              
*                    (508) 831-5357                                    
*                                                       
*      Rev History : 07/01/91
*                    Version 0.9
*                    Jonas A. Lehmann (jlehmann@cs.wpi.edu)
*/
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Includes                                                              */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

#include <sys/types.h>
#include <fcntl.h>           /* sys V */
#include <stdio.h>
#include <sys/file.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/errno.h>


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Constants                                                             */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

#define CC1_CALLS           18 /* this shows how many times scc1 is called */

#define OPEN_CALLS          2 /* per scc1 call, 2 open calls are made      */
#define FSTAT_CALLS         2
#define READ_CALLS          7
#define WRITE_CALLS         27
#define CLOSE_CALLS         1
#define IOCTL_CALLS         2
#define SIGVEC_CALLS        2
#define SBRK_CALLS          47
#define GETPAGESIZE_CALLS   1
#define GETRLIMIT_CALLS     1
#define SETRLIMIT_CALLS     1

#define SMALL_BUF_SIZE      512
#define AVG_FILE_SIZE       51200
#define GIMMY_TOTAL         4000000

#define TOTAL_DATA          5120
#define WRITE_BUF_SIZE      256
#define READ_BUF_SIZE       1024
  
  
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* main()                                                                */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

main(argc, argv)
     int   argc;
     char *argv[];
{
  
  int fd,i,j,junk;
  int data_top, old_brk, cur_brk, new_mem_sofar;
  int gimmy,  num_sbrks_sofar, psize;
  char *myarr;
  char write_buf[WRITE_BUF_SIZE], read_buf[READ_BUF_SIZE];
  char small_buf[SMALL_BUF_SIZE];
  struct rlimit rls;
  char dummy_file_name[15];
  int close(), fstat(), ioctl(), read(), write();
  int sbrk(), getpagesize(), getrlimit(), setrlimit();
  
  int sys,usr,file_op,rw_op,mem_op,misc_op;
  

  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* SYSTEM CALLS                      */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* file operations                   */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  sprintf(dummy_file_name,"%d",getpid());
  strcat(dummy_file_name,".temp");
  
  if ((fd = open(dummy_file_name,O_CREAT,0755)) < 0) 
    {
      fprintf(stderr, "couldn't create %s\n",dummy_file_name);
      exit(1);
    } 
  else 
    if (close(fd) < 0) 
      {
	fprintf(stderr, "couldn't close %s\n",dummy_file_name);
	exit(1);
      }
  
  for (i = 0; i < SMALL_BUF_SIZE; i++)
    small_buf[i] = 'a';
  
  for (i = 0; i < OPEN_CALLS; i++) 
    {
      fd = open(dummy_file_name, O_RDWR, 0);
      if (fd < 0) 
	{
	  fprintf(stderr, "Couldn't open %s\n",dummy_file_name);
	  exit(1);
	}

      write(fd,small_buf,SMALL_BUF_SIZE);

      if (close(fd) != 0) 
	{
	  fprintf(stderr, "Couldn't close %s\n",dummy_file_name);
	  exit(1);
	}
    }

  unlink(dummy_file_name); 
  

  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* file reads 'n writes              */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  
  sprintf(dummy_file_name,"%d",getpid());
  strcat(dummy_file_name,".temp");
  
  if ((fd = open(dummy_file_name,O_CREAT,0755)) < 0) 
    {
      fprintf(stderr, "couldn't create %s\n",dummy_file_name);
      exit(1);
    } 
  else 
    if (close(fd) < 0) 
      {
	fprintf(stderr, "couldn't close %s\n",dummy_file_name);
	exit(1);
      }
  

  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* create data to write              */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  for (i = 0; i < WRITE_BUF_SIZE; i++)
    write_buf[i] = 'a';
  
  if ((fd = open(dummy_file_name,O_RDWR,0)) < 0) 
    {
      fprintf(stderr, "couldn't create %s\n",dummy_file_name);
      exit(1);
    } 
  else 
    {
      for (i = 0; i < WRITE_CALLS; i++)
	{
	  if (write(fd, write_buf, WRITE_BUF_SIZE) < 0) 
	    {
	      fprintf(stderr, "couldn't write \n");
	      exit(1);
	    }
	}
      
      if (lseek(fd,0,0) < 0) 
	{ 
	  fprintf(stderr, "couldn't lseek \n");
	  exit(1);
	}
      
      for (i = 0; i < READ_CALLS; i++) 
	{
	  if (read(fd, read_buf, READ_BUF_SIZE) < 0) 
	    {
	      fprintf(stderr, "couldn't write \n");
	      exit(1);
	    }  
	}
      if((fsync(fd)!=0 ))
	{
	  fprintf(stderr,"couldn't fsync \n");
	}
      if (close(fd) < 0) 
	{
	  fprintf(stderr, "couldn't close %s\n",dummy_file_name);
	  exit(1);
	}
    }
  
  unlink(dummy_file_name); 


  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* memory management                 */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  num_sbrks_sofar = 0;
  gimmy = GIMMY_TOTAL/SBRK_CALLS;
  
  new_mem_sofar = 0;
  
  cur_brk = (int) sbrk(0);
  
  data_top = cur_brk;

  while ((new_mem_sofar < GIMMY_TOTAL) || 
	 (num_sbrks_sofar < SBRK_CALLS)) 
    {
      num_sbrks_sofar = num_sbrks_sofar + 1;
      old_brk = cur_brk;
      if ((GIMMY_TOTAL - new_mem_sofar) < gimmy)
	gimmy = GIMMY_TOTAL - new_mem_sofar;
      
      cur_brk = (int) sbrk(gimmy);
      
      cur_brk = (int) sbrk(0);  
      
      for (data_top = old_brk; data_top <= cur_brk; 
	   data_top = data_top + 1024) 
	{
	  myarr = (char *)data_top;
	  *myarr = 'a';
	}

      data_top = (int)myarr;
      cur_brk = (int) sbrk(0);
      new_mem_sofar = new_mem_sofar + (cur_brk - old_brk);
    }
  

  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
  /* misc system call                  */
  /*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

  for (i = 0; i < SIGVEC_CALLS; i++)
    {
      signal(SIGFPE,SIG_DFL);
    }

  exit(0);
}
