
/*********************************************************************
*
* Name        : solve.c
*
* Version     : 0.8 (Release Version)
*
* Description : The actual routines that solve the scrambled puzzle.
*               Timing is done form the start of the solution process 
*               till the end. 
*               
*
* Written by  : Aju John & Dhruve Shah.
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
* Rev History : Modified by Aju John in July 1990, to include timing
*               routines.
*-RCS-
 $Log$
************************************************************************/


/* include files */
#include <stdio.h>
#include <sys/types.h>
#include "timing.h"     /* timing details */
#include "glob.h"       /* file containing global declarations */
#include "defines.h"    /* file containing global definitions  */



/*****************************************************************************
 solve.c: Function that 

 Input(s): void
 Returns : the required size of the puzzle.
 Output  : none
 routines called: none    
                    
 ****************************************************************************/
unsigned long   time_diff;

solve(size_of_jigsaw)
int size_of_jigsaw;

{

  SET_PTR   pair;
  TILE_PTR  *jigsaw_matrix, start, head, ptr, prev, make_random_list(); 
  int total_pairs;
  int i,j,k;
  FILE *file3, *file4;

  printf("Solving the puzzle...");

  if (!(jigsaw_matrix = (TILE_PTR*) calloc (size_of_jigsaw, sizeof(TILE_PTR))))
    {
      printf ("Error in calloc at X01 \n");
      exit(-1);
    }


  for(i=0;i<size_of_jigsaw;i++)
    {
      jigsaw_matrix[i] = (TILE*) calloc (size_of_jigsaw, sizeof(TILE));
    }

  
  file3 = fopen("jumble.out","r");
  if (file3 == NULL)
    {
      printf("\nError: X02 - Cannot open file:jumble.out.\n");
      exit(-1);
    }


  head = start;
  for(i=0; i<size_of_jigsaw; i++)
    for(j=0; j<size_of_jigsaw; j++)  
      {

	jigsaw_matrix[i][j].match_north     =  INITIAL_VALUE;
	jigsaw_matrix[i][j].match_south  =  INITIAL_VALUE;
	jigsaw_matrix[i][j].match_west    =  INITIAL_VALUE;
	jigsaw_matrix[i][j].match_east   =  INITIAL_VALUE;
	jigsaw_matrix[i][j].count=  0;
	jigsaw_matrix[i][j].next = NULL;


	fscanf(file3,"%d %d %d %d %d\n",&jigsaw_matrix[i][j].identity,&jigsaw_matrix[i][j].east,&jigsaw_matrix[i][j].west,&jigsaw_matrix[i][j].north,&jigsaw_matrix[i][j].south);
	if ((j+1)%size_of_jigsaw)
	    jigsaw_matrix[i][j].next = &jigsaw_matrix[i][j+1];
	else
	    jigsaw_matrix[i][j].next = &jigsaw_matrix[i+1][0];
      }
  fclose(file3);


  head = &jigsaw_matrix[0][0];




arrange(head,size_of_jigsaw);

}

arrange(head, size)
TILE_PTR head;
int size;
{
  TILE_PTR  c, t;
  int tot;
  int time_val;
  char *ver;

  ver = (char *)calloc( 60, sizeof(char));
  strcpy(ver,"$Id: solve.c,v 1.0 91/01/12 10:05:15 aju Exp Locker: aju $");
  ver[28] = 0;
  ver += 13; 
  tot = size * size * 4;
  c = head;

/* timing starts */	
	begin_timing();


  while( c!= NULL && tot > 0 ){
    t = c->next;
    while ( (c->count != 4) && (t!= NULL) ){
      if ( (c->match_south == -1) && (c->south % t->north  == KEY) ){
	c->match_south = t->identity;
	t->match_north = c->identity;
        ++(c->count);++(t->count);
	tot -= 2;
      }
      if ( (c->match_east == -1) && (c->east % t->west == KEY) ){
	c->match_east = t->identity;
	t->match_west = c->identity;
	++(c->count);++(t->count);
	tot -= 2;
      }
      if ( (c->match_west == -1) && (t->east % c->west == KEY) ){
	c->match_west = t->identity;
	t->match_east = c->identity;
	++(c->count);++(t->count);
	tot -= 2;
      }
      if ( (c->match_north == -1) && (t->south % c->north  == KEY) ){
	c->match_north  = t->identity;
	t->match_south = c->identity;
	++(c->count);++(t->count);
	tot -= 2;
      }
      t = t->next; 
    }
    c = c->next; 
  }

/* timing ends */
  printf("Done.\n");
  end_timing();

  wpi_banner("Jigsaw Puzzle Benchmark", ver);
  printf ("Puzzle size: %dx%d, Tile size: %d bytes\n", size,size,sizeof(TILE));
  printf ("Time taken for solving the puzzle: %d milliseconds\n", time_diff);
  printf("----------------------------------------------------\n\n\n\n");
  /** to check validity of solution.
    while ( head != NULL)
    {
    printf("%d %d %d %d %d\n",head->identity,head->match_east,head->match_west,head->match_north,head->match_south);
    head = head->next;
    }
   **/
}

/* $Header$ */




