double second_();

main ()
{
	int i;
	double f1,f2,f3,f4;

	f2 = 2345.2345;
	f3 = 4536.5467;
	f4 = 2435.9788;
	
	for (i=0;i<1000000;i++) {
		f1 = f2 * f3 / f4;
	}

	printf("second()=%20.10e\n\n",(double)second_());
}


#ifdef UCB
#include <sys/time.h>
#include <sys/resource.h>

double
second_ ()
{
    struct rusage ru;

#ifdef MOXIE
    static unsigned count = 0;
    static unsigned stop;
    extern unsigned __Argc;
    extern char **__Argv;
    if (count == 0 && __Argc > 1) {
	stop = atoi(__Argv[__Argc-1]);
    }
    count += 1;
    if (count == stop) exit(0);
#endif

    getrusage (0, &ru);
    return ((double)ru.ru_utime.tv_sec + ((double)ru.ru_utime.tv_usec / 1.0e6));
}
#else

#include <sys/types.h>
#include <sys/times.h>
double
second_()
{
	struct tms buf;
	long t;
	t = times(&buf);
	return(buf.tms_utime*0.01);         /* 1 tick = 1/100 sec */
}
#endif
