/*
 * NAME
 *     Unidel.h -- Basic, global definitions used all over Unidel
 *
 * AUTHOR
 *     Ken MacLeod
 *
 * SCCS
 *     @(#) Unidel.h  1.1 11/7/90 09:55:27 
 */

/*----------------------------------------------------------------------------
 * Define general things used everywhere.
 */
 
#define _findPartial 0x00000001l
#define _findExact 0x00000000l

#define _normal 0x0000
#define _noEcho 0x0001
#define _upperCase 0x0002
#define _lowerCase 0x0004
#define _defaultAnswer 0x0008
#define _defaultYes 0x0010

#define _keyLeft 0x100
#define _keyRight 0x101
#define _keyUp 0x102
#define _keyDown 0x103
#define _keyAbort 0x104

#define _true 1
#define _false 0

extern char *programName;
extern char errorString[];

/* Modes of various sorts */
extern int more;		/* 1 = PrintArticle stops at the end of screens and pages, 2 = stops after title */
extern int local;		/* _true = local logon, _false = remote */
extern int floorMode;
extern int expertMode;
extern int guest;
extern int finished;
extern FILE *dumpFile;		/* file where output is going, usually 'stdout' */

extern char *months[12], *days[7];

typedef struct {
	char command[4];
	char *printString[4];
	long selector;
	int (*function) ();
} Menu;

extern Menu mainMenu[];
extern Menu readTypesSubMenu[];
extern char *selectorStrings[];

/*----------------------------------------------------------------------------
 * Declare functions that return a pointer type, but are not declared in any
 * standard header file.
 */

char	*getenv ();
char	*KeepString (/* char *string */);
