/*
 * NAME
 *     ReadMesg.c -- Message reading commands and functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) ReadMesg.c  1.7 30 Sep 1991 21:05:15\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <fgetmfs.h>
#include <time.h>
#include <ctype.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "Message.h"

extern char *hdr[], *hdrFieldNames[];
static char *Who ();

void StrCat ();

static int position;
#define _atHeader 0
#define _atTop 1
#define _inMiddle 2
#define _atBottom 3

extern int linesLeft;		/* number of lines left */
extern int numLines;		/* number of lines to a screen */

/* XXX These should be in a structure and each instance local to PrintArticle */
/* XXX Put 'hdr' here with these */
static FILE *articleFile;
static char *articleFileName;
static int articleNum;		/* Relative article number,
							   < 0 if not an article, -1 if has header */
static long bytes;
static long length;
static long startOfBody;	/* File position after ReadHeader */
static int done;			/* _true to end reading */
static int reading;			/* _false to end reading this message */
static int whoa;			/* _true to do display "--More--" */
static int backFlag;		/* _true if we want to go back an article */
static int backErase;		/* Characters to erase from prompt */
static int noSig = _true;	/* Don't print after "-- \n" */

static int MorePageDown (), MorePageUp (), MoreLineDown (), MoreLineUp ();
static int MoreArtNext (), MoreArtPrev ();
static int MoreDownload (), MoreFollowup (), MoreReply (), MoreDisplayHeader ();
static int MoreStop (), MoreCancel (), MoreHelp ();
#ifdef REMIND
static int MoreUpdate ();
#endif

static Menu moreMenu[] = {
	"?", "=", NULL, NULL, NULL, 0l, MoreHelp,
	" ", "=", NULL, NULL, NULL, 0l, MorePageDown,
	"\n", "=", NULL, NULL, NULL, 0l, MoreLineDown,
	"B", "=", NULL, NULL, NULL, 0l, MoreArtPrev,
	"C", "=", NULL, NULL, NULL, 0l, MoreCancel,
	"D", "=", NULL, NULL, NULL, 0l, MoreDownload,
	"F", "=", NULL, NULL, NULL, 0l, MoreFollowup,
	"H", "=", NULL, NULL, NULL, 0l, MoreDisplayHeader,
	"L", "=", NULL, NULL, NULL, 0l, MoreLineUp,
	"N", "=", NULL, NULL, NULL, 0l, MoreArtNext,
	"R", "=", NULL, NULL, NULL, 0l, MoreReply,
	"S", "=", NULL, NULL, NULL, 0l, MoreStop,
	"Q", "=", NULL, NULL, NULL, 0l, MoreStop,
	"U", "=", NULL, NULL, NULL, 0l, MorePageUp,

	/* End of list */
	"", NULL, NULL, NULL, NULL, 0l, NULL,
};

int
PrintMessage (flags, fileName, article, back)

long flags;
char *fileName;		/* article file name */
int article;		/* article relative number,
					   < 0 if not an article, -1 if has header */
int back;			/* We've come back to this article, no skipping */

{
	void ClearHeader (), FreeHeader ();
	char moreBuf[_bufSize];

	if (flags & _readMoreDefault)
		more = moreDefault;
	else if (flags & _readMore)
		more = 1;
	else
		more = 0;
	articleNum = article;
	articleFileName = fileName;
	done = _false;
	if ((articleFile = fopen (fileName, "r")) == NULL)
		return (-1);
	if (article >= -1) {
		ClearHeader (hdr, hdrFieldNames);
		(void) ReadHeader (articleFile, hdr, hdrFieldNames);
		if (!back && !(flags & _readAll) && hdr[_hdrNewsgroups] && BetterNewsgroup (hdr[_hdrNewsgroups])) {
			if (!(flags & _readHeaders))
				PrintRealShortHeader (hdr, article);
			goto outtaHere;
		}
		if (flags & _readHeaders) {
			PrintRealShortHeader (hdr, article);
			goto outtaHere;
		}
	}
	startOfBody = ftell (articleFile);
	(void)fseek (articleFile, 0l, 2);
	length = ftell (articleFile) - startOfBody;
	(void)fseek (articleFile, startOfBody, 0);
	if (length <=0)
		length = 1;
	bytes = 1;

	numLines = lines;

	position = _atHeader;
	reading = _true;
	whoa = _false;
	backFlag = _false;
	do {
		if (article >= -1 && position == _atHeader) {
			if (more >= 2)
				linesLeft = lines;
			PrintShortHeader (hdr, article);
			if (hdr[_hdrUploadFile] != NULL) {
				position = _atBottom;
				(void)fseek (articleFile, 0l, 2);
			} else {
				position = _atTop;
				if (more >= 2)
					whoa = _true;
			}
		}
		if (whoa) {
			whoa = _false;
			(void) sprintf (moreBuf, "--More--(%d%%)", (int) (bytes*100/length));
			backErase = strlen (moreBuf);
			(void) printf ("%s", moreBuf);
			(void) DoMenu (flags, moreMenu);
		} else if (PrintFileLine (articleFile, length, flags, moreMenu) == EOF) {
			/* XXX stop at bottom?  External pager? */
			position = _atBottom;
			break;
		}
	} while (reading && !done);

outtaHere:
	(void) fclose (articleFile);
	if (article >= -1)
		FreeHeader (hdr, hdrFieldNames);
	if (done)
		return (2);
	else
		return (backFlag);
}

/* ARGSUSED */
static int
MoreHelp (dummy)

long dummy;

{
	BackErase (backErase);
	(void) printf ("Help\n");
	Help ("more");
	whoa = _true;
	return (0);
}

/* ARGSUSED */
static int
MoreDownload (dummy)

long dummy;

{
	BackErase (backErase);
	(void) printf ("Download\n");
	if (hdr[_hdrUploadFile])
		ReadFile (hdr[_hdrUploadFile]);
	else
		ReadFile (articleFileName);
	whoa = _true;
	return (0);
}

/* ARGSUSED */
static int
MoreFollowup (dummy)

long dummy;

{
	int followupToPoster;

	BackErase (backErase);
	(void) printf ("Followup\n");
	if (articleNum < 0) {
		(void) printf ("Not a message, can't followup.\n");
	} else {
		followupToPoster = hdr[_hdrFollowupTo]
						   && (strcmp (hdr[_hdrFollowupTo], "poster") == 0);
		if (followupToPoster)
			(void) printf ("Followups have been directed to be emailed to the author.\n");
		if (EnterMessage (0l, articleFileName, followupToPoster))
			(void) printf ("Article not %s.\n", followupToPoster ? "mailed" : "posted");
	}
	whoa = _true;
	return (0);
}

/* ARGSUSED */
static int
MoreReply (dummy)

long dummy;

{
	BackErase (backErase);
	(void) printf ("Reply to author\n");
	if (articleNum < -1) {
		(void) printf ("Not a message, can't reply.\n");
	} else if (EnterMessage (0l, articleFileName, _true))
		(void) printf ("Mail not sent.\n");
	whoa = _true;
	return (0);
}

/* ARGSUSED */
static int
MoreDisplayHeader (dummy)

long dummy;

{
	BackErase (backErase);
	if (articleNum < -1) {
		(void) printf ("Not a message, no header.\n");
		whoa = _true;
	} else {
		PrintHeader (articleFile);
		(void)fseek (articleFile, startOfBody, 0);
		position = _atTop;
	}
	return (0);
}

/* ARGSUSED */
static int
MoreStop (dummy)

long dummy;

{
	BackErase (backErase);
	done = _true;
	return (0);
}

/* ARGSUSED */
static int
MoreCancel (dummy)

long dummy;

{
	char *copyOfFrom, *author, *fullname, *sitename;

	BackErase (backErase);
	if (articleNum < 0) {
		(void) printf ("Not a message, can't cancel.\n");
	} else {
		(void) printf ("Cancel\n");
		copyOfFrom = NULL;
		if (hdr[_hdrFrom]) {
			AllocString ("MoreCancel", &copyOfFrom, hdr[_hdrFrom]);
			BreakFrom (copyOfFrom, &author, &fullname, &sitename);
		}
		if ((hdr[_hdrFrom] && author
		               && (strcmp (author, logname) == 0)
			           && sitename && (IsIn (_siteName, sitename)))) {
			if (AnswerYesNo ("Cancel this message (Y/[N])? ", _defaultAnswer)) {
				(void) printf ("Oops, this ain't written yet.\n");
				/* reading = _false; */
			}
		}
		if (copyOfFrom)
		  (void)free ((malloc_t)copyOfFrom);
	}
	whoa = _true;
	return (0);
}

/* ARGSUSED */
static int
MorePageDown (dummy)

long dummy;

{
	BackErase (backErase);
	position = _inMiddle;
	return (0);
}

/* ARGSUSED */
static int
MorePageUp (dummy)

long dummy;

{
	BackErase (backErase);
	/* XXX go figure */
	return (0);
}

/* ARGSUSED */
static int
MoreLineDown (dummy)

long dummy;

{
	BackErase (backErase);
	position = _inMiddle;
	linesLeft = 1;
	return (0);
}

/* ARGSUSED */
static int
MoreLineUp (dummy)

long dummy;

{
	BackErase (backErase);
	/* XXX Go figure */
	return (0);
}

/* ARGSUSED */
static int
MoreArtNext (dummy)

long dummy;

{
	BackErase (backErase);
	reading = _false;
	return (0);
}

/* ARGSUSED */
static int
MoreArtPrev (dummy)

long dummy;

{
	BackErase (backErase);
	if (position == _atTop) {
		reading = _false;
		backFlag = _true;
	} else {
		(void) fseek (articleFile, startOfBody, 0);
		position = _atHeader;
		bytes = 1;
	}
	return (0);
}

#ifdef REMIND
static int
MoreUpdate (dummy)

long dummy;

{
	BackErase (backErase);
	(void) printf ("Update\n");
	if (articleNum < 0) {
		(void) printf ("Not a message, can't update.\n");
	} else {
		/* XXX Well?  Where's the remind? */
	}
	whoa = _true;
	return (0);
}
#endif

PrintFileLine (file, fileLength, flags, menu)

FILE *file;
long fileLength, flags;
Menu *menu;

{
	int eof;
	char *fileLine;

	eof = _true;
	if ((fileLine = fgetms (file)) != NULL) {
		bytes += strlen (fileLine);
		PrintLine (fileLine, (int) (bytes*100/fileLength), flags, menu);
		eof = noSig && (strcmp (fileLine, "-- \n") == 0);
		(void)free ((malloc_t)fileLine);
	}
	return (eof ? EOF : 0);
}

PrintLine (string, percent, flags, menu)

char *string;
int percent;
long flags;
Menu *menu;

{
	char moreBuf[_bufSize];
	char lineBuf[_bufSize];
	int i;

	/* XXX implement term width */
	i = 0;
	while (*string) {
	  lineBuf[i] = *string;
		if (++i == 80 || *string == '\n') {
		  lineBuf[i] = '\0';
		  fputs (lineBuf, dumpFile);
			linesLeft --;
			if (linesLeft <= 1) {
				linesLeft = 1;	/* If we don't have a menu, stop next time we do */
				if (menu && more >= 1) {
					linesLeft = lines;
					(void) sprintf (moreBuf, "--More--(%d%%)", percent);
					backErase = strlen (moreBuf);
					(void) printf ("%s", moreBuf);
					(void) DoMenu (flags, menu);
				}
			}
			i = 0;
		}
		string ++;
	}
}

PrintRealShortHeader (hdr, article)

char *hdr[];
int article;

{
	time_t messageTime, parsedate (), time ();
	struct tm *tm;
	char *who;
	char msgDate[128], *copyOfTitle;
	char articleNumFlags[20], articleNum[20];
	int i;

	who = Who (hdr[_hdrFrom], hdr[_hdrOrganization]);
	if (who && strlen (who) > 25)
		who[25] = '\0';

	if (hdr[_hdrDate]) {
		messageTime = parsedate (hdr[_hdrDate], NULL);
		tm = localtime (&messageTime);
		if (messageTime < (time ((long *) 0) - 7 * 24 * 60 * 60))
			(void) sprintf (msgDate, "%s %2d", months[tm -> tm_mon],
			  tm -> tm_mday);
		else
			(void) sprintf (msgDate, "%s %2d:%2.2d", days[tm -> tm_wday],
			  tm -> tm_hour, tm -> tm_min);
	} else {
		(void) strcpy (msgDate, "(no date)");
	}

	copyOfTitle = NULL;
	if (hdr[_hdrSubject]) {
		AllocString ("PrintRealShortHeader", &copyOfTitle, hdr[_hdrSubject]);
		if (strlen (copyOfTitle) > (columns - 47))
			copyOfTitle[columns - 47] = '\0';	/* truncate title so we don't wrap */
	}

	i = 0;
	if (articles[article].read)
		articleNumFlags[i++] = 'O';
	if (articles[article].checked)
		articleNumFlags[i++] = 'X';
	if (hdr[_hdrPriority] && (hdr[_hdrPriority][0] >= '0') && (hdr[_hdrPriority][0] <= '9') && (atoi (hdr[_hdrPriority]) < 10))
		articleNumFlags[i++] = hdr[_hdrPriority][0];
	else if (hdr[_hdrPriority])
		articleNumFlags[i++] = 'P';
	if (hdr[_hdrNewsgroups]) {
		if (BetterNewsgroup (hdr[_hdrNewsgroups]))
			articleNumFlags[i++] = '<';
		else if (strchr (hdr[_hdrNewsgroups], ',') != NULL)
			articleNumFlags[i++] = '>';
	}
	for (; i < 7; i ++)
		articleNumFlags[i] = ' ';
	(void) sprintf (articleNum, "%7d", article + 1);
	for (i = 7; (i >= 0) && (articleNum[i] != ' '); i --)	/* This copies the terminator first, then the num */
		articleNumFlags[i] = articleNum[i];

	(void) printf ("%7s %-25s  %-9s  %s\n", articleNumFlags, who ? who : "Unknown",
	               msgDate, copyOfTitle ? copyOfTitle : "");

	if (copyOfTitle)
	  (void)free ((malloc_t)copyOfTitle);
	if (who)
	  (void)free ((malloc_t)who);
}

PrintShortHeader (hdr, article)

char *hdr[];
int article;

{
	char tempBuffer[_bufSize * 4], lineBuffer[_bufSize * 4];
	char *who, *copyOfSubject;
	int i;
	time_t messageTime, parsedate ();
	struct tm *tm;

	if (dumpFile != stdout)
		(void) fprintf (dumpFile, " ----- \n");	/* A marker that can be used to separate messages */
	if ((article > 0) && rooms[currentRoom].displayNumber || floors[currentFloor].displayNumber) {
		if (dumpFile == stdout)
			(void) sprintf (tempBuffer, "%d/%d -- ", article + 1, numArticles);
		else
			(void) sprintf (tempBuffer, "%s -- ", hdr[_hdrMessageID]);
		StrCat (lineBuffer, tempBuffer);
	} else {
		StrCat (lineBuffer, "   ");
	}
	if (rooms[currentRoom].anonymous || floors[currentFloor].anonymous)
		StrCat ((char *) NULL, "*****");
	else {
		if (hdr[_hdrDate]) {
			messageTime = parsedate (hdr[_hdrDate], NULL);
			tm = localtime (&messageTime);
			(void) sprintf (tempBuffer, "%2d%s%2.2d %d:%2.2d %cm",
			  tm -> tm_year, months[tm -> tm_mon], tm -> tm_mday,
			  tm -> tm_hour % 12, tm -> tm_min,
			  (tm -> tm_hour / 12) == 0 ? 'a' : 'p');
			StrCat ((char *) NULL, tempBuffer);
		}
		who = Who (hdr[_hdrFrom], hdr[_hdrOrganization]);
		if (who) {
			StrCat ((char *) NULL, " from ");
			StrCat ((char *) NULL, who);
			(void)free ((malloc_t)who);
		}
	}
	StrCat ((char *) NULL, "\n");
	PrintLine (lineBuffer, 0, 0l, (Menu *) NULL);

	if (hdr[_hdrSubject]) {
		copyOfSubject = NULL;
		AllocString ("PrintHeader", &copyOfSubject, hdr[_hdrSubject]);
		(void)strcpy (tempBuffer, hdr[_hdrSubject]);
		for (i = 0; tempBuffer[i] != '\0'; i ++) {
			if (isupper (tempBuffer[i]))
				tempBuffer[i] = tolower (tempBuffer[i]);
		}
		if ((strcmp (tempBuffer, "(none)") != 0) && (strcmp (tempBuffer, "re: (none)") != 0)) {
			(void) sprintf (tempBuffer, "   Subject: %s\n", hdr[_hdrSubject]);
			PrintLine (tempBuffer, 0, 0l, (Menu *) NULL);
		}
		(void)free ((malloc_t)copyOfSubject);
	}
	if (hdr[_hdrSummary]) {
		(void) sprintf (tempBuffer, "   Summary: %s\n", hdr[_hdrSummary]);
		PrintLine (tempBuffer, 0, 0l, (Menu *) NULL);
	}
	if (hdr[_hdrKeywords]) {
		(void) sprintf (tempBuffer, "   Keywords: %s\n", hdr[_hdrKeywords]);
		PrintLine (tempBuffer, 0, 0l, (Menu *) NULL);
	}
}

PrintHeader (article)

FILE *article;

{
	char *headerLine;
	char sigBuffer[_bufSize * 4];
	int i, sigIndex, aChar;

	(void)fseek (article, 0l, 0);
	/* Print header of article */
	while ((headerLine = fgetms (article)) != NULL) {
		if (headerLine[0] == '\n') {
		  (void)free ((malloc_t)headerLine);
			break;
		}
		PrintLine (headerLine, 0, 0l, (Menu *) NULL);
		(void)free ((malloc_t)headerLine);
	}

	/* Print signature of article */
	sigIndex = 0;
	while ((aChar = getc (article)) != EOF) {
		if (aChar == signature[sigIndex]) {
			sigIndex ++;
			if (signature[sigIndex] == '\0') {
				break;
			}
		} else
			sigIndex = 0;
	}
	if (aChar != EOF) {
		PrintLine (signature, 0, 0l, (Menu *) NULL);
		i = 0;
		while ((aChar = getc (article)) != EOF) {
			sigBuffer[i++] = aChar;
			if (aChar == '\n') {
				sigBuffer[i] = '\0';
				PrintLine (sigBuffer, 0, 0l, (Menu *) NULL);
				i = 0;
			}
		}
	}
}

BackErase (characters)

int characters;

{
  char lineBuf[_bufSize*3], *ptr;

  ptr = lineBuf;
	while (characters--) {
	  *ptr++ = '\b';
	  *ptr++ = ' ';
	  *ptr++ = '\b';
	}
  *ptr = '\0';
  fputs (lineBuf, stdout);
}

BetterNewsgroup (string)
/* returns _true if there is a more appropriate newsgroup for this article than the current one */

char *string;

{
	char *copyOfString, *ptr;
	int i;

	copyOfString = NULL;
	AllocString ("BetterNewsgroup", &copyOfString, string);
	for (ptr = strtok (copyOfString, ","); ptr != NULL; ptr = strtok ((char *) NULL, ",")) {
		if (strcmp (rooms[currentRoom].name, ptr) == 0) {
		  (void)free ((malloc_t)copyOfString);
			return (_false);
		} else {
		  for (i = 0; rooms[i].name != NULL; i ++) {
		    if (!floors[rooms[i].floor].forgotten && !rooms[i].forgotten
			&& (strcmp (rooms[i].name, ptr) == 0)) {
		      (void)free ((malloc_t)copyOfString);
		      return (_true);
		    }
		  }
		}
	}
	(void)free ((malloc_t)copyOfString);
	return (_false);
}

BreakFrom (line, author, fullname, sitename)

register char *line;
char **author, **fullname, **sitename;

{
	char *ptr;

	*author = line;
	*fullname = *sitename = NULL;
	/*
		Parse to '@' if "user@site" form, or to '<' if
		"full name <address>" form, or to '!' if it's
		siteA!siteB!user
	*/
	while (*line && *line != '@' && *line != '<' && *line != '!')
		line ++;

	switch (*line) {
	case '@':	/* It's "user@site" */
		*line++ = '\0';
		*sitename = line;
		while (*line && !(*line == ' ' || *line == '\t'))
			line ++;
		if (*line) {	/* Wow! there might be a "(full name)" */
			*line++ = '\0';
			while (*line && (*line == ' ' || *line == '\t'))
				line ++;
			if (*line++ == '(') {	/* Yep! */
				*fullname = line;
				while (*line)		/* We'll go straight to the end */
					line ++;
				if (*(--line) == ')')	/* and work back one */
					*line = '\0';
			}
		}
		break;
	case '<':	/* It's "full name <address>" */
		*fullname = *author;
		ptr = line - 1;
		/* clear any trailing spaces on full name */
		while (ptr > *fullname && (*ptr == ' ' || *ptr == '\t'))
			*ptr-- = '\0';
		line++;
		*author = line;
		while (*line && *line != '@' && *line != '!')
			line ++;
		if (*line == '@') {	/* 'address' is "user@site" */
			*line ++ = '\0';
			*sitename = line;
			while (*line && *line != '>')
				line ++;
		} else if (*line == '!') {	/* 'address' is "siteA!siteB!user" */
			*sitename = *author;
			*author = line + 1;
			*line ++ = '\0';
			while (*line && *line != '>') {
				if (*line == '!') {
					*sitename = *author;
					*author = line + 1;
					*line = '\0';
				}
				line ++;
			}
		}
		*line = '\0';
		break;
	case '!':	/* It's "siteA!siteB!user" */
		*sitename = *author;
		*author = line + 1;
		*line ++ = '\0';
		while (*line && *line != ' ' && *line != '\t') {
			if (*line == '!') {
				*sitename = *author;
				*author = line + 1;
				*line = '\0';
			}
			line ++;
		}
		if (*line) {	/* Wow! there might be a "(full name)" */
			*line++ = '\0';
			while (*line && (*line == ' ' || *line == '\t'))
				line ++;
			if (*line++ == '(') {	/* Yep! */
				*fullname = line;
				while (*line)		/* We'll go straight to the end */
					line ++;
				if (*(--line) == ')')	/* and work back one */
					*line = '\0';
			}
		}
		break;
	}
}

static char *
Who (from, org)

char *from, *org;

{
	char *who, *copyOfFrom, *author, *fullname, *sitename;
	int i;

	copyOfFrom = NULL;
	if (from) {
		AllocString ("Who", &copyOfFrom, from);
		BreakFrom (copyOfFrom, &author, &fullname, &sitename);
	} else
		author = fullname = sitename = NULL;

	if (fullname)
		author = fullname;

	if (org) {
		if (strcmp (org, _organization) == 0)
			sitename = NULL;	/* Don't use org if it's ours */
		else
			sitename = org;
	}

	if (sitename && !author)
		author = "Unknown";

	if (author) {
		i = strlen (author);
		who = (char *)malloc ((size_t) (i + 1 + (sitename ? strlen (sitename) + 1 : 0)));
		if (!who)
			ErrorLog ("Who", _fatalError, "Out of memory.");
		(void)strcpy (who, author);
		if (sitename) {
			who[i] = '@';
			(void)strcpy (&who[i+1], sitename);
		}
	} else
		who = NULL;

	if (copyOfFrom)
	  (void)free ((malloc_t)copyOfFrom);

	return (who);
}
