/*
 * NAME
 *     ReadFile.c -- File reading (download) functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) ReadFile.c  1.3 06 Jun 1991 18:02:31\n\t";
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <time.h>
#include <malloc.h>
#include <stdio.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "File.h"

static char *fileFieldNames[] = {
	"File: ",
	"Desc: ",
	"User: ",
	"Date: ",
	NULL,
};
static char *ExpandFiles ();

/* ARGSUSED */
int
ReadFileCommand (type)

long type;

{
	char fileNames[_bufSize], *expandedList;

	if (rooms[currentRoom].fileDir == NULL) {
		(void) printf ("Files are only in rooms that end with \"]\".\n");
		return;
	}

	(void) printf ("Enter filename(s):\n:");
	GetString (&fileNames[0], _normal);
	if (fileNames[0] == '\0') {
		return;
	}
	if ((expandedList = ExpandFiles (&fileNames[0])) == NULL)
		return;

	ReadFile (expandedList);

	/*(void)free ((malloc_t)expandedList);*/
}

ReadFile (fileNames)

char *fileNames;

{
	char *commandString, *commandString1, destFileName[_bufSize], readyQuestion[_bufSize], *oneFile;

	if (local) {
		(void) printf ("Download to: ");
		GetString (destFileName, _normal);
		if (destFileName[0] != '\0') {
			commandString = (char *)malloc ((size_t) (strlen (destFileName) + strlen (fileNames)) + 80);
			(void) sprintf (commandString, "exec cp %s %s", fileNames, destFileName);
			(void)system (commandString);
			(void)free ((malloc_t)commandString);
		}
	} else {
		if (transferProtocol == NULL) {
			(void) printf ("You have not selected a transfer protocol.\n", transferProtocol);
			return;
		}
		if (transferReadCommand == NULL) {
			(void) printf ("%s transfer not implemented.\n", transferProtocol);
			return;
		}
		/* 80 is a catchall for the 'exec' call below */
		commandString = (char *)malloc ((size_t) (strlen (transferReadCommand) + strlen (fileNames)) + 80);
		commandString1 = (char *)malloc ((size_t) (strlen (transferReadCommand) + strlen (fileNames)) + 1);
		(void) sprintf (readyQuestion, "Ready for %s download? ", transferProtocol);
		if (transferBatch) {
			if (AnswerYesNo (readyQuestion, _defaultAnswer | _defaultYes | _noEcho) == _true) {
				(void) sprintf (commandString1, transferReadCommand, fileNames);
				(void) sprintf (commandString, "cd %s ; exec %s", rooms[currentRoom].fileDir ? rooms[currentRoom].fileDir : ".", commandString1);
/*				(void) sprintf (commandString, "export SHELL PATH ; SHELL=/bin/rsh PATH=/usr/rbin cd %s ; exec %s", rooms[currentRoom].fileDir, commandString1);*/
				(void) system (commandString);
			}
		} else {
			oneFile = strtok (fileNames, " ");
			while (oneFile != NULL) {
				if (AnswerYesNo (readyQuestion, _defaultAnswer | _defaultYes | _noEcho) == _true) {
					(void) sprintf (commandString1, transferReadCommand, oneFile);
					(void) sprintf (commandString, "cd %s ; exec %s", rooms[currentRoom].fileDir ? rooms[currentRoom].fileDir : ".", commandString1);
/*					(void) sprintf (commandString, "export SHELL PATH ; SHELL=/bin/rsh PATH=/usr/rbin cd %s ; exec %s", rooms[currentRoom].fileDir, commandString1);*/
					(void) system (commandString);
				} else
					break;
				oneFile = strtok ((char *) NULL, " ");
			}
		}
		(void)free ((malloc_t)commandString);
		(void)free ((malloc_t)commandString1);
	}
}

ReadDirectory (extended)

long extended;

{
	void ClearHeader (), FreeHeader ();
	FILE *fileList;
	struct stat statBuffer;
	char *fileDesc[_maxFileFields];
#ifdef useRegex
	char *re, *regcmp (), *regex (), *dummy, *lcTemp;
#endif
	char fileListName[_bufSize];
	char matchPattern[_bufSize], commandString[_bufSize];
	char *ToLower ();
	char uploadDate[14], *fileName, fileSize[14];
	int found, aChar;
	time_t messageTime, parsedate ();
	struct tm *tm;

	if (rooms[currentRoom].fileDir != NULL) {
		if (extended) {
			GetString (matchPattern, _normal);
			(void) ToLower (matchPattern);
#ifdef useRegex
			if (matchPattern[0]) {
				re = regcmp (matchPattern, NULL);
			} else
				re = NULL;
#endif
			(void) sprintf (fileListName, "%s/.fileList", rooms[currentRoom].fileDir);
			if ((fileList = fopen (fileListName, "r")) != NULL) {
				while (_true) {
					/* Read up to a non new-line */
					while ((aChar = getc (fileList)) == '\n')
						;
					(void)ungetc (aChar, fileList);
					/* Termination condition */
					if (aChar == EOF)
						break;

					/* Read file entry */
					ClearHeader (fileDesc, fileFieldNames);
					(void) ReadHeader (fileList, fileDesc, fileFieldNames);
					if (fileDesc[_fileName] == NULL) {
						FreeHeader (fileDesc, fileFieldNames);
						continue;
					}
#ifdef useRegex
					/* If we have a search string, look for it */
					if (re == NULL)
						found = _true;	/* If we don't have a search string, print everything */
					else {
						AllocString ("ReadDirectory", &lcTemp, fileDesc[_fileName]);
						found = regex (re, ToLower (lcTemp), &dummy, &dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
							&dummy, &dummy, &dummy) != NULL;
						(void)free ((malloc_t)lcTemp);
						if (!found && fileDesc[_fileDesc]) {
							AllocString ("ReadDirectory", &lcTemp, fileDesc[_fileDesc]);
							found = regex (re, ToLower (lcTemp), &dummy, &dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
								&dummy, &dummy, &dummy) != NULL;
							(void)free ((malloc_t)lcTemp);
						}
						if (!found && fileDesc[_fileUser]) {
							AllocString ("ReadDirectory", &lcTemp, fileDesc[_fileUser]);
							found = regex (re, ToLower (lcTemp), &dummy, &dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
								&dummy, &dummy, &dummy) != NULL;
							(void)free ((malloc_t)lcTemp);
						}
					}
#else
					found = _true;
#endif
					if (found) {
						fileName = (char *)malloc ((size_t) (strlen (rooms[currentRoom].fileDir) + strlen (fileDesc[_fileName]) + 2));
						(void) sprintf (fileName, "%s/%s", rooms[currentRoom].fileDir, fileDesc[_fileName]);
						if (stat (fileName, &statBuffer) != -1)
							(void) sprintf (fileSize, "%ld", statBuffer.st_size);
						else
						  (void)strcpy (fileSize, "offlin");
						if (fileDesc[_fileDate]) {
							messageTime = parsedate (fileDesc[_fileDate], NULL);
							tm = localtime (&messageTime);
							(void) sprintf (uploadDate, "(%d%s%2d)", tm -> tm_year, months[tm -> tm_mon], tm -> tm_mday);
						} else
							uploadDate[0] = '\0';
						(void) printf ("%-14s %6s | %s%s\n", fileDesc[_fileName], fileSize, fileDesc[_fileDesc] ? fileDesc[_fileDesc] : "", uploadDate);
						(void)free ((malloc_t)fileName);
					}
					FreeHeader (fileDesc, fileFieldNames);
				}
			}
#ifdef useRegex
			if (re != NULL)
			  (void)free ((malloc_t)re);
#endif
		} else {
			GetString (matchPattern, _normal);
			(void) sprintf (commandString, "cd %s ; exec ls -FRs %s", rooms[currentRoom].fileDir, matchPattern);
			(void)system (commandString);
		}
	} else {
		(void) printf ("\nFiles are only in rooms that end with \"]\".\n");
	}
}

ReadArchiveHeader ()

{
	char fileName[_bufSize], filePath[_bufSize], commandString[_bufSize], *ptr;

	if (rooms[currentRoom].fileDir == NULL) {
		(void) printf ("\nFiles are only in rooms that end with \"]\".\n");
		return;
	}

	(void) printf ("Enter Filename:\n: ");
	GetString (fileName, _normal);
	if (fileName[0] == '\0')
		return;

	if (fileName[0] == '/') {
	  (void)strcpy (filePath, fileName);
	} else {
		(void) sprintf (filePath, "%s/%s", rooms[currentRoom].fileDir, fileName);
	}
	ptr = strrchr (fileName, '.');
	if ((ptr != NULL) && (strcmp (ptr, ".arc") == 0)) {
		if (!access (filePath, 4)) {
			(void) sprintf (commandString, "exec arc -il %s", filePath);
			(void)system (commandString);
		}
	} else {
		(void) printf ("File is not an archived file.\n");
	}
}

/* XXX This could use some work. */
static char *
ExpandFiles (fileNames)

char *fileNames;

{
	char *sourceFiles[1000];
	static char expandedFiles[10000];	/* XXX ! */
	int i, nf;

	nf = split (fileNames, sourceFiles, 1000, ", ");
	expandedFiles[0] = '\0';
	for (i = 0; i < nf; i++) {
		if ((strlen (expandedFiles) + strlen (sourceFiles[i])
		/*  + strlen (rooms[currentRoom].fileDir)*/ + 3) < 10000 ) {
		  (void)strcat (expandedFiles, " ");
		  /*(void)strcat (expandedFiles, rooms[currentRoom].fileDir);
		    (void)strcat (expandedFiles, "/");*/
		  (void)strcat (expandedFiles, sourceFiles[i]);
		}
	}
	return (expandedFiles);
}
