/*
 * NAME
 *     Mesg.c -- general message handling functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Mesg.c  1.2 11/11/90 07:40:41\n\t";
#endif

#include <stdio.h>
#include <fgetmfs.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"

char *GetAddresses ();

#ifdef GETPATH
char *pathfile = _pathsFileName;
#endif

int
ValidAddresses (theAddresses)

char *theAddresses;

{
	char *addresses, *address;
	int status = 0;

	addresses = NULL;
	AllocString ("ValidAddresses", &addresses, theAddresses);
	if (GetAddresses (addresses) == NULL) {
	  (void)free ((malloc_t)addresses);
		return (0);
	}
	for (address = strtok (addresses, " "); address != NULL; address = strtok ((char *) NULL, " ")) {
		status = ValidAddress (address);
	}
	(void)free ((malloc_t)addresses);
	return (status);
}

int
ValidAddress (address)
/*
returns 2 (impossible) for mixed ('@' and '!') addresses

returns 1 (unlikely) if siteName in 'siteName!userName' or
   'userName@siteName' is in _remoteUsersFile and userName
   is not.

returns 0 (likely) if any one of the following is true, 2 (impossible)
   otherwise:

   *  'address' is in 'aliases'

   *  'address' is of the form 'userName' and userName is in 'passwd'

   *  'address' is of the form 'userName@localSite' or 'localSite!userName'
      and userName is in 'passwd'.  Both forms are converted to 'userName'

   *  'address' is of the form 'userName@siteName' or 'siteName!userName' and
     siteName or it's domain is in 'paths'.  'siteName!userName' is converted
     to 'userName@siteName'

   *  'address' is of the form 'siteA!siteB!siteC!userName' and siteA is
      in 'L.sys' or 'Systems' (depending on UUCP version)

*/

char *address;

{
	char testLine[_bufSize], userName[_bufSize], siteName[_bufSize];
	char siteRoot[_bufSize], siteDomain[_bufSize];
	char *ptr, *ptr1;
	FILE *lookupFile;
	int hasSite;	/* _true if site is given and is not local site */
	int hasPath;    /* _true if '!' form with more than one '!', first site in path can't be domain */
	int i;

	if ((strchr (address, '@') != NULL) && (strchr (address, '!') != NULL)) {
		(void) printf ("Mixed addressing ('@' and '!') not allowed.\n");
		/* XXX Well, we probably could try to resolve it, but why cater to bugs? */
		return (2);	/* impossible */
	}

	hasSite = _false;
	hasPath = _false;
	userName[0] = siteName[0] = siteRoot[0] = siteDomain[0] = '\0';

	/* Get all the relevant parts of an address */
	(void)strcpy (testLine, address);
	for (i = 0; testLine[i] != '\0'; i++)
		if (isupper (testLine[i]))
			testLine[i] = tolower (testLine[i]);
	/* check for form 'siteName![...!]userName' */
	if ((ptr = strchr (testLine, '!')) != NULL) {
		*ptr++ = '\0';
		/* Site name we're interested in is the first or only site */
		(void)strcpy (siteName, testLine);
		hasSite = _true;
		/* the rest of the path plus/or name goes in userName */
		(void)strcpy (userName, ptr);
		/* if there's another '!' it's a path */
		if (strchr (userName, '!') != NULL)
			hasPath = _true;
	} else if ((ptr = strchr (testLine, '@')) != NULL) {
		*ptr++ = '\0';
		/* Site name is after '@' */
		(void)strcpy (siteName, ptr);
		hasSite = _true;
		/* User name is before '@' */
		(void)strcpy (userName, testLine);
	} else {
		/* 'address' is user name only */
	  (void)strcpy (userName, testLine);
	}

	/* Split site root and site domain out */
	if (hasSite) {
	  (void)strcpy (testLine, siteName);
		if ((ptr = strchr (testLine, '.')) != NULL) {
			*ptr++ = '\0';
			(void)strcpy (siteRoot, testLine);
			(void)strcpy (siteDomain, ptr);
			if (strcmp (siteDomain, _siteDomain) == 0) {
				ptr = strchr (siteName, '.');
				*ptr = '\0';
			}
		} else {	/* a name without a domain is assumed to be in our domain */
		  (void)strcpy (siteRoot, testLine);
		  (void)strcpy (siteDomain, _siteDomain);
		}
	}

	/* Check to see if 'site' is this site, clear it if so */
	if (hasSite) {
		if ((strcmp (siteRoot, _siteName) == 0) && (strcmp (siteDomain, _siteDomain) == 0)) {
			siteRoot[0] = siteDomain[0] = siteName[0] = '\0';
			hasSite = _false;
		}
	}

	/* search for 'userName' in alias(8) file, only the first white-space separated field of the alias file is checked */
	lookupFile = fopen (_aliasFileName, "r");
	if (lookupFile != NULL) {
		while (fgets (testLine, _bufSize, lookupFile) != NULL) {
			if (isspace (testLine[0]) || (testLine[0] == '#'))
				continue;
			if ((ptr = strpbrk (testLine, " \t@!:")) != NULL) {
				if (*ptr == '!') {	/* skip past site if it's first */
					ptr1 = ptr ++;
					ptr = strpbrk (ptr1, " \t:");
					if (ptr == NULL)
						continue;
				} else
					ptr1 = testLine;
				*ptr = '\0';
				if (strcmp (userName, ptr1) == 0) {
				  (void)strcpy (address, userName);
				  (void)fclose (lookupFile);
					return (0);	/* likely */
				}
			}
		}
		(void)fclose (lookupFile);
	}

	/* search for userName in passwd(4), only the first ':' separated field of the passwd file is checked */
	if (!hasSite) {
		lookupFile = fopen (_passwdFileName, "r");
		if (lookupFile == NULL) {
			ErrorLog ("ValidAddress:001", _error, "Not able to open passwd file.");
			return (2);	/* impossible */
		}
		while (fgets (testLine, _bufSize, lookupFile) != NULL) {
			if ((ptr = strchr (testLine, ':')) != NULL) {
				*ptr = '\0';
				if (strcmp (userName, testLine) == 0) {
				  (void)strcpy (address, userName);
				  (void)fclose (lookupFile);
					return (0);	/* likely */
				}
			}
		}
		(void)fclose (lookupFile);
		(void) printf ("'%s' is not a user on this system.\n", userName);
		return (2); /* impossible */
	}

	/* check for siteName in 'L.sys' or 'Systems' file, only the first white-space field is checked */
	if (hasPath) {
		lookupFile = fopen (_systemsFileName, "r");
		if (lookupFile == NULL) {
			ErrorLog ("ValidAddress:002", _error, "Not able to open Systems file.");
			return (2);	/* impossible */
		}
		while (fgets (testLine, _bufSize, lookupFile) != NULL) {
			if ((ptr = strpbrk (testLine, " \t")) != NULL) {
				*ptr = '\0';
				if (strcmp (siteName, testLine) == 0) {
				  (void)fclose (lookupFile);
					return (0);	/* likely */
				}
			}
		}
		(void)fclose (lookupFile);
		(void) printf ("'%s' is not a site connected to this system.\n", siteName);
		/* XXX Attempt "well known site" search on path, display "user@site" result */
		return (2);	/* Impossible */
	}

#ifdef GETPATH
	/* check for siteName in paths(8), only the first tab separated field is checked */
	if (siteName[0]) {
		int cost;	/* dummy variable for 'getpath' */

		ptr = siteName;
		do {
			if (!getpath (ptr, testLine, &cost))
				return (0);	/* likely */
		} while ((ptr = strchr (ptr + 1, '.')) != NULL);
		(void) printf ("'%s' is not a site reachable from here.\n", siteName);
		return (2);	/* impossible */
	}
#else
	/* XXX Implement routines for using other mailers' address checking */
	if (siteName[0]) {
		/* Don't bother the user just to tell them we can't check */
		return (0);
	}
#endif

	/* We should have checked everything by now */
	(void) sprintf (errorString, "Aaack! We're not supposed to reach this looking for '%s'!", address);
	ErrorLog ("ValidAddress:003", _error, errorString);
	return (2);	/* Ee gads */
}

char *
GetAddresses (addresses)

char *addresses;

{
	char *ptr, *ptr1;
	int parenLevel = 0;

	for (ptr1 = ptr = addresses; *ptr1 != '\0'; ptr1 ++) {
		if (*ptr1 == '(') {
			if (++parenLevel == 2) {
				(void) printf ("Nested parenthesis, that's a no-no.\n");
				return (NULL);
			}
			continue;
		}
		if (*ptr1 == ')') {
			parenLevel --;
			continue;
		}
		if (parenLevel != 0)
			continue;
		if (*ptr1 == ',') {
			*ptr++ = ' ';
			continue;
		}
		*ptr++ = *ptr1;
	}
	*ptr = '\0';
	return (addresses);
}
