/*
 * NAME
 *     Floor.c -- Floor functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Floor.c  1.1 11/7/90 09:55:13\n\t";
#endif

#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"

extern char *user[];

GotoFloorCommand (type)

long type;

{
	char floorName[_bufSize];
	int room, floor;

	switch ((int) type) {
	case 0:		/* Goto Floor */
		GetString (floorName, _normal);
		if (floorName[0]) {
			room = FindFloor (floorName);
			if (room != -1) {
				MarkRead ();
				Goto (room);
			}
		}
		break;
	case 1:		/* Skip Floor */
	case 2:		/* Next Floor */
		floor = currentFloor;
		do {
			floor ++;
			if (floors[floor].name == NULL)
				floor = 0;
			room = FindFloor (floors[floor].name);	/* This actually looks up the first non-forgotten room in that floor */
		} while (floors[floor].forgotten || ((room == -1) && (floor != currentFloor)));
		if (room != -1) {
			MarkRead ();
			Goto (room);
		}
		break;
	case 3:		/* Previous Floor */
		floor = currentFloor;
		do {
			if (floor == 0)
				for (floor = 0; floors[floor].name != NULL; floor ++);
			floor --;
			room = FindFloor (floors[floor].name);	/* This actually looks up the first non-forgotten room in that floor */
		} while (floors[floor].forgotten || ((room == -1) && (floor != currentFloor)));
		if (room != -1) {
			MarkRead ();
			Goto (room);
		}
		break;
	}
}

int
FindFloor (floorName)
/* Returns the first known room on this floor or -1 */

char *floorName;

{
	char floorNameCopy[_bufSize];
	int floor, room, i;

	for (i = 0; floorName[i] != '\0'; i ++)
		floorNameCopy[i] = isupper (floorName[i]) ? tolower (floorName[i]) : floorName[i];
	floorNameCopy[i] = '\0';

	for (floor = 0;
	  (floors[floor].name != NULL)
	  && !IsIn (floorNameCopy, floors[floor].name)
	  && !IsIn (floorNameCopy, floors[floor].description); floor ++)
		;
	if (floors[floor].name == NULL)		/* No floor by that name */
		return (-1);

	for (room = 0; (rooms[room].name != NULL) && !(!rooms[room].forgotten && (rooms[room].floor == floor)); room ++);
	if (rooms[room].name == NULL)		/* No known rooms on that floor */
		return (-1);
	return (room);
}

ForgetFloor ()

{
	if (currentFloor != 0) {
		floors[currentFloor].forgotten = _true;
		GotoFloorCommand (2l);	/* Next Floor */
	}
}

KnownFloors ()

{
	int floor;

	for (floor = 0; floors[floor].name != NULL; floor ++) {
		if (!floors[floor].forgotten) {
			(void) printf ("[%s", floors[floor].name);
			if (floors[floor].description != NULL)
				(void) printf (":\t%s", floors[floor].description);
			(void) printf ("]\n");
		}
	}
}

ToggleFloorMode ()

{
	if (floorMode) {
		floorMode = _false;
		AllocString ("ToggleFloorMode", &user[_userFloorMode], "No");
		(void) printf ("Normal mode.\n");
	} else {
		floorMode = _true;
		AllocString ("ToggleFloorMode", &user[_userFloorMode], "Yes");
		(void) printf ("Floor mode.\n");
	}
}
