/*
 * NAME
 *     unilogin -- Accept a unidel login, using a different passwd file.
 *
 * DESCRIPTION
 *     unilogin will request a user name and password and if they are
 * found in passwd then the login shell is executed.
 */

#include <stdio.h>
#include <pwd.h>
#include <string.h>
#include <malloc.h>
#include <fgetmfs.h>
#include <varargs.h>

#define _maxTries 5

static char *passwordFileName = "/home/rspdev/ken/play/unidel/lib/passwd";
static char *emptyEnviron[] = { (char *) NULL };

main (argc, argv, envp)
     int   argc;
     char *argv[],
     *envp[];
{
  extern char **environ;
  struct passwd *pw, *GetPwName();
  char *userName, *password, *crypted, *crypt(), *pp, *setenv(),
  *getpass();
  int tries;

  tries = 0;
  while (1) {
    while (1) {
      if (tries++ == _maxTries)
	return 0;		/* Too many tries */
    
      (void) printf ("Enter your BBS login id: ");
      fflush (stdout);
      userName = fgetms (stdin);
      if (userName == (char *) NULL)
	return 0;		/* end-of-file */
      pp = strchr (userName, '\n');
      if (pp)
	*pp = '\0';

      pw = GetPwName (passwordFileName, userName);
      if (pw != (struct passwd *) NULL) {
	pp = strrchr (pw->pw_passwd, ',');
	if (pp != (char *) NULL)
	  *pp = '\0';
	if (*pw->pw_passwd == '\0') {
	  (void) printf ("Your password has expired.\n");
	  password = "";
	  break;
	}
      }

      password = getpass ("Enter your password: ");

      if (pw != (struct passwd *) NULL)
	break;
      
      printf ("Login incorrect.\n");
    }

    if (*password == '\0' && *pw->pw_passwd == '\0')
      break;

    crypted = crypt (password, pw->pw_passwd);

    if (strcmp (crypted, pw->pw_passwd) == 0)
      break;

    printf ("Login incorrect.\n");
  }

  if (chdir (pw->pw_dir) < 0) {
    (void) printf ("User %s: can't change directory to %s.\n",
		   pw->pw_name, pw->pw_dir);
    return (0);
  }

  environ = emptyEnviron;
  (void)setenv("LOGNAME", pw->pw_name, 1);
  (void)setenv("HOME", pw->pw_dir, 1);
  (void)setenv("SHELL", "/bin/sh", 1);
  (void)setenv("USER", pw->pw_name, 1);
  (void)setenv("PATH", "/bin:/usr/bin", 0);

  pp = strrchr (pw->pw_shell, '/');
  if (pp == (char *) NULL)
    pp = pw->pw_shell;
  else
    pp ++;

  (void) execl (pw->pw_shell, pp, (char *) 0);

  (void) printf ("User %s: can't exec shell.\n", pw->pw_name);
  return (0);
}

struct passwd *
GetPwName (fileName, name)
     char *fileName, *name;
{
  static struct passwd pw;
  static int firstTime = 1;
  FILE *file;
  char *pwLine, *pp, *uidStr, *gidStr;

  if (!firstTime)
    free (pw.pw_name);
  else
    firstTime = 0;
  
  file = fopen (fileName, "r");
  if (file == (FILE *) NULL)
    return ((struct passwd *) NULL);
  
  while ((pwLine = fgetms (file)) != (char *) NULL) {
    pp = strchr (pwLine, '\n');
    if (pp)
      *pp = '\0';
    (void) splitl (pwLine, ":", &pw.pw_name, &pw.pw_passwd, &uidStr,
		   &gidStr, &pw.pw_gecos, &pw.pw_dir, &pw.pw_shell,
		   (char *) NULL);
    if (strcmp (name, pw.pw_name) == 0) {
      (void) fclose (file);
      
      pw.pw_uid = atoi (uidStr);
      pw.pw_gid = atoi (gidStr);
#ifdef BSD
      pw.pw_quota = 0;
#else
      pw.pw_age = (char *) NULL;
#endif
      pw.pw_comment = (char *) NULL;
      
      return (&pw);
    }

    free (pwLine);
  }

  (void) fclose (file);
  
  return ((struct passwd *) NULL);
}

int
/*splitl (string, delim, arg0, ..., argn, (char *) 0)*/
splitl (va_alist)
va_dcl

{
  register char *ss, *dd, *delim;
  register int nn, pastArgn;
  char *string, **arg;
  va_list pvar;


  va_start (pvar);
  
  ss = string = va_arg (pvar, char *);
  delim = va_arg (pvar, char *);

  pastArgn = 0;
  nn = 0;
  while (*ss != '\0') {
    if (!pastArgn && ((arg = va_arg (pvar, char **)) != (char **) 0))
      *arg = ss;
    pastArgn = arg == (char **)0;
    nn ++;
    
    /*
     * Scan for the next delimiter in string (ss)
     */
    for (; *ss != '\0'; ss ++) {
      /* Scan for "this" character (*ss) in delim (dd) */
      dd = delim;
      while ((*dd != '\0') && (*ss != *dd))
	dd ++;

      if (*ss == *dd) {
	*ss = '\0';
	ss ++;
	if (*ss == '\0')	/* Case where delim is last char */
	  nn++;
	break;
      }
    }
  }
  /*
   * Last substring delimited by '\0'
   */
  if (!pastArgn && ((arg = va_arg (pvar, char **)) != (char **) 0))
    *arg = ss;
  pastArgn = arg == (char **)0;

  /*
   * Put NULL in remaining arg positions.
   */
  if (!pastArgn)
    while ((arg = va_arg (pvar, char **)) != (char **) 0)
      *arg = (char *) 0;

  va_end (pvar);
  
  return (nn);
}

char *
setenv (env, val, replace)
     char *env, *val;
     int replace;
{
  char *oldValue, *pp, *getenv();

  oldValue = getenv (env);
  
  pp = (char *) malloc (strlen (env) + strlen (val) + 2);
  if (pp == (char *) NULL) {
    (void) fprintf (stderr, "Out of memory.\n");
    exit (1);
  }
  (void) sprintf (pp, "%s=%s", env, val);
  if (putenv (pp) != 0) {
    (void) fprintf (stderr, "Out of memory.\n");
    exit (1);
  }

  return (oldValue);
}
