/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  suchen.c						   */
/*        FUNKTIONEN  suchen(), edit()					   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  13.06.1992					   */
/***************************************************************************/

#include <stdio.h>
#include <signal.h>

#include "mbox.h"


/***************************************************************************/
/*      FUNKTION  suchen()						   */
/*  BESCHREIBUNG  Artikel im aktuellen Brett mit GREP nach muster durch-   */
/* 		  suchen und entsprechende Artikel anzeigen.		   */
/*     PARAMETER  muster = Suchbegriff				           */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void suchen( muster )
char muster[];
{
  FILE *fp;

  char s[STRING];
  char t[STRING];
  char tmp[STRING];
  char ex[LONGSTRING];

  int fpid;
  int found = 0;
  int ok = 0;
  int i;
  

  if(muster[0] == '\0'){
	ansi( "md" );
	printf("\n\n%s ", SUC01_MSG);
	ansi( "me" );
	strcpy(muster, (char *) getline(60, 1, 32, ""));
	if(muster[0] == '\0'){
		printf(" <- %s\n", SUC02_MSG);
		return;
	}
  }

  i = 0;
  while(muster[i] != '\0'){
	if(muster[i] == '"') muster[i] = ' ';
	i++;
  }

  sprintf(s, " %s \"%s\" %s [%s] ", SUC03_MSG, (char *) stripped(muster), SUC04_MSG, NG);
  headline( s );

  printf("%s .", SUC05_MSG);

  sprintf(tmp, "%s/such.%d", TMP, getpid());

  if(strcomp("PM", BRETT) == 0){
	sprintf(t, "%s/usr/%d", HOME, USER.id);
	chdir( t );
  }
  else{
	chdir( BRETT );
  }

  switch( (fpid = fork()) ){
		case -1 :
				break;
		case  0 :	while(1){
					printf(".");
					sleep(3);
				}	
				break;
  }

  sprintf(s, "%s \"%s\" * > %s 2> %s", GREP, (char *) stripped(muster), tmp, CPRN);
  system( s );

  kill( fpid, SIGKILL );
  wait( fpid );

  printf("%c", CR);


  fp = fopen( tmp, "r" );
  if(fp == 0){
	
  }
  while((fgets(ex, LONGSTRING, fp) != NULL) && (ok == 0)){
	if(atoi(ex) != 0){	
		if(show( (char *) stripped(ex), 9999, USER.more ) == -1) ok++;
		found++;
	}
  }
  fclose(fp);

  chdir( HOME );

  if(found == 0){
	printf("%s \"%s\" %s\n", SUC06_MSG, (char *) stripped(muster), SUC07_MSG);
  }

  unlink( tmp );
}


/***************************************************************************/
/*      FUNKTION  edit()						   */
/*  BESCHREIBUNG  							   */
/*     PARAMETER  						           */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void edit( arg )
char arg[];
{
  FILE *fp;
  FILE *ff;

  char s[STRING];
  char t[STRING];
  char d[STRING];
  char p1[STRING];
  char p2[STRING];

  int ok = 0;
  int yet = 0;

  if (arg[0] == '\0') {
	ansi( "md" );
	printf(" <- %s\n", SUC07aMSG);
	ansi( "me" ); 
	return;
  }

  if (strcomp(BRETT, "PM") != 0) {
        sprintf(t, "%s/%s", BRETT, arg); 
  }
  else {
	sprintf(t, "%s/usr/%d/%s", HOME, USER.id, arg);
	/*
	ansi( "md" );
	printf(" <- %s\n", SUC08_MSG);
	ansi( "me" ); 
	return;
	*/
  }
  
  if((USER.level < ADMIN_LEV) && (USER.level >= EXE_LEV)){
 	fp = fopen( t, "r" );
	if(fp == NULL){
		ansi( "md" );
		printf(" <- %s\n", SUC10_MSG);
		ansi( "me" ); 
		return;
	}
	while((fgets(s, 80, fp) != 0) && (ok == 0)){
		if(strcomp("From: ", s) == 0){
			strcpy(d, (char *) strcopy(s, 6, 80));
			if(strcomp(USER.name, d) == 0) ok++;
		}
	}
	fclose(fp);
	if(ok == 0){
		ansi( "md" );
		printf(" <- %s\n", SUC09_MSG);
		ansi( "me" ); 
		return;
	}
  }

  if(USER.level >= EXE_LEV){
	sprintf(s, "%s %s", EDDY, t);
	noctrlx();
	system(s);
	ctrlx();
  }
  else{
	sprintf(p1, "%s/%dED1", TMP, getpid());
	sprintf(p2, "%s/%dED2", TMP, getpid());

	fp = fopen( t, "r" );
	if(fp == NULL){
		ansi( "md" );
		printf(" <- %s\n", SUC08_MSG);
		ansi( "me" ); 
		return;
	}
 	ff = fopen( p1, "w" );
	while(fgets(s, 80, fp) != NULL){
		fputs(s, ff);
		if(strcomp("From: ", s) == 0){
			strcpy(d, (char *) strcopy(s, 6, 80));
			if(strcomp(USER.name, d) == 0) ok++;
		}
		if((strlen(s) < 3) && (yet == 0)){
			fclose(ff);
			ff = fopen( p2, "w" );
			yet++;
		}
	}
	fclose(fp);
	fclose(ff);

	if(ok == 0){
		ansi( "md" );
		printf(" <- %s\n", SUC09_MSG);
		ansi( "me" ); 
		unlink( p1 );
		unlink( p2 );
		return;
	}

	sprintf(s, "%s %s", EDDY, p2);
	noctrlx();
	system(s);
	ctrlx();

	sprintf(s, "cat %s > %s", p1, t);
	system( s );
	sprintf(s, "cat %s >> %s", p2, t);
	system( s );

	unlink( p1 );
	unlink( p2 );
  }
}
