/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  pd.c						   */
/*        FUNKTIONEN  pd(), download(), status(), mkix(), statistik()	   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  22.06.1992					   */
/***************************************************************************/
  
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <time.h>

#include "mbox.h"


/***************************************************************************/
/*      FUNKTION  pd()							   */
/*  BESCHREIBUNG  Eine Datei wird mit o. ohne Protokoll uebertragen.       */
/*		  Diese Funktion wird von "lesen()" oder "pruefe()"        */
/*		  aufgerufen, wenn die zu bearbeitende Datei den Kenn-     */
/*		  zeichner "BINFILE" enthaelt.                             */
/*     PARAMETER  arg = Dateiname                                          */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void pd(arg, keywds)
char arg[], keywds[];
{
  FILE *fp;
  FILE *ff;

  char s[STRING];
  char tmp[STRING];
  char c;
  char protokoll;
  char cd[STRING];
  struct stat fst;
  long ts, tn;

  int cps, bps, eff;
  int ok, i;

  strcpy(cd, stripped(arg));

  printf("\n\n");
  ansi("md");
  printf("%s\n\n", PD01_MSG);
  
  if(keywds[0] != '\0'){
	printf("%s ", PD02_MSG); 
	ansi("me");
	printf("%s\n\n", keywds);
  }
  else{
	 ansi("me");
  }

  ansi("mr");
  printf("%c%s [%c, %c, (%c)] >  ", CR, PD03_MSG, GBL06_MSG, GBL07_MSG, PD06_MSG);
  ansi("me");

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if ((c != GBL06_MSG) && (c != GBL07_MSG) && (c != PD06_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == PD06_MSG) {	/*  X  */
	printf("\n");
	sigcatch(SIGINT);	
  }

  if (c != GBL06_MSG) {	/*  J  */
	printf("\n");
	return;
  }
  ansi("mr");
  printf("%c[%s] %c, %c, %c, %c ? > ", CR, PD07_MSG, PD08_MSG, PD09_MSG, PD10_MSG, PD11_MSG);
  ansi("me");


  do {
	protokoll = getint();
	if (protokoll >= 97) protokoll -= 32;
	if (protokoll == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, PD12_MSG);
		ansi("me");
	}
	if ((protokoll != PD08_MSG) && (protokoll != PD09_MSG) &&
	    (protokoll != PD10_MSG) && (protokoll != PD11_MSG))
		protokoll = 0;
  } while (protokoll == 0);


  printf("%c", protokoll);

  signal(SIGINT,  SIG_IGN);
  signal(SIGHUP,  SIG_IGN);
  signal(SIGQUIT, SIG_IGN);
  signal(SIGABRT, SIG_IGN);
  signal(SIGTERM, SIG_IGN);

  printf("\n\n");
  ansi("md");
  printf("%s\n\n", PD13_MSG);
  ansi("me");

  time(&ts);

  switch (protokoll) {
      case PD08_MSG:
		sprintf(s, "exec cat %s", cd);
		break;
      case PD09_MSG:
		sprintf(s, "exec %s -b %s 2> /dev/null", SX, cd);
		break;
      case PD10_MSG:
		sprintf(s, "exec %s %s 2> /dev/null", SB, cd);
		break;
      case PD11_MSG:
		sprintf(s, "exec %s %s 2> /dev/null", SZ, cd);
		break;
  }
  system( s );

  time(&tn); tn = tn - ts; 

  stat(cd, &fst);
  USER.downratio += ((long) fst.st_size / 1024);

  ansi( "md" );
 
  if(tn < 1) tn = 1;
  cps = fst.st_size / tn;
  bps = cps * 11;

  BAUDRATE = baudrate( bps );

  eff = ((100000 / BAUDRATE) * bps) / 1000;  

  if(bps > BAUDRATE){
	printf("\n\n%s\n", PD14_MSG);
	ok = -1;
  }
  else{	
	printf("\n\n%ld %s.\n", fst.st_size, PD15_MSG);
	ok = 0;
  }

  ansi( "me" );
  printf("%s %d cps (ca. %d bps).", PD16_MSG, cps, bps);
  sprintf(tmp, "%s/%d.pd", TMP, getpid());
  ff = fopen( tmp, "w" );


  if(ok == 0){
	fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, cd); 
	if(bps < BAUDRATE){
		fprintf(ff, "  %6.d  %6.d  %2.d%% OK\n", cps, bps, eff);
	}
	else{
		fprintf(ff, "  %6.d  %6.d  %2.d%% BRK\n", cps, bps, eff);
	}
  }
  else{
	/*
	fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, cd); 
	fprintf(ff, "  %6.6d  %6.6d  %s\n", cps, bps, PD17_MSG);
	*/
  }

  i = 0;

  fp = fopen( PDLOG, "r" );
  if(fp != NULL){
	while((fgets(s, 80, fp) != NULL) && (i < PRO_ENTRIES)){
		fputs(s, ff);
		i++;
	}
	fclose(fp);
  }

  fclose(ff);

  sprintf(cd, "mv %s %s", tmp, PDLOG);
  system( cd );

  printf("\n");
}




/***************************************************************************/
/*      FUNKTION  status						   */
/*  BESCHREIBUNG  Verschiedene (eigentlich fast alle) Eintraege aus den    */
/*		  Teilnehmerdaten werden angezeigt.                        */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine  					           */
/***************************************************************************/

void status()
{
  char s[STRING];
  char t[STRING];
  char d[STRING];
  char ex[255];
  int a, b;
  int i;


  sprintf(s, " %s %d ) %s ", PD18_MSG, USER.id, USER.name);
  headline(s);
  printf("\n");

  ansi("md");
  printf("%s", PD19_MSG);
  ansi("me");

  printf("\n");

  sprintf(ex, "%s                                        ", USER.name);
  ex[27] = '\0';
  strcat(ex, USER.nick);
  strcat(ex, "                            ");
  ex[45] = '\0';
  strcat(ex, USER.geburtsdatum);
  strcat(ex, "                            ");
  ex[62] = '\0';
  strcat(ex, USER.telefon1);
  printf("%s\n", ex);

  sprintf(ex, "%s                                        ", USER.strasse);
  ex[27] = '\0';
  strcat(ex, USER.sh_name);
  strcat(ex, "                            ");
  ex[45] = '\0';
  strcat(ex, "                            ");
  ex[62] = '\0';
  strcat(ex, USER.telefon2);
  printf("%s\n", ex);

  printf("%s\n\n", USER.wohnort);
  ansi("md");
  printf("%s", PD20_MSG);  
  ansi("me");
  printf("\n");

  s[0] = '\0'; strcat(s, datereconv( LASTLOG ));
  strcat(s, "-"); strcat(s, timereconv( LASTTIME ));
  s[16] = '\0';

  sprintf(ex, "       %1d       %1d  %5d     %1d       %1d     %1d      %1d  %6d  %s",
	USER.terminal, USER.editor, USER.level, USER.bell, USER.prompt, USER.more, USER.intro, USER.seq, s);
  printf("%s\n\n", ex);

  ansi("md");
  printf("%s", PD21_MSG);  
  ansi("me");
  sprintf(ex, "\n%06.6d                      %06.6d                    %06.6d",
	(USER.elapsed / 60), USER.upratio, USER.downratio);
  printf("%s\n\n", ex);

  ansi("md");
  printf("%s", PD22_MSG);
  ansi("me");

  i = 0;
  strcpy(s, (char *) USER.name);
  while (s[i] != '\0') {
	if (s[i] == ' ') s[i] = '.';
	i++;
  }

  sprintf(t,  "%s: %s@%s", PD23_MSG, s, UUCPID);
  strcpy(d, USER.account); d[10] = '\0';
  strcpy(s, (char *) strcopy(USER.account, 11, 16));
  i = atoi(s); 
  sprintf(s, "%s  %3d.%02d", d, fix(i), flt(i));
  sprintf(ex, "%-54.54s%s DM\n%s: %s%s", t, s, PD24_MSG, UUCPBANG, USER.nick);
  printf("\n%s\n", ex);
  if (USER.sh_name[0] != '\0')
	printf("%s: %s!%s\n", PD25_MSG, UUCPSITE, USER.sh_name);

  printf("\n");

  ansi("md");
  printf("%s\n", PD26_MSG);

  ansi("me");

  i = 1;
  while(newsgrp[i][0] != '\0'){
	if(i != 1) printf(", ");
	printf("%s", newsgrp[i]);
	i++;
  }

  printf("\n\n");  
}



/***************************************************************************/
/*      FUNKTION  mkix()						   */
/*  BESCHREIBUNG  Wandelt eine Datei ins UNIX-Format (CRs werden entfernt) */
/*     PARAMETER  s  =  Dateiname                                          */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void mkix( pfad )
char pfad[];
{
  FILE *fp; 
  FILE *ff;

  char s[255];
  char p[255];

  int i, ok = 0;

  
  sprintf(p, "%sabc", pfad);

  fp = fopen( pfad, "r" );
  if(fp == NULL){
	return;
  }  	

  ff = fopen( p, "w" );
  if(ff == NULL){
	nerror("pd.c", 243, "mkix", "Datei-Erstellungsfehler", p);	
  }

  while((ok == 0) && (fgets(s, 254, fp) != NULL)){
	i = 0;
	while(s[i] != '\0'){
		if(s[i] == CTRL_Z){
			ok++;
			break;
		}
		i++;
	}
	if(ok == 0){
		i = strlen(s) -2;
		if(s[i] == CR){
			s[i]    = LF;
			s[i +1] = '\0';
		}
		fputs(s, ff);
	}
  }
  fclose(fp);
  fclose(ff);

  unlink(pfad);
  rename(p, pfad);
}



/***************************************************************************/
/*      FUNKTION  statitik()						   */
/*  BESCHREIBUNG  Anrufer-Protokoll auswerten 				   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void statistik()
{
  FILE *fp;

  struct tm *tp;
  time_t tt;

  char s[STRING];
  char od[MAX_TAGE][STRING];
  char t[STRING];
  char r[STRING];

  int v18u[MAX_TAGE];
  int n18u[MAX_TAGE];
  int v18g = 0;
  int n18g = 0;

  int zeit = 0;
  int tage = 0;
  int max  = 0;

  int i, a;
  int toggle = 0;
  int sun;

  fp = fopen( CALLS, "r" );
  if(fp == NULL){
	nerror("pd.c", 288, "statistik", "Datei-Lesefehler", CALLS);		
  }

  od[0][0] = '\0';

  headline( PD27_MSG );
  printf("%s\n", PD28_MSG);
  printf("===============================================================================\n");

  while((fgets(s, (STRING *2), fp) != NULL) && (tage < (MAX_SCR_LINES -7))){
	strcpy(t, (char *) strcopy(s, 64, 71));

	if(strcomp(t, od[tage]) != 0){
		if(tage != 0){
			if((v18u[tage] + n18u[tage]) > max){
				max = v18u[tage] + n18u[tage];
			}
			v18g += v18u[tage];
			n18g += n18u[tage];
		}
		tage++;
		od[tage][0] = '\0'; strcat(od[tage], t);
		v18u[tage] = 0;
		n18u[tage] = 0;
        }
	zeit = atoi(strcopy(s, 74, 75));
	if((zeit >   6) && (zeit < 18)) v18u[tage]++;
	if((zeit >= 18) || (zeit <= 6)) n18u[tage]++;
  }

  sprintf(s, "%s", "ooooooooooooooooooooooooooooooooooooooooooooooooooooo");

  time(&tt);
  tp = localtime(&tt);
  sun = tp->tm_wday;

  for(i = 1; i < tage; i++){
	sprintf(t, "%s", s);
	a = (290 / max * (v18u[i] + n18u[i])) / 10;
	t[a] = '\0';	
	strcpy(r, "    ");	
	if(sun == 0){
		strcpy(r, PD29_MSG);
		toggle++;	
		ansi( "md" );
	}
	if(sun == 6) 
		strcpy(r, PD30_MSG);
	sun--;
	if(sun == -1) sun = 6;

	printf("%s %s %4.d        %5.d         %5.d      %s\n",
                od[i], r, v18u[i], n18u[i], v18u[i]+n18u[i], t);
	if(toggle != 0) ansi( "me" );
	toggle = 0;
  }

  printf("-------------------------------------------------------------------------------\n");
  printf("%s %5.d        %5.d         %5.d      %s\n",
	  PD31_MSG, v18g, n18g, v18g+n18g, PD32_MSG);
  printf("===============================================================================\n");

  printf("\n%s %d %s.\n", PD33_MSG, (tage -1), PD34_MSG);   

  fclose(fp);
}





/***************************************************************************/
/*      FUNKTION  archivieren()						   */
/*  BESCHREIBUNG  Archivierer auswaehlen und Dateien packen		   */
/*     PARAMETER  arg = artikel-liste					   */
/*     RUECKGABE  Names des Archivs					   */
/***************************************************************************/

char *archivieren( arg )
char arg[];
{
  FILE *fp;
  int i, c;

  struct stat fstat;

  char s[LONGSTRING+STRING];
  char t[STRING];
  char packers[10][STRING];
  char adds[10][STRING];
  char tar[10][STRING];
  char en[10][STRING];
  char cd[LONGSTRING];

  int fpid;


  headline( " Auswahl der Komprimierer " );
  printf("\n");

  sprintf(s, "%s/%s", HOME, PACKERS);
  fp = fopen(s, "r");
  if (fp == NULL) {
	nerror("pd.c", 495, "archivieren", "Datei-Lesefehler", s);
  }
  i = 0;
  while((fgets(s, 80, fp) != NULL) && (s[0] == '/'));
  while((i < 10) && (fscanf(fp, "%s %s %s %s %s", s, packers[i], adds[i], tar[i], en[i]) > 0)){
	i++;
	printf("  %d - %s\n\n", i, s); 
  }
  fclose(fp);

  ansi("md");
  printf("\n%s > ", "Welcher?");
  ansi("me");

  c = getint();
  if(c > 32) printf("%c", c);
  c -= 49;

  if(c > i) return (char *) "Noe!";

  
  printf("\n\n%s .", "Momentchen");

  switch( (fpid = fork()) ){
	case -1 :
		break;
	case  0 : 
		while(1){
			printf(".");
			sleep(2);
		}	
		break;
  }

  strcpy(cd, (char *) arg);

  if(tar[c][0] != '-'){
	sprintf(t, "DNL%s.tar", mytime(1));
	t[5] = 'Z';
	sprintf(s, "exec %s %s %s > /dev/null 2>&1", TAR, t, cd);
	system( s );
	strcpy(cd, (char *) t);
  }    
  else{
	sprintf(t, "DNL%s", mytime(1));
	t[5] = 'Z';
  }

  if(adds[c][0] == '?')
	sprintf(s, "exec %s %s > /dev/null 2>&1", packers[c], cd);
  else
	sprintf(s, "exec %s %s %s %s > /dev/null 2>&1", packers[c], adds[c], t, cd);
	
  system( s );

  unlink( t );

  strcat(t, (char *) en[c]);

  kill( fpid, SIGKILL );
  (void) wait( &fpid );

  clearline();

  if(tar[c][0] != '-'){
	ansi( "md" );
	printf("ACHTUNG: ");
	ansi( "me" );
	printf("Die Dateien mussten per TAR vor der Komprimierung gepackt werden!\n");
  }  

  stat(t, &fstat);
  printf("Das Archiv \"%s\" enthaelt %ld Bytes.", t, fstat.st_size);

  return (char *) t;
}



/***************************************************************************/
/*      FUNKTION  download()						   */
/*  BESCHREIBUNG  Text- und Binaerartikel uebertragen			   */
/*     PARAMETER  arg = artikel[-artikel]                                  */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

#define MAX_DL_FILES 20

void download( arg )
char arg[];
{
  int i, k, l, m;
  int von, bis;
  int ALLE;
  int protokoll, ok;
  int cps, bps, eff;

  long ts, tn;
  long bytes_total = 0L;

  struct stat fst;

  char s[STRING];
  char cd[LONGSTRING];
  char t[(LONGSTRING+STRING)];
  char tmp[STRING];

  char files[MAX_DL_FILES][STRING];
  int mdlp = 1;

  int art[MAX_PER_NG];
  int artp = 0;
  int lastart;

  int havetokill = 0;


  FILE *fp, *ff;

  
  tmp[0] = '\0';

  i = 0;
  k = -1;
  l = -1;
  m = -1;

  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	if ((arg[i] > 48) && (arg[i] < 58) && (m == -1)) m = i;
	i++;
  }

  von = 1;
  bis = 32000;

  if ((m == -1) && (l == -1) && (k == -1)) {
	return;
  }

  if ((m != -1) && (l == -1) && (k == -1)) {
	strcpy(s, (char *) strcopy(arg, m, length(arg)));
	von = atoi(s);
	bis = von;
  }
  if (k != -1) {
	strcpy(s, (char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (char *) strcopy(arg, (k + 1), length(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
  }
  
  if(von > bis){
	i = bis;
	bis = von;
	von = i;
  }

  maybe_locked(INHALT, "r");
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	nerror("pd.c", 504, "download", "Datei-Lesefehler", INHALT);
  }
  while (fgets(cd, 250, fp) != NULL){
	i = atoi(cd);
	if((i >= von) && (i <= bis)){
		art[artp] = i;
		artp++;
		if(artp > MAX_PER_NG){
			printf("This is a known bug ;-)");
			exit(0);
		}		
	}
  }
  fclose(fp);


  printf("\n\n");

  ansi("mr");
  printf("%c[%s] %c, %c, %c, %c ? > ", CR, PD07_MSG, PD08_MSG, PD09_MSG, PD10_MSG, PD11_MSG);
  ansi("me");


  do {
	protokoll = getint();
	if (protokoll >= 97) protokoll -= 32;
	if (protokoll == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, PD12_MSG);
		ansi("me");
	}
	if ((protokoll != PD08_MSG) && (protokoll != PD09_MSG) &&
	    (protokoll != PD10_MSG) && (protokoll != PD11_MSG))
		protokoll = 0;
  } while (protokoll == 0);


  printf("%c", protokoll);

  if (strcomp(BRETT, "PM") != 0) {
	       sprintf(s, "%s", BRETT); 
  }
  else {
	sprintf(s, "%s/usr/%d", HOME, USER.id);
  }
  chdir( s );

  cd[0] = '\0';
  printf("\n\n%s .", PD36_MSG);

  lastart = artp;

  for( i = 0; i < artp; i++){  

	sprintf(s, "%d", art[i]); 
	
	fp = fopen(s, "r");
	if(fp != 0){
		printf(".");

		while ((fgets(t, 250, fp) != NULL) && (t[0] > 32));
		while ((fgets(t, 250, fp) != NULL) && (t[0] < 32));

		ok = 0;

		if (strcomp("BINFILE", t) == 0) {
			fgets(t, 80, fp);
			strcpy(s, (char *) stripped(t));
			ok++;
		}
		if(((2 + strlen(s) + strlen(cd)) < LONGSTRING) && (mdlp < MAX_DL_FILES)){
			stat(s, &fst);
			bytes_total += (long) fst.st_size;

			if(ok != 0){
				strcpy(files[mdlp], s);
				mdlp++;				
				USER.downratio += ((long) fst.st_size / 1024);
			}

			strcat(cd, s); 
			strcat(cd, " ");
			lastart = i;
		}
		fclose(fp);
	}
  }

  if(cd[0] == '\0'){
	ansi("md");
	printf("%c%s\n", CR, PD35_MSG);
	ansi("me");
	chdir( HOME );
	return;
  }

  if(protokoll != PD08_MSG){
	strcpy(s, (char *) archivieren( cd ));
	if(strcomp("Noe!", s) != 0){
		strcpy(cd, (char *) s);
		havetokill++;
	}
  }

  signal(SIGINT, SIG_IGN);
  signal(SIGHUP, SIG_IGN);
  signal(SIGQUIT, SIG_IGN);
  signal(SIGABRT, SIG_IGN);
  signal(SIGTERM, SIG_IGN);

  printf("\n\n");
  ansi("md");
  printf("%s\n\n", PD13_MSG);
  ansi("me");

  time(&ts);

  switch (protokoll) {
      case PD08_MSG:
		sprintf(t, "exec cat %s", cd);
		break;
      case PD09_MSG:
		sprintf(t, "exec %s -b %s 2> /dev/null", SX, cd);
		break;
      case PD10_MSG:
		sprintf(t, "exec %s %s 2> /dev/null", SB, cd);
		break;
      case PD11_MSG:
		sprintf(t, "exec %s %s 2> /dev/null", SZ, cd);
		break;
  }	
  system( t );

  if(havetokill != 0) unlink( cd );

  time(&tn); tn = tn - ts; 

  chdir( HOME );

  ansi( "md" );
 
  if(tn < 1) tn = 1;
  cps = bytes_total / tn;
  bps = cps * 11;

  BAUDRATE = baudrate( bps );

  eff = ((100000 / BAUDRATE) * bps) / 1000;

  if(bps > BAUDRATE){
	printf("\n\n%s\n", PD14_MSG);
	ok = -1;
  }
  else{	
	printf("\n\n%ld %s.\n", fst.st_size, PD15_MSG);
	ok = 0;
  }

  ansi( "me" );
  printf("%s %d cps (ca. %d bps).", PD16_MSG, cps, bps);  

  
  if(ok != -1){
	  
	sprintf(tmp, "%s/%d.pd", TMP, getpid());
	ff = fopen( tmp, "w" );

	for(i = 1; i < mdlp; i++){
		fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, files[i]); 
		fprintf(ff, "  %6.d  %6.d  %2.d%% DNL\n", cps, bps, eff);		
	}  

	i = 0;

	fp = fopen( PDLOG, "r" );
	if(fp != NULL){
		while((fgets(s, 80, fp) != NULL) && (i < PRO_ENTRIES)){
			fputs(s, ff);
			i++;
		}
		fclose(fp);
	}

	fclose(ff);

	sprintf(cd, "mv %s %s", tmp, PDLOG);
	system( cd );
  }
  else{
	if(ff != 0) fclose(ff);
	if(tmp[0] != '\0') unlink(tmp);
  }

  if((lastart != artp) && (art[0] != art[lastart])){
	ansi( "md" );
	printf("\nACHTUNG: ");
	ansi( "me" );
	printf("Es wurden nur die Artikel %d bis %d uebertragen!", art[0], art[lastart]);
  }

  printf("\n\n");
}


