/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  misc2.c						   */
/*        FUNKTIONEN  chk_newsgrp(), subb(), loeschen(), brett() 	   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  11.06.1992					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"





/***************************************************************************/
/*      FUNKTION  chk_newsgrp()						   */
/*  BESCHREIBUNG  Stellt fest, ob ein Benutzer die angefragt NG betreten   */
/*		  darf.	                                                   */
/*     PARAMETER  s  =  Name der fraglichen NG				   */
/*     RUECKGABE  -1 =  Kein Zugang/Zugriff :-(                            */
/*                 1 =  Zugang erlaubt :-) 				   */
/***************************************************************************/

int chk_newsgrp( s )
char s[];
{
  int i = 1, ok = -1;

  while ((i < MAX_NEWSGRPS) && (newsgrp[i][0] != '\0') && (ok == -1)) {
	if (strcomp(newsgrp[i], s) == 0) ok = 0;
	if (strcomp(newsgrp[i], "all") == 0) ok = 0;
	i++;
  }

  return ok;
}




/***************************************************************************/
/*      FUNKTION  subb()						   */
/*  BESCHREIBUNG  Ist die angefragte NG eine Unter-NG, oder ein kompletter */
/*		  Pfad ??                                                  */
/*     PARAMETER  s  =  Name der NG                         |              */
/*     RUECKGABE  0  =  Unter-NG (z.B. minix)               v              */
/*		  n  =  Erste Obergruppe endet bei 'n' (comp.os.minix)     */
/***************************************************************************/

int subb(s)
char s[];
{
  int a = 0, i = 0;

  while (s[i] != '\0') {
	if ((s[i] == '.') && (a == 0)) a = i;
	i++;
  }
  return a;
}




/***************************************************************************/
/*      FUNKTION  loeschen()						   */
/*  BESCHREIBUNG  Gezielt einen persoenliche Mail loeschen.		   */
/*     PARAMETER  arg  =  Nummer der Mail                                  */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void loeschen(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  char s[STRING];
  char entry[STRING];
  char index[STRING];
  char t[STRING];
  char ex[255];
  char c;
  int i, a = atoi(arg);
  int ok;


  if ((arg[0] < '1') || (arg[0] > '9')) {
	ansi("md");
	printf(" %s\n", MI201_MSG);
	ansi("me");
	return;
  }
  if (strcomp(BRETT, "PM") != 0) {
	if(arg[0] < 33) return;
	if(USER.level < ADMIN_LEV){
		ansi("md");
		printf(" %s %d ...\n", MI202_MSG, USER.level);
		ansi("me");
	}
	else{
		sprintf(entry, "%s/%s", BRETT, arg);
		unlink(entry);
		printf("\n\n%s\n", MI203_MSG);		
		sprintf(entry, "%s %s -X", MB_DAEMON, NG);
		system(entry);
	}
	return;
  }

  if(USER.level == GUEST_LEV){
	return;
  }

  sprintf(entry, "%s/usr/%d/%s", HOME, USER.id, arg);
  sprintf(index, "%s/usr/%d/INDEX", HOME, USER.id);

  sprintf(s, "%s/loe%d", TMP, getpid());
  ff = fopen(s, "w");

  fp = fopen(index, "r");
  if (fp == NULL) {
	nerror("misc2.c", 109, "loeschen", "Datei-Lesefehler", index);
  }
  ok = 0;

  while (fgets(ex, 250, fp) != NULL) {
	if (atoi(ex) != a)
		fputs(ex, ff);
	else
		ok = 1;
  }
  fclose(fp);
  fclose(ff);

  sprintf(t, "cp %s %s", s, index);
  system(t);
  unlink(s);
  unlink(entry);
}



/***************************************************************************/
/*      FUNKTION  brett()						   */
/*  BESCHREIBUNG  Wechselt das Brett, zeigt Bretter an etc. pp. 	   */
/*     PARAMETER  arg  =  '!'     =  Brettername ausgeben		   */
/*		  arg  =  ''      =  aktuelle Bretter ausgeben		   */
/*		  arg  =  '*'     =  alle Bretter ausgeben	           */
/*		  arg  =  '#'     =  Gruppen ausgeben                      */
/*		  arg  =  '..'    =  eine Gruppe zurueck		   */
/*		  arg  =  '^'     =  ALLE (!) Bretter ausgeben		   */
/*		  arg  = 'Brett'  =  ins Brett 'Brett' wechseln		   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

/*
void brett(arg)  Compiler Bug ???? 
*/
brett(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  char s[STRING];
  char o[STRING];
  int a, b, h;
  char t[STRING];
  char org[STRING];
  char maybe[STRING];
  int this;
  int i, j;
  int subboard = 0;
  char c;
  int plus = 0;
  int zeile = 0;
  int swing = 1;  
  int fpid;

  if (arg[0] == '!') {
	printf("\n\n");
	ansi( "md" );
	printf("%s", MI204_MSG);
	ansi( "me" );
	printf(" %s\n", NG);
	ansi( "md" );
	printf("%s", MI204aMSG);
	ansi( "me" );
	printf(" ");	

	if(strcomp(BRETT, "PM") == 0){
		printf("%s", MI204bMSG);
	}
	else{
		fp = fopen( NEWSGROUPS, "r" );
		if(fp == NULL){
			nerror("misc2.c", 190, "brett", "Datei-Lesefehler", NEWSGROUPS);
		}
		h = 0;
		while((h == 0) && (fgets(s, 80, fp) != NULL)){
			if(strcomp(NG, s) == 0){
				a = 0; 
				while(s[a] > 32) a++;
				while(s[a] < 32) a++;
				strcpy(t, (char *) strcopy(s, a, 80)); 
				printf("%s", (char *) stripped(t));
				h++;
			}
		}
		fclose(fp);
	}
	printf("\n");
	return;
  }
  if ((arg[0] == '+') || (arg[0] == '-')) {
	scanner(arg[0] + 255);
	return;
  }
  if (arg[0] == '\0') {
	maybe_locked(UGROUPS, "r");
	fp = fopen(UGROUPS, "r");
	if (fp == NULL) {
		nerror("misc2.c", 908, "brett", "Datei-Lesefehler", UGROUPS);
	}
	arg[0] = '*';
  }
  else {
	maybe_locked(NGROUPS, "r");
	fp = fopen(NGROUPS, "r");
	if (fp == NULL) {
		nerror("misc2.c", 916, "brett", "Datei-Lesefehler", NGROUPS);
	}
  }


  org[0] = '\0';
  strcat(org, arg);

  if (arg[0] == '.') {
	i = 0;
	j = 0;
	strcpy(org, NG);
	while (org[i] != '\0') {
		if (org[i] == '.') j = i;
		i++;
	}
	if (j == 0) return;
	org[j] = '\0';
  }
  if (arg[0] == '#') subboard++;

  zeile = 0;

  show(NGROUPS, 99, 99); /* RESET */

  if ((arg[0] == '*') || (arg[0] == '+') || (arg[0] == '#') || (arg[0] == '~') || (arg[0] == '^')) {

	if(arg[0] != '^'){
		sprintf(s, "%s %d) ", MI205_MSG, USER.level);
	}
	else{
		sprintf(s, "%s 10) ", MI205_MSG);
	}
	headline(s);
	i = 0;
	strcpy(o, (char *) "OOPS");

	while (fscanf(fp, "%s %d %d %s", s, &a, &h, t) > 0) {
#ifdef _CNEWS
		if(t[0] == '=') 	
			continue; 
#endif
		if (arg[0] == '~') {
			if (strcomp(NG, s) != 0) continue;
		}
		if ((strcomp(o, s) != 0) || (subboard == 0)) {
			if (subboard != 0) {
				j = subb(s);
				if (j != 0) s[j] = '\0';
				o[0] = '\0'; strcat(o, s);
			}
			if ((chk_newsgrp(s) == 0) || (arg[0] == '^')){
				s[((80/USER.schluessel[1]) -2)] = '\0';
				strcat(s, "                                   ");
				s[((80/USER.schluessel[1]) -1)] = '\0';
				printf("%s", s);
				i++;
				plus++;
				if (i == USER.schluessel[1]) {
					printf("\n");
					i = 0;				
					zeile++;
					if (zeile >= MAX_SCR_LINES) {
						zeile = 0;
						if(USER.more != 0){
							if (more() != 0) return (int) 1;
						}
					}
				}
			}
		}
	}
	if (plus == 0) {
		printf("%s", MI206_MSG);
	}
	printf("\n");
  }
  else {
	if (org[0] != '\0') {

		SO_WHAT:

		strcpy(o, (char *) org);

		i = 0;
		while (org[i] != '\0') {
			t[i] = org[i];
			if (t[i] == '.') t[i] = '/';
			i++;
		}
		t[i] = '\0';

		sprintf(s, "%s/%s", NEWS, t);

		if (chdir(s) != 0) {
			sprintf(o, "%s.%s", NG, org);
			i = 0;
			while (o[i] != '\0') {
				t[i] = o[i];
				if (t[i] == '.') t[i] = '/';
				i++;
			}
			t[i] = '\0';
			sprintf(s, "%s/%s", NEWS, t);
		}
		if (chdir(s) != 0) {
			this = 9999;
			maybe_locked(NGROUPS, "r");
			ff = fopen(NGROUPS, "r");
			if (ff == NULL) {
				nerror("misc2.c", 1001, "brett", "Datei-Lesefehler", NGROUPS);
			}
			while (fscanf(ff, "%s %d %d %s", s, &i, &i, t) > 0) {
				i = strcomp(org, s);
				if (i < this) {
					this = i;
					strcpy(maybe, s);
				}
			}
			fclose(ff);
			
			strcpy(org, maybe);
			printf("\n\n");
			ansi("mr");
			printf("%s \"%s\" [%c, %c] >", MI207_MSG, maybe, GBL06_MSG, GBL07_MSG);
			ansi("me");

			c = yesno();
			
			if (c != GBL07_MSG) goto SO_WHAT;

			printf("\n");
		}
		else {

			if (chk_newsgrp(o) == 0) {
				strcpy(BRETT, s);
				printf("\n");
				sprintf(NG, "%s", o);
				if(length(o) > 14){
#ifndef _LONGNAMES
					strcpy(o, (char *) shortname(o));
#endif
				}
#ifdef _NOINDEX
				printf("\n%s ..", MI211_MSG);
				switch( (fpid = fork()) ){
					case -1 :
						break;
					case  0 :	while(1){
								printf(".");
								sleep(1);
							}	
						break;
				}
				sprintf(s, "%s %s -x", MB_DAEMON, NG);
				system( s );
				sprintf(s, "mv %s/%s/%s %s/inhalt.%d", HOME, LIB, o, TMP, getpid());
				system( s );
				sprintf(INHALT, "%s/inhalt.%d", TMP, getpid());
				kill( fpid, SIGKILL );
				wait( fpid );
				printf("\n");				
#else				
				sprintf(INHALT, "%s/%s", LIB, o);
#endif
			} else {
				ansi("md");
				printf(" %s\n", MI210_MSG);
				ansi("me");
			}
		}
		chdir(HOME);
	}
  }
  fclose(fp);
  return;
}

