/***************************************************************************/
/*	    PROGRAMM  ix/MBox						   */
/*             DATEI  mbox.h						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  10.05.1992					   */
/***************************************************************************/
 
#include "mbox.msg"
#include "defs.h"
#include "patchlevel.h"


 
/***************************************************************************/
/* >ORGANIZATION  -  frei waehlbar (moeglichst identisch mit dem ent-      */
/*		     sprechenden Eintrag fuer NEWS)			   */
/* >SYSTEM        -  frei waehlbar (Name der Mailbox)     	  	   */
/***************************************************************************/

#define ORGANIZATION 	"THE UNDERGROUND NETWORK"
#define SYSTEM       	"The Time Traveling Agency"  



/***************************************************************************/
/*  VERSION       -  wird vom Autor (und nur vom dem) geandert		   */
/*                   Co-Autoren, Portierer etc. koennen sich gefaelligst   */
/*		     ihren eigenen Eintrag basteln.		           */
/*  AUTOR         -  das bin ich - Hallo auch !				   */
/***************************************************************************/

#define VERSION	     	"ix/MBox 1.6"
#define AUTOR        	"by <volkers@unnet.w.open.DE>"




/***************************************************************************/
/* >UUCPSITE       - Systemname innerhalb der UUCP-Netze		   */
/* >UUCPID2        - Adresse (Domain-) im Internet			   */
/* >UUCPID1        - Adresse (Domain-) im lokalen UUCP-Netz 		   */
/* >UUCPBANG       - Adresse als BANG-Pfad				   */
/*  UUCPCOSTS      - Gebuehrenaufstellung				   */
/* >SMARTHOST	   - 							   */
/***************************************************************************/

#define UUCPSITE     	"unnet"
#define UUCPID2      	"unnet.w.open.DE"        
#define UUCPID1	     	"unnet.ruhr.SUB.ORG"
#define UUCPBANG     	"~!unido!horga!xenox!unnet!"
#define UUCPCOSTS    	"/usr/spool/uucp/.costs"
#define SMARTHOST	"xenox"



/***************************************************************************/
/*  X_MAIL_DEMON    - Name des X-Mail-Daemons (HAENDE WEG !!!) 		   */
/***************************************************************************/

#define X_MAIL_DEMON 	"X-Mail-Daemon"




/***************************************************************************/
/*  LIB		     - Pfad zum MBox-Directory LIB			   */
/*  TMP              - Directory fuer temporaere Dateien		   */
/* >NEWS	     - Pfad zum SPOOL-Directory fuer NEWS		   */
/*  NEWSGROUPS       - Pfad zur Datei mit den Erlaeuterungen der Gruppen   */
/*  ERRMBOX          - Mailbox des Error-Users (POSTMASTER)		   */
/*  MAILDROP         - Pfad zu den Maildrops der SH-User		   */
/* >NGROUPS          - Pfad zur "active"-Datei von NEWS			   */
/*  AGROUPS	     - Pfad zur MBox-"active"-Datei			   */
/***************************************************************************/

#define LIB	     	"./lib"
#define TMP	     	"/tmp"
#define NEWS         	"/usr/spool/news"
#define NEWSGROUPS	"/usr/lib/news/newsgroups"
#define ERRMBOX      	"/usr/spool/mail/postmaster"
#define MAILDROP     	"/usr/spool/mail"
#define NGROUPS      	"/usr/lib/news/active"
#define AGROUPS      	"./etc/active"





/***************************************************************************/
/* >CONSOLE	      - Geraet/Datei fuer die Logbuch-Ausgaben		   */
/*			Ist CONSOLE als "REDIRECT" definiert, wird aus der */
/*                      Datei CDIRECTFL der Name der Ausgabedatei gelesen  */
/*			gelesen					           */
/*  CDIRECTFL         - Geraet/Datei wohin CONSOLE-Info ausgeben wird	   */
/*		        Die Datei ENTHAELT DEN NAMEN der Ausgabedatei !!!  */
/* >CPRN              - Geraet/Datei fuer Fehler-Ausgaben		   */
/* >POSTMASTER        - Name des SYSOPs (identisch mit dessen SH-Account)  */
/*  MAX_BPS           - Maximale Modem-Ubertragungsrate in BPS             */
/* >PMS_TTY           - Nummer des einzigen Terminals, auf dem sich "root" */
/*			anmelden darf					   */
/*  GUEST             - MBox-Account fuer Besucher			   */
/*  UDBASE            - Pfad zur Teilnehmer-Datenbank			   */
/*  UDSEQ             - Pfad zur Teilnehmer-SEQ-Datei			   */
/***************************************************************************/

#define CONSOLE	     	"REDIRECT"
#define CDIRECTFL    	"/etc/mbox.out"
#define CPRN	     	"/tmp/errlog"
#define POSTMASTER   	"volkers"
#define PMS_TTY      	"/dev/tty4"
#define MAX_BPS      	19200
#define GUEST        	"GAST"
#define UDBASE       	"./etc/users.data"
#define UDSEQ        	"./etc/users.seq"




/***************************************************************************/
/*  BEFEHLE 	   - Pfad zur Befehls-Tabelle				   */
/*  HILFE          - Pfad zu den HELP-Texten				   */
/*  KURZHILFE	   - Kurzuebersicht					   */
/*  INTRO          - Pfad zur INTRO-Meldung				   */
/*  LOGO           - Optionaler Text als Mailbox-LOGO 			   */
/*  SYSINFO	   - Allgemeine Infos zur MBox				   */
/***************************************************************************/

#define BEFEHLE	     	"./etc/help.befehle"  
#define HILFE	     	"./etc/help.hilfe"
#define KURZHILFE    	"./etc/help.shorthelp"
#define INTRO        	"./etc/intro"
#define LOGO         	"./etc/logo"
#define SYSINFO		"./etc/sysinfo"



/***************************************************************************/
/*  SEQ             - Pfad zur MBox-SEQ-Datei (Anzahl der Anrufe)	   */
/*  CALLS           - Pfad zur MBox-CALLS-Datei (Logfile)		   */
/*  WHO             - Pfad zur MBox-WHO-Datei (gerade aktive User)	   */
/***************************************************************************/

#define SEQ          	"./etc/mbox.seq"
#define CALLS        	"./etc/mbox.calls"
#define WHO          	"./etc/mbox.who"




/***************************************************************************/
/*  EDITORS          - Pfad zur Liste der verfuegbaren Eddies		   */
/*  GAMES            - Pfad zur Liste der Online-Spiele			   */
/*  MAX_GAMES 	     - Anzahl der max. angebotenen Spiele		   */
/* >CHAT             - Pfad zum CHAT-Programm				   */
/*  RSH              - MBox-RSH; NICHT identisch mit RemoteSH/RestrictedSH */
/*  UDCS	     - Pfad zur Liste der 'User defined Commands'	   */
/*  PACKERS	     - Pfad zur Liste der Komprimierer/Archivierer         */
/***************************************************************************/

#define EDITORS      	"./etc/mbox.editors"
#define GAMES	     	"./etc/mbox.games"
#define MAX_GAMES	10
#define CHAT         	"/usr/bin/chat"
#define RSH          	"./mbrsh"
#define UDCS		"./etc/mbox.udc"
#define PACKERS		"./etc/mbox.packers"




/***************************************************************************/
/*  ROOT_UID          - siehe "/etc/passwd"				   */
/*  ROOT_GID          - dito						   */
/*  GUEST_GID 	      - dito (unbedingt != GID fuer "normale" User)        */
/***************************************************************************/

#define ROOT_UID      	0
#define ROOT_GID      	0
#define GUEST_GID     	1





/***************************************************************************/
/* >FIRST_EX_TTY       - Nummer des ersten seriellen Terminals		   */
/*  MAX_TERMINALS      - Max. Anzahl der aktiven Terminals 		   */
/***************************************************************************/

#define FIRST_EX_TTY	64
#define MAX_TERMINALS	20




/***************************************************************************/
/* >SIGNATURE          - Name des '.signature'-File im $HOME eins SH-Users */
/* >TSET               - Pfad zum TSET-Programm				   */
/* >EXPIRE             - Pfad zum EXPIRE-Programm			   */
/*  MB-DAEMON          - Pfad zum MB-DAEMON-Programm			   */
/*  MB_DLOG            - Pfad zum MB-DAEMON-Statistik-File		   */
/*  XMDLOG	       - Pfad zum XMD-Protokoll-File		           */
/*  XMD_ALIAS	       - Pfad zur Alias-Datei des XMD			   */
/***************************************************************************/

#define SIGNATURE    	".wmailsign"
#define TSET         	"./etc/tset"
#define EXPIRE       	"/usr/lib/news/expire"
#define MB_DAEMON    	"/usr/bin/mb-daemon"
#define MB_DLOG      	"./etc/mbd.log"
#define XMDLOG	     	"/usr/adm/xmd.log"
#define XMD_ALIAS	"./etc/xmd.alias"




/***************************************************************************/
/* >COMPRESS		- Pfad zum Standard-COMPRESS			   */
/* >GREP 		- Pfad zum SUCH-Programm (GREP -L: Filename only !)*/
/* >SORTEDCUT           - Zaehlt die Downloads pro File			   */
/* >SECONDCUT           - Zaehlt die Anrufe pro User			   */
/* >UUX                 - Fuehrt Kommandos auf fremden Sites aus	   */
/*  TAR			- Tar-Synopsis zum bilden eines neuen Archives     */
/***************************************************************************/

#define COMPRESS     	"/usr/bin/compress"
#define GREP         	"/usr/bin/grep -l"
#define SORTEDCUT       "cut -d' ' -i2 -f3 %s | sort - | uniq -c | sort -r - | sed '/ \\//s//   \\//g' > %s"
#define SECONDCUT	"cut -c6-35 %s | sed '/  /s//    /g' | sort - | uniq -c | sort -r - > %s"
#define UUX		"uux -r"
#define TAR		"/usr/bin/tar cf"



/***************************************************************************/
/*  PDNG		 - Name der Freeware/Shareware/PD-NG		   */
/*  PDLOG                - PD-Download-Protokoll			   */
/*  PDSCRIPT		 - Pfad zum Protokoll der UPLOADs		   */
/* >NEWS_MINIMUM         - Mindestens verfuegbare NGs			   */
/*  MAX_PER_NG           - Maximale Anzahl der Eintraege pro NG		   */
/*  EXPIRE_DAYS          - Ab wann loeschen, wenn MAX_PER_NG erreicht ist  */
/*  MAX_XMD_ALIAS	 - Wieviele Namen kann XMD "umleiten"              */
/*  NAT_DOMAIN1          - Nationale Domains (gebuehrenfrei)		   */
/*  NAT_DOMAIN2          - (dito)					   */
/*  NAT_DOMAIN3          - (dito)					   */
/***************************************************************************/

#define PDNG	     	"local.pd"
#define PDLOG	     	"./etc/pd.log"
#define PDSCRIPT     	"./etc/pd.script"
#define NEWS_MINIMUM 	"local unnet xenox de"
#define MAX_PER_NG   	1000
#define EXPIRED_DAYS 	32
#define MAX_XMD_ALIAS   20
#define NAT_DOMAIN1  	".de"
#define NAT_DOMAIN2  	".sub.org"
#define NAT_DOMAIN3  	".de" 





/***************************************************************************/
/*  SZ  		  - ZModem Download				   */
/*  SX			  - X-Modem					   */
/*  SB		          - Y-Modem					   */
/*  RZ			  - ZModem Upload				   */
/*  RX                    - X-Modem 					   */
/*  RB                    - Y-Modem					   */
/***************************************************************************/

#define SZ           	"/usr/bin/sz"
#define SX           	"/usr/bin/sx"
#define SB 	     	"/usr/bin/sb"

#define RZ           	"/usr/bin/rz"
#define RX	     	"/usr/bin/rx"
#define RB	     	"/usr/bin/rb"





/***************************************************************************/
/*  TARIF           	  - Pfennige pro Einheit (Telefongebuehren)	   */
/*  NZNT                  - Sekunden pro Einheit Nahzone/Normal-Tarif	   */
/*  NZBT                  -                      Nahzone/Billig-Tarif	   */
/*  RZNT                  - 		         Regionalzone/Normal-Tarif */
/*  RZBT		  -			 Regionalzone/Billig-Tarif */
/*  WZNT		  -			 Weitzone/Normal-Tarif     */
/*  WZBT		  -			 Weitzone/Billig-Tarif     */
/***************************************************************************/

#define TARIF        	23
#define NZNT         	360
#define NZBT         	720
#define RZNT 	     	60
#define RZBT	    	120
#define WZNT	     	21
#define WZBT	     	42




/***************************************************************************/
/*  PRO_ENTRIES    	  - Maximal Eintraege in MBOX.CALLS      	   */
/*  MAX_TAGE		  - Max. Eintraege im PRO-Diagramm		   */
/***************************************************************************/

#define PRO_ENTRIES  	999
#define MAX_TAGE	16



/***************************************************************************/
/*  MVERSION		  - Version des MB-DAEMON			   */
/*  REFLECT_NG		  - Auf diese Gruppe wird "reflektiert"		   */
/*  REFLECT_LOG		  - LOG-File des Reflektors			   */
/*  DIRLIST		  - Wird gesendet bei DIRLIST-Request 		   */
/*  REFLECTUID		  - UID des Reflektors (siehe /etc/passwd)         */
/*  TZS			  - ?? Fehler in der Zeitberechnung ??		   */
/***************************************************************************/

#define MVERSION    	"+++ Un.Net Reflecting Device - Version 1.6 / MB-DAEMON +++"
#define REFLECT_NG  	"xenox.test"
#define REFLECT_LOG 	"/local/mbox/etc/reflector.log"
#define DIRLIST     	"/public/pd/DIRLIST"
#define REFLECTUID  	22
#define TZS		1


/***************************************************************************/
/*  MIME-VERSION	  - MIME Versionsnummer (f. MultiMedia-Mail)	   */
/***************************************************************************/

#define MIME_VERSION	"1.0"



