/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  intro.c						   */
/*        FUNKTIONEN  intro(), init_user()				   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  11.07.1992					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <time.h>

#include "mbox.h"

time_t time_start, time_now;


void init_user();

/***************************************************************************/
/*      FUNKTION  intro()						   */
/*  BESCHREIBUNG  Teilnehmer melden sich an. Beim Aufruf von SHELL, wird   */
/*		  die Prozedur automagisch abgewickelt. Gaeste koennen     */
/*		  ausserdem in dieser Funktion ein Terminal auswaehlen.    */
/*     PARAMETER  keine                                                    */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void intro()
{
  FILE *fp;
  FILE *ff;
  int fd;
  char s[LSTRING];
  char t[STRING];
  char f[STRING];
  char tmp[STRING];
  char crypt_pw[STRING];
  char ex[255];
  char tmpuser[STRING];
  char moreLASTLOG[STRING];
  int i, calls;
  char c;
  int ok;
  int a, b;
  long ll, lalo;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;
 
  struct stat fst;

  umask(0007);

  sprintf(TERMINAL, "ansi");
  ansi("INIT");

  time(&time_start);

  fp = fopen( LOGO, "r" );
  if(fp != NULL){
	fclose(fp);
	printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
	ansi("cl");
	ansi("md");
        show( LOGO, 24, 0 );
	ansi("me");
	c = getint();	
  }

  printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
  ansi("cl");

  ansi("md");
  printf("\n%s ", INT01_MSG);
  ansi("me");
  printf("%s", ORGANIZATION);
	
  ansi("md");
  printf("\n%s ", INT02_MSG);
  ansi("me");
  printf("%s %s %s", VERSION, PATCHLEVEL, AUTOR);

  ansi("md");
  printf("\n%s ", INT03_MSG);
  ansi("me");
  printf("%s", SYSTEM);

  BAUDRATE = (int) 0;

  if (OLDGID == GUEST_GID) {	/* GAESTE */

        TRY_AGAIN:

	printf("\n\n%s ", GBL04_MSG);
	strcpy(LOOSER.name, (char *) getline(30, 11, '.', ""));
	if (LOOSER.name[0] == '\0') goto TRY_AGAIN;

	strcpy(s, (char *) upcased(LOOSER.name));

	if (strcomp(GUEST, s) != 0) {

		printf("\n%s ", GBL09_MSG);
		strcpy(LOOSER.passwort, (char *) getline(10, 12, '.', ""));
		strcpy(crypt_pw, (char *) crypted(LOOSER.passwort));

		maybe_locked(UDBASE, "r"); mblock(UDBASE);
		fd = open(UDBASE, O_RDONLY);
		if (fd == -1) {
			nerror("intro.c", 78, "intro", "Datei-Lesefehler", UDBASE);
		}
		ok = 0;
		while ((ok == 0) && (read(fd, &USER, sizeof(USER)) == sizeof(USER))) {
			if (((strcomp(LOOSER.name, USER.name) == 0) ||
		  	     (strcomp(LOOSER.name, USER.nick) == 0)) &&
			    ((strcomp(USER.passwort, (char *) crypt_pw) == 0) ||
			     (strcomp(USER.passwort, LOOSER.passwort) == 0)))
				ok = 1;
		}
		close(fd);
		mbunlock(UDBASE);

		if (ok == 1) goto WELL_DONE;
		goto TRY_AGAIN;
	}
	strcpy(LOOSER.name, (char *) upcased(s));

	maybe_locked(UDBASE, "r"); mblock(UDBASE);
	fd = open(UDBASE, O_RDONLY);
	if (fd == -1) {
		nerror("intro.c", 98, "intro", "Datei-Lesefehler", UDBASE);
	}
	ok = 0;
	while ((ok == 0) && (read(fd, &USER, sizeof(USER)) == sizeof(USER))) {
		if (strcomp(LOOSER.name, USER.name) == 0) ok = 1;
	}
	close(fd);
	mbunlock(UDBASE);

	ansi("md");
	printf("\n\n%s\n\n", INT04_MSG);
	ansi("me");
	printf("%s\n", INT05_MSG);
	ansi("md");
	printf("\n%s > ", INT06_MSG);
	ansi("me");

	do {
		c = getint();
	} while ((c < '1') || (c > '4'));
	printf("%c", c);
	USER.terminal = c - 48;

	strcpy(USER.name, (char *) GUEST);
	sprintf(USER.passwort, "%s", "*****");

	USER.level	   =  0;
	USER.prompt        =  2;
	USER.bell          =  0;
	USER.intro         =  1;
	USER.more          =  3;
	USER.editor        =  1;
	USER.lastmode      =  2;
	USER.leserichtung  =  2;
	USER.tlines        = 23;
	USER.schluessel[0] =  1;
	USER.schluessel[1] =  3;

	sprintf(USER.newsgrps, "%s", NEWS_MINIMUM);

	LASTLOG = (long) 19700101;
	LASTTIME = 0;
	sprintf(moreLASTLOG, "%s", "01.01.1970");
  }
  else {			/* USER */

	printf("\n\n%s ....................", GBL04_MSG);
	for (i = 0; i < 20; i++) printf("%c", BS);

	strcpy(tmpuser, (char *) whoami());
	printf("%s", tmpuser);

	printf("\n%s ..........", GBL09_MSG);

	for (i = 0; i < 10; i++) printf("%c", BS);
	for (i = 0; i < 10; i++) printf("*");

	if (strcomp(tmpuser, "root") == 0) {
		strcpy(tmpuser, (char *) POSTMASTER);

		strcpy(s, (char *) ttyname(0));
		if(strcomp(PMS_TTY, s) != 0){
			printf("\n\n");
			ansi("mr");
			printf("%s", INT07_MSG);
			ansi("me");
			printf("\n\n");
			exit(-1);
		}
		else {
			USER.level = 10;
		}
	}
	maybe_locked(UDBASE, "r"); mblock(UDBASE);
	fd = open(UDBASE, O_RDONLY);
	if (fd == -1) {
		nerror("intro.c", 156, "intro", "Datei-Lesefehler", UDBASE);
	}
	ok = 0;
	while ((ok == 0) && (read(fd, &USER, sizeof(USER)) == sizeof(USER))) {
		if ((strcomp(tmpuser, USER.sh_name) == 0)) ok = 1;
	}
	close(fd);
	mbunlock(UDBASE);

	if (ok == 0) postfach(tmpuser);

  }

  WELL_DONE:

  setuid( ROOT_UID );
  setgid( ROOT_GID ); 

  if (strcomp(GUEST, USER.name) != 0) {
	LASTLOG = (long) dateconv(USER.lastlog);
	LASTTIME = USER.lasttime;
	sprintf(moreLASTLOG, "%s", USER.lastlog);
  }
  if (USER.lastmode == 2) LASTTIME = 0;

  sprintf(UGROUPS, "%s/usr/%d/.active", HOME, USER.id);

  maybe_locked( AGROUPS, "r" );
  fp = fopen(AGROUPS, "r");
  if (fp == NULL) {
	nerror("intro.c", 182, "intro", "Datei-Lesefehler", AGROUPS);
  }
  ff = fopen(UGROUPS, "w");
  if (ff == NULL) {
	nerror("intro.c", 195, "intro", "Datei-Schreibfehler", UGROUPS);
  }
  while (fscanf(fp, "%s %ld", s, &lalo) > 0) {
	if (LASTLOG < lalo) {
		sprintf(t, "%s 00000 00000 y\n", s);
		fputs(t, ff);
	}
	if (LASTLOG == lalo) {
	}
  }
  fclose(ff);
  fclose(fp);

  sprintf(s, "%s \"%s\" (%d) %s", INT08_MSG, USER.name, USER.id, INT09_MSG);
  control(s, 3);
  whodo( INT10_MSG );

  printf("\n\n");

  if ((USER.level < 10) && (strcomp(MYNAME, USER.name) != 0)) {

	maybe_locked(SEQ, "r"); mblock(SEQ);
	fp = fopen(SEQ, "r");
	if (fp == NULL) {
		nerror("intro.c", 223, "intro", "Datei-Lesefehler", SEQ);
	}
	fscanf(fp, "%d", &calls);
	fclose(fp);
	calls++;

	fp = fopen(SEQ, "w");
	if (fp == NULL) {
		nerror("intro.c", 227, "intro", "Datei-Schreibfehler", SEQ);
	}
	fprintf(fp, "%d\n", calls);
	fclose(fp);
	mbunlock(SEQ);

	sprintf(tmp, "%s/%dT", TMP, getpid());

	fp = fopen(tmp, "w");
	if (fp == NULL) {
		nerror("intro.c", 236, "intro", "Datei-Schreibfehler", tmp);
	}
	maybe_locked(CALLS, "r"); mblock(CALLS);
	ff = fopen(CALLS, "r");
	if (ff == NULL) {
		nerror("intro.c", 239, "intro", "Datei-Lesefehler", CALLS);
	}
	sprintf(s, "%s (%s)", USER.name, USER.nick);
	sprintf(t, "%s", numstripped(USER.wohnort));
	if (t[0] == '\0') sprintf(t, "%s", "   ");

	sprintf(f, "%s", (char *) ttyna());

	fprintf(fp, "%5.d  %-28.28s  %-17.17s%8.8s  %s  %s\n",
		calls, s, stripped(t), f, (char *) mydate(1), (char *) mytime(1));

	if(PRO_ENTRIES < 10){
		nerror("intro.c", 291, "intro", "PRO_ENTRIES zu klein dimensioniert", "mbox.h");			
	}

	i = 1;
	while ((fgets(s, 84, ff) != NULL) && (i <= PRO_ENTRIES)) {
		fputs(s, fp);
		i++;
	}

	fclose(ff);
	fclose(fp);

	sprintf(s, "cp %s %s > /dev/null", tmp, CALLS);
	system(s);

	unlink(tmp);
	mbunlock(CALLS);
  }

  sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);  
  if(atol(USER.abused) == 0L){
	  stat(s, &fst);
	  IDX_SIZE = (long) fst.st_size;
  }
  else IDX_SIZE = atol(USER.abused);

  init_user( INT11_MSG );

  if (USER.intro < 3) {

	a = 0;
	fp = fopen(UGROUPS, "r");
	if (fp == NULL) {
		nerror("intro.c", 283, "intro", "Datei-Lesefehler", AGROUPS);
	}
	while (fgets(ex, 200, fp) != NULL) a++;
	fclose(fp);

	b = 0;
	sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);  
	
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("intro.c", 291, "intro", "Datei-Lesefehler", s);
	}
	while (fgets(ex, 200, fp) != NULL){
		if(ex[0] < 65) b++;
	}
	fclose(fp);
	b -= 1;

	ansi("md");
	printf("%s %d. %s %s %s.\n", 
		INT12_MSG, USER.seq, INT13_MSG, moreLASTLOG, INT14_MSG);
	printf("%s %d %s %d %s.\n", 
		INT15_MSG, a, INT16_MSG, b, INT17_MSG);
	ansi("me");
	printf("\n");
  }
  if ((USER.intro != 2) && (USER.intro != 4)) show(INTRO, 9999, 1);



  
  fp = fopen(WHO, "a");
  if (fp == NULL) {
	nerror("intro.c", 309, "intro", "Datei-Lesefehler", WHO);
  }
  strcpy(s, (char *) USER.sh_name);
  if (s[0] == '\0') strcpy(s, (char *) USER.nick);
  if (s[0] == '\0') strcpy(s, (char *) GBL10_MSG);
  sprintf(ex, "%-8.8s %s (%s)                                               ",
	(char *) ttyna(), USER.name, s);

  ex[39] = '\0';
  fputs(ex, fp);

  sprintf(ex, "%8.8s", (char *) ttyna());
  fputs(ex, fp);

  strcpy(s, (char *) mytime(1));
  if (USER.level < 10)
	sprintf(ex, "   %s   [%d] MBox: %s\n", s, USER.level, INT10_MSG);
  else
	sprintf(ex, "   %s   [%d] MBox: %s\n", s, ADMIN_LEV, INT10_MSG);

  fputs(ex, fp);
  fclose(fp);
  


  sprintf(MYNAME, "%s", USER.name);

  sprintf(s, "%s", (char *) mydate(0));
  s[5] = '\0';
  if (strcomp(s, USER.geburtsdatum) == 0) {
	ansi("md");
	printf("\n\n%s\n", INT18_MSG);
	printf("%s\n\n", INT19_MSG);
	ansi("me");
  }
  if (strcomp("24.12.", s) == 0) {
	ansi("md");
	printf("\n\n%s\n", INT20_MSG);
	printf("%s\n\n", INT21_MSG);
	ansi("me");
  }
  if (strcomp("06.12.", s) == 0) {
	ansi("md");
	printf("\n\n%s\n", INT22_MSG);
	printf("\n%s\n\n", INT23_MSG);
	ansi("me");
  }
  if (strcomp("01.01.", s) == 0) {
	ansi("md");
	printf("\n\n%s\n", INT24_MSG);
	printf("%s\n\n", INT25_MSG);
	ansi("me");
  }
  if ((calls == 1000) || (calls == 10000) || (calls == 100000)) {
	ansi("md");
	printf("\n\n%s %d%s\n\n", INT26_MSG, calls, INT27_MSG);
	ansi("me");
  }


  /* Strict Accounting ... decrease Level if User doesn't pay */

  strcpy(s, (char *) mydate( 0 ));
  lalo = dateconv(s);  
  
  strcpy(s, (char *) USER.account);
  s[10] = '\0';
  ll = dateconv(s);

  if((ll <= lalo) && (ll > 19000000L)){
	ansi( "md" );
	printf("\n%s %s %s\n", INT28_MSG, s, INT29_MSG);
	ansi( "me" );
	printf("%s\n", INT30_MSG);

	if(lalo > (ll + 21)){
		USER.level = WRITE_INTERNAT - 1;
	}
  }
}



/***************************************************************************/
/*      FUNKTION  init_user()						   */
/*  BESCHREIBUNG  Teilnehmer-Parameter werden zugewiesen, Rechte verteilt  */
/*		  und die Daten aktualisiert.                              */
/*     PARAMETER  info  =  Ansage-Text                                     */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void init_user(info)
char info[];
{
  FILE *fp;
  FILE *ff;
  int fd;
  char s[STRING];
  char t[STRING];
  int i;
  struct userdaten DUMMY;
  int dummy = sizeof(DUMMY);
  long ll, lalo;
  int lati;
  int ok;

  printf("%s ..", info);

  switch (USER.terminal) {
      case 1:
		sprintf(s, "eval '%s ansi' ", TSET);
		sprintf(TERMINAL, "ansi");
		break;
      case 2:
		sprintf(s, "eval '%s vt100' ", TSET);
		sprintf(TERMINAL, "vt100");
		break;
      case 3:
		sprintf(s, "eval '%s vt52' ", TSET);
		sprintf(TERMINAL, "vt52");
		break;
      case 4:
		sprintf(s, "eval '%s vt52' ", TSET);
		sprintf(TERMINAL, "vt52");
		break;
  }
  printf(".");

  ansi("INIT");

  fp = fopen(EDITORS, "r");
  if (fp == NULL) {
	nerror("intro.c", 487, "intro", "Datei-Lesefehler", EDITORS);
  }
  i = 0;
  while((fgets(s, 80, fp) != NULL) && (s[0] == '/'));
  while ((i != USER.editor) && (fscanf(fp, "%s %s", s, EDDY) > 0)) i++;
  fclose(fp);

  printf(".");

  if (USER.leserichtung == 0) USER.leserichtung = 2;

  USER.seq++;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDWR);
  if (fd == -1) {
	nerror("intro.c", 395, "init_user", "Datei-Schreib/-Lesefehler", UDBASE);
  }
  while (read(fd, &DUMMY, dummy) == dummy) {
	if (USER.id == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
  }
  lseek(fd, ll, SEEK_SET);
  write(fd, &USER, sizeof(USER));
  close(fd);
  mbunlock(UDBASE);

  printf(".");

  sprintf(UGROUPS, "%s/usr/%d/.active", HOME, USER.id);
  sprintf(MAKRO, "%s/usr/%d/.makro", HOME, USER.id);

  maybe_locked( AGROUPS, "r" );
  fp = fopen(AGROUPS, "r");
  if (fp == NULL) {
	nerror("intro.c", 412, "intro", "Datei-Lesefehler", AGROUPS);
  }
  ff = fopen(UGROUPS, "w");
  if (ff == NULL) {
	nerror("intro.c", 442, "intro", "Datei-Schreibfehler", UGROUPS);
  }
  while (fscanf(fp, "%s %ld %d", s, &lalo, &lati) > 0) {
	if (LASTLOG < lalo) {
		sprintf(t, "%s 00000 00000 y\n", s);
		fputs(t, ff);
	}
	if (LASTLOG == lalo) {
		if (LASTTIME <= lati) {
			sprintf(t, "%s 00000 00000 y\n", s);
			fputs(t, ff);
		}
	}
  }
  fclose(ff);
  fclose(fp);

  printf(".");

  strcpy(BRETT, "PM");
  sprintf(NG, "%s.PM", USER.name);
  sprintf(INHALT, "%s/usr/%d/INDEX", HOME, USER.id);

  printf(".");

  if (USER.newsgrps[0] == '\0') sprintf(USER.newsgrps, "%s", NEWS_MINIMUM);

  sscanf(USER.newsgrps, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
	newsgrp[1], newsgrp[2], newsgrp[3], newsgrp[4], newsgrp[5],
	newsgrp[6], newsgrp[7], newsgrp[8], newsgrp[9], newsgrp[10],
	newsgrp[11], newsgrp[12], newsgrp[13], newsgrp[14], newsgrp[15]);
 

  if((USER.tlines < 22) || (USER.tlines > 23)){
	MAX_SCR_LINES = DEF_MAX_SCR_LINES;
	USER.tlines = DEF_MAX_SCR_LINES;
  }
  else 
	MAX_SCR_LINES = USER.tlines;


  if(USER.schluessel[0] == 32)
	SHORT_HEADER = 1;
  else
	SHORT_HEADER = 0;

  if(USER.schluessel[1] == 0)
	USER.schluessel[1] = 4;

  if(USER.level >= WRITE_INTERNAT){
	strcpy(UUCPID, UUCPID2);
  }
  else{
	strcpy(UUCPID, UUCPID1);
  }

  if(USER.account[0] == '\0') strcpy(USER.account, "00.00.0000 000.00");
  
  printf("%c", CR);
}
