/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  help.c						   */
/*        FUNKTIONEN  help()						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  16.11.1991					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"


/***************************************************************************/
/*      FUNKTION  help() 						   */
/*  BESCHREIBUNG  Der Inhalt der Datei HILFE wird entweder komplett ange-  */
/*		  zeigt, oder aber in Abhaengigkeit von 'cmd' in Auszuegen */
/*		  ausgegeben.                                              */
/*     PARAMETER  cmd  =  '*'      =  HILFE wird komplett ausgegeben       */
/*                        '='      =  SHORTHELP                            */
/*		  #Befehl  	   =  HILFE zu "Befehl" wird ausgegeben    */
/*     RUECKGABE  0  =  Keinen Eintrag gefunden                            */
/*                n  =  Anzahl der Eintraege				   */
/***************************************************************************/

int help(cmd)
char cmd[];
{
  FILE *fp;
  char s[255];
  int ende = 0, ok = 0, found = 0, toggle = 0, lines = 0;

  show(KURZHILFE, 99, 99); /* RESET */
  
  if(cmd[0] == '='){
	headline( HLP01_MSG );
	show(KURZHILFE, 9999, USER.more);	
	return 9999;
  }

  maybe_locked(HILFE, "r");
  fp = fopen(HILFE, "r");
  if (fp == NULL) {
	nerror("help.c", 14, "help", "Datei-Lesefehler", HILFE);
  }
  if (cmd[0] != '#') {
	ok = 2;
	found++;
  }
  headline( HLP01_MSG );
  lines = 0;

  while ((fgets(s, 85, fp) != NULL) && !ende) {

	if (USER.more > 0) {
		if (lines >= MAX_SCR_LINES) {
			lines = 0;
			if (more() != 0) return 1;
		}
	}
	if (ok == 2) {
		if (s[0] != '#') {
			printf("%s", s);
			lines++;
			if (toggle > 0) {
				ansi("me");
				toggle = 0;
			}
		}
		else {
			printf("\n");
			lines++;
			ansi("md");
			toggle++;
		}
	}
	else {
		if ((ok == 1) && (s[0] == '#')) {
			ok = 0;
			printf("\n");
			lines++;
		}
		if ((ok == 1) && (s[0] != '#')) {
			printf("%s", s);
			lines++;
			if (toggle > 0) {
				ansi("me");
				toggle == 0;
			}
		}
		if ((ok == 0) && (s[0] == '#')) {
			if (strcomp(cmd, s) == 0) {
				ok = 1;
				found++;
				ansi("md");
				toggle++;
			}
		}
	}
  }
  fclose(fp);

  return found;
}
